/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.mobile.collect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.ImageList;
import kd.bos.form.control.events.AttachmentOperaClickListener;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TelephoneField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.page.EduPageServiceImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.repository.HcfRepository;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.repository.common.HomConfigRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.base.IHomConfigDomainService;
import kd.hr.hom.business.domain.service.collect.DynamicFiledViewServiceFactory;
import kd.hr.hom.business.domain.service.collect.ICollectGroupStatusService;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.business.domain.service.collect.ICollectValidateService;
import kd.hr.hom.business.domain.service.common.IHomConfigService;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.business.domain.service.impl.collect.MultiBaseDataFiledViewServiceImpl;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.constant.InfoGroupFieldConstants;
import kd.hr.hom.common.entity.InfoGroupCertEntity;
import kd.hr.hom.common.entity.InfoGroupConfigEntity;
import kd.hr.hom.common.enums.InfoGroupCertTypeEnum;
import kd.hr.hom.common.enums.InfoGroupEnum;
import kd.hr.hom.common.enums.InfoGroupFieldTypeEnum;
import kd.hr.hom.common.enums.InfoGroupStatusEnum;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.formplugin.common.CustomStyleUtils;
import kd.hr.hom.formplugin.common.OcrToBusinessUtils;
import kd.hr.hom.formplugin.mobile.collect.InfoGroupMultipleMobilePlugin;
import kd.hr.hom.formplugin.web.activity.AbstractCollectDynViewPlugin;
import kd.sdk.hr.hom.common.InfoGroupEntity;

public class InfoGroupDynViewMobilePlugin
extends AbstractMobFormPlugin
implements AfterF7SelectListener,
UploadListener,
AttachmentOperaClickListener {
    private static final Log logger = LogFactory.getLog(InfoGroupDynViewMobilePlugin.class);
    private static final int CERT_VALIDATE = 0;
    private static final Set<String> SELECT_KEY_LIST = new HashSet<String>(Arrays.asList("ComboField", "BasedataField", "BooleanField", "MulBasedataField", "DateField", "DateRangeField"));
    private Map<String, Future> futureMap = new HashMap<String, Future>();

    public void createNewData(BizDataEventArgs e) {
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        e.setDataEntity((Object)dataEntity);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String jsonObject = (String)showParameter.getCustomParam("infoGroupEntity");
        InfoGroupEntity infoGroup = (InfoGroupEntity)JSONObject.parseObject((String)jsonObject, InfoGroupEntity.class);
        String infoGroupConfigStr = (String)showParameter.getCustomParam("infoGroupConfig");
        InfoGroupConfigEntity infoGroupConfig = (InfoGroupConfigEntity)SerializationUtils.fromJsonString((String)infoGroupConfigStr, InfoGroupConfigEntity.class);
        FlexPanelAp flexPanelAp = this.loadMetas(infoGroup, infoGroupConfig, this.isPreview(showParameter), null);
        Container flexPanel = (Container)this.getView().getControl("flexpanelap");
        flexPanel.getItems().addAll(((Container)flexPanelAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(flexPanel.getItems());
        this.getModel().updateCache();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String candidateId = (String)showParameter.getCustomParam("candidateid");
        String onboardId = (String)showParameter.getCustomParam("onbrdid");
        String id = (String)showParameter.getCustomParam("id");
        Long activityId = (Long)showParameter.getCustomParam("activityId");
        String isMulti = (String)showParameter.getCustomParam("isMulti");
        String jsonObject = (String)showParameter.getCustomParam("infoGroupEntity");
        InfoGroupEntity infoGroup = (InfoGroupEntity)JSONObject.parseObject((String)jsonObject, InfoGroupEntity.class);
        String infoGroupConfigStr = (String)showParameter.getCustomParam("infoGroupConfig");
        InfoGroupConfigEntity infoGroupConfig = (InfoGroupConfigEntity)SerializationUtils.fromJsonString((String)infoGroupConfigStr, InfoGroupConfigEntity.class);
        IPageCache pageCache = this.getPageCache();
        pageCache.put("groupId", String.valueOf(infoGroup.getInfoGroupId()));
        pageCache.put("infoGroup", JSONObject.toJSONString((Object)infoGroup));
        pageCache.put("candidateid", candidateId);
        pageCache.put("onbrdid", onboardId);
        id = Objects.isNull(id) ? "0" : id;
        pageCache.put("mainId", id);
        pageCache.put("infoGroupConfig", infoGroupConfigStr);
        pageCache.put("activityId", String.valueOf(activityId));
        pageCache.put("isMulti", isMulti);
        pageCache.put("rows", (String)showParameter.getCustomParam("rows"));
        this.cacheCertConfig();
        Map<String, List<InfoGroupEntity.InfoGroupField>> entityFieldMap = infoGroup.getInfoGroupFieldList().stream().collect(Collectors.groupingBy(InfoGroupEntity.InfoGroupField::getPageKey));
        HashMap<String, String> isEditMap = new HashMap<String, String>(entityFieldMap.size());
        if (!OperationStatus.ADDNEW.equals((Object)showParameter.getStatus()) && !HRStringUtils.equals((String)id, (String)"0")) {
            this.modelBindData(entityFieldMap, candidateId, id, isMulti, isEditMap);
            this.getModel().setDataChanged(false);
            if (OperationStatus.EDIT.equals((Object)showParameter.getStatus())) {
                this.showRejectInfoFrom(infoGroup, Long.parseLong(this.getPageCache().get("mainId")));
            }
        }
        List<String> fieldNameList = infoGroup.getInfoGroupFieldList().stream().filter(InfoGroupEntity.InfoGroupField::getFieldOcr).map(InfoGroupEntity.InfoGroupField::getFieldName).collect(Collectors.toList());
        if (Objects.nonNull(this.getModel().getDataEntityType().getProperties().get((Object)"textocrtip"))) {
            this.getModel().setValue("textocrtip", (Object)InfoGroupDynViewMobilePlugin.getOcrTipsInfo(fieldNameList, this.getView()));
        }
        if (InfoGroupEnum.CERTIFICATE_INFO.getNumber().equalsIgnoreCase(infoGroup.getInfoGroupNumber())) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"fieldcerttype"});
            Object certtypeValue = this.getModel().getValue("fieldcerttype");
            if (Objects.isNull(certtypeValue) || HRStringUtils.isEmpty((String)((String)certtypeValue))) {
                if (CollectionUtils.isEmpty((Collection)infoGroupConfig.getInfoGroupCertEntityList())) {
                    this.getModel().setValue("fieldcerttype", (Object)InfoGroupCertTypeEnum.IDCARD.getId());
                } else {
                    String certSortInfoStr = "{\"1010\":1,\"1060\":2,\"1070\":3,\"1050\":4,\"1020\":5}";
                    Map certSortRuleMap = (Map)JSONObject.parseObject((String)certSortInfoStr, Map.class);
                    List infoGroupCertEntityList = infoGroupConfig.getInfoGroupCertEntityList().stream().sorted(Comparator.comparingInt(cert -> certSortRuleMap.getOrDefault(cert.getCertTypeNumber(), Integer.MAX_VALUE))).collect(Collectors.toList());
                    this.getModel().setValue("fieldcerttype", (Object)((InfoGroupCertEntity)infoGroupCertEntityList.get(0)).getCertTypeNumber());
                }
                this.getModel().setValue("field" + InfoGroupFieldConstants.CERT_TYPE, this.getModel().getValue("fieldcerttype"));
                this.getModel().getDataEntity().set("field" + InfoGroupFieldConstants.CERT_TYPE + "_id", this.getModel().getValue("fieldcerttype"));
            }
            if (!HRStringUtils.isBlank((CharSequence)candidateId)) {
                DynamicObject canBaseInfo = IHomToHcfAppService.getInstance().getSingleRowEntity(Long.valueOf(Long.parseLong(candidateId)), "hcf_canbaseinfo");
                HOMObjectUtils.setFieldValueIfEmpty((IDataModel)this.getModel(), (String)("field" + InfoGroupFieldConstants.CERT_NAME), (Object)canBaseInfo.get("name"));
                HOMObjectUtils.setFieldValueIfEmpty((IDataModel)this.getModel(), (String)("field" + InfoGroupFieldConstants.CERT_GENDER), (Object)canBaseInfo.get("gender"));
                HOMObjectUtils.setFieldValueIfEmpty((IDataModel)this.getModel(), (String)("field" + InfoGroupFieldConstants.CERT_NATIONALITY), (Object)canBaseInfo.get("nationality"));
                HOMObjectUtils.setFieldValueIfEmpty((IDataModel)this.getModel(), (String)("field" + InfoGroupFieldConstants.CERT_BIR), (Object)canBaseInfo.get("birthday"));
                HOMObjectUtils.setFieldValueIfEmpty((IDataModel)this.getModel(), (String)("field" + InfoGroupFieldConstants.CERT_NATION), (Object)canBaseInfo.get("folk"));
            }
        }
        this.getModel().setValue("texttitle", (Object)infoGroup.getInfoGroupName());
        this.getView().setEnable(Boolean.FALSE, new String[]{"texttitle"});
        FlexPanelAp flexPanelAp = this.loadMetas(infoGroup, infoGroupConfig, this.isPreview(showParameter), null);
        Container fldPanel = (Container)this.getView().getControl("flexpanelap");
        fldPanel.getItems().addAll(((Container)flexPanelAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(fldPanel.getItems());
        String pageKeys = String.join((CharSequence)",", entityFieldMap.keySet());
        this.getPageCache().put("isEditMap", JSONObject.toJSONString(isEditMap));
        pageCache.put("pageKey", pageKeys);
        pageCache.put("entityFieldMap", SerializationUtils.toJsonString(entityFieldMap));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String hasRejectField = (String)formShowParameter.getCustomParam("hasRejectField");
        String jsonObject = (String)this.getView().getFormShowParameter().getCustomParam("infoGroupEntity");
        InfoGroupEntity infoGroup = (InfoGroupEntity)JSONObject.parseObject((String)jsonObject, InfoGroupEntity.class);
        int remarkFieldCount = infoGroup.getInfoGroupFieldList().stream().filter(infoGroupField -> !HRObjectUtils.isEmpty((Object)infoGroupField.getFieldRemark())).toArray().length;
        this.getView().setVisible(Boolean.valueOf(remarkFieldCount > 0), new String[]{"announcenment"});
        this.getView().setVisible(Boolean.valueOf(HRStringUtils.equals((String)hasRejectField, (String)"1")), new String[]{"modifytail"});
        ((ICollectValidateService)ServiceFactory.getService(ICollectValidateService.class)).dealCertField(this.getModel(), this.getView());
        this.setUnEnable();
        if (HRStringUtils.isNotEmpty((String)((String)formShowParameter.getCustomParam("h5preview")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"mtoolbarap"});
        }
        this.dealEduInfoGroup();
        this.dealLanguageInfoGroup();
        this.setVisibleEduLevel();
        this.refreshDateFieldRange(InfoGroupFieldConstants.BASE_BIRTHDAY, InfoGroupFieldConstants.CERT_BIR, InfoGroupFieldConstants.CERT_ISSUEDATE, InfoGroupFieldConstants.CERT_EXPIRATIONDATE, InfoGroupFieldConstants.LANG_SIGNTIME, InfoGroupFieldConstants.WORK_STARTDATE, InfoGroupFieldConstants.WORK_ENDDATE, InfoGroupFieldConstants.RSMPATINV_APPLYTIME, InfoGroupFieldConstants.EXAM_TIME);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity.getDataEntityType().getProperties().containsKey((Object)("field" + InfoGroupFieldConstants.ISMAJOR_CERT)) && dataEntity.getBoolean("field" + InfoGroupFieldConstants.ISMAJOR_CERT)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"field" + InfoGroupFieldConstants.ISMAJOR_CERT});
        }
    }

    protected void setVisibleEduLevel() {
        String[] fieldList = InfoGroupFieldConstants.EDU_FIELD_SET.stream().map(field -> "fieldboard" + field).collect(Collectors.toList()).toArray(new String[0]);
        this.getView().setVisible(Boolean.TRUE, fieldList);
        if (HRObjectUtils.isEmpty((Object)this.getModel().getDataEntity().getDynamicObjectType().getProperties().get((Object)("field" + InfoGroupFieldConstants.EDUCATIONID))) || HRObjectUtils.isEmpty((Object)this.getModel().getValue("field" + InfoGroupFieldConstants.EDUCATIONID))) {
            return;
        }
        String educationNumber = this.getModel().getDataEntity().getString("field" + InfoGroupFieldConstants.EDUCATIONID + ".number");
        EduPageServiceImpl service = new EduPageServiceImpl();
        String educationId = service.educationNumberToId(educationNumber);
        Set configSet = ((IHomConfigDomainService)ServiceFactory.getService(IHomConfigDomainService.class)).getConfigSet(this.getView(), "lower_edu_id", "lower_edu_id");
        if (configSet.contains(educationId)) {
            this.getModel().setValue("field" + InfoGroupFieldConstants.EDU_SCHOOLNAME, (Object)InfoGroupFieldConstants.OTHER_SCHOOL_ID);
            this.getView().setVisible(Boolean.FALSE, fieldList);
        }
    }

    private void refreshDateFieldRange(Long ... fieldIds) {
        if (HRArrayUtils.isEmpty((Object[])fieldIds)) {
            return;
        }
        FormViewPluginProxy service = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        if (HRObjectUtils.isEmpty((Object)service)) {
            return;
        }
        for (Long fieldId : fieldIds) {
            Control control = this.getControl("field" + fieldId);
            if (HRObjectUtils.isEmpty((Object)control)) continue;
            OnGetControlArgs e1 = new OnGetControlArgs((Object)this, "field" + fieldId);
            e1.setControl(control);
            service.fireOnGetControl(e1);
        }
    }

    protected void dealEduInfoGroup() {
        ((ICollectValidateService)ServiceFactory.getService(ICollectValidateService.class)).dealEduInfoGroup(this.getModel(), this.getView());
    }

    protected void dealLanguageInfoGroup() {
        ((ICollectValidateService)ServiceFactory.getService(ICollectValidateService.class)).dealLanguageInfoGroup(this.getModel(), this.getView());
    }

    private void setUnEnable() {
        ArrayList fieldIdList = Lists.newArrayListWithExpectedSize((int)5);
        this.getView().setEnable(Boolean.FALSE, fieldIdList.toArray(new String[0]));
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        String infoGroupConfig = this.getPageCache().get("infoGroup");
        if (StringUtils.isEmpty((CharSequence)infoGroupConfig)) {
            return;
        }
        if ("fieldcerttype".equals(key)) {
            ComboEdit comboEdit = new ComboEdit();
            comboEdit.setKey(key);
            comboEdit.setView(this.getView());
            e.setControl((Control)comboEdit);
            return;
        }
        InfoGroupEntity infoGroup = (InfoGroupEntity)JSON.parseObject((String)infoGroupConfig, InfoGroupEntity.class);
        List fieldList = infoGroup.getInfoGroupFieldList();
        Map<String, InfoGroupEntity.InfoGroupField> fieldIdList = fieldList.stream().collect(Collectors.toMap(field -> "field" + field.getFieldId(), obj -> obj));
        if (!fieldIdList.containsKey(key)) {
            return;
        }
        InfoGroupEntity.InfoGroupField infoGroupField = fieldIdList.get(key);
        this.setBaseControl(e, infoGroupField);
    }

    public void beforeClick(BeforeClickEvent evt) {
        Button button;
        super.beforeClick(evt);
        Object source = evt.getSource();
        if (source instanceof Button && "barsave".equals((button = (Button)source).getKey())) {
            this.saveCheck(evt);
            this.saveCertCheck(evt);
            this.savePhoneAndEmailCheck(evt);
        }
    }

    public void click(EventObject evt) {
        Button button;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button && "barsave".equals((button = (Button)source).getKey())) {
            this.save();
        }
    }

    private void save() {
        DynamicObject dy = this.getModel().getDataEntity();
        String pageKeys = this.getPageCache().get("pageKey");
        String onboardId = this.getPageCache().get("onbrdid");
        String candidateId = this.getPageCache().get("candidateid");
        String entityFieldMapStr = this.getPageCache().get("entityFieldMap");
        String activityId = this.getPageCache().get("activityId");
        InfoGroupEntity infoGroup = (InfoGroupEntity)SerializationUtils.fromJsonString((String)this.getPageCache().get("infoGroup"), InfoGroupEntity.class);
        Map isEditMap = (Map)JSONObject.parseObject((String)this.getPageCache().get("isEditMap"), Map.class);
        Map entityFieldMap = (Map)JSONObject.parseObject((String)entityFieldMapStr, Map.class);
        Stream.of(pageKeys.split(",")).forEach(pageKey -> this.saveData(dy, (String)pageKey, Long.valueOf(candidateId), ((JSONArray)entityFieldMap.get(pageKey)).toJavaList(InfoGroupEntity.InfoGroupField.class), this.getPageCache().getAll(), isEditMap));
        if (!this.hasRejectActivity(activityId)) {
            ((ICollectGroupStatusService)ServiceFactory.getService(ICollectGroupStatusService.class)).completeCollectGroup(Collections.singletonList(infoGroup.getInfoGroupId()), Long.valueOf(Long.parseLong(activityId)));
        }
        ((ICollectService)ServiceFactory.getService(ICollectService.class)).syncSubmitPro(Long.valueOf(Long.parseLong(onboardId)));
        IHcfDataDomainService.getInstance().syncDataFormHcfToHom(Long.valueOf(Long.parseLong(onboardId)));
        IFormView parentView = this.getView().getParentView();
        if (Objects.nonNull(parentView)) {
            parentView.invokeOperation("refresh");
            if (Objects.nonNull(parentView.getParentView())) {
                parentView.getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(parentView.getParentView());
            }
            this.getView().sendFormAction(parentView);
        }
    }

    public void saveData(DynamicObject dataEntity, String pageKey, Long candidateId, List<InfoGroupEntity.InfoGroupField> fieldList, Map<String, String> variables, Map<String, String> isEditMap) {
        DynamicObject dy;
        DynamicObjectCollection saveDataDyColl;
        long id = 0L;
        if (HRStringUtils.isEmpty((String)variables.get("mainId")) || HRStringUtils.equals((String)variables.get("mainId"), (String)"0")) {
            id = ORM.create().genLongId(pageKey);
            variables.put("mainId", String.valueOf(id));
        }
        HashMap result = new HashMap();
        if ("hcf_canaddress".equals(pageKey)) {
            this.saveAddress(dataEntity, pageKey, candidateId, variables.get("mainId"));
            return;
        }
        if ("hcf_educertificate".equals(pageKey)) {
            Map<String, Long> idMap = this.saveCertificate(dataEntity, pageKey, candidateId, fieldList, variables.get("mainId"));
            List<InfoGroupEntity.InfoGroupField> collect = fieldList.stream().filter(field -> 2 == field.getFieldType()).collect(Collectors.toList());
            this.saveCertificateAttachment(variables, idMap, collect);
            return;
        }
        if (pageKey.contains("hom_")) {
            String onboardId = this.getPageCache().get("onbrdid");
            DynamicObject homEntity = HomCommonRepository.queryDynamicObjectByPk((String)pageKey, (String)"", (Object)Long.parseLong(onboardId));
            this.setDyDataFromModel(dataEntity, fieldList, homEntity, variables, homEntity.getLong("id"));
            HomCommonRepository.updateDynamicObject((String)pageKey, (DynamicObject)homEntity);
            logger.info("save page:{} onboardId:{} success", (Object)pageKey, (Object)onboardId);
            return;
        }
        DynamicObject candidate = HomCommonRepository.queryDynamicObjectByPk((String)"hcf_candidate", (String)"", (Object)candidateId);
        IHomToHcfAppService iHomToHcfAppService = IHomToHcfAppService.getInstance();
        if ("hcf_cancre".equalsIgnoreCase(pageKey) && dataEntity.getDataEntityType().getProperties().containsKey((Object)("field" + InfoGroupFieldConstants.ISMAJOR_CERT)) && dataEntity.getBoolean("field" + InfoGroupFieldConstants.ISMAJOR_CERT)) {
            DynamicObjectCollection hisMultiRowEntity = iHomToHcfAppService.getHisMultiRowEntity(candidateId, pageKey);
            saveDataDyColl = new DynamicObjectCollection();
            hisMultiRowEntity.stream().filter(dynamicObject -> dynamicObject.getBoolean("ismajor")).forEach(dynamicObject -> {
                DynamicObject dy = this.getNewDyObject(pageKey, (DynamicObject)dynamicObject, false, "0");
                dy.set("boid", (Object)dynamicObject.getLong("id"));
                dy.set("candidate", (Object)candidate);
                dy.set("ismajor", (Object)Boolean.FALSE);
                saveDataDyColl.add((Object)dy);
            });
            this.saveOrUpdate(pageKey, saveDataDyColl, candidateId);
        }
        if (Sets.newHashSet((Object[])((IHomConfigService)ServiceFactory.getService(IHomConfigService.class)).getConfVal("hcf_multipagelist", "hcf_educertificate,hcf_caneduexp,hcf_canlgability,hcf_canfamily,hcf_rsmpatinv,hcf_cancontact,hcf_canprework,hcf_cancre,hcf_canbankcard,hcf_canocpqual").split(",")).contains(pageKey)) {
            String pkId;
            DynamicObjectCollection hisMultiRowEntity = iHomToHcfAppService.getHisMultiRowEntity(candidateId, pageKey);
            String isEditFlag = isEditMap.get(pageKey);
            String confVal = ((IHomConfigService)ServiceFactory.getService(IHomConfigService.class)).getConfVal("hcf_nonehisentity", "hcf_rsmpatinv,hcf_canbankcard,hcf_educertificate,hcf_canocpqual");
            InfoGroupFieldConstants.NO_HIS_TABLE = Sets.newHashSet((Object[])confVal.split(","));
            String string = pkId = InfoGroupFieldConstants.NO_HIS_TABLE.contains(pageKey) ? "id" : "boid";
            if (isEditFlag != null && HRStringUtils.equals((String)isEditFlag, (String)"1")) {
                dy = hisMultiRowEntity.stream().filter(dbDy -> HRStringUtils.equals((String)dbDy.getString(pkId), (String)((String)variables.get("mainId")))).findFirst().get();
                variables.put("mainId", dy.getString(pkId));
                id = dy.getLong(pkId);
                dy = this.getNewDyObject(pageKey, dy, false, "0");
                dy.set(pkId, (Object)id);
            } else {
                dy = this.getNewDyObject(pageKey, null, true, variables.get("mainId"));
            }
        } else {
            dy = iHomToHcfAppService.getSingleRowEntity(candidateId, pageKey);
            if (HRObjectUtils.isEmpty((Object)dy)) {
                dy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)pageKey));
            }
            variables.put("mainId", dy.getString("id"));
            id = dy.getLong("id");
            dy = this.getNewDyObject(pageKey, dy, HRObjectUtils.isEmpty((Object)dy), HRObjectUtils.isEmpty((Object)dy) ? variables.get("mainId") : "0");
        }
        dy.set("candidate", (Object)candidate);
        this.setDyDataFromModel(dataEntity, fieldList, dy, variables, id);
        if ("hcf_caneduexp".equals(pageKey) && dataEntity.getDataEntityType().getProperties().containsKey((Object)("field" + InfoGroupFieldConstants.EDU_IS_HIGHEST_DEGREE)) && dataEntity.getBoolean("field" + InfoGroupFieldConstants.EDU_IS_HIGHEST_DEGREE)) {
            DynamicObjectCollection attachData = iHomToHcfAppService.getHisMultiRowEntity(candidateId, pageKey);
            DynamicObjectCollection saveDataDyColl2 = new DynamicObjectCollection();
            attachData.forEach(data -> {
                data = this.getNewDyObject(pageKey, (DynamicObject)data, false, "0");
                data.set("ishighestdegree", (Object)Boolean.FALSE);
                data.set("boid", (Object)data.getLong("boid"));
                saveDataDyColl2.add(data);
            });
            this.saveOrUpdate(pageKey, saveDataDyColl2, candidateId);
        }
        saveDataDyColl = new DynamicObjectCollection();
        saveDataDyColl.add((Object)dy);
        this.saveOrUpdate(pageKey, saveDataDyColl, candidateId);
        if ("hcf_cancre".equalsIgnoreCase(pageKey) && dataEntity.getDataEntityType().getProperties().containsKey((Object)("field" + InfoGroupFieldConstants.ISMAJOR_CERT)) && dataEntity.getBoolean("field" + InfoGroupFieldConstants.ISMAJOR_CERT)) {
            String onboardId = this.getPageCache().get("onbrdid");
            ((ICollectService)ServiceFactory.getService(ICollectService.class)).syncMajorCertInfo(candidateId, Long.valueOf(Long.parseLong(onboardId)));
        }
        logger.info("save page:{} candidateId:{} result:{}", new Object[]{pageKey, candidateId, result});
    }

    private void saveOrUpdate(String pageKey, DynamicObjectCollection saveDataDyColl, Long candidateId) {
        String confVal = ((IHomConfigService)ServiceFactory.getService(IHomConfigService.class)).getConfVal("hcf_nonehisentity", "hcf_rsmpatinv,hcf_canbankcard,hcf_educertificate,hcf_canocpqual");
        InfoGroupFieldConstants.NO_HIS_TABLE = Sets.newHashSet((Object[])confVal.split(","));
        if (InfoGroupFieldConstants.NO_HIS_TABLE.contains(pageKey)) {
            HashMap<String, DynamicObjectCollection> collMap = new HashMap<String, DynamicObjectCollection>();
            collMap.put(pageKey, saveDataDyColl);
            IHomToHcfAppService.getInstance().saveCandidateInfo(collMap, candidateId);
        } else {
            HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>(2);
            map.put(pageKey, saveDataDyColl);
            ArrayList<HashMap<String, DynamicObjectCollection>> list = new ArrayList<HashMap<String, DynamicObjectCollection>>(1);
            list.add(map);
            IHomToHcfAppService.getInstance().saveOrUpdateCandidates(list);
        }
    }

    private DynamicObject getNewDyObject(String pageKey, DynamicObject sourceDy, boolean add, String id) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)pageKey);
        DynamicObject newDy = new DynamicObject((DynamicObjectType)dataEntityType);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        if (add) {
            if (properties.containsKey((Object)"boid")) {
                newDy.set("boid", null);
            }
        } else {
            HRDynamicObjectUtils.copy((DynamicObject)sourceDy, (DynamicObject)newDy);
        }
        newDy.set("id", (Object)id);
        if (properties.containsKey((Object)"sourcevid")) {
            newDy.set("sourcevid", (Object)0L);
        }
        return newDy;
    }

    private void setSubEntityData(List<InfoGroupEntity.InfoGroupField> fieldList, DynamicObject sourceDy, DynamicObject targetDy) {
        fieldList.forEach(field -> targetDy.set(field.getFieldKey(), sourceDy.get("field" + field.getFieldId())));
    }

    public void afterUpload(UploadEvent event) {
        boolean enableOCR = OcrToBusinessUtils.getEnableOCR(this.getView());
        logger.info("ocrenable2=={}", (Object)enableOCR);
        if (!enableOCR) {
            return;
        }
        Control source = (Control)event.getSource();
        Object[] urls = event.getUrls();
        Long fieldLongId = Long.parseLong(source.getKey().replace("field", ""));
        Map entityFieldMap = (Map)JSONObject.parseObject((String)this.getPageCache().get("entityFieldMap"), Map.class);
        String templateNumber = AbstractCollectDynViewPlugin.getTemplateNumber(fieldLongId, this.getPageCache().get("groupId"), 0L);
        logger.info(MessageFormat.format("templateNumber {0}", templateNumber));
        if (HRStringUtils.isEmpty((String)templateNumber)) {
            return;
        }
        OcrToBusinessUtils.ocrWithDataH5(urls, AbstractCollectDynViewPlugin.getPageKey(fieldLongId, entityFieldMap), templateNumber, this.getView());
    }

    public void clientCallBack(ClientCallBackEvent event) {
        AbstractCollectDynViewPlugin.executeOCRTask(event, this.getView(), "H5");
    }

    private void setDyDataFromModel(DynamicObject dataEntity, List<InfoGroupEntity.InfoGroupField> fieldList, DynamicObject singleRowEntity, Map<String, String> variables, Long id) {
        List<String> visibleFiledList = this.getVisibleFiledList();
        DataEntityPropertyCollection properties = singleRowEntity.getDataEntityType().getProperties();
        for (InfoGroupEntity.InfoGroupField infoGroupField : fieldList) {
            String fieldKey = "field" + infoGroupField.getFieldId();
            if (InfoGroupFieldConstants.EDU_SCHOOLNAME.equals(infoGroupField.getFieldId())) {
                singleRowEntity.set(infoGroupField.getFieldKey() + "_id", dataEntity.get(fieldKey + "_id"));
                continue;
            }
            if (visibleFiledList.contains(fieldKey) && !InfoGroupFieldConstants.CERT_TYPE.equals(infoGroupField.getFieldId())) {
                if (!singleRowEntity.containsProperty(infoGroupField.getFieldKey()) || !InfoGroupFieldConstants.CERT_EXPIRATIONDATE.equals(infoGroupField.getFieldId())) continue;
                singleRowEntity.set(infoGroupField.getFieldKey(), null);
                continue;
            }
            if (infoGroupField.getFieldType() == Integer.parseInt(InfoGroupFieldTypeEnum.ATTACH.getFieldType())) {
                String attachKey = infoGroupField.getFieldKey();
                String pageId = infoGroupField.getPageKey();
                String removeId = variables.get(fieldKey + "_removeUid");
                String attachStr = variables.get(fieldKey);
                AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(fieldKey);
                attachStr = SerializationUtils.toJsonString((Object)attachmentPanel.getAttachmentData());
                String appId = "hom";
                if (InfoGroupFieldConstants.CHECKIN_ATTACH.equals(infoGroupField.getFieldId())) {
                    attachKey = infoGroupField.getFieldKey();
                    pageId = infoGroupField.getPageKey();
                }
                this.saveAndRemoveAttachment(appId, attachKey, pageId, id, attachStr);
                this.removeAttachment(pageId, removeId, id);
                continue;
            }
            if (InfoGroupFieldConstants.RSM_PTDATA.equals(infoGroupField.getFieldId())) {
                singleRowEntity.set("ptstartdate", dataEntity.get("field" + infoGroupField.getFieldId() + "_ptstartdate"));
                singleRowEntity.set("ptendingdate", dataEntity.get("field" + infoGroupField.getFieldId() + "_ptendingdate"));
                continue;
            }
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)infoGroupField.getFieldKey());
            if (iDataEntityProperty instanceof BasedataProp && HRObjectUtils.isEmpty((Object)dataEntity.get(fieldKey))) {
                singleRowEntity.set(infoGroupField.getFieldKey() + "_id", dataEntity.get(fieldKey + "_id"));
                continue;
            }
            if (iDataEntityProperty instanceof MulBasedataProp) {
                MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)dataEntity.get(fieldKey);
                MulBasedataDynamicObjectCollection newMul = (MulBasedataDynamicObjectCollection)singleRowEntity.get(infoGroupField.getFieldKey());
                newMul.clear();
                mulBasedataDynamicObjectCollection.forEach(dynamicObject -> {
                    long fbasedataid_id = dynamicObject.getLong("fbasedataid_id");
                    DynamicObject dynamicObject1 = newMul.addNew();
                    dynamicObject1.set("fbasedataid", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)fbasedataid_id, (String)((MulBasedataProp)iDataEntityProperty).getBaseEntityId()));
                    dynamicObject1.set("fbasedataid_id", (Object)fbasedataid_id);
                });
                continue;
            }
            Object value = dataEntity.get(fieldKey);
            if (InfoGroupFieldConstants.PHONELIST.contains(infoGroupField.getFieldId())) {
                String tmpValue;
                String string = tmpValue = value == null ? "" : value.toString();
                if (!tmpValue.contains("+86-")) {
                    value = tmpValue.replace("+86", "+86-");
                }
            }
            singleRowEntity.set(infoGroupField.getFieldKey(), value);
        }
    }

    public void buildAddressDy(String pageKey, Long candidateId, DynamicObject modelDy, String addressType, DynamicObjectCollection hisMultiRowEntity, Map<String, List<DynamicObject>> collect) {
        DynamicObject dyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)pageKey));
        List<DynamicObject> dynamicObjects = collect.get(addressType);
        if (!CollectionUtils.isEmpty(dynamicObjects)) {
            DynamicObject dbDy = dynamicObjects.get(dynamicObjects.size() - 1);
            dyn.set("boid", (Object)dbDy.getLong("boid"));
            HRDynamicObjectUtils.copy((DynamicObject)dbDy, (DynamicObject)dyn);
        } else {
            dyn.set("boid", null);
        }
        hisMultiRowEntity.add((Object)dyn);
        dyn.set("candidate", (Object)candidateId);
        dyn.set("addresstype", (Object)IHcfDataDomainService.getInstance().getAddressTypeById(Long.valueOf(Long.parseLong(addressType))));
        String confVal = ((IHomConfigService)ServiceFactory.getService(IHomConfigService.class)).getConfVal("ADDRESS_ID_MAP", "");
        if (HRStringUtils.isNotEmpty((String)confVal)) {
            Map map = (Map)JSONObject.parseObject((String)confVal, Map.class);
            InfoGroupFieldConstants.ADDRESS_ID_MAP.putAll(map);
        }
        for (Map.Entry stringLongEntry : InfoGroupFieldConstants.ADDRESS_ID_MAP.entrySet()) {
            String key = (String)stringLongEntry.getKey();
            if (!key.startsWith(addressType + "_")) continue;
            String fieldKey = key.substring((addressType + "_").length());
            Long fieldId = (Long)stringLongEntry.getValue();
            if (HRObjectUtils.isEmpty((Object)modelDy.getDataEntityType().getProperties().get((Object)("field" + fieldId)))) continue;
            if (!HRObjectUtils.isEmpty((Object)modelDy.getDataEntityType().getProperties().get((Object)("field" + fieldId + "_id")))) {
                dyn.set(fieldKey, modelDy.get("field" + fieldId + "_id"));
                continue;
            }
            dyn.set(fieldKey, modelDy.get("field" + fieldId));
        }
    }

    private void saveAddress(DynamicObject dataEntity, String pageKey, Long candidateId, String mainId) {
        DynamicObjectCollection hisMultiRowEntity = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, pageKey);
        if (HRObjectUtils.isEmpty((Object)hisMultiRowEntity)) {
            hisMultiRowEntity = new DynamicObjectCollection();
        }
        DynamicObjectCollection multiRowEntity = new DynamicObjectCollection();
        Map<String, List<DynamicObject>> collect = hisMultiRowEntity.stream().filter(dynamicObject -> !HRStringUtils.isEmpty((String)dynamicObject.getString("addresstype.id"))).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("addresstype.id")));
        String confVal = ((IHomConfigService)ServiceFactory.getService(IHomConfigService.class)).getConfVal("address_type_str", InfoGroupFieldConstants.ADDRESS_TYPE_DEFAULT_STR);
        for (String addressType : confVal.split(",")) {
            this.buildAddressDy(pageKey, candidateId, dataEntity, addressType, multiRowEntity, collect);
        }
        this.saveOrUpdate(pageKey, multiRowEntity, candidateId);
        logger.info("save page:{} candidateId:{} result:{}", (Object)pageKey, (Object)candidateId);
    }

    private Map<String, Long> saveCertificate(DynamicObject dataEntity, String pageKey, Long candidateId, List<InfoGroupEntity.InfoGroupField> fieldList, String eduId) {
        DynamicObjectCollection hisMultiRowEntity = new DynamicObjectCollection();
        Map certificateMap = MultiBaseDataFiledViewServiceImpl.getCertificateByNumber((Long)candidateId, (String)eduId);
        Map<String, List<InfoGroupEntity.InfoGroupField>> certiFiledMap = fieldList.stream().filter(field -> 2 != field.getFieldType()).collect(Collectors.groupingBy(field -> (String)InfoGroupFieldConstants.EDU_CERTIFICATE_MAP.get(field.getFieldId())));
        HashMap<String, Long> idMap = new HashMap<String, Long>();
        if (certiFiledMap.isEmpty()) {
            Map<String, List<InfoGroupEntity.InfoGroupField>> certFiledAttachMap = fieldList.stream().filter(field -> 2 == field.getFieldType()).collect(Collectors.groupingBy(field -> (String)InfoGroupFieldConstants.EDU_CERTIFICATE_MAP.get(field.getFieldId())));
            certFiledAttachMap.forEach((certTypeId, fields) -> {
                DynamicObject certFieldAttachDy = (DynamicObject)certificateMap.get(certTypeId);
                if (HRObjectUtils.isEmpty((Object)certFieldAttachDy)) {
                    Long id = ORM.create().genLongId(pageKey);
                    certFieldAttachDy = this.getNewDyObject(pageKey, null, true, String.valueOf(id));
                    certFieldAttachDy.set("certtype", (Object)HomCommonRepository.queryDynamicObjectByPk((String)"hbss_educerttype", (String)"", (Object)Long.parseLong(certTypeId)));
                } else {
                    certFieldAttachDy = this.getNewDyObject(pageKey, certFieldAttachDy, false, certFieldAttachDy.getString("id"));
                }
                certFieldAttachDy.set("edu", (Object)eduId);
                hisMultiRowEntity.add((Object)certFieldAttachDy);
                idMap.put((String)certTypeId, certFieldAttachDy.getLong("id"));
            });
        } else {
            certiFiledMap.forEach((certTypeId, fields) -> {
                DynamicObject certiDy = (DynamicObject)certificateMap.get(certTypeId);
                if (HRObjectUtils.isEmpty((Object)certiDy)) {
                    Long id = ORM.create().genLongId(pageKey);
                    certiDy = this.getNewDyObject(pageKey, null, true, String.valueOf(id));
                    this.setSubEntityData((List<InfoGroupEntity.InfoGroupField>)fields, dataEntity, certiDy);
                    certiDy.set("certtype", (Object)HomCommonRepository.queryDynamicObjectByPk((String)"hbss_educerttype", (String)"", (Object)Long.parseLong(certTypeId)));
                } else {
                    certiDy = this.getNewDyObject(pageKey, certiDy, false, certiDy.getString("id"));
                    this.setSubEntityData((List<InfoGroupEntity.InfoGroupField>)fields, dataEntity, certiDy);
                }
                certiDy.set("edu", (Object)eduId);
                hisMultiRowEntity.add((Object)certiDy);
                idMap.put((String)certTypeId, certiDy.getLong("id"));
            });
        }
        this.saveOrUpdate(pageKey, hisMultiRowEntity, candidateId);
        logger.info("save page:{} candidateId:{}", (Object)pageKey, (Object)candidateId);
        return idMap;
    }

    private void saveAndRemoveAttachment(String appId, String attachKey, String pageId, Object id, String attachStr) {
        if (!HRStringUtils.isEmpty((String)attachStr)) {
            List attachments = (List)SerializationUtils.fromJsonString((String)attachStr, List.class);
            HashMap<String, List> attachmentInfo = new HashMap<String, List>();
            attachmentInfo.put(attachKey, attachments);
            attachments.forEach(atatchMap -> atatchMap.put("size", Long.parseLong(atatchMap.get("size").toString())));
            AttachmentServiceHelper.saveTempAttachments((String)pageId, (Object)id, (String)appId, attachmentInfo);
        }
    }

    private void removeAttachment(String pageKey, String removeUidString, Object id) {
        if (!HRStringUtils.isEmpty((String)removeUidString)) {
            Set removeUidSet = (Set)SerializationUtils.fromJsonString((String)removeUidString, Set.class);
            removeUidSet.forEach(uid -> AttachmentServiceHelper.remove((String)pageKey, (Object)id, (Object)uid));
        }
    }

    private void saveCertificateAttachment(Map<String, String> variables, Map<String, Long> idMap, List<InfoGroupEntity.InfoGroupField> collect) {
        String pageKey = "hcf_educertificate";
        collect.forEach(field -> {
            String appId = "hcf";
            String fieldKey = "field" + field.getFieldId();
            Long dataId = (Long)idMap.get(InfoGroupFieldConstants.EDU_CERTIFICATE_MAP.get(field.getFieldId()));
            AttachmentPanel control = (AttachmentPanel)this.getControl("field" + field.getFieldId());
            String attachStr = SerializationUtils.toJsonString((Object)control.getAttachmentData());
            String removeId = (String)variables.get(fieldKey + "_removeUid");
            this.saveAndRemoveAttachment(appId, field.getFieldKey(), pageKey, dataId, attachStr);
            this.removeAttachment(pageKey, removeId, dataId);
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"barsave"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)"detailsave", (String)op.getOperateKey())) {
            // empty if block
        }
    }

    private List<String> getVisibleFiledList() {
        ArrayList<String> result = new ArrayList<String>();
        ((ICollectValidateService)ServiceFactory.getService(ICollectValidateService.class)).getCertVisibleField(result, this.getModel(), this.getView());
        ((ICollectValidateService)ServiceFactory.getService(ICollectValidateService.class)).getEduVisibleField(result, this.getModel());
        ((ICollectValidateService)ServiceFactory.getService(ICollectValidateService.class)).getLangVisibleField(result, this.getModel());
        ((ICollectValidateService)ServiceFactory.getService(ICollectValidateService.class)).getEduLevel(result, this.getModel(), this.getView());
        return result;
    }

    private void saveCheck(BeforeClickEvent evt) {
        DynamicObject dy;
        DataEntityPropertyCollection properties;
        Map entityFieldMap = (Map)JSONObject.parseObject((String)this.getPageCache().get("entityFieldMap"), Map.class);
        ArrayList<InfoGroupEntity.InfoGroupField> fieldStatusVerifyList = new ArrayList<InfoGroupEntity.InfoGroupField>();
        ArrayList fieldStatusVerifyDescList = new ArrayList();
        List<String> visibleFiledList = this.getVisibleFiledList();
        AtomicBoolean allEmpty = new AtomicBoolean(true);
        entityFieldMap.forEach((pageKey, fieldList) -> {
            List infoGroupFields = fieldList.toJavaList(InfoGroupEntity.InfoGroupField.class);
            List<InfoGroupEntity.InfoGroupField> errorFieldList = CustomStyleUtils.checkFieldList(visibleFiledList, infoGroupFields, this.getView(), allEmpty);
            fieldStatusVerifyDescList.addAll(CustomStyleUtils.checkFieldDescList(visibleFiledList, infoGroupFields, this.getView(), allEmpty));
            fieldStatusVerifyList.addAll(errorFieldList);
        });
        if (!CollectionUtils.isEmpty(fieldStatusVerifyList)) {
            StringBuilder errorMessage = CustomStyleUtils.getErrorMessage(fieldStatusVerifyList, this.getView());
            this.getView().showTipNotification(errorMessage.toString());
            evt.setCancel(true);
        }
        if (!CollectionUtils.isEmpty(fieldStatusVerifyDescList)) {
            this.getView().showTipNotification((String)fieldStatusVerifyDescList.get(0));
            evt.setCancel(true);
        }
        if ((properties = (dy = this.getModel().getDataEntity()).getDynamicObjectType().getProperties()).containsKey((Object)("field" + InfoGroupFieldConstants.BANK_ACCOUNT))) {
            String account = dy.getString("field" + InfoGroupFieldConstants.BANK_ACCOUNT);
            Optional accoutOp = IOnbrdCommonAppService.getInstance().checkAccount(account);
            if (accoutOp.isPresent()) {
                this.getView().showTipNotification((String)accoutOp.get());
                evt.setCancel(true);
            }
        }
        if (!evt.isCancel() && allEmpty.get()) {
            evt.setCancel(true);
            String title = ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a", (String)"CollectActivityMobilePlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            CustomStyleUtils.nothingInputConfirm(this.getView(), title, new ConfirmCallBackListener("nothingchange", (IFormPlugin)this), "");
        }
    }

    private void saveCertCheck(BeforeClickEvent evt) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String jsonObject = (String)showParameter.getCustomParam("infoGroupEntity");
        InfoGroupEntity infoGroupEntity = (InfoGroupEntity)JSONObject.parseObject((String)jsonObject, InfoGroupEntity.class);
        int certResult = this.checkCertValidate(infoGroupEntity);
        ((ICollectValidateService)ServiceFactory.getService(ICollectValidateService.class)).certNumberValidate(certResult, this.getView(), evt, infoGroupEntity);
    }

    private void savePhoneAndEmailCheck(BeforeClickEvent evt) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String jsonObject = (String)showParameter.getCustomParam("infoGroupEntity");
        InfoGroupEntity infoGroup = (InfoGroupEntity)JSONObject.parseObject((String)jsonObject, InfoGroupEntity.class);
        long onboardId = HRJSONUtils.getLongValOfCustomParam((Object)showParameter.getCustomParam("onbrdid"));
        if (IOnbrdBillDomainService.getInstance().phoneAndEmailUniqCheck(infoGroup, onboardId, this.getView())) {
            evt.setCancel(true);
            return;
        }
    }

    private int checkCertValidate(InfoGroupEntity infoGroupEntity) {
        if (!InfoGroupEnum.CERTIFICATE_INFO.getNumber().equalsIgnoreCase(infoGroupEntity.getInfoGroupNumber())) {
            return 0;
        }
        ArrayList certTypeSet = Lists.newArrayListWithExpectedSize((int)3);
        ArrayList certValueSet = Lists.newArrayListWithExpectedSize((int)3);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map certFieldMap = (Map)JSONObject.parseObject((String)this.getView().getParentView().getPageCache().get("idIndex"), Map.class);
        if (certFieldMap != null) {
            certFieldMap.forEach((index, map) -> {
                if (HRObjectUtils.isEmpty(map.get("certtype"))) {
                    return;
                }
                certTypeSet.add(map.get("certtype").toString());
                certValueSet.add(map.get("certvalue").toString());
            });
        }
        boolean isAdd = true;
        String originCertType = "";
        String originCertValue = "";
        if (!HRStringUtils.equals((String)((String)formShowParameter.getCustomParam("id")), (String)"0")) {
            QFilter[] qFilters = new QFilter[]{new QFilter("boid", "=", (Object)Long.parseLong((String)formShowParameter.getCustomParam("id")))};
            DynamicObject[] attachData = HcfRepository.queryHcfAttachedData((String)"hcf_cancre", (String)"credentialstype,number", (QFilter[])qFilters);
            originCertType = attachData[0].getString("credentialstype.id");
            originCertValue = attachData[0].getString("number");
            certTypeSet.remove(originCertType);
            certValueSet.remove(originCertValue);
            isAdd = false;
        }
        IFormView formView = this.getView().getParentView();
        Long onboardId = HRJSONUtils.getLongValOfCustomParam((Object)formView.getFormShowParameter().getCustomParam("onbrdid"));
        return ((ICollectValidateService)ServiceFactory.getService(ICollectValidateService.class)).certValidate(this.getModel(), this.getView(), isAdd, originCertType, originCertValue, (List)certTypeSet, (List)certValueSet, onboardId);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        Future future;
        super.confirmCallBack(messageBoxClosedEvent);
        if ("nothingchange".equals(messageBoxClosedEvent.getCallBackId()) && "yes".equalsIgnoreCase(messageBoxClosedEvent.getResultValue())) {
            IPageCache pageCache = this.getPageCache();
            Long activityId = Long.parseLong(pageCache.get("activityId"));
            Long groupId = Long.parseLong(pageCache.get("groupId"));
            if (!HRStringUtils.equals((String)pageCache.get("isMulti"), (String)"1")) {
                this.save();
                String approvestatus = (String)this.getView().getFormShowParameter().getCustomParam("approvestatus");
                InfoGroupStatusEnum infoGroupStatusEnum = HRStringUtils.isEmpty((String)approvestatus) ? InfoGroupStatusEnum.UN_COMPLETE : InfoGroupStatusEnum.REJECT;
                ((ICollectGroupStatusService)ServiceFactory.getService(ICollectGroupStatusService.class)).setCollectGroupStatus(Collections.singletonList(groupId), activityId, infoGroupStatusEnum);
            } else {
                this.delete(pageCache.get("mainId"));
            }
            this.getView().close();
        } else if ("cancelocr".equals(messageBoxClosedEvent.getCallBackId()) && !Objects.isNull(future = this.futureMap.get(messageBoxClosedEvent.getCustomVaule()))) {
            future.cancel(true);
        }
    }

    private void delete(String id) {
        IFormView parentView;
        String infoStr = this.getPageCache().get("infoGroup");
        String candidateId = (String)this.getView().getFormShowParameter().getCustomParam("candidateid");
        Long collectId = Long.parseLong(this.getPageCache().get("activityId"));
        InfoGroupEntity infoGroup = (InfoGroupEntity)JSONObject.parseObject((String)infoStr, InfoGroupEntity.class);
        Map<String, List<InfoGroupEntity.InfoGroupField>> entityFieldMap = infoGroup.getInfoGroupFieldList().stream().collect(Collectors.groupingBy(InfoGroupEntity.InfoGroupField::getPageKey));
        Long idLong = Long.parseLong(id);
        Long candidateIdLong = Long.parseLong(candidateId);
        IHomToHcfAppService hcfAppService = IHomToHcfAppService.getInstance();
        entityFieldMap.keySet().forEach(pageKey -> {
            if (HRStringUtils.equals((String)"hcf_canaddress", (String)pageKey)) {
                hcfAppService.deleteRowEntity(pageKey, new ArrayList<Long>(Collections.singleton(candidateIdLong)));
            } else if (HRStringUtils.equals((String)"hcf_educertificate", (String)pageKey)) {
                Map certificateMap = MultiBaseDataFiledViewServiceImpl.getCertificate((Long)candidateIdLong, (String)id);
                certificateMap.values().stream().map(dy -> dy.getLong("id")).forEach(certificateId -> hcfAppService.deleteByIdNoHis(certificateId, pageKey));
                return;
            }
            Set noHisTable = ((IHomConfigDomainService)ServiceFactory.getService(IHomConfigDomainService.class)).getConfigOfSet("no_his_table");
            if (noHisTable.contains(pageKey) || InfoGroupMultipleMobilePlugin.noHisPageList.contains(pageKey)) {
                hcfAppService.deleteByIdNoHis(idLong, pageKey);
            } else {
                hcfAppService.deleteById(idLong, pageKey);
            }
        });
        String rows = this.getPageCache().get("rows");
        if (HRStringUtils.isNotEmpty((String)rows) && Integer.parseInt(rows) == 1) {
            this.getPageCache().put("deleteAll", "1");
            String approvestatus = (String)this.getView().getFormShowParameter().getCustomParam("approvestatus");
            InfoGroupStatusEnum infoGroupStatusEnum = HRStringUtils.isEmpty((String)approvestatus) ? InfoGroupStatusEnum.UN_COMPLETE : InfoGroupStatusEnum.REJECT;
            ((ICollectGroupStatusService)ServiceFactory.getService(ICollectGroupStatusService.class)).setCollectGroupStatus(Collections.singletonList(infoGroup.getInfoGroupId()), collectId, infoGroupStatusEnum);
        }
        if (Objects.nonNull(parentView = this.getView().getParentView())) {
            parentView.getPageCache().put("deleteAll", this.getPageCache().get("deleteAll"));
            parentView.invokeOperation("refresh");
            parentView.updateView();
            this.getView().sendFormAction(parentView);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (!HRStringUtils.equals((String)"detailsave", (String)args.getOperateKey()) || !operationResult.isSuccess()) {
            if ("modifytail".equals(args.getOperateKey())) {
                String jsonObject = (String)this.getView().getFormShowParameter().getCustomParam("infoGroupEntity");
                Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activityId");
                InfoGroupEntity infoGroup = (InfoGroupEntity)JSONObject.parseObject((String)jsonObject, InfoGroupEntity.class);
                Map<String, String> rejectFieldInfo = this.getRejectFieldInfo(infoGroup, Long.parseLong(this.getPageCache().get("mainId")), activityId);
                if (rejectFieldInfo.isEmpty()) {
                    return;
                }
                String rejectInfoStr = rejectFieldInfo.values().stream().collect(Collectors.joining(System.lineSeparator()));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u63d0\u793a", (String)"InfoGroupDynViewMobilePlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]), rejectInfoStr, MessageBoxOptions.Toast, ConfirmTypes.Default, new ConfirmCallBackListener("", (IFormPlugin)this));
            } else if ("announcenment".equals(args.getOperateKey())) {
                ArrayList remarks = new ArrayList();
                String jsonObject = (String)this.getView().getFormShowParameter().getCustomParam("infoGroupEntity");
                InfoGroupEntity infoGroup = (InfoGroupEntity)JSONObject.parseObject((String)jsonObject, InfoGroupEntity.class);
                infoGroup.getInfoGroupFieldList().forEach(infoGroupField -> {
                    if (HRStringUtils.isEmpty((String)infoGroupField.getFieldRemark())) {
                        return;
                    }
                    remarks.add(infoGroupField.getFieldName() + ": " + infoGroupField.getFieldRemark());
                });
                String remarkStr = remarks.stream().collect(Collectors.joining(System.lineSeparator()));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u586b\u5199\u6ce8\u610f\u4e8b\u9879", (String)"InfoGroupDynViewMobilePlugin_12", (String)"hr-hom-formplugin", (Object[])new Object[0]), remarkStr, MessageBoxOptions.Toast, ConfirmTypes.Default, new ConfirmCallBackListener("", (IFormPlugin)this));
            }
        }
    }

    private boolean isPreview(FormShowParameter showParameter) {
        boolean isPreview = false;
        if (!HRStringUtils.isEmpty((String)((String)showParameter.getCustomParam("h5preview"))) | showParameter.getStatus() == OperationStatus.VIEW) {
            isPreview = true;
        }
        return isPreview;
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        long id = Long.parseLong((String)showParameter.getCustomParam("id"));
        String jsonObject = (String)showParameter.getCustomParam("infoGroupEntity");
        String infoGroupConfigStr = (String)showParameter.getCustomParam("infoGroupConfig");
        InfoGroupConfigEntity infoGroupConfig = (InfoGroupConfigEntity)SerializationUtils.fromJsonString((String)infoGroupConfigStr, InfoGroupConfigEntity.class);
        InfoGroupEntity infoGroup = (InfoGroupEntity)JSONObject.parseObject((String)jsonObject, InfoGroupEntity.class);
        Long activityId = (Long)showParameter.getCustomParam("activityId");
        Map<String, String> rejectFieldInfo = this.getRejectFieldInfo(infoGroup, id, activityId);
        if (!rejectFieldInfo.isEmpty()) {
            showParameter.setCustomParam("hasRejectField", (Object)"1");
        }
        Set<Long> rejectFieldIdList = infoGroup.getInfoGroupFieldList().stream().filter(field -> rejectFieldInfo.containsKey(String.valueOf(field.getFieldId()))).map(InfoGroupEntity.InfoGroupField::getFieldId).collect(Collectors.toSet());
        FlexPanelAp flexPanelAp = this.loadMetas(infoGroup, infoGroupConfig, this.isPreview(showParameter), rejectFieldIdList);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("id", "flexpanelap");
        paramsMap.put("items", (String)flexPanelAp.createControl().get("items"));
        e.getItems().add(paramsMap);
    }

    private void modelBindData(Map<String, List<InfoGroupEntity.InfoGroupField>> entityFieldMap, String condi, String id, String isMulti, Map<String, String> isEditMap) {
        entityFieldMap.forEach((entityName, fields) -> this.entitySetValue(Long.valueOf(condi), (String)entityName, id, (List<InfoGroupEntity.InfoGroupField>)fields, isMulti, isEditMap));
    }

    private void entitySetValue(Long condi, String entityName, String id, List<InfoGroupEntity.InfoGroupField> fieldList, String isMulti, Map<String, String> isEditMap) {
        DynamicObject dy;
        String selectProper = fieldList.stream().map(field -> {
            if (InfoGroupFieldConstants.RSM_PTDATA.equals(field.getFieldId())) {
                return "ptstartdate,ptendingdate";
            }
            return field.getFieldKey();
        }).reduce((field1, field2) -> field1 + "," + field2).get();
        if ("hcf_canaddress".equals(entityName)) {
            this.setAddress(condi, entityName, isEditMap);
            return;
        }
        if ("hcf_educertificate".equals(entityName)) {
            this.setEdu(condi, id, fieldList, isEditMap);
            return;
        }
        if (entityName.startsWith("hom_onbrd")) {
            dy = HomCommonRepository.queryDynamicObjectByPk((String)"hom_onbrdinfo", (String)selectProper, (Object)Long.parseLong(this.getPageCache().get("onbrdid")));
        } else {
            String confVal = ((IHomConfigService)ServiceFactory.getService(IHomConfigService.class)).getConfVal("hcf_nonehisentity", "hcf_rsmpatinv,hcf_canbankcard,hcf_educertificate,hcf_canocpqual");
            InfoGroupFieldConstants.NO_HIS_TABLE = Sets.newHashSet((Object[])confVal.split(","));
            String pkId = InfoGroupFieldConstants.NO_HIS_TABLE.contains(entityName) ? "id" : "boid";
            QFilter[] qFilters = new QFilter[]{new QFilter(pkId, "=", (Object)Long.parseLong(id))};
            DynamicObjectCollection attachData = IHomToHcfAppService.getInstance().getHisMultiRowEntity(Long.valueOf(Long.parseLong(this.getView().getPageCache().get("candidateid"))), entityName, qFilters);
            if (HRStringUtils.equals((String)isMulti, (String)"1")) {
                dy = attachData.stream().filter(data -> HRStringUtils.equals((String)data.getString(pkId), (String)id)).findAny().orElseThrow(() -> new KDBizException("data not exist!"));
            } else {
                if (attachData.size() == 0) {
                    isEditMap.put(entityName, "0");
                    return;
                }
                dy = (DynamicObject)attachData.get(0);
            }
        }
        isEditMap.put(entityName, "1");
        this.setValue(dy, fieldList);
    }

    protected void setAttachment(String formId, String pkId, String attachKey, String fieldId) {
        if (("field" + InfoGroupFieldConstants.CHECKIN_ATTACH).equals(fieldId)) {
            attachKey = "checkinfopanelap";
            formId = "hom_onbrdbillbase";
        }
        List attachments = AttachmentServiceHelper.getAttachments((String)formId, (Object)pkId, (String)attachKey);
        AttachmentPanel attachmentEdit = (AttachmentPanel)this.getView().getControl(fieldId);
        if (Objects.isNull(attachmentEdit)) {
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)attachmentEdit.getView().getService(IClientViewProxy.class);
        for (Map attachmentMap : attachments) {
            attachmentMap.put("visible", "1111");
        }
        proxy.setFieldProperty(attachmentEdit.getKey(), "v", (Object)attachments);
        proxy.setEntryProperty(attachmentEdit.getKey(), "data", (Object)attachments);
        this.getView().getPageCache().put(fieldId, SerializationUtils.toJsonString((Object)attachments));
        ((ICollectService)ServiceFactory.getService(ICollectService.class)).dynEntityBindAttach(attachments, attachmentEdit.getKey(), this.getView());
    }

    private void setAddress(Long candidateId, String pageKey, Map<String, String> isEditMap) {
        DynamicObjectCollection canAddressDynamicObject = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, pageKey);
        String confVal = ((IHomConfigService)ServiceFactory.getService(IHomConfigService.class)).getConfVal("ADDRESS_ID_MAP", "");
        if (HRStringUtils.isNotEmpty((String)confVal)) {
            Map tempMap = (Map)JSONObject.parseObject((String)confVal, Map.class);
            InfoGroupFieldConstants.ADDRESS_ID_MAP.putAll(tempMap);
        }
        canAddressDynamicObject.forEach(dynamicObject -> {
            String addressType = dynamicObject.getString("addresstype.id");
            for (Map.Entry stringLongEntry : InfoGroupFieldConstants.ADDRESS_ID_MAP.entrySet()) {
                Object obj;
                String key = (String)stringLongEntry.getKey();
                if (!key.startsWith(addressType + "_")) continue;
                String fieldKey = key.substring((addressType + "_").length());
                Long fieldId = (Long)stringLongEntry.getValue();
                try {
                    obj = dynamicObject.get(fieldKey);
                }
                catch (Exception e) {
                    logger.warn("###canAddressDynamicObject exception:", (Throwable)e);
                    continue;
                }
                this.setValue("field" + fieldId, obj);
                isEditMap.put(pageKey + "_" + addressType, "1");
            }
        });
    }

    private void setEdu(Long candidateId, String eduId, List<InfoGroupEntity.InfoGroupField> fieldList, Map<String, String> isEditMap) {
        String pageKey = "hcf_educertificate";
        DynamicObjectCollection multiRowEntity = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, pageKey);
        if (CollectionUtils.isEmpty((Collection)multiRowEntity)) {
            return;
        }
        List<DynamicObject> certificateList = multiRowEntity.stream().filter(dy -> HRStringUtils.equals((String)eduId, (String)dy.getString("edu_id"))).collect(Collectors.toList());
        Map<String, List<InfoGroupEntity.InfoGroupField>> fieldGroupMap = fieldList.stream().collect(Collectors.groupingBy(field -> (String)InfoGroupFieldConstants.EDU_CERTIFICATE_MAP.get(field.getFieldId())));
        certificateList.forEach(certiDy -> {
            String certTypeNumber = certiDy.getString("certtype.id");
            if (fieldGroupMap.containsKey(certTypeNumber)) {
                isEditMap.put(pageKey, "1");
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)fieldGroupMap.get(certTypeNumber)))) {
                return;
            }
            this.setValue((DynamicObject)certiDy, (List)fieldGroupMap.get(certTypeNumber));
        });
    }

    private void setValue(DynamicObject dy, List<InfoGroupEntity.InfoGroupField> fieldList) {
        for (InfoGroupEntity.InfoGroupField field : fieldList) {
            String currfieldId = "field" + field.getFieldId();
            if (field.getFieldType() == 2) {
                this.setAttachment(field.getPageKey(), dy.getString("id"), field.getFieldKey(), currfieldId);
                continue;
            }
            if (field.getFieldId().equals(InfoGroupFieldConstants.RSM_PTDATA)) {
                this.getModel().setValue("field" + field.getFieldId() + "_ptstartdate", dy.get("ptstartdate"));
                this.getModel().setValue("field" + field.getFieldId() + "_ptendingdate", dy.get("ptendingdate"));
                continue;
            }
            Object value = dy.get(field.getFieldKey());
            this.setValue(currfieldId, value);
            if (!InfoGroupFieldConstants.CERT_TYPE.equals(field.getFieldId())) continue;
            this.getModel().setValue("fieldcerttype", (Object)dy.getString(field.getFieldKey() + ".id"));
        }
    }

    private void setValue(String currfieldId, Object value) {
        IDataEntityProperty property = this.getModel().getProperty(currfieldId);
        if (HRObjectUtils.isEmpty((Object)property)) {
            return;
        }
        if (value instanceof MulBasedataDynamicObjectCollection) {
            MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)value;
            MulBasedataProp iDataEntityProperty = (MulBasedataProp)this.getModel().getDataEntityType().getProperties().get((Object)currfieldId);
            MulBasedataDynamicObjectCollection newMul = (MulBasedataDynamicObjectCollection)this.getModel().getDataEntity().get(currfieldId);
            newMul.clear();
            mulBasedataDynamicObjectCollection.forEach(dynamicObject -> {
                long fbasedataid_id = dynamicObject.getLong("fbasedataid_id");
                DynamicObject dynamicObject1 = newMul.addNew();
                dynamicObject1.set("fbasedataid", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)fbasedataid_id, (String)iDataEntityProperty.getBaseEntityId()));
                dynamicObject1.set("fbasedataid_id", (Object)fbasedataid_id);
            });
        } else if (value instanceof DynamicObject) {
            Long baseDataId = ((DynamicObject)value).getLong("id");
            String baseDataIdKey = currfieldId + "_id";
            this.getModel().setValue(currfieldId, value);
            this.getModel().getDataEntity().set(baseDataIdKey, (Object)baseDataId);
        } else {
            this.getModel().setValue(currfieldId, value);
        }
    }

    protected void setBaseControl(OnGetControlArgs e, InfoGroupEntity.InfoGroupField infoGroupField) {
        MulBasedataEdit basedataEdit;
        AttachmentPanel control;
        String key = e.getKey();
        if (infoGroupField.getFieldType() == Integer.parseInt(InfoGroupFieldTypeEnum.ATTACH.getFieldType())) {
            control = new AttachmentPanel();
            control.setKey(key);
            control.setLock("view");
            control.setView(this.getView());
        } else {
            String simpleName = DynamicFiledViewServiceFactory.getStandardField((InfoGroupEntity.InfoGroupField)infoGroupField);
            control = DynamicFiledViewServiceFactory.getDynamicFiledViewService((String)simpleName).getControl(key, (AbstractFormPlugin)this, infoGroupField);
        }
        if (HRObjectUtils.isEmpty((Object)control)) {
            return;
        }
        if (control instanceof MulBasedataEdit) {
            basedataEdit = (MulBasedataEdit)control;
            basedataEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
            basedataEdit.setDisplayProp("name");
            String langCertId = "field" + InfoGroupFieldConstants.CERTIFICATE;
            String langId = "field" + InfoGroupFieldConstants.LANGUAGE_TYPE;
            String purposeId = "field" + InfoGroupFieldConstants.BANK_PURPOSE_FIELD;
            String mainId = this.getView().getPageCache().get("mainId");
            if (key.equals(langCertId)) {
                Long language = this.getModel().getDataEntity().getLong(langId + "_id");
                basedataEdit.setQFilter(new QFilter("languagetype.id", "=", (Object)language));
            } else if (key.equals(purposeId)) {
                ArrayList bankTypeSet = new ArrayList();
                if (!HRObjectUtils.isEmpty((Object)this.getView().getParentView().getPageCache().get("idIndex"))) {
                    Map certFieldMap = (Map)JSONObject.parseObject((String)this.getView().getParentView().getPageCache().get("idIndex"), Map.class);
                    certFieldMap.forEach((index, map) -> {
                        if (HRObjectUtils.isEmpty(map.get("banktype")) || mainId.equals(map.get("id").toString())) {
                            return;
                        }
                        bankTypeSet.add(map.get("banktype"));
                    });
                    basedataEdit.setQFilter(new QFilter("id", "not in", bankTypeSet));
                }
            }
            MulBasedataProp basedataProp = (MulBasedataProp)basedataEdit.getModel().getDataEntityType().getProperties().get((Object)key);
            String baseEntityId = basedataProp.getBaseEntityId();
            if (new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)baseEntityId)).getDataEntityType().getProperties().containsKey((Object)"iscurrentversion")) {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter("datastatus", "=", (Object)"1"));
                qFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
                basedataEdit.setQFilters(qFilters);
            }
            e.setControl((Control)basedataEdit);
        } else if (control instanceof BasedataEdit) {
            basedataEdit = (BasedataEdit)control;
            basedataEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
            basedataEdit.setDisplayProp("name");
            String langCertId = "field" + InfoGroupFieldConstants.CERTIFICATE;
            String langId = "field" + InfoGroupFieldConstants.LANGUAGE_TYPE;
            String purposeId = "field" + InfoGroupFieldConstants.BANK_PURPOSE_FIELD;
            String mainId = this.getView().getPageCache().get("mainId");
            if (key.equals(langCertId)) {
                Long language = this.getModel().getDataEntity().getLong(langId + "_id");
                basedataEdit.setQFilter(new QFilter("languagetype.id", "=", (Object)language));
            } else if (key.equals(purposeId)) {
                ArrayList bankTypeSet = new ArrayList();
                if (!HRObjectUtils.isEmpty((Object)this.getView().getParentView().getPageCache().get("idIndex"))) {
                    Map certFieldMap = (Map)JSONObject.parseObject((String)this.getView().getParentView().getPageCache().get("idIndex"), Map.class);
                    certFieldMap.forEach((index, map) -> {
                        if (HRObjectUtils.isEmpty(map.get("banktype")) || mainId.equals(map.get("id").toString())) {
                            return;
                        }
                        bankTypeSet.add(map.get("banktype"));
                    });
                    basedataEdit.setQFilter(new QFilter("id", "not in", bankTypeSet));
                }
            }
            BasedataProp basedataProp = (BasedataProp)basedataEdit.getModel().getDataEntityType().getProperties().get((Object)key);
            String baseEntityId = basedataProp.getBaseEntityId();
            if (new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)baseEntityId)).getDataEntityType().getProperties().containsKey((Object)"iscurrentversion")) {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter("datastatus", "=", (Object)"1"));
                qFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
                basedataEdit.setQFilters(qFilters);
            }
            e.setControl((Control)basedataEdit);
        }
        if (control instanceof AttachmentPanel) {
            AttachmentPanel attachmentPanel = control;
            attachmentPanel.addUploadListener((UploadListener)this);
            attachmentPanel.setLock("view");
            e.setControl((Control)attachmentPanel);
        }
        if (control instanceof ImageList) {
            ImageList imageList = (ImageList)control;
            imageList.addUploadListener((UploadListener)this);
            e.setControl((Control)imageList);
        }
        e.setControl((Control)control);
    }

    protected void cacheCertConfig() {
        DynamicObjectCollection infoGroupConfigFieldCert = HomConfigRepository.queryConfigEntityByBusinessKey((String)"info_group_config_fieldCert");
        HashMap certConfigMap = new HashMap();
        if (CollectionUtils.isEmpty((Collection)infoGroupConfigFieldCert)) {
            this.getPageCache().put("certConfigMap", JSON.toJSONString(certConfigMap));
            return;
        }
        infoGroupConfigFieldCert.forEach(config -> {
            String entityValue = config.getString("entityvalue");
            List list = CollectionUtils.arrayToList((Object)entityValue.split(","));
            String entityKey = config.getString("entitykey");
            certConfigMap.put(entityKey, list);
        });
        this.getPageCache().put("certConfigMap", JSON.toJSONString(certConfigMap));
    }

    private FlexPanelAp loadMetas(InfoGroupEntity infoGroup, InfoGroupConfigEntity infoGroupConfig, boolean isPreview, Set<Long> rejectFieldIdList) {
        FlexPanelAp firstFlex = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("flexpanelap").setDirection("column").setJustifyContent("flex-start").setAlignItems("stretch").setBackColor("#f5f5f5").setPaddingBottom("50px")).setGrow(1).build();
        FlexPanelAp infoListFlex = new HRFlexPanelAp.Builder("flexcontent").setDirection("column").setJustifyContent("flex-start").setAlignItems("stretch").setGrow(0).setWidth("100%").setShrink(0).setOverflow("visible").build();
        FlexPanelAp imageFlex = new HRFlexPanelAp.Builder("fleximage").setDirection("column").setJustifyContent("flex-start").setAlignItems("stretch").setGrow(1).setShrink(0).build();
        Style styleBoard = new Style();
        Margin marginBoard = new Margin();
        marginBoard.setBottom("12px");
        styleBoard.setMargin(marginBoard);
        infoListFlex.setStyle(styleBoard);
        List fieldList = infoGroup.getInfoGroupFieldList();
        if (InfoGroupEnum.CERTIFICATE_INFO.getNumber().equalsIgnoreCase(infoGroup.getInfoGroupNumber())) {
            FlexPanelAp certFlex = new HRFlexPanelAp.Builder("certFlex").setDirection("column").setJustifyContent("flex-start").setAlignItems("stretch").setGrow(1).setShrink(0).build();
            this.drawCertTypeFlex(certFlex, infoGroupConfig);
            firstFlex.getItems().add(certFlex);
        }
        for (InfoGroupEntity.InfoGroupField field : fieldList) {
            this.drawFlexPanelAp(isPreview, rejectFieldIdList, infoListFlex, imageFlex, styleBoard, field);
        }
        if (infoGroup.getInfoGroupOcr()) {
            firstFlex.getItems().add(imageFlex);
            imageFlex.setGrow(0);
            firstFlex.getItems().add(infoListFlex);
        } else {
            firstFlex.getItems().add(infoListFlex);
            firstFlex.getItems().add(imageFlex);
        }
        return firstFlex;
    }

    private void drawFlexPanelAp(boolean isPreview, Set<Long> rejectFieldIdList, FlexPanelAp infoListFlex, FlexPanelAp imageFlex, Style styleBoard, InfoGroupEntity.InfoGroupField field) {
        ControlAp controlAp;
        FlexPanelAp fieldBoardFlex = this.getFieldBoardFlex("fieldboard" + field.getFieldId());
        LabelAp labelAp = null;
        if (field.getFieldType() == Integer.parseInt(InfoGroupFieldTypeEnum.ATTACH.getFieldType())) {
            controlAp = this.buildAttachControlPanel(field);
            imageFlex.getItems().add(fieldBoardFlex);
            fieldBoardFlex.getItems().add(controlAp);
            fieldBoardFlex.setStyle(styleBoard);
        } else if (field.getFieldType() == Integer.parseInt(InfoGroupFieldTypeEnum.IMAGE.getFieldType())) {
            FlexPanelAp imgFieldFlex = this.getImgFieldBoardFlex("imgFieldFlex" + field.getFieldId());
            imgFieldFlex.setJustifyContent("center");
            imgFieldFlex.setAlignItems("center");
            FlexPanelAp imgHeadFlex = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("imgHeadFlex" + field.getFieldId()).setDirection("row").setJustifyContent("flex-start").setAlignItems("center").setHeight("48px").setPaddingLeft("12px")).setWidth("100%").setGrow(0).setShrink(0).setWrap(false).setBorderBottom("0.5px solid #f2f2f2")).build();
            labelAp = new HRLabelAp.Builder("imagetitlelabel" + field.getFieldId()).setFontSize(16).setName(field.getFieldName()).build();
            controlAp = this.buildImageControlAp(field);
            imgHeadFlex.getItems().add(labelAp);
            if (field.isFieldMustInput() && !isPreview) {
                labelAp = new HRLabelAp.Builder("imagemustinputlabel" + field.getFieldId()).setFontSize(16).setName("*").setForeColor("red").setVisible("init,edit,new").build();
                imgHeadFlex.getItems().add(labelAp);
            }
            imgFieldFlex.getItems().add(imgHeadFlex);
            imgFieldFlex.getItems().add(controlAp);
            fieldBoardFlex.getItems().add(imgFieldFlex);
            imageFlex.getItems().add(fieldBoardFlex);
            fieldBoardFlex.setStyle(styleBoard);
        } else {
            controlAp = this.buildFieldControlAp(field);
            infoListFlex.getItems().add(fieldBoardFlex);
            fieldBoardFlex.getItems().add(controlAp);
        }
        if (!isPreview) {
            this.setFieldCustomStyle((ControlAp)(Objects.isNull(labelAp) ? controlAp : labelAp), rejectFieldIdList, field);
        }
    }

    private ControlAp buildFieldControlAp(InfoGroupEntity.InfoGroupField field) {
        FieldAp controlAp = ((ICollectService)ServiceFactory.getService(ICollectService.class)).buildFieldAp(field, "");
        this.setFieldEmptyText(controlAp.getField());
        FieldAp fieldAp = controlAp;
        if (fieldAp.getField() instanceof TelephoneField && !HRObjectUtils.isEmpty((Object)fieldAp.getName().getLocaleValue())) {
            fieldAp.setLabelWidth(new LocaleString(16 * fieldAp.getName().getLocaleValue().length() + 30 + "px"));
            fieldAp.setMobFieldPattern(1);
        } else {
            fieldAp.setLabelWidth(new LocaleString("160px"));
        }
        controlAp.setGrow(1);
        controlAp.setWidth(new LocaleString("100%"));
        controlAp.setFontSize(16);
        controlAp.setForeColor("#212121");
        return controlAp;
    }

    private ControlAp buildAttachControlPanel(InfoGroupEntity.InfoGroupField field) {
        AttachmentPanelAp controlAp = ((ICollectService)ServiceFactory.getService(ICollectService.class)).buildAttachPanelAp(field, "");
        controlAp.setName(new LocaleString(field.getFieldName()));
        controlAp.setFontSize(16);
        controlAp.setForeColor("#212121");
        controlAp.setWidth(new LocaleString("100%"));
        controlAp.setGrow(1);
        controlAp.setShrink(0);
        controlAp.setLock("view");
        return controlAp;
    }

    private ControlAp buildImageControlAp(InfoGroupEntity.InfoGroupField field) {
        Style imageChildEleStyle = new Style();
        Margin marginImageChildEleStyle = new Margin();
        marginImageChildEleStyle.setLeft("12px");
        marginImageChildEleStyle.setRight("12px");
        marginImageChildEleStyle.setTop("12px");
        marginImageChildEleStyle.setBottom("12px");
        imageChildEleStyle.setMargin(marginImageChildEleStyle);
        FieldAp controlAp = ((ICollectService)ServiceFactory.getService(ICollectService.class)).buildFieldAp(field, "");
        controlAp.setHeight(new LocaleString("160px"));
        controlAp.setWidth(new LocaleString("295px"));
        controlAp.setGrow(1);
        controlAp.setShrink(1);
        controlAp.setStyle(imageChildEleStyle);
        controlAp.setBackColor("#ffffff");
        return controlAp;
    }

    private FlexPanelAp getImgFieldBoardFlex(String fieldKey) {
        return ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(fieldKey).setDirection("column").setJustifyContent("center").setAlignItems("stretch").setMarginBottom("0px")).setMarginTop("0px")).setMarginRight("0px")).setBackColor("#FFFFFF").setPaddingRight("0px")).setPaddingLeft("0px")).setWidth("100%").setShrink(1).setGrow(1).build();
    }

    private FlexPanelAp getFieldBoardFlex(String fieldKey) {
        return ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(fieldKey).setDirection("row").setJustifyContent("center").setAlignItems("flex-start").setMarginBottom("0px")).setMarginTop("0px")).setMarginRight("0px")).setBackColor("#FFFFFF").setPaddingRight("0px")).setPaddingLeft("0px")).setBorderBottom("0.5px solid #f2f2f2")).setWidth("100%").setShrink(0).setGrow(0).build();
    }

    private void setFieldCustomStyle(ControlAp fieldAp, Set<Long> rejectFieldIdList, InfoGroupEntity.InfoGroupField field) {
        String rejectSelector;
        String text = ResManager.loadKDString((String)"\u9a73\u56de", (String)"InfoGroupDynViewMobilePlugin_5", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        String rejectCustomStyle = " { content: '%s';\n    width: 24px;\n    height: 16px;\n    font-family: PingFangSC-Regular;\n    font-size: 12px;\n    color: #FF854D;\n    letter-spacing: 0;\n    text-align: center;\n    line-height: 16px;\n    font-weight: 400;\n\n    width: 40px;\n    height: 20px;\n    border: 0.5px solid rgba(255,202,168,1);\n    border-radius: 10px;\n    margin-left: 4px;\n    padding-top: 2px;\n}";
        rejectCustomStyle = String.format(Locale.ROOT, rejectCustomStyle, text);
        String style = "";
        String starLabel = "{\ncontent: '*';\n  color: red;\n}";
        if (field.getFieldType() == Integer.parseInt(InfoGroupFieldTypeEnum.ATTACH.getFieldType())) {
            if (field.isFieldMustInput()) {
                style = "$>div:first-child>div:first-child span:after {\n" + starLabel;
            }
            rejectSelector = "$>div:first-child>div:first-child:after";
        } else if (field.getFieldType() == Integer.parseInt(InfoGroupFieldTypeEnum.IMAGE.getFieldType())) {
            rejectSelector = "$ :after";
        } else {
            FieldAp fieldcast = (FieldAp)fieldAp;
            LocaleString labelWidth = fieldcast.getLabelWidth();
            int oldLength = 0;
            if (Objects.nonNull(labelWidth)) {
                String lengthStr = labelWidth.getLocaleValue().replaceAll("px", "");
                oldLength = Integer.parseInt(lengthStr);
            } else {
                oldLength = HRObjectUtils.isEmpty((Object)fieldcast.getName().getLocaleValue()) ? 230 : 22 * fieldcast.getName().getLocaleValue().length() + 10;
            }
            int length = 30;
            if (field.isFieldMustInput()) {
                length = 40;
            }
            fieldcast.setLabelWidth(new LocaleString(oldLength + length + "px"));
            rejectSelector = "$ > div:first-child:after";
        }
        if (!CollectionUtils.isEmpty(rejectFieldIdList) && rejectFieldIdList.contains(field.getFieldId())) {
            style = style + rejectSelector + rejectCustomStyle;
        }
        fieldAp.setCustomeStyles(CustomStyleUtils.getStyleToBase64(style));
    }

    public void setFieldEmptyText(Field<?> field) {
        if (Objects.isNull(field)) {
            return;
        }
        Class<?> aClass = field.getClass();
        try {
            Method setEmptyTextMethod = aClass.getMethod("setEmptyText", LocaleString.class);
            if (SELECT_KEY_LIST.contains(aClass.getSimpleName())) {
                setEmptyTextMethod.invoke(field, ResManager.getLocaleString((String)"\u8bf7\u9009\u62e9", (String)"InfoGroupDynViewMobilePlugin_2", (String)"hr-hom-formplugin"));
            } else {
                setEmptyTextMethod.invoke(field, ResManager.getLocaleString((String)"\u8bf7\u8f93\u5165", (String)"InfoGroupDynViewMobilePlugin_3", (String)"hr-hom-formplugin"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawCertTypeFlex(FlexPanelAp infoListFlex, InfoGroupConfigEntity infoGroupConfig) {
        FlexPanelAp fieldCertFlexAp = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("infogroupcertflex").setDirection("row").setJustifyContent("flex-start").setAlignItems("stretch").setMarginBottom("0px")).setWidth("100%").setBackColor("#FFFFFF").setBorderBottom("0.5px solid #f2f2f2")).build();
        FieldAp fieldAp = this.buildCertTypeField("fieldcerttype", infoGroupConfig);
        fieldCertFlexAp.getItems().add(fieldAp);
        infoListFlex.getItems().add(fieldCertFlexAp);
    }

    protected FieldAp buildCertTypeField(String key, InfoGroupConfigEntity infoGroupConfigEntity) {
        ComboField comboField = new ComboField();
        List infoGroupCertEntityList = infoGroupConfigEntity.getInfoGroupCertEntityList();
        String certSortInfoStr = "{\"1010\":1,\"1060\":2,\"1070\":3,\"1050\":4,\"1020\":5}";
        Map certSortRuleMap = (Map)JSONObject.parseObject((String)certSortInfoStr, Map.class);
        infoGroupCertEntityList = infoGroupCertEntityList.stream().sorted(Comparator.comparingInt(cert -> certSortRuleMap.getOrDefault(cert.getCertTypeNumber(), Integer.MAX_VALUE))).collect(Collectors.toList());
        ArrayList items = Lists.newArrayListWithExpectedSize((int)infoGroupCertEntityList.size());
        for (InfoGroupCertEntity infoGroupCertEntity : infoGroupCertEntityList) {
            ComboItem item = new ComboItem();
            item.setImageKey("");
            item.setCaption(new LocaleString(infoGroupCertEntity.getCertTypeName()));
            item.setValue(infoGroupCertEntity.getCertTypeNumber());
            items.add(item);
        }
        comboField.setItems((List)items);
        comboField.setMustInput(true);
        comboField.setId(key);
        comboField.setKey(key);
        FieldAp fieldAp = new FieldAp();
        fieldAp.setWidth(new LocaleString("100%"));
        fieldAp.setField((Field)comboField);
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setName(new LocaleString(ResManager.loadKDString((String)"\u8bc1\u4ef6\u7c7b\u578b", (String)"InfoGroupDynViewMobilePlugin_6", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        fieldAp.setFireUpdEvt(true);
        this.setFieldEmptyText(fieldAp.getField());
        fieldAp.setHeight(new LocaleString("47px"));
        fieldAp.setGrow(1);
        fieldAp.setFontSize(16);
        fieldAp.setForeColor("#212121");
        return fieldAp;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("AbstractCollTemplateViewPlugin", exp.getMessage()), new Object[0]);
        }
        String jsonObject = (String)this.getView().getFormShowParameter().getCustomParam("infoGroupEntity");
        MainEntityType finalNewMainType = newMainType;
        InfoGroupEntity infoGroup = (InfoGroupEntity)JSONObject.parseObject((String)jsonObject, InfoGroupEntity.class);
        String infoGroupConfigStr = (String)this.getView().getFormShowParameter().getCustomParam("infoGroupConfig");
        InfoGroupConfigEntity infoGroupConfig = (InfoGroupConfigEntity)SerializationUtils.fromJsonString((String)infoGroupConfigStr, InfoGroupConfigEntity.class);
        if (InfoGroupEnum.CERTIFICATE_INFO.getNumber().equalsIgnoreCase(infoGroup.getInfoGroupNumber())) {
            ComboProp comboProp = new ComboProp();
            comboProp.setName("fieldcerttype");
            comboProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u8bc1\u4ef6\u7c7b\u578b", (String)"InfoGroupDynViewMobilePlugin_6", (String)"hr-hom-formplugin", (Object[])new Object[0])));
            comboProp.setDbIgnore(true);
            comboProp.setDefValue((Object)"");
            List infoGroupCertEntityList = infoGroupConfig.getInfoGroupCertEntityList();
            ArrayList items = Lists.newArrayListWithExpectedSize((int)infoGroupCertEntityList.size());
            for (InfoGroupCertEntity infoGroupCertEntity : infoGroupCertEntityList) {
                ValueMapItem item = new ValueMapItem();
                item.setImageKey("");
                item.setName(new LocaleString(infoGroupCertEntity.getCertTypeName()));
                item.setValue(infoGroupCertEntity.getCertTypeNumber());
                items.add(item);
            }
            comboProp.setComboItems((List)items);
            finalNewMainType.registerSimpleProperty((DynamicSimpleProperty)comboProp);
        }
        List infoGroupFieldList = infoGroup.getInfoGroupFieldList();
        ICollectService service = (ICollectService)ServiceFactory.getService(ICollectService.class);
        infoGroupFieldList.forEach(infoGroupField -> {
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)infoGroupField.getPageKey()));
            service.registerDynamicProps("field", (DynamicObjectType)finalNewMainType, infoGroupField, dynamicObject, "");
        });
        e.setNewEntityType(finalNewMainType);
    }

    public void upload(UploadEvent evt) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)evt.getSource();
        String key = attachmentPanel.getKey();
        Object[] attachs = evt.getUrls();
        List attachments = new ArrayList(attachs.length);
        String attachJsonString = this.getPageCache().get(key);
        if (!HRStringUtils.isEmpty((String)attachJsonString)) {
            attachments = (List)SerializationUtils.fromJsonString((String)attachJsonString, List.class);
        }
        ArrayList finalAttachments = attachments;
        Set<String> finalChangeUidSet = this.getAttachmentChangeSet();
        Arrays.stream(attachs).map(attObj -> (Map)attObj).forEach(attachment -> {
            finalChangeUidSet.add(attachment.get("uid").toString());
            finalAttachments.add(attachment);
        });
        this.getPageCache().put(key, SerializationUtils.toJsonString(finalAttachments));
        this.getPageCache().put("isAttachChanged", SerializationUtils.toJsonString(finalChangeUidSet));
    }

    public void remove(UploadEvent evt) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)evt.getSource();
        String key = attachmentPanel.getKey();
        Object[] attachs = evt.getUrls();
        Map attachment = (Map)attachs[0];
        String removeUid = attachment.get("uid").toString();
        String removeUidString = this.getPageCache().get(key + "_removeUid");
        Set<String> removeUidSet = new HashSet<String>(attachs.length);
        if (!HRStringUtils.isEmpty((String)removeUidString)) {
            removeUidSet = (Set)SerializationUtils.fromJsonString((String)removeUidString, Set.class);
        }
        removeUidSet.add(removeUid);
        this.getPageCache().put(key + "_removeUid", SerializationUtils.toJsonString(removeUidSet));
        String attachJsonString = this.getPageCache().get(key);
        List attachments = (List)SerializationUtils.fromJsonString((String)attachJsonString, List.class);
        List saveAttachments = attachments.stream().filter(attach -> !attach.get("uid").equals(removeUid)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(saveAttachments)) {
            this.getPageCache().put(key, "");
        } else {
            this.getPageCache().put(key, SerializationUtils.toJsonString(saveAttachments));
        }
        Set<String> changeUidSet = this.getAttachmentChangeSet();
        if (!changeUidSet.remove(removeUid)) {
            changeUidSet.add(removeUid);
        }
        this.getPageCache().put("isAttachChanged", SerializationUtils.toJsonString(changeUidSet));
    }

    private Set<String> getAttachmentChangeSet() {
        Set<String> changeUidSet = new HashSet<String>();
        String changeUidSetString = this.getPageCache().get("isAttachChanged");
        if (!HRStringUtils.isEmpty((String)changeUidSetString)) {
            changeUidSet = (Set)SerializationUtils.fromJsonString((String)changeUidSetString, Set.class);
        }
        return changeUidSet;
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        ((ICollectService)ServiceFactory.getService(ICollectService.class)).afterF7Select(evt, this.getModel(), this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldStr;
        String key = e.getProperty().getName();
        Long fieldId = 0L;
        if ((key.startsWith("field") || key.startsWith("entry")) && (fieldStr = key.replace("field", "").replace("entry", "")).length() >= 19) {
            fieldId = Long.parseLong(fieldStr.substring(0, 19));
        }
        if ("fieldcerttype".equals(key)) {
            ((ICollectValidateService)ServiceFactory.getService(ICollectValidateService.class)).dealCertField(this.getModel(), this.getView());
            DynamicObject dataEntity = this.getModel().getDataEntity();
            dataEntity.set("field" + InfoGroupFieldConstants.CERT_TYPE, this.getModel().getValue("fieldcerttype"));
            dataEntity.set("field" + InfoGroupFieldConstants.CERT_TYPE + "_id", this.getModel().getValue("fieldcerttype"));
        } else if (HRObjectUtils.equals((Object)InfoGroupFieldConstants.EDU_SCHOOLNAME, (Object)fieldId)) {
            this.dealEduInfoGroup();
        } else if (InfoGroupFieldConstants.EDUCATIONID.equals(fieldId)) {
            ((ICollectValidateService)ServiceFactory.getService(ICollectValidateService.class)).dealEduLevel(this.getModel(), this.getView());
        } else if (HRObjectUtils.equals((Object)InfoGroupFieldConstants.LANG_CERT, (Object)fieldId)) {
            this.dealLanguageInfoGroup();
        } else if (HRObjectUtils.equals((Object)InfoGroupFieldConstants.LANGUAGE_TYPE, (Object)fieldId)) {
            this.getModel().getDataEntity().set("field" + InfoGroupFieldConstants.LANG_CERT + "_id", (Object)0L);
            this.getModel().getDataEntity().set("field" + InfoGroupFieldConstants.LANG_CERT, null);
            this.getView().updateView("field" + InfoGroupFieldConstants.LANG_CERT);
            this.dealLanguageInfoGroup();
        } else if (InfoGroupFieldConstants.OCR_FIELD_SET.contains(fieldId)) {
            Object newValObj;
            if (e.getChangeSet() != null && e.getChangeSet().length > 0 && !HRObjectUtils.isEmpty((Object)(newValObj = e.getChangeSet()[0].getNewValue()))) {
                Object fieldcerttype;
                String imageFullUrl = newValObj.toString();
                Long fieldLongId = Long.parseLong(key.replace("field", ""));
                Long type = 0L;
                DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
                if (Objects.nonNull(properties.get((Object)"fieldcerttype")) && Objects.nonNull(fieldcerttype = this.getModel().getValue("fieldcerttype"))) {
                    type = Long.parseLong(fieldcerttype.toString());
                }
                Map entityFieldMap = (Map)JSONObject.parseObject((String)this.getPageCache().get("entityFieldMap"), Map.class);
                String templateNumber = AbstractCollectDynViewPlugin.getTemplateNumber(fieldLongId, this.getPageCache().get("groupId"), type);
                logger.info("orgTempNumber=={}", (Object)templateNumber);
                if (HRStringUtils.isEmpty((String)templateNumber)) {
                    return;
                }
                OcrToBusinessUtils.ocrWithDataH5(new String[]{imageFullUrl}, AbstractCollectDynViewPlugin.getPageKey(fieldLongId, entityFieldMap), templateNumber, this.getView());
            }
        } else if (HRObjectUtils.equals((Object)InfoGroupFieldConstants.CITY_FIELD, (Object)fieldId)) {
            DynamicObject dynamicObject = (DynamicObject)e.getChangeSet()[0].getNewValue();
            this.getModel().setValue("field" + InfoGroupFieldConstants.CITY_FIELD, (Object)dynamicObject);
            if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
                this.getModel().getDataEntity().set("field" + InfoGroupFieldConstants.CITY_FIELD + "_id", (Object)0L);
            } else {
                this.getModel().getDataEntity().set("field" + InfoGroupFieldConstants.CITY_FIELD + "_id", (Object)dynamicObject.getLong("id"));
            }
        } else if (HRObjectUtils.equals((Object)InfoGroupFieldConstants.BASE_ENGLISH, (Object)fieldId)) {
            if (((ICollectValidateService)ServiceFactory.getService(ICollectValidateService.class)).validateEngName(this.getModel())) {
                String jsonObject = (String)this.getView().getFormShowParameter().getCustomParam("infoGroupEntity");
                InfoGroupEntity infoGroup = (InfoGroupEntity)JSONObject.parseObject((String)jsonObject, InfoGroupEntity.class);
                InfoGroupEntity.InfoGroupField baseEnglishField = ((ICollectService)ServiceFactory.getService(ICollectService.class)).findInfoGroupFieldById(infoGroup.getInfoGroupFieldList(), InfoGroupFieldConstants.BASE_ENGLISH);
                this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u53ea\u80fd\u7531\u82f1\u6587\u5b57\u6bcd\u7ec4\u6210\uff0c\u4e14\u5355\u8bcd\u9996\u5b57\u6bcd\u9700\u4e3a\u5927\u5199\u3002", (String)"AbstractCollectDynViewPlugin_13", (String)"hr-hom-formplugin", (Object[])new Object[0]), baseEnglishField.getFieldName()));
            }
        } else if (HRObjectUtils.equals((Object)InfoGroupFieldConstants.CERT_ISPERMANENT, (Object)fieldId)) {
            this.getView().setVisible(Boolean.valueOf(!this.getModel().getDataEntity().getBoolean("field" + InfoGroupFieldConstants.CERT_ISPERMANENT)), new String[]{"field" + InfoGroupFieldConstants.CERT_EXPIRATIONDATE, "fieldboard" + InfoGroupFieldConstants.CERT_EXPIRATIONDATE});
            if (this.getModel().getDataEntity().getBoolean("field" + InfoGroupFieldConstants.CERT_ISPERMANENT) && this.getModel().getDataEntity().containsProperty("field" + InfoGroupFieldConstants.CERT_EXPIRATIONDATE)) {
                this.getModel().setValue("field" + InfoGroupFieldConstants.CERT_EXPIRATIONDATE, null);
            }
        }
    }

    private boolean hasRejectActivity(String activityId) {
        boolean hasReject = false;
        QFilter activityFilter = new QFilter("collectactivity", "=", (Object)Long.valueOf(activityId));
        DynamicObject query = HomCommonRepository.queryDynamicObject((String)"hom_collectgroupstatus", (String)"", (QFilter[])new QFilter[]{activityFilter});
        DynamicObjectCollection dynamicObjectCollection = query.getDynamicObjectCollection("infogroupentry");
        for (DynamicObject object : dynamicObjectCollection) {
            if (!InfoGroupStatusEnum.REJECT.getStatus().equals(object.getString("infogroupstatus"))) continue;
            hasReject = true;
        }
        return hasReject;
    }

    private Map<String, String> getRejectFieldInfo(InfoGroupEntity infoGroup, Long id, Long activityId) {
        HashMap<String, String> fieldIdAndReasonMap = new HashMap<String, String>();
        if (id == 0L) {
            return fieldIdAndReasonMap;
        }
        Long infoGroupId = infoGroup.getInfoGroupId();
        QFilter activityFilter = new QFilter("collectactivity", "=", (Object)activityId);
        DynamicObject query = HomCommonRepository.queryDynamicObject((String)"hom_collectgroupstatus", (String)"", (QFilter[])new QFilter[]{activityFilter});
        if (HRObjectUtils.isEmpty((Object)query)) {
            return fieldIdAndReasonMap;
        }
        Optional<DynamicObject> first = query.getDynamicObjectCollection("infogroupentry").stream().filter(dynamicObject -> infoGroupId.equals(dynamicObject.getLong("infogroup.id"))).filter(dynamicObject -> "2".equals(dynamicObject.getString("infogroupstatus"))).findFirst();
        if (!first.isPresent()) {
            return fieldIdAndReasonMap;
        }
        DynamicObject dy = first.get();
        DynamicObjectCollection subentryentity = dy.getDynamicObjectCollection("subentryentity");
        if (CollectionUtils.isEmpty((Collection)subentryentity)) {
            return fieldIdAndReasonMap;
        }
        BiFunction<DynamicObject, String, String> getValue = (fieldDy, filedName) -> {
            if (HRObjectUtils.isEmpty((Object)fieldDy)) {
                return "";
            }
            return fieldDy.getString(filedName);
        };
        Map<Long, String> fieldMap = infoGroup.getInfoGroupFieldList().stream().collect(Collectors.toMap(InfoGroupEntity.InfoGroupField::getFieldId, InfoGroupEntity.InfoGroupField::getFieldName));
        if (subentryentity.size() == 1) {
            return subentryentity.stream().collect(Collectors.toMap(rejectInfo -> (String)getValue.apply((DynamicObject)rejectInfo, "field.id"), rejectInfo -> (String)fieldMap.get(rejectInfo.getLong("field.id")) + ": " + rejectInfo.getString("remark"), (key1, key2) -> key1));
        }
        return subentryentity.stream().filter(fieldRejectInfoDy -> id.equals(fieldRejectInfoDy.getLong("business"))).collect(Collectors.toMap(rejectInfo -> (String)getValue.apply((DynamicObject)rejectInfo, "field.id"), rejectInfo -> (String)fieldMap.get(rejectInfo.getLong("field.id")) + ": " + rejectInfo.getString("remark"), (key1, key2) -> key1));
    }

    private void showRejectInfoFrom(InfoGroupEntity infoGroup, Long id) {
        String displayFirstCacheKey;
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        if (infoGroup.isMultipleEntity()) {
            pageCache = this.getView().getParentView().getParentView().getPageCache();
        }
        if (HRStringUtils.equals((String)pageCache.get(displayFirstCacheKey = infoGroup.getInfoGroupId() + "_" + id), (String)"1")) {
            return;
        }
        pageCache.put(displayFirstCacheKey, "1");
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activityId");
        Map<String, String> rejectFieldInfo = this.getRejectFieldInfo(infoGroup, id, activityId);
        if (rejectFieldInfo.isEmpty()) {
            return;
        }
        String rejectInfoStr = rejectFieldInfo.values().stream().collect(Collectors.joining(System.lineSeparator()));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u63d0\u793a", (String)"InfoGroupDynViewMobilePlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]), rejectInfoStr, MessageBoxOptions.Toast, ConfirmTypes.Default, new ConfirmCallBackListener("", (IFormPlugin)this));
    }

    public static String getOcrTipsInfo(List<String> fieldList, IFormView view) {
        if (CollectionUtils.isEmpty(fieldList)) {
            view.setVisible(Boolean.FALSE, new String[]{"textocrtip"});
            return "";
        }
        String errorItemFormat = "\u3010%s\u3011";
        String errorSeparator = "\u3001";
        String fieldTipsStr = CustomStyleUtils.getFormatStr(fieldList, errorItemFormat, errorSeparator);
        String tips = ResManager.loadKDString((String)"\u8be5\u4fe1\u606f\u7ec4\u652f\u6301%s\u7684OCR\u8bc6\u522b\uff0c\u4e0a\u4f20\u6750\u6599\u540e\uff0c\u7cfb\u7edf\u5c06\u4f1a\u81ea\u52a8\u586b\u5145\u76f8\u5173\u5185\u5bb9\u3002\u652f\u6301\u683c\u5f0f\uff1ajpg/png/jpeg\u3002", (String)"InfoGroupDynViewMobilePlugin_9", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        return String.format(Locale.ROOT, tips, fieldTipsStr);
    }
}

