/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.mobile.onbrd;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.MapControl;
import kd.bos.ext.form.dto.MapSelectPointOption;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;

public class LocMapMobilePlugin
extends AbstractMobFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(LocMapMobilePlugin.class);
    private static final HRBaseServiceHelper HOM_PLACEENTRY_HELPER = new HRBaseServiceHelper("hom_placeentry");
    private static final String ISSETGPSINFO = "issetgpsinfo";
    private static final String SETGPS_YES = "true";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().addClientCallBack("selectPoint", Integer.valueOf(500));
    }

    public void clientCallBack(ClientCallBackEvent e) {
        LOGGER.info("LocMapMobilePlugin_clientCallBack");
        if ("selectPoint".equals(e.getName())) {
            this.setCompLoc();
        }
    }

    private void setCompLoc() {
        Long onbrdBillId = this.getOnbrdBillId();
        MapControl control = (MapControl)this.getView().getControl("mapcontrolap");
        MapSelectPointOption mapSelectPointOption = new MapSelectPointOption();
        DynamicObject dynamicObject = this.getOnbrdtCity(onbrdBillId);
        if (Objects.isNull(dynamicObject)) {
            LOGGER.info("LocMapMobilePlugin_clientCallBack_setCompLoc_notBill");
            return;
        }
        Label city = (Label)this.getView().getControl("labelapcity");
        Label address = (Label)this.getView().getControl("labelapaddress");
        city.setText(dynamicObject.getString("name"));
        address.setText(dynamicObject.getString("address"));
        if (!SETGPS_YES.equals(dynamicObject.getString(ISSETGPSINFO))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u7684\u62a5\u5230\u5730\u70b9\u672a\u914d\u7f6eGPS\u4fe1\u606f\u3002", (String)"LocMapMobilePlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        LOGGER.info("\u8bbe\u7f6e\u516c\u53f8\u7ecf\u7eac\u5ea6");
        mapSelectPointOption.setLng(dynamicObject.getBigDecimal("longitude").doubleValue());
        mapSelectPointOption.setLat(dynamicObject.getBigDecimal("latitude").doubleValue());
        control.selectPoint(mapSelectPointOption);
    }

    private DynamicObject getOnbrdtCity(Long onbrdBillId) {
        if (Objects.isNull(onbrdBillId)) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdBillId);
        DynamicObject onbrdBillInfo = IOnbrdBillDomainService.getInstance().findOnbrdBill("onbrdtcity", new QFilter[]{qFilter});
        if (Objects.isNull(onbrdBillInfo)) {
            LOGGER.info("onbrdBillInfo_null");
            return null;
        }
        DynamicObject onbrdtCity = onbrdBillInfo.getDynamicObject("onbrdtcity");
        if (Objects.isNull(onbrdtCity) || StringUtils.isEmpty((CharSequence)onbrdtCity.getString("name"))) {
            LOGGER.info("onbrdtCity_null");
            return null;
        }
        QFilter qFilter1 = new QFilter("name", "=", (Object)onbrdtCity.getString("name"));
        return HOM_PLACEENTRY_HELPER.loadDynamicObject(qFilter1);
    }

    private Long getOnbrdBillId() {
        Long onbrdBillId = (Long)this.getView().getFormShowParameter().getCustomParam("onbrdid");
        return onbrdBillId;
    }
}

