/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.mobile.onbrd;

import com.google.common.collect.ImmutableMap;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.hr.web.util.HrGuestUrlUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.mobile.IMobCommonAppService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.util.LanguageUtils;

public class NavigationBarMobPlugin
extends AbstractMobFormPlugin
implements ClickListener {
    private static final Log LOGGER = LogFactory.getLog(NavigationBarMobPlugin.class);
    private static final String CUSTOMCONTROL_MENU = "custommenu";
    private static final String ITEM_PERSONALCENTERNAME = "personalcenterName";
    private static final String ITEM_LANGUAGENAME = "languageName";
    private static final String ITEM_LOGOUTNAME = "logoutName";
    private static final String CLICK_PERSONALCENTER = "personalcenter";
    private static final String CLICK_LANGUAGES = "languages";
    private static final String CLICK_LOGOUT = "logout";
    private static final String IMAGE_LOGO = "logo_company";
    private static final String VECTORAP = "vectorap";
    private static final String FLEXPANEL_LANGUAGE = "flexpanel_language";
    private static final String KEY_REFRESHVIEW = "refreshview";

    public void afterCreateNewData(EventObject eventObject) {
        this.getPageCache().put(KEY_REFRESHVIEW, "1");
        this.updateBarView();
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        String refreshviewStr = this.getPageCache().get(KEY_REFRESHVIEW);
        if (HRStringUtils.isEmpty((String)refreshviewStr)) {
            this.updateBarView();
        } else {
            LOGGER.info("this.getPageCache().remove(KEY_REFRESHVIEW)");
            this.getPageCache().remove(KEY_REFRESHVIEW);
        }
    }

    private void updateBarView() {
        String entityId;
        CustomControl customControl = (CustomControl)this.getView().getControl(CUSTOMCONTROL_MENU);
        ImmutableMap map = ImmutableMap.builder().put((Object)ITEM_PERSONALCENTERNAME, (Object)ResManager.loadKDString((String)"\u4e2a\u4eba\u4e2d\u5fc3", (String)"NavigationBarMobPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0])).put((Object)ITEM_LANGUAGENAME, (Object)ResManager.loadKDString((String)"\u8bed\u8a00", (String)"NavigationBarMobPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0])).put((Object)ITEM_LOGOUTNAME, (Object)ResManager.loadKDString((String)"\u9000\u51fa", (String)"NavigationBarMobPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0])).build();
        customControl.setData((Object)map);
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdBillId);
        DynamicObject onbrdBillInfo = IOnbrdBillDomainService.getInstance().findOnbrdBill("picturefield", new QFilter[]{qFilter});
        if (HRObjectUtils.isEmpty((Object)onbrdBillInfo)) {
            return;
        }
        String bannerLogo = IMobCommonAppService.getInstance().getNavigationBarLogo(onbrdBillId);
        LOGGER.info("bannerLogo:" + bannerLogo);
        Image logoIamge = (Image)this.getView().getControl(IMAGE_LOGO);
        if (HRStringUtils.isNotEmpty((String)bannerLogo) && logoIamge != null) {
            if (!bannerLogo.contains("/") || bannerLogo.contains(RequestContext.get().getTenantCode())) {
                bannerLogo = HRImageUrlUtil.getImageFullUrl((String)bannerLogo);
                LOGGER.info("bannerLogo-url:" + bannerLogo);
            }
            LOGGER.info("logoIamge.setUrl");
            logoIamge.setUrl(bannerLogo);
        }
        Image image = (Image)this.getView().getControl("picturefield");
        String picturefield = onbrdBillInfo.getString("picturefield");
        if (HRStringUtils.isNotEmpty((String)picturefield)) {
            String imageUrl = UrlService.getImageFullUrl((String)picturefield);
            image.setUrl(imageUrl);
        }
        if (HRStringUtils.equals((String)"hom_homepage", (String)(entityId = this.getView().getEntityId()))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{VECTORAP});
        }
    }

    private void showCurrentLang() {
        this.getModel().beginInit();
        this.getModel().setValue(ITEM_LANGUAGENAME, (Object)LanguageUtils.getCurrentSysLangNumber());
        this.getView().updateView(ITEM_LANGUAGENAME);
        this.getModel().endInit();
    }

    public void customEvent(CustomEventArgs customEventArgs) {
        if (!HRStringUtils.equals((String)CUSTOMCONTROL_MENU, (String)customEventArgs.getKey())) {
            return;
        }
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        String operationName = customEventArgs.getEventArgs();
        if (HRStringUtils.equals((String)operationName, (String)CLICK_PERSONALCENTER)) {
            IMobCommonAppService.getInstance().showPageWithOnbrdId(this.getView(), onbrdBillId, "hom_personalcenter");
        } else if (HRStringUtils.equals((String)operationName, (String)CLICK_LANGUAGES)) {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("hom_moblanguage");
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            if (onbrdBillId != null) {
                showParameter.setCustomParam("onbrdid", (Object)onbrdBillId);
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "hom_moblanguage");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (HRStringUtils.equals((String)operationName, (String)CLICK_LOGOUT)) {
            HrGuestUrlUtil.hrLogout((IFormView)this.getView());
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        if (HRStringUtils.isEmpty((String)((String)this.getView().getFormShowParameter().getCustomParam("preview")))) {
            this.addClickListeners(new String[]{"picturefield", IMAGE_LOGO, FLEXPANEL_LANGUAGE});
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Container flexPanelAp;
        super.beforeClick(evt);
        Object source = evt.getSource();
        if (source instanceof Image) {
            Image image = (Image)source;
            Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
            if (HRStringUtils.equals((String)"picturefield", (String)image.getKey())) {
                IMobCommonAppService.getInstance().showPageWithOnbrdId(this.getView(), onbrdBillId, "hom_personalcenter");
            } else if (HRStringUtils.equals((String)IMAGE_LOGO, (String)image.getKey())) {
                IMobCommonAppService.getInstance().showPageWithOnbrdId(this.getView(), onbrdBillId, "hom_homepage");
            }
        } else if (source instanceof Container && HRStringUtils.equals((String)FLEXPANEL_LANGUAGE, (String)(flexPanelAp = (Container)source).getKey())) {
            this.switchSysLanguage();
        }
    }

    private void switchSysLanguage() {
        List comboItemList = LanguageUtils.getLangComboItemList();
        List valueItems = comboItemList.stream().map(ComboItem::getValue).collect(Collectors.toList());
        LOGGER.info(valueItems.toString());
        String langNumber = (String)this.getModel().getValue(ITEM_LANGUAGENAME);
        if (HRStringUtils.equals((String)langNumber, (String)"zh_CN")) {
            if (valueItems.contains("en_US")) {
                langNumber = "en_US";
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u82f1\u6587\u8bed\u8a00\u73af\u5883\u3002", (String)"NavigationBarMobPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            }
        } else {
            langNumber = "zh_CN";
        }
        this.getModel().setValue(ITEM_LANGUAGENAME, (Object)langNumber);
        this.getView().updateView(ITEM_LANGUAGENAME);
        LanguageUtils.switchLanguage((String)langNumber);
        this.showCurrentLang();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)"hom_moblanguage", (String)actionId)) {
            Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
            IMobCommonAppService.getInstance().showPageNoBackWithOnbrdId(this.getView(), onbrdBillId, this.getView().getEntityId(), null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)"back", (String)operateKey)) {
            ShowType showType = this.getView().getFormShowParameter().getOpenStyle().getShowType();
            if (ShowType.InContainer.getValue() == showType.getValue()) {
                IFormView parentView = this.getView().getParentView();
                if (parentView != null) {
                    parentView.invokeOperation("close");
                    this.getView().sendFormAction(parentView);
                    IFormView lastView = parentView.getParentView();
                    lastView.invokeOperation("refresh");
                    this.getView().sendFormAction(lastView);
                }
            } else {
                IFormView parentView = this.getView().getParentView();
                if (parentView != null) {
                    parentView.invokeOperation("refresh");
                    this.getView().sendFormAction(parentView);
                }
            }
            this.getView().close();
        }
    }
}

