/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.mobile.onbrd;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hpfs.IPersonFileIntegrateService;
import kd.hr.hom.common.enums.PositionTypeEnum;
import kd.hr.hom.formplugin.common.OnBrdHandleHelper;

public class OnbrdHandleMobileBillPlugin
extends AbstractMobBillPlugIn {
    private static final String PANEL_DOWN = "panel_down";
    private static final String PANEL_UP = "panel_up";
    private static final List<String> CLICK_DOWN_LIST = Arrays.asList("panel_down", "lbl_down", "vectorap_down");
    private static final List<String> CLICK_UP_LIST = Arrays.asList("panel_up", "lbl_up", "vectorap_up");
    private static final SoftReference<Map<Long, String>> CACHE = new SoftReference(new ConcurrentHashMap());
    private static final String HIDDEN_FLEX = "hiddenflex";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(CLICK_DOWN_LIST.toArray(new String[0]));
        this.addClickListeners(CLICK_UP_LIST.toArray(new String[0]));
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.setHandleInfoDefaultValue(dataEntity);
        long currUserId = RequestContext.get().getCurrUserId();
        String cache = this.getCacheMap().get(currUserId);
        if (HRStringUtils.isEmpty((String)cache)) {
            this.getCacheMap().put(currUserId, PANEL_UP);
        }
        this.setFlexDownAndUp(this.getView(), this.getCacheMap().get(currUserId));
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Control) {
            Control container = (Control)evt.getSource();
            String key = container.getKey();
            if (CLICK_DOWN_LIST.contains(key)) {
                this.setFlexDownAndUp(this.getView(), PANEL_DOWN);
            }
            if (CLICK_UP_LIST.contains(key)) {
                this.setFlexDownAndUp(this.getView(), PANEL_UP);
            }
        }
    }

    private void setFlexDownAndUp(IFormView view, String key) {
        if (PANEL_UP.equals(key)) {
            view.setVisible(Boolean.FALSE, new String[]{HIDDEN_FLEX});
            view.setVisible(Boolean.TRUE, new String[]{PANEL_DOWN});
            view.setVisible(Boolean.FALSE, new String[]{PANEL_UP});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{HIDDEN_FLEX});
            view.setVisible(Boolean.FALSE, new String[]{PANEL_DOWN});
            view.setVisible(Boolean.TRUE, new String[]{PANEL_UP});
        }
        long currUserId = RequestContext.get().getCurrUserId();
        this.getCacheMap().put(currUserId, key);
    }

    private void setHandleInfoDefaultValue(DynamicObject dataEntity) {
        String aPositionType = dataEntity.getString("apositiontype");
        if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_JOB.getValue(), (String)aPositionType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"aposition", "stdposition"});
        } else if (PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue().equals(aPositionType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"aposition", "ajob"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ajob", "stdposition"});
        }
        OnBrdHandleHelper.setLeader(this.getView());
        IPersonFileIntegrateService.getInstance().getResponsible(this.getView());
    }

    private Map<Long, String> getCacheMap() {
        return Optional.ofNullable(CACHE.get()).orElseGet(ConcurrentHashMap::new);
    }
}

