/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.mobile.onbrd;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.mobile.IMobCommonAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdReservationService;
import kd.hr.hom.business.application.onbrd.IValidEntryDateService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.CheckinStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.PreEnrollStatusEnum;
import kd.hr.hom.common.util.UpdateControlUtil;

public class ReservationMobilePlugin
extends AbstractMobFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(ReservationMobilePlugin.class);
    private static final String PROPERTIES_SHOWPAGE = "id,preenrollstatus,preeneffectdate,preenonbrdtcity,checkinstatus,effectdate,onbrdtcity,validuntil,baselocation,enrollstatus";
    private static final String LBL_PREENROLLSTATUS = "lbl_preenrollstatus";
    private static final String BTN_CONFIRM = "btn_confirm";
    private static final String BTN_CANCEL = "btn_cancel";
    private static final String BTN_EDIT = "btn_edit";
    private static final String OPCODE_CONFIRM = "confirm";
    private static final String OPCODE_CANCEL = "cancel_appoint";
    private static final String OPCODE_EDIT = "edit";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        IMobCommonAppService.getInstance().getTipByHRCS(this.getView(), Long.valueOf(1408709680645143552L), "htmlap");
        DynamicObject onbrdBillInfo = this.getOnbrdBill();
        String enrollStatus = onbrdBillInfo.getString("enrollstatus");
        if (HRStringUtils.equals((String)enrollStatus, (String)OnbrdStatusEnum.HAS_ONBRD.toString())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"preeneffectdate"});
        }
        if (HRObjectUtils.isEmpty((Object)onbrdBillInfo)) {
            LOGGER.info("cannot find onbrdBill");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReservationMobilePlugin_5", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CONFIRM, BTN_EDIT});
            return;
        }
        String preEnrollStatus = onbrdBillInfo.getString("preenrollstatus");
        this.getView().getFormShowParameter().setCustomParam("preenrollstatus", (Object)preEnrollStatus);
        this.getModel().setValue("preeneffectdate", (Object)onbrdBillInfo.getDate("preeneffectdate"));
        this.getModel().setValue("preenonbrdtcity", (Object)onbrdBillInfo.getDynamicObject("preenonbrdtcity"));
        if (HRStringUtils.equals((String)PreEnrollStatusEnum.WAIT_RESERVATION.getValue(), (String)preEnrollStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CANCEL});
            UpdateControlUtil.changeCtrlBcColor((IFormView)this.getView(), (String)LBL_PREENROLLSTATUS, (String)"#276ff5");
            this.setLabelText(LBL_PREENROLLSTATUS, ResManager.loadKDString((String)"\u5f85\u9884\u7ea6", (String)"ReservationMobilePlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("preenonbrdtcity", (Object)this.queryDefaultPlace(onbrdBillInfo));
        } else {
            UpdateControlUtil.changeCtrlBcColor((IFormView)this.getView(), (String)LBL_PREENROLLSTATUS, (String)"#1BA854");
            UpdateControlUtil.changeCtrlName((IFormView)this.getView(), (String)BTN_CONFIRM, (String)ResManager.loadKDString((String)"\u786e\u8ba4\u4fee\u6539", (String)"ReservationMobilePlugin_6", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            this.setLabelText(LBL_PREENROLLSTATUS, PreEnrollStatusEnum.getEnumByValue((String)preEnrollStatus).getDesc());
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CANCEL});
        }
        String operationStatus = (String)this.getView().getFormShowParameter().getCustomParam("operationStatus");
        if (HRStringUtils.equals((String)PreEnrollStatusEnum.HAS_RESERVATION.getValue(), (String)preEnrollStatus) && !HRStringUtils.equalsIgnoreCase((String)operationStatus, (String)OperationStatus.EDIT.name())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CONFIRM, BTN_CANCEL});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_EDIT});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CONFIRM});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_EDIT});
        }
        this.updateConfirmBtnStatus();
        this.initScopeForPreEffectDate(onbrdBillInfo);
    }

    private DynamicObject getOnbrdBill() {
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdBillId);
        return IOnbrdBillDomainService.getInstance().findOnbrdBill(PROPERTIES_SHOWPAGE, new QFilter[]{qFilter});
    }

    private long queryDefaultPlace(DynamicObject onbrdBillInfo) {
        DynamicObject baselocation = onbrdBillInfo.getDynamicObject("baselocation");
        if (HRObjectUtils.isEmpty((Object)baselocation)) {
            return 0L;
        }
        HRBaseServiceHelper placeHelper = new HRBaseServiceHelper("hom_placeentry");
        QFilter qFilter = new QFilter("city", "=", (Object)baselocation.getLong("id"));
        qFilter.and(new QFilter("isdefaultaddress", "=", (Object)"1"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject defaultOnbrdPlace = placeHelper.queryOne(new QFilter[]{qFilter});
        long defaultPlaceId = defaultOnbrdPlace == null ? 0L : defaultOnbrdPlace.getLong("id");
        LOGGER.info("queryDefaultPlace:{}", (Object)String.valueOf(defaultPlaceId));
        return defaultPlaceId;
    }

    private void initScopeForPreEffectDate(DynamicObject onbrdBillInfo) {
        Date today = HRDateTimeUtils.truncateDate((Date)new Date());
        DateEdit effectDateEdit = (DateEdit)this.getView().getControl("preeneffectdate");
        effectDateEdit.setMinDate(today);
        Date validuntilDate = onbrdBillInfo.getDate("validuntil");
        if (validuntilDate != null) {
            effectDateEdit.setMaxDate(validuntilDate);
            if (HRDateTimeUtils.dayBefore((Date)validuntilDate, (Date)today)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u7684\u5165\u804c\u6d41\u7a0b\u5df2\u8d85\u671f\uff0c\u8bf7\u8054\u7cfbHR\u5904\u7406\u3002", (String)"ReservationMobilePlugin_9", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                this.getView().getFormShowParameter().setCustomParam("validuntil", (Object)validuntilDate.toString());
            }
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.setStatus();
    }

    private void setStatus() {
        boolean checkinStatusBoolean;
        String validuntilDate = (String)this.getView().getFormShowParameter().getCustomParam("validuntil");
        DynamicObject onbrdBillInfo = this.getOnbrdBill();
        String checkinstatus = onbrdBillInfo.getString("checkinstatus");
        boolean bl = checkinStatusBoolean = HRStringUtils.equals((String)CheckinStatusEnum.HAS_CHECKIN.toString(), (String)checkinstatus) || HRStringUtils.equals((String)CheckinStatusEnum.CHECKIN_WAIT_CONFIRM.toString(), (String)checkinstatus);
        if (HRStringUtils.isNotEmpty((String)validuntilDate) || checkinStatusBoolean) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_CONFIRM, BTN_EDIT, BTN_CANCEL});
            return;
        }
        String preEnrollStatus = (String)this.getView().getFormShowParameter().getCustomParam("preenrollstatus");
        String operationStatus = (String)this.getView().getFormShowParameter().getCustomParam("operationStatus");
        if (HRStringUtils.equals((String)PreEnrollStatusEnum.HAS_RESERVATION.getValue(), (String)preEnrollStatus) && !HRStringUtils.equalsIgnoreCase((String)operationStatus, (String)OperationStatus.EDIT.name())) {
            this.getView().setStatus(OperationStatus.VIEW);
        } else {
            this.getView().setStatus(OperationStatus.EDIT);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        this.updateConfirmBtnStatus();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)OPCODE_CONFIRM, (String)operateKey)) {
            boolean isSuccess = this.validateBeforeSave();
            LOGGER.info("ReservationMobilePlugin_beforeDoOperation:{}", (Object)isSuccess);
            if (isSuccess) {
                isSuccess = this.saveReservationInfo();
            }
            if (isSuccess) {
                this.getView().getParentView().updateView();
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5165\u804c\u9884\u7ea6\u6210\u529f", (String)"ReservationMobilePlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
            }
        } else if (HRStringUtils.equals((String)OPCODE_EDIT, (String)operateKey)) {
            this.getView().getFormShowParameter().setCustomParam("operationStatus", (Object)OperationStatus.EDIT.name());
            this.getView().updateView();
        } else if (HRStringUtils.equals((String)OPCODE_CANCEL, (String)operateKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u53d6\u6d88\u9884\u7ea6\u786e\u8ba4", (String)"ReservationMobilePlugin_7", (String)"hr-hom-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53d6\u6d88\u9884\u7ea6\u540e\u9700\u91cd\u65b0\u9884\u7ea6\u5165\u804c\u65e5\u671f/\u5730\u70b9\uff0c\u65b9\u53ef\u524d\u5f80\u516c\u53f8\u62a5\u5230\u3002", (String)"ReservationMobilePlugin_8", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(OPCODE_CANCEL, (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)OPCODE_CANCEL, (String)callBackId) && HRStringUtils.equals((String)MessageBoxResult.Yes.name(), (String)messageBoxClosedEvent.getResultValue())) {
            Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
            boolean result = IOnbrdReservationService.getInstance().cancelReservation(this.getView(), onbrdBillId);
            if (result) {
                this.getView().updateView();
            }
        }
    }

    private boolean validateBeforeSave() {
        DynamicObject pageInfo = this.getModel().getDataEntity();
        Date preEffectDate = pageInfo.getDate("preeneffectdate");
        DynamicObject preOnbrdCity = pageInfo.getDynamicObject("preenonbrdtcity");
        if (HRObjectUtils.isEmpty((Object)preEffectDate) || HRObjectUtils.isEmpty((Object)preOnbrdCity)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u9884\u7ea6\u4fe1\u606f\u3002", (String)"ReservationMobilePlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return false;
        }
        String properties = "id,effectdate,aadminorg,aposition,stdposition,ajob,validuntil,apositiontype,preeneffectdate,viewtype,personfield,personindexid";
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        DynamicObject onbrdBill = IOnbrdBillDomainService.getInstance().findOnbrdBill(properties, new QFilter[]{new QFilter("id", "=", (Object)onbrdBillId)});
        onbrdBill.set("effectdate", (Object)preEffectDate);
        String errMsg = IOnbrdCommonAppService.getInstance().validateEffectDateWithOrgField(onbrdBill);
        Date validuntil = onbrdBill.getDate("validuntil");
        if (preEffectDate != null && validuntil != null && HRDateTimeUtils.dayAfter((Date)preEffectDate, (Date)validuntil)) {
            errMsg = errMsg + ";" + String.format(ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f\u9700\u5728\u5165\u804c\u6709\u6548\u671f\uff08%s\uff09\u5185\u3002", (String)"ReservationOnbrdPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]), HRDateTimeUtils.format((Date)validuntil, (String)"yyyy-MM-dd"));
        }
        String prefix = ResManager.loadKDString((String)"\u5165\u804c\u9884\u7ea6\u5931\u8d25\uff0c", (String)"ReservationMobilePlugin_11", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        if (HRStringUtils.isNotEmpty((String)errMsg)) {
            LOGGER.info("validateBeforeSave_fail:{}", (Object)errMsg);
            this.getView().showErrorNotification(prefix + errMsg);
            return false;
        }
        Map validEntryDateOfQuitDateMap = IValidEntryDateService.getInstance().validEntryDateOfQuitDate(new DynamicObject[]{onbrdBill}, false);
        Optional message = validEntryDateOfQuitDateMap.getOrDefault(onbrdBill.getLong("personfield.id"), Optional.empty());
        if (message.isPresent()) {
            this.getView().showErrorNotification(prefix + (String)message.get());
            return false;
        }
        return true;
    }

    private void updateConfirmBtnStatus() {
        DynamicObject pageInfo = this.getModel().getDataEntity();
        Date preEffectDate = pageInfo.getDate("preeneffectdate");
        DynamicObject preOnbrdCity = pageInfo.getDynamicObject("preenonbrdtcity");
        if (HRObjectUtils.isEmpty((Object)preEffectDate) || HRObjectUtils.isEmpty((Object)preOnbrdCity)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_CONFIRM});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{BTN_CONFIRM});
        }
    }

    private boolean saveReservationInfo() {
        LOGGER.info("ReservationMobilePlugin_saveReservationInfo");
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        DynamicObject pageInfo = this.getModel().getDataEntity();
        Date preEffectDate = pageInfo.getDate("preeneffectdate");
        DynamicObject preOnbrdCity = pageInfo.getDynamicObject("preenonbrdtcity");
        return IOnbrdReservationService.getInstance().doReservation(this.getView(), onbrdBillId, preEffectDate, preOnbrdCity);
    }

    private void setLabelText(String key, String value) {
        Label label = (Label)this.getView().getControl(key);
        if (HRStringUtils.isEmpty((String)value)) {
            label.setText("-");
        } else {
            label.setText(value);
        }
    }
}

