/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.mobile.onbrd.checkin;

import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.impl.rule.OnbrdConfirmValidatorService;
import kd.hr.hom.business.application.mobile.IMobCommonAppService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.business.domain.service.util.OnbrdValidateUtils;
import kd.hr.hom.common.enums.CheckinStatusEnum;
import kd.hr.hom.formplugin.common.ApBuildUtils;
import org.apache.commons.lang3.time.DateUtils;

public class WaitCheckinMobilePlugin
extends AbstractMobFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(WaitCheckinMobilePlugin.class);
    private static final String BTN_CHECKIN_FLEX = "mtoolbarap";
    private static final String OPCODE_APPOINT = "appoint";
    private static final String OPCODE_CHECKIN = "checkin";
    private static final String OPCODE_DOLOC = "doloc";
    private static final String MAP_PAGE = "mappage";
    private static final String SETGPS_YES = "true";
    private static final String PROPERTIES_SHOWPAGE = "id,preenrollstatus,preeneffectdate,preenonbrdtcity,checkinstatus,effectdate,onbrdtcity,name,candidate,employeeno,certificatetype,certificatenumber,effectdate,iseligibleonboard,processstatus,phone,aadminorg,ajob,aposition,stdposition,validuntil,apositiontype,billstatus";

    public void afterCreateNewData(EventObject eventObject) {
        IMobCommonAppService.getInstance().getTipByHRCS(this.getView(), Long.valueOf(1406395330848806912L), "htmlap");
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdBillId);
        DynamicObject onbrdBillInfo = IOnbrdBillDomainService.getInstance().findOnbrdBill(PROPERTIES_SHOWPAGE, new QFilter[]{qFilter});
        if (this.showCheckinPage(onbrdBillId, onbrdBillInfo).booleanValue()) {
            return;
        }
        if (HRObjectUtils.isEmpty((Object)onbrdBillInfo)) {
            LOGGER.info("cannot find onbrdBill");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReservationMobilePlugin_5", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        Date effectDate = onbrdBillInfo.getDate("effectdate");
        this.getModel().setValue("effectdate", (Object)effectDate);
        DynamicObject onbrdtCity = onbrdBillInfo.getDynamicObject("onbrdtcity");
        if (!HRObjectUtils.isEmpty((Object)onbrdtCity)) {
            this.getModel().setValue("address", (Object)onbrdtCity.getLocaleString("address").getLocaleValue());
        }
        ApBuildUtils.setLabelStyle(CheckinStatusEnum.WAIT_CHECKIN.getDesc(), "1px_solid_#55A0F5", "#ffffff", "labelap2", this.getView(), "#276FF5");
        LOGGER.info("====4====");
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CHECKIN_FLEX});
        Optional checkErrorMsg = new OnbrdConfirmValidatorService().baseCheckIfIsEligible(onbrdBillInfo, "btn_confirmcheckin", true);
        Date today = new Date();
        if (effectDate == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8fdb\u884c\u9884\u7ea6\u62a5\u5230\u3002", (String)"WaitCheckinMobilePlugin_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CHECKIN_FLEX});
        } else if (DateUtils.isSameDay((Date)effectDate, (Date)today)) {
            if (checkErrorMsg.isPresent()) {
                this.getView().showTipNotification((String)checkErrorMsg.get());
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CHECKIN_FLEX});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CHECKIN_FLEX});
            }
        } else if (HRDateTimeUtils.dayBefore((Date)today, (Date)effectDate)) {
            if (OnbrdValidateUtils.isSkipEffectDateValidate()) {
                if (checkErrorMsg.isPresent()) {
                    this.getView().showTipNotification((String)checkErrorMsg.get());
                    this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CHECKIN_FLEX});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CHECKIN_FLEX});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CHECKIN_FLEX});
            }
        } else if (HRDateTimeUtils.dayAfter((Date)today, (Date)effectDate)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CHECKIN_FLEX});
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u672a\u5728\u5165\u804c\u5f53\u5929\u5b8c\u6210\u81ea\u52a9\u62a5\u5230\uff0c\u8bf7\u8054\u7cfbHR\u5b8c\u6210\u786e\u8ba4\u3002", (String)"WaitCheckinMobilePlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        if (HRStringUtils.equals((String)OPCODE_APPOINT, (String)operateKey)) {
            IMobCommonAppService.getInstance().showReservationPage(this.getView(), onbrdBillId);
        } else if (HRStringUtils.equals((String)OPCODE_CHECKIN, (String)operateKey)) {
            this.isHaveLoc();
        } else if (HRStringUtils.equals((String)OPCODE_DOLOC, (String)operateKey)) {
            this.showMapPage(null, "hom_companylocal");
        }
    }

    private Boolean showCheckinPage(Long onbrdId, DynamicObject onbrdBillInfo) {
        String checkinStatus = onbrdBillInfo.getString("checkinstatus");
        LOGGER.info("\u72b6\u6001\uff1a" + checkinStatus);
        if (HRStringUtils.equals((String)CheckinStatusEnum.WAIT_CHECKIN.getValue(), (String)checkinStatus)) {
            return Boolean.FALSE;
        }
        IMobCommonAppService.getInstance().showPageWithOnbrdId(this.getView(), onbrdId, "hom_checkined");
        return Boolean.TRUE;
    }

    private void showMapPage(String pageId, String formId) {
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        if (pageId != null) {
            showParameter.setCustomParam(MAP_PAGE, (Object)pageId);
        }
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("onbrdid", (Object)onbrdBillId);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5165\u804c\u670d\u52a1\u5e73\u53f0", (String)"MobMobCommonAppServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void isHaveLoc() {
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        DynamicObject onbrdtCity = IMobCommonAppService.getInstance().getOnbrdtCity(onbrdBillId);
        if (Objects.isNull(onbrdtCity) || !SETGPS_YES.equals(onbrdtCity.getString("issetgpsinfo"))) {
            this.showMapPage("hom_outmap", "hom_chekincommit");
        } else {
            this.showMapPage(null, "hom_inmapscene");
        }
    }
}

