/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.activity;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.report.CellStyle;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hom.business.application.common.CommonService;
import kd.hr.hom.business.application.hrcs.IHomToHrcsAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdWorkTableService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityCommonInfoService;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;
import kd.hr.hom.business.domain.service.impl.activity.ActivityNum;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.util.DateUtils;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.common.util.ListShowUtil;
import kd.sdk.hr.ssc.business.mservice.helper.SSCSLAServiceHelper;
import kd.sdk.hr.ssc.common.dto.SLATimeInfoDTO;

public class ActivityBaseListPlugin
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(ActivityBaseListPlugin.class);
    private static final String ACTIVITYINS = "activityins";
    private static final String ACTIVITYINS_TASKSTATUS = "activityins.taskstatus";
    private static final String ACTIVITYINS_TASKSTATUS_KEY = "activityins_taskstatus";
    private static final String FSEQ = "fseq";
    private static final String RED = "red";
    private static final String GREEN = "green";
    private static final String ORANGE = "orange";
    private static final String EXIT = "donothing_exit";
    static final String DONOTHING_TRANSFER = "donothing_transfer";
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"ActivityBaseListPlugin#&&94", (int)10, (int)1000);
    private static final Set<String> NO_DAYSREMAINING_STATUS = ImmutableSet.of((Object)ActivityStatusEnum.COMPLETED.getValue(), (Object)ActivityStatusEnum.TERMINATED.getValue());

    public void packageData(PackageDataEvent event) {
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                IDataEntityType dataEntityType = ((DynamicObject)rows.get(0)).getDataEntityType();
                if (!dataEntityType.getProperties().containsKey((Object)ActivityBaseListPlugin.ACTIVITYINS)) {
                    return rows;
                }
                ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(rows.size());
                ArrayList<Long> sscTaskIds = new ArrayList<Long>(rows.size());
                for (DynamicObject row : rows) {
                    Date latestdDeadline;
                    int rowNum = row.getInt(ActivityBaseListPlugin.FSEQ) - 1;
                    String taskStatus = row.getString(ActivityBaseListPlugin.ACTIVITYINS_TASKSTATUS);
                    long sscTackId = row.getLong("activityins.ssctaskid");
                    if (!HRObjectUtils.isEmpty((Object)taskStatus)) {
                        if (HRStringUtils.equals((String)ActivityStatusEnum.TOASSIGN.toString(), (String)taskStatus)) {
                            cellStyles.add(ActivityBaseListPlugin.this.getListUnitStyle(ActivityBaseListPlugin.ACTIVITYINS_TASKSTATUS_KEY, rowNum, ActivityBaseListPlugin.RED));
                        }
                        if (HRStringUtils.equals((String)ActivityStatusEnum.TERMINATED.toString(), (String)taskStatus)) {
                            cellStyles.add(ActivityBaseListPlugin.this.getListUnitStyle(ActivityBaseListPlugin.ACTIVITYINS_TASKSTATUS_KEY, rowNum, ActivityBaseListPlugin.RED));
                        }
                        if (HRStringUtils.equals((String)ActivityStatusEnum.COMPLETED.toString(), (String)taskStatus)) {
                            cellStyles.add(ActivityBaseListPlugin.this.getListUnitStyle(ActivityBaseListPlugin.ACTIVITYINS_TASKSTATUS_KEY, rowNum, ActivityBaseListPlugin.GREEN));
                        }
                        if (HRStringUtils.equals((String)ActivityStatusEnum.PROCESSING.toString(), (String)taskStatus) || HRStringUtils.equals((String)ActivityStatusEnum.REJECTED.toString(), (String)taskStatus)) {
                            cellStyles.add(ActivityBaseListPlugin.this.getListUnitStyle(ActivityBaseListPlugin.ACTIVITYINS_TASKSTATUS_KEY, rowNum, ActivityBaseListPlugin.ORANGE));
                        }
                    }
                    if (!Objects.isNull(latestdDeadline = row.getDate("latestdeadline")) && HRDateTimeUtils.dayBefore((Date)latestdDeadline, (Date)new Date())) {
                        cellStyles.add(ActivityBaseListPlugin.this.getListUnitStyle("daysremaining", row.getInt(ActivityBaseListPlugin.FSEQ) - 1, ActivityBaseListPlugin.RED));
                    }
                    if (HOMObjectUtils.isEmptyWithDynamicObjectField((Object)sscTackId)) continue;
                    sscTaskIds.add(sscTackId);
                }
                DynamicSimpleProperty daysRemaining = new DynamicSimpleProperty("daysremaining", String.class, (Object)"");
                DynamicSimpleProperty timeconsuming = new DynamicSimpleProperty("timeconsuming", String.class, (Object)"");
                rows.getDynamicObjectType().addProperty((DynamicProperty)daysRemaining);
                rows.getDynamicObjectType().addProperty((DynamicProperty)timeconsuming);
                Map slaInfoMap = SSCSLAServiceHelper.getSLAInfoByIds(sscTaskIds);
                for (DynamicObject row : rows) {
                    DynamicObject activityins = row.getDynamicObject(ActivityBaseListPlugin.ACTIVITYINS);
                    Date createTime = activityins.getDate("createtime");
                    Date handleTime = activityins.getDate("handletime");
                    Date latestDeadline = row.getDate("latestdeadline");
                    row.set("timeconsuming", (Object)DateUtils.getDayAndHour((Date)createTime, (Date)handleTime));
                    row.set("daysremaining", (Object)DateUtils.getDayAndHour((Date)new Date(), (Date)latestDeadline));
                    long sscTaskId = row.getLong("activityins.ssctaskid");
                    SLATimeInfoDTO slaTimeInfo = (SLATimeInfoDTO)slaInfoMap.get(sscTaskId);
                    if (!HRObjectUtils.isEmpty((Object)slaTimeInfo)) {
                        row.set("activityins.createtime", (Object)slaTimeInfo.getCreateTime());
                        row.set("latestdeadline", (Object)slaTimeInfo.getLatestdFinishTime());
                        row.set("daysremaining", (Object)slaTimeInfo.getRemainingDays());
                        Date finishDate = row.getDate("activityins.handletime");
                        if (row.containsProperty("finishdate")) {
                            row.set("finishdate", (Object)finishDate);
                        }
                        row.set("timeconsuming", (Object)DateUtils.getDayAndHour((Date)slaTimeInfo.getCreateTime(), (Date)finishDate));
                    }
                    if (!Objects.isNull(latestDeadline) && HRDateTimeUtils.dayBefore((Date)latestDeadline, (Date)new Date())) {
                        cellStyles.add(ActivityBaseListPlugin.this.getListUnitStyle("daysremaining", row.getInt(ActivityBaseListPlugin.FSEQ) - 1, ActivityBaseListPlugin.RED));
                    }
                    String taskStatus = row.getString(ActivityBaseListPlugin.ACTIVITYINS_TASKSTATUS);
                    if (NO_DAYSREMAINING_STATUS.contains(taskStatus)) {
                        row.set("daysremaining", (Object)"");
                    }
                    if (HRObjectUtils.isEmpty((Object)row.getDataEntityType().getProperties().get((Object)"finishdate")) || !HRObjectUtils.isEmpty((Object)row.getDate("finishdate"))) continue;
                    row.set("timeconsuming", (Object)"");
                }
                BillList billList = (BillList)ActivityBaseListPlugin.this.getView().getControl("billlistap");
                billList.setCellStyle(cellStyles);
                return rows;
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        if (EXIT.equals(eventArgs.getOperateKey())) {
            this.getView().getParentView().invokeOperation("close");
            this.getView().sendFormAction(this.getView().getParentView());
        }
        if (DONOTHING_TRANSFER.equals(eventArgs.getOperateKey()) && (HRObjectUtils.isEmpty((Object)eventArgs.getOperationResult()) || eventArgs.getOperationResult().isSuccess())) {
            this.activityTransfer();
        }
    }

    private CellStyle getListUnitStyle(String fieldKey, int rowNum, String foreColor) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey(fieldKey);
        cellStyle.setRow(rowNum);
        cellStyle.setForeColor(foreColor);
        return cellStyle;
    }

    public void closedCallBack(ClosedCallBackEvent callBackEvent) {
        super.closedCallBack(callBackEvent);
        List<Long> ids = this.getSelectLongs();
        if (ids == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)"transfer_callback", (CharSequence)callBackEvent.getActionId()) && callBackEvent.getReturnData() != null) {
            try {
                Boolean isCancel;
                Map resultMap = (Map)callBackEvent.getReturnData();
                Boolean bl = isCancel = resultMap.get("TRANSFER_CLOSE") != null ? (Boolean)resultMap.get("TRANSFER_CLOSE") : Boolean.FALSE;
                if (isCancel.booleanValue()) {
                    HRPageCache parentCache = new HRPageCache(this.getView());
                    List userIds = resultMap.get("cachepersonid") != null ? (List)resultMap.get("cachepersonid") : new ArrayList();
                    parentCache.put("personid", userIds);
                    IHomDataMutexService.getInstance().batchRelease(ids, "hom_collaborationdetail", "donothing_tran");
                    return;
                }
                DynamicObject[] dynamicObject = IActivityCommonInfoService.getInstance().getActivityInfo(ids);
                for (int index = dynamicObject.length - 1; index >= 0; --index) {
                    dynamicObject[index].set("modifier", (Object)RequestContext.get().getCurrUserId());
                    dynamicObject[index].set("modifytime", (Object)new Date());
                }
                IActivityCommonInfoService.getInstance().updateDatas(dynamicObject);
                IActivityCommonInfoService.getInstance().handleTransfer(this.getView(), resultMap);
                LOGGER.info("handleTransfer_closedCallBack_end");
                this.getView().invokeOperation("refresh");
            }
            catch (Exception e) {
                IHomDataMutexService.getInstance().batchRelease(ids, "hom_collaborationdetail", "donothing_tran");
                LOGGER.error("handleTransfer_closedCallBack", (Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
                this.getView().invokeOperation("refresh");
            }
        } else {
            IHomDataMutexService.getInstance().batchRelease(ids, "hom_collaborationdetail", "donothing_tran");
        }
    }

    private List<Long> getSelectLongs() {
        ListSelectedRowCollection selectRows = this.getSelectedRows();
        if (selectRows == null || selectRows.size() == 0) {
            return null;
        }
        List<Long> ids = selectRows.stream().map(selRow -> Long.valueOf(selRow.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        return ids;
    }

    private void activityTransfer() {
        String page = ((IListView)this.getView()).getBillFormId();
        String pageId = ActivityNum.HANDLE_PAGE.contains(page) ? "hom_handletransfer" : "hom_activitytransfer";
        IActivityCommonInfoService.getInstance().showTransfer(this.getView(), (IFormPlugin)this, "transfer_callback", pageId);
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        QFilter dataPermissionFilter;
        super.setFilter(setFilterEvent);
        LOGGER.info("###setFilter-start");
        List customQFilters = setFilterEvent.getCustomQFilters();
        String name = ((BillList)setFilterEvent.getSource()).getEntityType().getName();
        if ("hom_activehandlealllist".equals(name)) {
            QFilter status = new QFilter(ACTIVITYINS_TASKSTATUS, "!=", (Object)ActivityStatusEnum.TOASSIGN.getValue());
            customQFilters.add(status);
        }
        if ((dataPermissionFilter = ((IOnbrdWorkTableService)ServiceFactory.getService(IOnbrdWorkTableService.class)).getDataPermissionFilter()) != null) {
            DynamicObject[] dynamicObjects = HomCommonRepository.queryDynamicObjects((String)"hom_onbrdinfo", (String)"", (QFilter[])new QFilter[]{dataPermissionFilter});
            List ids = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            if (HRCollUtil.isEmpty((Collection)setFilterEvent.getQFilters()) || setFilterEvent.getQFilters().stream().noneMatch(filterHandler -> filterHandler.getProperty().equals("activityins.handlers.fbasedataid"))) {
                customQFilters.add(new QFilter("onbrdid", "in", ids));
            }
        }
        QFilter activity = new QFilter(ACTIVITYINS, "!=", (Object)0L);
        customQFilters.add(activity);
        customQFilters.add(new QFilter("activity.app.id", "=", (Object)"1WXB5G9/BL46"));
        Object dataStatus = this.getView().getFormShowParameter().getCustomParams().get("status");
        if (dataStatus != null && ActivityStatusEnum.COMPLETED.getValue().equals(String.valueOf(dataStatus))) {
            setFilterEvent.setOrderBy("finishdate desc");
        } else if (dataStatus != null && ActivityStatusEnum.TERMINATED.getValue().equals(String.valueOf(dataStatus))) {
            setFilterEvent.setOrderBy("onbrdid.breakupdate desc");
        } else {
            setFilterEvent.setOrderBy("activityins.taskstatus asc");
        }
        LOGGER.info("###setFilter-end");
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("activity.id".equals(args.getFieldName())) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            this.getContainerFilter(qFilterList);
            IListView listView = (IListView)this.getView();
            String page = listView.getBillFormId();
            if (ActivityNum.HANDLE_PAGE.contains(page)) {
                QFilter bizclassify = new QFilter("id", "not in", (Object)ActivityNum.HANDLE_ID_LIST);
                qFilterList.add(bizclassify);
            }
            args.setQfilters(qFilterList);
        }
    }

    private void getContainerFilter(List<QFilter> qFilterList) {
        String appId = this.getAppId("hom");
        QFilter status = new QFilter("enable", "=", (Object)"1");
        QFilter app = new QFilter("app", "=", (Object)appId);
        qFilterList.add(status);
        qFilterList.add(app);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FilterColumn filterColumn = args.getFilterColumn("activity.name");
        DynamicObject[] onbrdTypes = this.getActivity();
        ((CommonBaseDataFilterColumn)filterColumn).setComboItems(ListShowUtil.buildComboItems((DynamicObject[])onbrdTypes));
    }

    private String getAppId(String number) {
        HRBaseServiceHelper bizAppHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        DynamicObject[] dynamicObjects = bizAppHelper.query("id", new QFilter[]{numberFilter});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        return dynamicObjects[0].getString("id");
    }

    private DynamicObject[] getActivity() {
        IListView listView = (IListView)this.getView();
        String page = listView.getBillFormId();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        this.getContainerFilter(qFilterList);
        if (ActivityNum.HANDLE_PAGE.contains(page)) {
            QFilter bizClassify = new QFilter("id", "not in", (Object)ActivityNum.HANDLE_ID_LIST);
            qFilterList.add(bizClassify);
        }
        HRBaseServiceHelper BIZAPP_HELPER = new HRBaseServiceHelper("hrcs_activity");
        DynamicObject[] dynamicObjects = BIZAPP_HELPER.query("id,name,number", qFilterList.toArray(new QFilter[0]));
        return dynamicObjects;
    }

    public void clientCallBack(ClientCallBackEvent e) {
        HRPageCache pageCache = new HRPageCache(this.getView());
        if (HRStringUtils.equals((String)"asynDealTransfer", (String)e.getName())) {
            THREAD_POOL.execute(() -> this.asynDealTransfer("asynDealTransfer", pageCache), RequestContext.get());
        }
        if (HRStringUtils.equals((String)"batchAssignTask", (String)e.getName())) {
            THREAD_POOL.execute(() -> this.asynDealTransfer("batchAssignTask", pageCache), RequestContext.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asynDealTransfer(String strKey, HRPageCache pageCache) {
        List activityIds = (List)pageCache.get("activityBodyIds", List.class);
        List userIds = (List)pageCache.get("transferUserIds", List.class);
        List transferUserIds = CommonService.getLongList((List)userIds);
        List activityBodyIds = CommonService.getLongList((List)activityIds);
        try {
            String remakes = (String)pageCache.get("remakes", String.class);
            if ("asynDealTransfer".equals(strKey)) {
                IHomToHrcsAppService.getInstance().dealTransfer(activityBodyIds, (Long)transferUserIds.get(0), remakes);
            } else {
                IHomToHrcsAppService.getInstance().batchAssignTask(activityBodyIds, transferUserIds, remakes);
            }
        }
        catch (Exception exception) {
            LOGGER.error("error", (Throwable)exception);
        }
        finally {
            IHomDataMutexService.getInstance().batchRelease((Collection)activityBodyIds, "hom_collaborationdetail", "donothing_tran");
        }
    }
}

