/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.activity;

import com.google.common.collect.ImmutableMap;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.application.common.CommonService;
import kd.hr.hom.business.domain.service.activity.IActivityCommonInfoService;
import kd.hr.hom.business.domain.service.impl.activity.ActivityNum;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.enums.PositionTypeEnum;

public class ActivityBaseOnbInfoPlugin
extends HRDataBaseEdit
implements UploadListener {
    public Map<String, String> STATUSNAME_MAP = new ImmutableMap.Builder().put((Object)ActivityStatusEnum.TOASSIGN.getValue(), (Object)ResManager.loadKDString((String)"\u5f85\u5206\u914d", (String)"ActivityNum_0", (String)"hr-hom-business", (Object[])new Object[0])).put((Object)ActivityStatusEnum.PROCESSING.getValue(), (Object)ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"ActivityNum_1", (String)"hr-hom-business", (Object[])new Object[0])).put((Object)ActivityStatusEnum.COMPLETED.getValue(), (Object)ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ActivityNum_2", (String)"hr-hom-business", (Object[])new Object[0])).put((Object)ActivityStatusEnum.REJECTED.getValue(), (Object)ResManager.loadKDString((String)"\u5df2\u9a73\u56de", (String)"ActivityNum_3", (String)"hr-hom-business", (Object[])new Object[0])).put((Object)ActivityStatusEnum.TERMINATED.getValue(), (Object)ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"ActivityNum_4", (String)"hr-hom-business", (Object[])new Object[0])).build();

    public void afterCreateNewData(EventObject e) {
    }

    private void initData() {
        Long entryId = IActivityCommonInfoService.getInstance().getActivityId(this.getView());
        DynamicObject dynamicObject = IActivityCommonInfoService.getInstance().getActivityDetail(entryId);
        DynamicObject onboard = dynamicObject.getDynamicObject("onbrdid");
        String ondStatus = onboard.getString("enrollstatus");
        Long onboardId = onboard.getLong("id");
        this.getView().setEnable(Boolean.FALSE, new String[]{"basepanelap"});
        this.getView().getModel().setValue("enrollstatus", (Object)ondStatus);
        String apositionType = onboard.getString("apositiontype");
        if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue(), (String)apositionType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"aposition"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"stdposition"});
        } else if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue(), (String)apositionType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"aposition"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"stdposition"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"aposition"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"stdposition"});
        }
        this.getView().getModel().setValue("apositiontype", (Object)apositionType);
        String activityStatus = dynamicObject.getString("activityins.taskstatus");
        if (HRStringUtils.equals((String)activityStatus, (String)ActivityStatusEnum.TERMINATED.getValue()) || HRStringUtils.equals((String)activityStatus, (String)ActivityStatusEnum.COMPLETED.getValue())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_saveandnew"});
        }
        this.showPersonHeadView(onboardId, dynamicObject);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initData();
        this.getView().getModel().setDataChanged(false);
    }

    private void showPersonHeadView(Long onbrdId, DynamicObject activityInfo) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("onbrdcheckinhead");
        formShowParameter.setCustomParam("id", (Object)onbrdId);
        String activityStatus = activityInfo.getString("activityins.taskstatus");
        Long activityId = activityInfo.getLong("activity.id");
        formShowParameter.setCustomParam("activity.id", (Object)activityId);
        formShowParameter.setCustomParam("activitystatusdesc", (Object)this.STATUSNAME_MAP.get(activityStatus));
        formShowParameter.setCustomParam("statusNumber", ActivityNum.STATUS_NUMBER_MAP.get(activityStatus));
        formShowParameter.setFormId("hom_onbrdactivityhead");
        formShowParameter.setSendToClient(true);
        this.getView().showForm(formShowParameter);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().getModel().setDataChanged(false);
        Long id = IActivityCommonInfoService.getInstance().getActivityId(this.getView());
        CommonService.releaseLockWithOnbrdBill((Long)id, (String)"KEY_DATAMUTEX_ACTIVITY", (String)"hom_activebase", (String)"donothing_tran", (IFormView)this.getView());
    }
}

