/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.activity;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hom.business.domain.service.activity.IActivityCommonInfoService;
import kd.hr.hom.business.domain.service.collect.ICooperationManageService;

public class ActivityLogPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(ActivityLogPlugin.class);
    private static final String LOG_PANEL = "logpanel2";
    private static final String COLUMN = "column";

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.initLog();
    }

    private void initLog() {
        Long entryId = IActivityCommonInfoService.getInstance().getActivityId(this.getView());
        DynamicObject dy = ICooperationManageService.getInstance().queryCooperationById("id,onbrdid,activityins", entryId);
        QFilter billFilter = new QFilter("activityins", "in", (Object)dy.getLong("activityins.id"));
        DynamicObjectCollection logs = (DynamicObjectCollection)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"getActivityInsOPRecColl", (Object[])new Object[]{"creator,activityins,assigntype,createtime,auditmessage,mulhandler", billFilter, "createtime desc", 20});
        if (null == logs) {
            return;
        }
        List dynamicObjectList = logs.stream().filter(dynamicObject -> !HRStringUtils.equals((String)dynamicObject.getString("auditmessage"), (String)"$$transferremake$$")).collect(Collectors.toList());
        int size = dynamicObjectList.size();
        this.buildLogPanel(size);
        for (int index = 0; index < size; ++index) {
            DynamicObject item = (DynamicObject)dynamicObjectList.get(index);
            String description = item.getString("auditmessage");
            String operate = item.getString("assigntype");
            LOGGER.info(operate);
            String handler = item.getString("creator.name");
            String handlerNumber = item.getString("creator.number");
            String headScrupture = item.getString("creator.picturefield");
            String handTime = HRInteDateTimeUtil.formatDate((String)"hrcs_actassignrec", (String)"createtime", (Date)item.getDate("createtime"));
            String recevier = ActivityLogPlugin.getAllHandlers(item.getDynamicObjectCollection("mulhandler"));
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hom_commonlogshow");
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("handlerName", handler);
            paramsMap.put("handletime", handTime);
            paramsMap.put("headsculpture", HRImageUrlUtil.getImageFullUrl((String)headScrupture));
            paramsMap.put("handlerNum", handlerNumber);
            paramsMap.put("handler", recevier);
            paramsMap.put("receivorName", recevier);
            paramsMap.put("operate", operate);
            paramsMap.put("description", description);
            paramsMap.put("taskname", ResManager.loadKDString((String)"\u534f\u4f5c\u4efb\u52a1", (String)"ActivityCommonPlugin_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            if (index == 0) {
                paramsMap.put("isShowBlank", "1");
            } else {
                paramsMap.put("isShowBlank", "0");
            }
            showParameter.setCustomParams(paramsMap);
            showParameter.getOpenStyle().setTargetKey(LOG_PANEL + index);
            this.getView().showForm(showParameter);
        }
    }

    private void buildLogPanel(int size) {
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setId(LOG_PANEL);
        headPanelAp.setName(ResManager.getLocaleString((String)"\u65e5\u5fd7", (String)"ActivityCommonPlugin_3", (String)"hr-hom-formplugin"));
        headPanelAp.setKey(LOG_PANEL);
        headPanelAp.setDirection(COLUMN);
        headPanelAp.setJustifyContent("flex-start");
        headPanelAp.setAlignItems("stretch");
        headPanelAp.setWrap(false);
        headPanelAp.setGrow(0);
        for (int index = 0; index < size; ++index) {
            FlexPanelAp flexPanelAp = ActivityLogPlugin.createMappedFieldApBuilder(LOG_PANEL + index).build();
            headPanelAp.getItems().add(flexPanelAp);
        }
        this.getView().updateControlMetadata(LOG_PANEL, headPanelAp.createControl());
    }

    private static HRFlexPanelAp.Builder createMappedFieldApBuilder(String flexKey) {
        return new HRFlexPanelAp.Builder(flexKey).setDirection("row").setJustifyContent("center").setAlignItems("center").setGrow(0).setShrink(0).setClickable(true);
    }

    private static String getAllHandlers(DynamicObjectCollection dyCol) {
        if (dyCol == null) {
            return "-";
        }
        StringBuilder handlerSb = new StringBuilder();
        dyCol.forEach(item -> {
            handlerSb.append(item.getString("fbasedataid.name"));
            handlerSb.append(" | ");
            handlerSb.append(item.getString("fbasedataid.number"));
            handlerSb.append(';');
        });
        int length = handlerSb.length();
        String handlers = length > 0 ? handlerSb.deleteCharAt(length - 1).toString() : "";
        return handlers;
    }
}

