/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.activity;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.application.hrcs.IHomToHrcsAppService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.activity.IActivityCommonInfoService;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.impl.onbrd.OnbrdStartUpProcessService;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.enums.ActivityinsTaskSwitchEnum;
import kd.hr.hom.common.enums.AuditStatusEnum;
import kd.hr.hom.common.enums.BillStatusEnum;
import kd.hr.hom.common.enums.CollectApproveStatusEnum;
import kd.hr.hom.common.enums.CollectManageStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.PreEnrollStatusEnum;
import kd.hr.hom.common.enums.WorkflowSchemeStatusEnum;
import kd.hr.hom.common.util.DateUtils;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.formplugin.common.CheckHelper;
import kd.hr.hom.formplugin.common.InviteHelper;
import kd.sdk.hr.ssc.business.mservice.helper.SSCSLAServiceHelper;
import kd.sdk.hr.ssc.common.dto.SLATimeInfoDTO;

public class ActivityOverViewPlugin
extends HRDataBaseEdit {
    private static final String VIEW_DETAILS = "view_details";
    private static final String OPERATIONCOLUMNAP = "operationcolumnap";
    private static final String HOM_ACCEPTMANAGEPASS = "hom_acceptmanagepass";
    private static final String HOM_ACCEPTMANAGEUNPASS = "hom_acceptmanageunpass";
    private static final String HOM_ACCEPTMANAGEING = "hom_acceptmanageing";
    private static final String REFRESH = "refresh";
    private static final String RETRY = "retry";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operateName = (FormOperate)args.getSource();
        if (VIEW_DETAILS.equals(operateName.getOperateKey())) {
            boolean flag;
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject activityDetailDy = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
            Long activityId = activityDetailDy.getLong("activity.id");
            String activityAppId = activityDetailDy.getString("activity.app.id");
            if (HRStringUtils.equals((String)activityAppId, (String)"0VO5EV13=I9W")) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u201c\u85aa\u916c\u798f\u5229\u4e91-\u85aa\u916c\u7ba1\u7406-\u5b9a\u8c03\u85aa\u7ba1\u7406-\u5019\u9009\u4eba\u5b9a\u85aa\u534f\u4f5c\u201d\u67e5\u770b\u8be6\u60c5\u3002", (String)"ActivityOverViewPlugin_6", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject activityIns = activityDetailDy.getDynamicObject("activityins");
            if (activityIns.containsProperty("taskswitch") && ActivityinsTaskSwitchEnum.STR_THREE.getValue().equals(activityIns.getString("taskswitch"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6d3b\u52a8\u5df2\u8fdb\u5165HR\u5171\u4eab\u670d\u52a1\u4e2d\u5fc3\uff0c\u6b64\u5904\u65e0\u6cd5\u67e5\u770b\u6d3b\u52a8\u8be6\u60c5\u3002", (String)"ActivityOverViewPlugin_5", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Long currUserId = RequestContext.get().getCurrUserId();
            MulBasedataDynamicObjectCollection handlers = (MulBasedataDynamicObjectCollection)activityDetailDy.get("activityins.handlers");
            if (handlers != null && !(flag = handlers.stream().anyMatch(dynamicObject -> currUserId.equals(dynamicObject.getLong("fbasedataid_id"))))) {
                args.setCancel(true);
                String activityName = activityDetailDy.getString("activity.name");
                this.getView().showTipNotification(ResManager.loadKDString((String)MessageFormat.format("\u67e5\u770b\u8be6\u60c5\u5931\u8d25\uff0c\u60a8\u4e0d\u662f\u5f53\u524d\u534f\u4f5c\u6d3b\u52a8\uff08{0}\uff09\u7684\u5904\u7406\u4eba\uff0c\u8bf7\u524d\u5f80\u201c\u6838\u5fc3\u4eba\u529b\u4e91>\u5165\u804c\u7ba1\u7406>\u5165\u804c\u534f\u4f5c\u7ba1\u7406\u201d\u8fdb\u884c\u5904\u7406\u3002", activityName), (String)"ActivityOverViewPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                return;
            }
            long bindBizBillId = activityDetailDy.getLong("bindbizbillid");
            Long onbrdId = (Long)this.getView().getFormShowParameter().getCustomParam("onbrdid");
            DynamicObject onbrdObj = HomCommonRepository.queryDynamicObjectByPk((String)"hom_onbrdbilltpl", (String)"checkinstatus,preenrollstatus", (Object)onbrdId);
            String taskStatus = activityDetailDy.getString("activityins.taskstatus");
            ActivityNumberEnum activityNumberEnum = ActivityNumberEnum.getEnumById((Long)activityId);
            if (Objects.isNull(activityNumberEnum)) {
                this.showDefaultActivityInfoView(activityId, onbrdId);
                return;
            }
            switch (activityNumberEnum) {
                case APPOINTMENT: {
                    String tipMessage = null;
                    if (ActivityStatusEnum.COMPLETED.getValue().equals(taskStatus) && PreEnrollStatusEnum.WAIT_RESERVATION.getValue().equals(onbrdObj.getString("preenrollstatus"))) {
                        tipMessage = ResManager.loadKDString((String)"\u5f85\u5165\u804c\u4eba\u5458\u7684\u62a5\u5230\u534f\u4f5c\u5df2\u88ab\u9a73\u56de\uff0c\u8bf7\u91cd\u65b0\u9884\u7ea6\u3002", (String)"ActivityOverViewPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                    }
                    CheckHelper.showCheckBill(String.valueOf(bindBizBillId), this.getView(), "1", tipMessage);
                    break;
                }
                case CHECKININFO: {
                    if ((ActivityStatusEnum.PROCESSING.getValue().equals(taskStatus) || ActivityStatusEnum.REJECTED.getValue().equals(taskStatus)) && StringUtils.isBlank((CharSequence)onbrdObj.getString("checkinstatus"))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f85\u5165\u804c\u4eba\u5458\u7684\u62a5\u5230\u534f\u4f5c\u5df2\u88ab\u9a73\u56de\uff0c\u8bf7\u91cd\u65b0\u9884\u7ea6\u540e\u518d\u8fdb\u884c\u62a5\u5230\u3002", (String)"ActivityOverViewPlugin_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    CheckHelper.showCheckBill(String.valueOf(bindBizBillId), this.getView(), "2", null);
                    break;
                }
                case INFOCOLLECTION: 
                case INFOAUDIT: {
                    this.showCollectFormWindow(activityId, bindBizBillId);
                    break;
                }
                case INDUCTIONINVITATION: {
                    InviteHelper.showInvite(bindBizBillId, this.getView());
                    break;
                }
                case DATAACCEPTANCE: {
                    this.showAcceptFormWindow(bindBizBillId);
                    break;
                }
                default: {
                    this.showDefaultActivityInfoView(activityId, onbrdId);
                }
            }
        }
        if (RETRY.equals(operateName.getOperateKey())) {
            Long onbrdId = (Long)this.getView().getFormShowParameter().getCustomParam("onbrdid");
            Map resultMap = new OnbrdStartUpProcessService().sendOnbrdActivityPlanIdToWorkflow(Collections.singletonList(onbrdId));
            String tip = resultMap.getOrDefault(onbrdId, "");
            if (StringUtils.isNotBlank((CharSequence)tip)) {
                this.getView().showTipNotification(tip);
                return;
            }
            this.setBillStatus(onbrdId);
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.invokeOperation("refreshactivity");
                this.getView().sendFormAction(parentView);
            }
        }
    }

    private void setBillStatus(Long onbrdId) {
        DynamicObject[] dynamicObjects;
        for (DynamicObject data : dynamicObjects = HomCommonRepository.queryDynamicObjectByPks((String)"hom_onbrdinfo", (String)"billstatus,auditstatus,billno,org", (Object[])new Object[]{onbrdId})) {
            boolean hasAuditFlow = IActivityDomainService.getInstance().isHasAuditFlow(data);
            data.set("billstatus", (Object)(hasAuditFlow ? BillStatusEnum.SUBMIT.getCode() : BillStatusEnum.AUDIT_PASS.getCode()));
            data.set("auditstatus", (Object)(hasAuditFlow ? AuditStatusEnum.SUBMIT.getCode() : AuditStatusEnum.DEAL_COMPLETE.getCode()));
        }
        HomCommonRepository.saveDynamicObjects((String)"hom_onbrdinfo", (DynamicObject[])dynamicObjects);
    }

    private void showDefaultActivityInfoView(Long activityId, Long onbrdId) {
        QFilter typeFilter = new QFilter("activity.id", "=", (Object)activityId);
        QFilter onbFilter = new QFilter("onbrdid", "=", (Object)onbrdId);
        DynamicObject[] dynamicObjects = IActivityCommonInfoService.getInstance().getActivityInfo(new QFilter[]{typeFilter, onbFilter});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d3b\u52a8\u7684\u5b9e\u4f8b\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"ActivityOverViewPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        Long cooperationId = dynamicObjects[0].getLong("id");
        IActivityCommonInfoService.getInstance().linkLoad(this.getView(), "hom_activehandle", cooperationId);
    }

    private void showAcceptFormWindow(long bindBizBillId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        DynamicObject dyo = HomCommonRepository.queryDynamicObjectByPk((String)"hom_collect", (String)"acceptstatus,onboard.id,onboard.enrollstatus,templateresult", (Object)bindBizBillId);
        if ("0".equals(dyo.getString("templateresult"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5f85\u5165\u804c\u4eba\u5458\u672a\u5339\u914d\u5230\u4fe1\u606f\u91c7\u96c6\u65b9\u6848\uff0c\u8bf7\u8fdb\u5165\u4fe1\u606f\u91c7\u96c6\u5217\u8868\u91cd\u65b0\u5339\u914d\u3002", (String)"CollectActivityListPlugin_7", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        String acceptStatus = dyo.getString("acceptstatus");
        if (OnbrdStatusEnum.BREAK_UP.toString().equals(dyo.getString("onboard.enrollstatus")) || acceptStatus.equals("40")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62\u7684\u5355\u636e\u65e0\u6cd5\u67e5\u770b\u8be6\u60c5\u3002", (String)"CollectActivityListPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        billShowParameter.setPkId((Object)bindBizBillId);
        String candidateName = dyo.getString("onboard.name");
        billShowParameter.setCaption(MessageFormat.format(ResManager.loadKDString((String)"\u8d44\u6599\u9a8c\u6536-{0}", (String)"ACCEPTMANAGE_5", (String)"hr-hom-formplugin", (Object[])new Object[0]), candidateName));
        String biilFormId = "";
        if ("10".equals(acceptStatus)) {
            biilFormId = HOM_ACCEPTMANAGEING;
        }
        if ("20".equals(acceptStatus)) {
            biilFormId = HOM_ACCEPTMANAGEPASS;
        }
        if ("30".equals(acceptStatus)) {
            biilFormId = HOM_ACCEPTMANAGEUNPASS;
        }
        if (StringUtils.isBlank((CharSequence)biilFormId)) {
            return;
        }
        billShowParameter.setFormId(biilFormId);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void showCollectFormWindow(Long activityId, Long bindBizBillId) {
        String formId;
        DynamicObject dynamicObject = HomCommonRepository.queryDynamicObjectByPk((String)"hom_collect", (String)"", (Object)bindBizBillId);
        if ("0".equals(dynamicObject.getString("templateresult"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5f85\u5165\u804c\u4eba\u5458\u672a\u5339\u914d\u5230\u4fe1\u606f\u91c7\u96c6\u65b9\u6848\uff0c\u8bf7\u8fdb\u5165\u4fe1\u606f\u91c7\u96c6\u5217\u8868\u91cd\u65b0\u5339\u914d\u3002", (String)"CollectActivityListPlugin_7", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setPkId((Object)bindBizBillId);
        String candidateName = dynamicObject.getString("onboard.name");
        String tabName = String.format(ResManager.loadKDString((String)"\u4fe1\u606f\u91c7\u96c6-%s", (String)"CollectActivityListPlugin_6", (String)"hr-hom-formplugin", (Object[])new Object[0]), candidateName);
        if (ActivityNumberEnum.INFOAUDIT.getId().equals(activityId)) {
            formId = CollectApproveStatusEnum.valueByStatus((String)dynamicObject.getString("approvestatus")).getPageId();
            billShowParameter.setCustomParam("approve", (Object)"1");
            tabName = String.format(ResManager.loadKDString((String)"\u4fe1\u606f\u5ba1\u6838-%s", (String)"CollectActivityListPlugin_6", (String)"hr-hom-formplugin", (Object[])new Object[0]), candidateName);
        } else {
            formId = CollectManageStatusEnum.valueByStatus((String)dynamicObject.getString("collectstatus")).getPageId();
            billShowParameter.setCaption(String.format(ResManager.loadKDString((String)"\u4fe1\u606f\u5ba1\u6838-%s", (String)"CollectActivityListPlugin_6", (String)"hr-hom-formplugin", (Object[])new Object[0]), candidateName));
        }
        billShowParameter.setFormId(formId);
        billShowParameter.setCaption(tabName);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void beforeBindData(EventObject eventObject) {
        DynamicObject activityins;
        DynamicObject entryentityDy2;
        int i2;
        super.beforeBindData(eventObject);
        String flowWorkSchemeStatus = (String)this.getModel().getValue("flowworkschemestatus");
        Long onbrdId = (Long)this.getView().getFormShowParameter().getCustomParam("onbrdid");
        DynamicObject onbrdObj = HomCommonRepository.queryDynamicObjectByPk((String)"hom_onbrdbilltpl", (String)"enrollstatus", (Object)onbrdId);
        String enrollStatus = onbrdObj.getString("enrollstatus");
        if (OnbrdStatusEnum.WAIT_ONBRD.getValue().equals(enrollStatus)) {
            if (WorkflowSchemeStatusEnum.WAIT_MATCH.getValue().equals(flowWorkSchemeStatus) || WorkflowSchemeStatusEnum.MATCH_FAIL.getValue().equals(flowWorkSchemeStatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{RETRY});
                this.getView().setVisible(Boolean.FALSE, new String[]{REFRESH});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{REFRESH});
                this.getView().setVisible(Boolean.FALSE, new String[]{RETRY});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{REFRESH});
            this.getView().setVisible(Boolean.FALSE, new String[]{RETRY});
        }
        int finishActivityNum = 0;
        DynamicObjectCollection entryentityDys = this.getModel().getEntryEntity("entryentity");
        int earlyWarnActivityNum = 0;
        boolean isTerminated = false;
        List sscTaskIds = entryentityDys.stream().filter(i -> !HOMObjectUtils.isEmptyWithDynamicObjectField((Object)i.getLong("activityins.ssctaskid"))).map(j -> j.getLong("activityins.ssctaskid")).collect(Collectors.toList());
        Map slaInfoMap = SSCSLAServiceHelper.getSLAInfoByIds(sscTaskIds);
        for (i2 = 0; i2 < entryentityDys.size(); ++i2) {
            entryentityDy2 = (DynamicObject)entryentityDys.get(i2);
            activityins = entryentityDy2.getDynamicObject("activityins");
            if (activityins != null) {
                SLATimeInfoDTO slaTimeInfo;
                DynamicObject activityInsByIdObj = IHomToHrcsAppService.getInstance().getActivityInsById("handlers,activity,taskstatus", Long.valueOf(activityins.getLong("id")));
                String taskStatus = activityInsByIdObj.getString("taskstatus");
                if (ActivityStatusEnum.TERMINATED.getValue().equals(taskStatus)) {
                    isTerminated = true;
                }
                if (ActivityStatusEnum.COMPLETED.getValue().equals(taskStatus)) {
                    ++finishActivityNum;
                }
                DynamicObjectCollection handlersDys = activityInsByIdObj.getDynamicObjectCollection("handlers");
                String handlersShow = handlersDys.stream().map(dynamicObject -> dynamicObject.getString("fbasedataid.name")).filter(StringUtils::isNotBlank).collect(Collectors.joining(";"));
                entryentityDy2.set("handlersshow", (Object)handlersShow);
                Date handleTime = activityins.getDate("handletime");
                Date createTime = activityins.getDate("createtime");
                SLATimeInfoDTO slaTimeInfoDto = new SLATimeInfoDTO();
                slaTimeInfoDto.setCreateTime(createTime);
                slaTimeInfoDto.setRealFinishTime(handleTime);
                slaTimeInfoDto.setLatestdFinishTime(entryentityDy2.getDate("latestdeadline"));
                slaTimeInfoDto.setConsumingDays(DateUtils.getDayAndHour((Date)createTime, (Date)handleTime));
                slaTimeInfoDto.setRemainingDays(DateUtils.getDayAndHour((Date)new Date(), (Date)entryentityDy2.getDate("latestdeadline")));
                long sscTaskId = entryentityDy2.getLong("activityins.ssctaskid");
                if (!HOMObjectUtils.isEmptyWithDynamicObjectField((Object)sscTaskId) && !HRObjectUtils.isEmpty((Object)(slaTimeInfo = (SLATimeInfoDTO)slaInfoMap.get(sscTaskId)))) {
                    slaTimeInfoDto = slaTimeInfo;
                    slaTimeInfoDto.setRealFinishTime(handleTime);
                    slaTimeInfoDto.setConsumingDays(DateUtils.getDayAndHour((Date)slaTimeInfo.getCreateTime(), (Date)handleTime));
                }
                entryentityDy2.set("starttimetmp", (Object)slaTimeInfoDto.getCreateTime());
                entryentityDy2.set("handletimetmp", (Object)slaTimeInfoDto.getRealFinishTime());
                entryentityDy2.set("taskstatus", (Object)taskStatus);
                entryentityDy2.set("latestdeadline", (Object)slaTimeInfoDto.getLatestdFinishTime());
                if (slaTimeInfoDto.getRealFinishTime() != null) {
                    entryentityDy2.set("activitytime", (Object)DateUtils.getDayAndHour((Date)slaTimeInfoDto.getCreateTime(), (Date)handleTime));
                    continue;
                }
                entryentityDy2.set("dayremaining", (Object)slaTimeInfoDto.getRemainingDays());
                long hour = DateUtils.getHour((Date)new Date(), (Date)slaTimeInfoDto.getLatestdFinishTime());
                if (hour > 72L) continue;
                ++earlyWarnActivityNum;
                continue;
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            ArrayList<String> operationKeys = new ArrayList<String>();
            operationKeys.add(VIEW_DETAILS);
            entryGrid.hideOperateItems(OPERATIONCOLUMNAP, i2, operationKeys);
        }
        this.getModel().setValue("completionschedule", (Object)(finishActivityNum + "/" + entryentityDys.size()));
        if (!isTerminated) {
            for (DynamicObject entryentityDy2 : entryentityDys) {
                activityins = entryentityDy2.getDynamicObject("activityins");
                if (activityins != null) continue;
                entryentityDy2.set("taskstatus", (Object)ActivityStatusEnum.NOSTART.getValue());
            }
        }
        for (i2 = 0; i2 < entryentityDys.size(); ++i2) {
            entryentityDy2 = (DynamicObject)entryentityDys.get(i2);
            String taskStatus = entryentityDy2.getString("taskstatus");
            if (ActivityStatusEnum.COMPLETED.getValue().equals(taskStatus)) {
                this.setGridFiledStyle(i2, "#26B175");
                continue;
            }
            this.setGridFiledStyle(i2, "#FC8555");
        }
        this.getModel().setValue("earlywarnactivitnum", (Object)earlyWarnActivityNum);
    }

    private void setGridFiledStyle(int num, String color) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        ArrayList<CellStyle> cellStyleList = new ArrayList<CellStyle>();
        CellStyle cellStyle = new CellStyle();
        cellStyle.setRow(num);
        cellStyle.setFieldKey("taskstatus");
        cellStyle.setForeColor(color);
        cellStyleList.add(cellStyle);
        entryGrid.setCellStyle(cellStyleList);
    }
}

