/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.activity;

import java.text.MessageFormat;
import java.util.EventObject;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.sdk.hr.ssc.common.util.SSCCommonUtil;

public class CollectActivityAcceptPlugin
extends HRCoreBaseBillEdit {
    private static final String ACCEPTFLEX = "acceptflex";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"hyperlink"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long onboardId = this.getModel().getDataEntity().getLong("onboard.id");
        boolean isEnroll = IOnbrdBillDomainService.getInstance().isCanOperate(onboardId);
        boolean fromIsHstc = SSCCommonUtil.showParameterAppIdIsHstc((IFormView)this.getView());
        boolean isHanler = true;
        DynamicObject accteptins = this.getModel().getDataEntity().getDynamicObject("accteptins");
        if (!HRObjectUtils.isEmpty((Object)accteptins)) {
            long userId = UserServiceHelper.getCurrentUserId();
            Optional<DynamicObject> isHandlerOp = accteptins.getDynamicObjectCollection("handlers").stream().filter(user -> userId == user.getLong("fbasedataId.id")).findAny();
            isHanler = isHandlerOp.isPresent();
        }
        if (isEnroll || fromIsHstc || !isHanler) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ACCEPTFLEX});
            return;
        }
        String acceptStatus = this.getModel().getDataEntity().getString("acceptstatus");
        if ("10".equals(acceptStatus) || "30".equals(acceptStatus) || "20".equals(acceptStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{ACCEPTFLEX});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{ACCEPTFLEX});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (!(source instanceof Button)) {
            return;
        }
        Button button = (Button)source;
        if (!"hyperlink".equals(button.getKey())) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        BillShowParameter billShowParameter = new BillShowParameter();
        String billFormId = "";
        String acceptStatus = dataEntity.getString("acceptstatus");
        if ("10".equals(acceptStatus)) {
            billFormId = "hom_acceptmanageing";
        } else if ("20".equals(acceptStatus)) {
            billFormId = "hom_acceptmanagepass";
        } else if ("30".equals(acceptStatus)) {
            billFormId = "hom_acceptmanageunpass";
        } else {
            return;
        }
        billShowParameter.setPkId((Object)dataEntity.getLong("id"));
        String candidateName = dataEntity.getString("onboard.name");
        billShowParameter.setCaption(MessageFormat.format(ResManager.loadKDString((String)"\u8d44\u6599\u9a8c\u6536-{0}", (String)"ACCEPTMANAGE_5", (String)"hr-hom-formplugin", (Object[])new Object[0]), candidateName));
        billShowParameter.setFormId(billFormId);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }
}

