/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.activity.handle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hom.business.application.common.CommonService;
import kd.hr.hom.business.domain.service.activity.IActivityCommonInfoService;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;
import kd.hr.hom.business.domain.service.impl.activity.ActivityNum;
import kd.hr.hom.common.enums.ActivityStatusEnum;

public class HandleBillLinkListPlugin
extends HRDataBaseList
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(HandleBillLinkListPlugin.class);
    private static final HRBaseServiceHelper BASE_SERVICE_HELPER = new HRBaseServiceHelper("hom_activeinfobody");
    private static final long serialVersionUID = 952716672844862951L;
    private static final String EXIT = "donothing_exit";
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"HandleBillLinkListPlugin$$@&", (int)10, (int)1000);
    static final String DONOTHING_COMMIT = "donothing_commit";

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (HRStringUtils.equals((String)fieldName, (String)"onbrdid_name")) {
            String cooperationId = this.getFocusRowPkId().toString();
            IActivityCommonInfoService.getInstance().linkLoad(this.getView(), "hom_activehandle", Long.valueOf(cooperationId));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        if (eventArgs.getOperateKey().equals(EXIT)) {
            this.getView().getParentView().invokeOperation("close");
            this.getView().sendFormAction(this.getView().getParentView());
        }
        if (eventArgs.getOperateKey().equals(DONOTHING_COMMIT) && (HRObjectUtils.isEmpty((Object)eventArgs.getOperationResult()) || eventArgs.getOperationResult().isSuccess())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (HRStringUtils.equals((String)"asynActivityCommit", (String)e.getName())) {
            HRPageCache pageCache = new HRPageCache(this.getView());
            THREAD_POOL.execute(() -> this.asynCommit(pageCache), RequestContext.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asynCommit(HRPageCache pageCache) {
        List activityBodyIds = (List)pageCache.get("activityBodyIds", List.class);
        List activityIds = CommonService.getLongList((List)activityBodyIds);
        try {
            IActivityCommonInfoService.getInstance().activityCommit(activityIds);
        }
        catch (Exception exception) {
            this.getView().showErrorNotification(exception.getMessage());
        }
        finally {
            IHomDataMutexService.getInstance().batchRelease((Collection)activityIds, "hom_collaborationdetail", "donothing_tran");
        }
    }

    private void activityCommit() {
        ListSelectedRowCollection collection = this.getSelectedRows();
        String opName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"HandleBillLinkListPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        List activityIds = collection.stream().map(selRow -> Long.valueOf(selRow.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        try {
            if (!IActivityCommonInfoService.getInstance().getBatchLock((IListView)this.getView(), opName)) {
                return;
            }
            ArrayList<String> status = new ArrayList<String>();
            status.add(ActivityStatusEnum.PROCESSING.getValue());
            IActivityCommonInfoService.getInstance().handleConsentTask(this.getView(), activityIds, status, true);
            QFilter qFilter = new QFilter("id", "in", activityIds);
            DynamicObject[] activityInfos = IActivityCommonInfoService.getInstance().getActivityInfo(new QFilter[]{qFilter});
            if (activityInfos == null || activityInfos.length == 0) {
                LOGGER.error("activityCommit_HandleBillLinkListPlugin_error:activityInfos is null");
                throw new KDBizException("activityInfos is null");
            }
            Date deta = new Date();
            Long user = RequestContext.get().getCurrUserId();
            Arrays.stream(activityInfos).forEach(dy -> {
                dy.set("finishdate", (Object)deta);
                dy.set("modifier", (Object)user);
                dy.set("modifytime", (Object)deta);
            });
            BASE_SERVICE_HELPER.update(activityInfos);
        }
        catch (Exception exception) {
            LOGGER.error("activityCommit_HandleBillLinkListPlugin_error", (Throwable)exception);
            this.getView().showErrorNotification(exception.getMessage());
            IHomDataMutexService.getInstance().batchRelease(activityIds, "hom_collaborationdetail", "donothing_tran");
            this.getView().invokeOperation("refresh");
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        setFilterEvent.setMainOrgQFilter(null);
        List customQFilters = setFilterEvent.getCustomQFilters();
        Long userId = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("activityins.handlers.fbasedataid", "=", (Object)userId);
        QFilter numberFilter = new QFilter("activity.id", "not in", (Object)ActivityNum.HANDLE_ID_LIST);
        customQFilters.add(qFilter.and(numberFilter));
    }
}

