/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.activity.handle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hom.business.domain.service.activity.IActivityCommonInfoService;
import kd.hr.hom.business.domain.service.impl.activity.ActivityNum;

public class TransferPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    static final String PERSONS = "persons";
    static final String PERSON = "person";
    static final String FBASE_DATA_NUMBER = "fbasedataid.id";

    public void propertyChanged(PropertyChangedArgs event) {
        String name = event.getProperty().getName();
        if (PERSONS.equals(name) || PERSON.equals(name)) {
            this.changeProperty(event);
        }
    }

    private void changeProperty(PropertyChangedArgs event) {
        List<Long> ids;
        String name = event.getProperty().getName();
        HRPageCache thisCache = new HRPageCache(this.getView());
        HRPageCache parenCache = new HRPageCache(this.getView().getParentView());
        if (PERSONS.equals(name)) {
            ChangeData[] changeData = event.getChangeSet();
            DynamicObjectCollection person = (DynamicObjectCollection)changeData[0].getNewValue();
            if (CollectionUtils.isEmpty((Collection)person)) {
                ids = new ArrayList<Long>(0);
                this.getView().getPageCache().remove("personid");
            } else {
                ids = new ArrayList(person.size());
                ids = person.stream().map(dy -> dy.getLong(FBASE_DATA_NUMBER)).collect(Collectors.toList());
            }
        } else {
            ChangeData[] changeData = event.getChangeSet();
            DynamicObject user = (DynamicObject)changeData[0].getNewValue();
            if (HRObjectUtils.isEmpty((Object)user)) {
                return;
            }
            ids = new ArrayList(1);
            ids.add(user.getLong("id"));
        }
        thisCache.put("personid", ids);
        parenCache.put("personid", ids);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String key = eventArgs.getOperateKey();
        HRPageCache thisCache = new HRPageCache(this.getView());
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HRPageCache parentCache = new HRPageCache(this.getView().getParentView());
        ArrayList ids = new ArrayList();
        if (thisCache.get("personid", List.class) != null) {
            ids.addAll((Collection)thisCache.get("personid", List.class));
        }
        parentCache.put("personid", ids);
        if (StringUtils.equals((CharSequence)"determine", (CharSequence)key)) {
            resultMap.put("personid", ids);
            resultMap.put("operation", "determine");
            String text = (String)this.getView().getModel().getValue("transferremake");
            resultMap.put("transferremake", text);
            resultMap.put("TRANSFER_CLOSE", Boolean.FALSE);
            this.getView().returnDataToParent(resultMap);
        } else {
            resultMap.put("cachepersonid", ids);
            resultMap.put("TRANSFER_CLOSE", Boolean.TRUE);
            this.getView().returnDataToParent(resultMap);
        }
        this.getView().close();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        HRPageCache pageCache = new HRPageCache(this.getView().getParentView());
        List Ids = (List)pageCache.get("personid", List.class);
        if (CollectionUtils.isEmpty((Collection)Ids)) {
            return;
        }
        List<Long> personId = this.getLongList(Ids);
        HRPageCache thisCache = new HRPageCache(this.getView());
        thisCache.put("personid", personId);
        List<Long> personids = this.getUserIds();
        if (!Collections.disjoint(personids, personId)) {
            return;
        }
        if (this.isFromHandle()) {
            this.getView().getModel().setValue(PERSON, (Object)personId.get(0));
        } else {
            this.getView().getModel().setValue(PERSONS, (Object)personId.toArray(new Long[0]));
        }
    }

    private List<Long> getLongList(List<Object> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> ids = new ArrayList<Long>(list.size());
        list.stream().forEach(obj -> ids.add(Long.valueOf(obj.toString())));
        return ids;
    }

    private boolean isFromHandle() {
        String page;
        IFormView view = this.getView().getParentView();
        if (view instanceof IListView) {
            IListView listView = (IListView)view;
            page = listView.getBillFormId();
        } else {
            page = view.getFormShowParameter().getFormId();
        }
        return ActivityNum.HANDLE_PAGE.contains(page);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        List<Long> personids = this.getUserIds();
        ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "not in", personids));
    }

    private List<Long> getUserIds() {
        IFormView view = this.getView().getParentView();
        ArrayList<Long> activityInfoIds = new ArrayList<Long>();
        if (view instanceof IListView) {
            IListView listView = (IListView)view;
            List ids = IActivityCommonInfoService.getInstance().getKeyList(listView);
            activityInfoIds.addAll(ids);
        } else {
            Long id = IActivityCommonInfoService.getInstance().getActivityId(view);
            activityInfoIds.add(id);
        }
        DynamicObject[] activityInfos = IActivityCommonInfoService.getInstance().getActivityInfo(activityInfoIds);
        ArrayList<Long> personIds = new ArrayList<Long>();
        Stream.of(activityInfos).forEach(dy -> {
            DynamicObjectCollection handlers = dy.getDynamicObjectCollection("activityins.handlers");
            personIds.addAll(handlers.stream().map(item -> item.getLong(FBASE_DATA_NUMBER)).collect(Collectors.toList()));
        });
        return personIds;
    }
}

