/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.onbrd.IAttachmentAppService;

public class HcfDataBaseExtAttachmentPlugin
extends HRDynamicFormBasePlugin
implements UploadListener {
    private static final Log LOGGER = LogFactory.getLog(HcfDataBaseExtAttachmentPlugin.class);
    protected static final String KEY_ONBRDNULLPAGE = "onbrdnullpage";
    protected List<AttachmentPanelAp> attachmentPanelAps = new ArrayList<AttachmentPanelAp>();

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        cache.remove("TampAttCache" + this.getView().getPageId());
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        List<AttachmentPanelAp> allAttachmentPanel = this.getAllAttachmentPanel();
        allAttachmentPanel.forEach(attachmentPanelAp -> {
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(attachmentPanelAp.getKey());
            if (attachmentPanel != null) {
                attachmentPanel.addUploadListener((UploadListener)this);
            }
        });
    }

    public void remove(UploadEvent evt) {
        Object[] urls;
        Long dataId = this.getDataId();
        for (Object url : urls = evt.getUrls()) {
            if (!(url instanceof LinkedHashMap)) continue;
            AttachmentServiceHelper.remove((String)((String)this.getModel().getValue("obj")), (Object)dataId, ((LinkedHashMap)url).get("uid"));
        }
    }

    protected Long getDataId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("id");
    }

    protected void loadAttachments(Long dataId) {
        List attachments;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        this.attachmentPanelAps = this.getAllAttachmentPanel();
        Set<String> attachmentPanelKeys = this.attachmentPanelAps.stream().map(attachmentPanelAp -> attachmentPanelAp.getKey()).collect(Collectors.toSet());
        Map customParams = formShowParameter.getCustomParams();
        if (OperationStatus.VIEW.equals((Object)formShowParameter.getStatus())) {
            this.getView().setEnable(Boolean.FALSE, attachmentPanelKeys.toArray(new String[attachmentPanelKeys.size()]));
        }
        if ((attachments = IHomToHcfAppService.getInstance().queryAttach(dataId, attachmentPanelKeys, (String)customParams.get("obj"))).isEmpty()) {
            return;
        }
        Map<String, List<DynamicObject>> attachmentMap = attachments.stream().collect(Collectors.groupingBy(dy -> dy.getString("fattachmentpanel")));
        IAttachmentAppService.getInstance().bindAttachmentInfo(attachmentMap, this.getView());
    }

    protected List<AttachmentPanelAp> getAllAttachmentPanel() {
        if (!this.attachmentPanelAps.isEmpty()) {
            return this.attachmentPanelAps;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String editPageNUmber = customParams.containsKey("editinfo") ? (String)customParams.get("editinfo") : this.getView().getEntityId();
        String entityPkid = MetadataDao.getIdByNumber((String)editPageNUmber, (MetaCategory)MetaCategory.Form);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)entityPkid, (MetaCategory)MetaCategory.Form);
        List items = formMetadata.getItems();
        ArrayList<AttachmentPanelAp> attachmentPanelAps = new ArrayList<AttachmentPanelAp>(items.size());
        items.forEach(controlAp -> {
            if (controlAp instanceof AttachmentPanelAp) {
                attachmentPanelAps.add((AttachmentPanelAp)controlAp);
            }
        });
        return attachmentPanelAps;
    }

    protected void saveAttachment(Long id, String entityNumber) {
        List<AttachmentPanelAp> attachmentPanelAps = this.getAllAttachmentPanel();
        HashMap<String, List> objectObjectHashMap = new HashMap<String, List>(2);
        for (AttachmentPanelAp attachmentPanelAp : attachmentPanelAps) {
            String key = attachmentPanelAp.getKey();
            AttachmentPanel attachmentpanelap = (AttachmentPanel)this.getView().getControl(key);
            List attachmentData = attachmentpanelap.getAttachmentData();
            objectObjectHashMap.put(key, attachmentData);
        }
        DynamicObjectCollection collection = AttachmentServiceHelper.saveTempAttachments((String)entityNumber, (Object)id, (String)"hcf", objectObjectHashMap);
        LOGGER.info("saveAttachment result:{}", (Object)collection);
    }

    protected void delAllAttachment(Long dataId, String objNumber) {
        this.attachmentPanelAps = this.getAllAttachmentPanel();
        Set attachmentPanelKeys = this.attachmentPanelAps.stream().map(attachmentPanelAp -> attachmentPanelAp.getKey()).collect(Collectors.toSet());
        List attachmentList = IHomToHcfAppService.getInstance().queryAttach(dataId, attachmentPanelKeys, objNumber);
        if (CollectionUtils.isEmpty((Collection)attachmentList)) {
            return;
        }
        for (DynamicObject dyo : attachmentList) {
            AttachmentServiceHelper.remove((String)dyo.getString("fbilltype"), (Object)dataId, (Object)dyo.get("fnumber"));
        }
    }
}

