/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.base;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.formplugin.web.base.HcfDataBaseExtAttachmentPlugin;

public class HcfDataBaseExtEditPlugin
extends HcfDataBaseExtAttachmentPlugin {
    private static final Log LOGGER = LogFactory.getLog(HcfDataBaseExtEditPlugin.class);
    protected static final String BTN_ADD = "btn_add";

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long candidateId = HRJSONUtils.getLongValOfCustomParam(customParams.get("candidateid"));
        this.getModel().setValue("candidate", (Object)candidateId);
        String entityNumber = (String)customParams.get("obj");
        this.getView().getModel().setValue("obj", (Object)entityNumber);
        Long dataId = HRJSONUtils.getLongValOfCustomParam(customParams.get("id"));
        if (HRObjectUtils.isEmpty((Object)dataId)) {
            return;
        }
        DynamicObject dynamicObject = IHomToHcfAppService.getInstance().getById(dataId, (String)customParams.get("obj"));
        DynamicObject dataEntity = this.getModel().getDataEntity();
        HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)dataEntity);
        this.loadAttachments(dataId);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String isAlreadyClose = this.getPageCache().get("isalreadyclose");
        if (this.getModel().getDataChanged() && HRStringUtils.isEmpty((String)isAlreadyClose)) {
            e.setCancel(true);
            this.clickCancelChanged("cancel");
        } else {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (OperationStatus.VIEW.equals((Object)status)) {
                return;
            }
            Object entityNum = this.getView().getFormShowParameter().getCustomParams().get("obj");
            Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
            IOnbrdCommonAppService.getInstance().releaseLockByHCF(id, String.valueOf(entityNum), "modify");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        boolean success = afterDoOperationEventArgs.getOperationResult().isSuccess();
        if (success && "save".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.updateOrSaveCanExtInfo();
            this.updateCanExtView();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        if (HRStringUtils.equals((String)actionId, (String)"cancel") && MessageBoxResult.Yes == resultValue) {
            this.getPageCache().put("isalreadyclose", "1");
            this.getView().close();
        }
    }

    protected void clickCancelChanged(String actionId) {
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"HomDataBaseEdit_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"HomDataBaseEdit_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        String msg = MessageFormat.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f{0}\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"HomDataBaseEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), System.lineSeparator());
        String changeDesc = this.getModel().getChangeDesc();
        this.getView().showConfirm(msg, changeDesc, MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener(actionId, (IFormPlugin)this), btnNameMaps);
    }

    @Override
    protected List<AttachmentPanelAp> getAllAttachmentPanel() {
        if (!this.attachmentPanelAps.isEmpty()) {
            return this.attachmentPanelAps;
        }
        String entityPkid = MetadataDao.getIdByNumber((String)this.getView().getEntityId(), (MetaCategory)MetaCategory.Form);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)entityPkid, (MetaCategory)MetaCategory.Form);
        List items = formMetadata.getItems();
        ArrayList<AttachmentPanelAp> attachmentPanelAps = new ArrayList<AttachmentPanelAp>(items.size());
        items.forEach(controlAp -> {
            if (controlAp instanceof AttachmentPanelAp) {
                attachmentPanelAps.add((AttachmentPanelAp)controlAp);
            }
        });
        return attachmentPanelAps;
    }

    protected void updateOrSaveCanExtInfo() {
        DynamicObject dyo = null;
        Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long candidateId = dataEntity.getLong("candidate.id");
        String entityNumber = dataEntity.getString("obj");
        if (!HRObjectUtils.isEmpty((Object)id)) {
            DynamicObjectCollection coll = IHomToHcfAppService.getInstance().getHisMultiRowEntityById(id, candidateId, entityNumber);
            if (!CollectionUtils.isEmpty((Collection)coll)) {
                dyo = (DynamicObject)coll.get(0);
            }
        } else {
            id = ORM.create().genLongId(entityNumber);
        }
        DynamicObject canExtDy = HomCommonRepository.createEmptyDynamicObject((String)entityNumber);
        if (dyo == null) {
            canExtDy.set("boid", null);
            canExtDy.set("id", (Object)id);
        } else {
            canExtDy.set("boid", (Object)dyo.getLong("boid"));
        }
        HRDynamicObjectUtils.copy((DynamicObject)dataEntity, (DynamicObject)canExtDy);
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.add((Object)canExtDy);
        HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>(2);
        map.put(entityNumber, collection);
        ArrayList<HashMap<String, DynamicObjectCollection>> list = new ArrayList<HashMap<String, DynamicObjectCollection>>(1);
        list.add(map);
        Map result = IHomToHcfAppService.getInstance().saveOrUpdateCandidates(list);
        LOGGER.info("saveOrUpdateCandidates result:{}", (Object)result);
        this.saveAttachment(id, entityNumber);
    }

    protected void updateCanExtView() {
        this.getPageCache().put("isalreadyclose", "1");
        this.getView().getParentView().invokeOperation("refresh");
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().close();
    }
}

