/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.base;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.form.control.MapControl;
import kd.bos.ext.form.control.events.MapSelectEvent;
import kd.bos.ext.form.control.events.MapSelectListener;
import kd.bos.ext.form.dto.MapSelectPointOption;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.field.DecimalEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.domain.repository.common.HomConfigRepository;
import kd.hr.hom.business.domain.service.impl.common.BaseDataDomainServiceImpl;
import org.apache.commons.collections4.MapUtils;

public class OnbrdPlacePlugin
extends HRDataBaseEdit
implements MapSelectListener {
    private static final Log logger = LogFactory.getLog(OnbrdPlacePlugin.class);
    private static final HRBaseServiceHelper PLACE_HELPER = new HRBaseServiceHelper("hom_placeentry");
    private static final String MAP_CONTROL = "mapcontrolap";
    private static final String CACHE_ISFIRSTLOAD = "isfirstload";
    private static final String LONGITUDE = "longitude";
    private static final String LATITUDE = "latitude";
    private static final String LAT = "lat";
    private static final String LNG = "lng";
    private static final String POINT = "point";
    private static final String ADDRESS = "address";
    private static final String SELECT_POINT = "selectPoint";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        MapControl control = (MapControl)this.getControl(MAP_CONTROL);
        control.addSelectListener((MapSelectListener)this);
    }

    public void select(MapSelectEvent evt) {
        Map locationInfo = evt.getPoint();
        logger.info(MessageFormat.format("OnbrdPlacePlugin-select {0}", locationInfo.toString()));
        if (CollectionUtils.isEmpty((Map)locationInfo)) {
            return;
        }
        Map point = (Map)locationInfo.get(POINT);
        if (CollectionUtils.isEmpty((Map)point)) {
            return;
        }
        Double lat = MapUtils.getDouble((Map)point, (Object)LAT);
        Double lng = MapUtils.getDouble((Map)point, (Object)LNG);
        this.getModel().setValue(LONGITUDE, (Object)lng);
        this.getModel().setValue(LATITUDE, (Object)lat);
        this.getModel().setValue(ADDRESS, locationInfo.get(ADDRESS));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey;
        switch (fieldKey = args.getProperty().getName()) {
            case "city": {
                if (this.isExistCity()) {
                    if (Boolean.TRUE.equals(this.getModel().getValue("isdefaultaddress"))) {
                        String strs = ResManager.loadKDString((String)"\u8be5\u57ce\u5e02\u5df2\u6709\u9ed8\u8ba4\u5730\u5740\uff0c\u8bf7\u5148\u4fee\u6539\u539f\u6570\u636e\u4e3a\u975e\u9ed8\u8ba4\u5730\u5740\u3002", (String)"OnbrdPlacePlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                        this.getView().showTipNotification(strs);
                    }
                    this.getModel().setValue("isdefaultaddress", (Object)Boolean.FALSE);
                    break;
                }
                this.getModel().setValue("isdefaultaddress", (Object)Boolean.TRUE);
                break;
            }
            case "isdefaultaddress": {
                Boolean isDefaultAddress = (Boolean)this.getModel().getValue("isdefaultaddress");
                if (!isDefaultAddress.booleanValue() || !this.isExistCity()) break;
                String strs = ResManager.loadKDString((String)"\u8be5\u57ce\u5e02\u5df2\u6709\u9ed8\u8ba4\u5730\u5740\uff0c\u8bf7\u5148\u4fee\u6539\u539f\u6570\u636e\u4e3a\u975e\u9ed8\u8ba4\u5730\u5740\u3002", (String)"OnbrdPlacePlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(strs);
                this.getModel().setValue("isdefaultaddress", (Object)Boolean.FALSE);
                break;
            }
            case "issetgpsinfo": {
                this.setMustInput();
                break;
            }
            case "longitude": 
            case "latitude": 
            case "address": {
                this.setMapControl(true);
                break;
            }
        }
    }

    private void setMapControl(boolean flag) {
        if (!((Boolean)this.getModel().getValue("issetgpsinfo")).booleanValue()) {
            return;
        }
        OrmLocaleValue address = (OrmLocaleValue)this.getModel().getValue(ADDRESS);
        if (ObjectUtils.isEmpty((Object)address.getLocaleValue())) {
            return;
        }
        MapControl control = (MapControl)this.getControl(MAP_CONTROL);
        MapSelectPointOption mapSelectPointOption = new MapSelectPointOption();
        mapSelectPointOption.setLat(((BigDecimal)this.getModel().getValue(LATITUDE)).doubleValue());
        mapSelectPointOption.setLng(((BigDecimal)this.getModel().getValue(LONGITUDE)).doubleValue());
        mapSelectPointOption.setAddress(address.getLocaleValue());
        if (flag) {
            mapSelectPointOption.setTitle(" ");
            mapSelectPointOption.setProvince(" ");
            mapSelectPointOption.setCity(" ");
            if (BigDecimal.ZERO.compareTo((BigDecimal)this.getModel().getValue(LATITUDE)) == 0 && BigDecimal.ZERO.compareTo((BigDecimal)this.getModel().getValue(LONGITUDE)) == 0) {
                control.selectAddress(address.getLocaleValue());
                return;
            }
        }
        control.selectPoint(mapSelectPointOption);
    }

    private boolean isExistCity() {
        DynamicObject cityDy = (DynamicObject)this.getModel().getValue("city");
        if (cityDy != null) {
            long cityId = cityDy.getLong("id");
            QFilter cityQilter = new QFilter("city", "=", (Object)cityId);
            cityQilter.and(new QFilter("isdefaultaddress", "=", (Object)"1"));
            cityQilter.and(new QFilter("id", "!=", this.getModel().getValue("id")));
            BaseDataDomainServiceImpl baseDataDomainService = new BaseDataDomainServiceImpl();
            return baseDataDomainService.isExists(PLACE_HELPER, cityQilter);
        }
        return false;
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (SELECT_POINT.equals(e.getName())) {
            logger.info("clientCallBack");
            String isfirstload = this.getPageCache().get(CACHE_ISFIRSTLOAD);
            if (HRStringUtils.equals((String)"1", (String)isfirstload)) {
                logger.info("Don't need to refresh location when first load");
                return;
            }
            this.setMapControl(false);
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setMustInput();
        this.getView().addClientCallBack(SELECT_POINT, Integer.valueOf(2000));
    }

    private void setMustInput() {
        DecimalEdit longitude = (DecimalEdit)this.getView().getControl(LONGITUDE);
        DecimalEdit latitude = (DecimalEdit)this.getView().getControl(LATITUDE);
        DecimalEdit effectRadius = (DecimalEdit)this.getView().getControl("effectradius");
        if (!((Boolean)this.getModel().getValue("issetgpsinfo")).booleanValue()) {
            longitude.setMustInput(false);
            latitude.setMustInput(false);
            effectRadius.setMustInput(false);
        } else {
            longitude.setMustInput(true);
            latitude.setMustInput(true);
            effectRadius.setMustInput(true);
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        long pkId = this.getModel().getDataEntity().getLong("id");
        logger.info("afterCreateNewData pkId:" + pkId);
        if (pkId != 0L) {
            return;
        }
        String defaultLocation = HomConfigRepository.queryValueByBusinessKey((String)"onbrdplace_default_location");
        if (HRStringUtils.isEmpty((String)defaultLocation)) {
            return;
        }
        Map locationInfoMap = (Map)JSONObject.parseObject((String)defaultLocation, Map.class);
        String defaultAddress = (String)locationInfoMap.get(ADDRESS);
        MapControl mapCtl = (MapControl)this.getView().getControl(MAP_CONTROL);
        mapCtl.selectAddress(defaultAddress);
        this.getPageCache().put(CACHE_ISFIRSTLOAD, "1");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operateKey) && operationResult.isSuccess()) {
            if (afterDoOperationEventArgs.getSource() instanceof SaveAndNew) {
                return;
            }
            this.getView().close();
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"OnbrdPlacePlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(parentView);
            }
        }
    }
}

