/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class ShowResultPlugin
extends HRDynamicFormBasePlugin {
    private static final Log logger = LogFactory.getLog(ShowResultPlugin.class);
    private static final String VIEWDETAILS = "viewdetails";
    private static final String LBL_SUCCESSPERSON = "successperson";
    private static final String LBL_SUCCESSOPERATION = "successoperation";
    private static final String LBL_FAILPERSON = "failperson";
    private static final String LBL_FAILOPERATION = "failoperation";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String formId = formShowParameter.getFormId();
        if ("hom_result_success".equals(formId)) {
            this.initSuccessPage(formShowParameter);
        } else if ("hom_result_fail".equals(formId)) {
            this.initFailPage(formShowParameter);
        } else {
            this.initAllPage(formShowParameter);
        }
    }

    private void initSuccessPage(FormShowParameter formShowParameter) {
        String successPerson = (String)formShowParameter.getCustomParam(LBL_SUCCESSPERSON);
        String successOperation = (String)formShowParameter.getCustomParam(LBL_SUCCESSOPERATION);
        Label successpersonLabel = (Label)this.getView().getControl(LBL_SUCCESSPERSON);
        successpersonLabel.setText(successPerson);
        Label successoperationLabel = (Label)this.getView().getControl(LBL_SUCCESSOPERATION);
        successoperationLabel.setText(successOperation);
    }

    private void initFailPage(FormShowParameter formShowParameter) {
        String failPerson = (String)formShowParameter.getCustomParam(LBL_FAILPERSON);
        String failOperation = (String)formShowParameter.getCustomParam(LBL_FAILOPERATION);
        Label failpersonLabel = (Label)this.getView().getControl(LBL_FAILPERSON);
        failpersonLabel.setText(failPerson);
        Label failoperationLabel = (Label)this.getView().getControl(LBL_FAILOPERATION);
        failoperationLabel.setText(failOperation);
    }

    private void initAllPage(FormShowParameter formShowParameter) {
        String successPerson = (String)formShowParameter.getCustomParam(LBL_SUCCESSPERSON);
        String successOperation = (String)formShowParameter.getCustomParam(LBL_SUCCESSOPERATION);
        String failPerson = (String)formShowParameter.getCustomParam(LBL_FAILPERSON);
        String failOperation = (String)formShowParameter.getCustomParam(LBL_FAILOPERATION);
        Label successpersonLabel = (Label)this.getView().getControl(LBL_SUCCESSPERSON);
        successpersonLabel.setText(successPerson);
        Label successoperationLabel = (Label)this.getView().getControl(LBL_SUCCESSOPERATION);
        successoperationLabel.setText(successOperation);
        Label failpersonLabel = (Label)this.getView().getControl(LBL_FAILPERSON);
        failpersonLabel.setText(failPerson);
        Label failoperationLabel = (Label)this.getView().getControl(LBL_FAILOPERATION);
        failoperationLabel.setText(failOperation);
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{VIEWDETAILS});
    }

    public void click(EventObject evt) {
        Control control;
        Object source = evt.getSource();
        if (source instanceof Control && (control = (Control)source).getKey().equals(VIEWDETAILS)) {
            this.exportExcel();
        }
    }

    private void exportExcel() {
        String excelName = (String)this.getView().getFormShowParameter().getCustomParam("excelname");
        List exportDataList = (List)this.getView().getFormShowParameter().getCustomParam("exportdatalist");
        List headDataList = new ArrayList();
        try {
            headDataList = (List)HRJSONUtils.cast((String)this.getView().getFormShowParameter().getCustomParam("headdatalist").toString(), List.class, (Class[])new Class[]{HRExportHeadObject.class});
        }
        catch (IOException iOException) {
            logger.error((Throwable)iOException);
            this.getView().showErrMessage(iOException.getMessage(), " Fail to cast json ! Reason: ");
        }
        String exportExcelUrl = null;
        try {
            exportExcelUrl = HRExportDataHelper.getExportExcelUrl((String)excelName, (List)exportDataList, headDataList);
        }
        catch (IOException iOException) {
            logger.error((Throwable)iOException);
            this.getView().showErrMessage(iOException.getMessage(), " Fail to get export Excel url ! Reason: ");
        }
        if (!HRStringUtils.isEmpty((String)exportExcelUrl)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)exportExcelUrl);
        }
    }
}

