/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.checkin;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.onbrd.IValidEntryDateService;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.formplugin.web.checkin.ReservationInfoPlugin;

public class CheckinInfoPlugin
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(ReservationInfoPlugin.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"CheckinInfoPlugin", (int)Runtime.getRuntime().availableProcessors(), (int)1000);

    public void afterCreateNewData(EventObject eventObject) {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        DynamicObject checkinInfoObj = IOnbrdBillDomainService.getInstance().findOnbrdBillById("preenrollstatus,preeneffectdate,preenonbrdtcity,effectdate,onbrdtcity,checkintype,nocheckintimes,ischeckinexception,exceptioncause,checkinstatus,preenonbrdtcity.id,enrollstatus", (Object)onbrdId);
        this.getModel().setValue("effectdate", checkinInfoObj.get("effectdate"));
        this.getModel().setValue("onbrdtcity", checkinInfoObj.get("onbrdtcity"));
        this.getModel().setValue("checkintype", checkinInfoObj.get("checkintype"));
        this.getModel().setValue("ischeckinexception", checkinInfoObj.get("ischeckinexception"));
        this.getModel().setValue("nocheckintimes", checkinInfoObj.get("nocheckintimes"));
        this.getModel().setValue("exceptioncause", checkinInfoObj.get("exceptioncause"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        String properties = "id,effectdate,aadminorg,aposition,stdposition,apositiontype,ajob,viewtype,personfield,personindexid";
        DynamicObject onbrdBill = IOnbrdBillDomainService.getInstance().findOnbrdBill(properties, new QFilter[]{new QFilter("id", "=", (Object)onbrdId)});
        Date effectDateNew = HRDateTimeUtils.truncateDate((Date)this.getModel().getDataEntity().getDate("effectdate"));
        onbrdBill.set("effectdate", (Object)effectDateNew);
        String validateResult = IOnbrdCommonAppService.getInstance().validateEffectDateWithOrgField(onbrdBill);
        if (HRStringUtils.isNotEmpty((String)validateResult)) {
            args.setCancel(true);
            args.setCancelMessage(validateResult);
            return;
        }
        Map validEntryDateOfQuitDateMap = IValidEntryDateService.getInstance().validEntryDateOfQuitDate(new DynamicObject[]{onbrdBill}, false);
        Optional message = validEntryDateOfQuitDateMap.getOrDefault(onbrdBill.getLong("personfield.id"), Optional.empty());
        if (message.isPresent()) {
            args.setCancel(true);
            args.setCancelMessage((String)message.get());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult().isSuccess() && "save".equals(afterDoOperationEventArgs.getOperateKey())) {
            try (TXHandle txHandle = TX.required();){
                try {
                    Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
                    IOnbrdBillDomainService OnbrdBillDomainService = IOnbrdBillDomainService.getInstance();
                    DynamicObject checkinInfoObj = OnbrdBillDomainService.findOnbrdBillById("preenrollstatus,preeneffectdate,preenonbrdtcity,effectdate,onbrdtcity,checkintype,nocheckintimes,ischeckinexception,exceptioncause,checkinstatus,preenonbrdtcity.id,enrollstatus", (Object)onbrdId);
                    Date effectDateNew = HRDateTimeUtils.truncateDate((Date)((Date)this.getModel().getValue("effectdate")));
                    Date effectDateOld = checkinInfoObj.getDate("effectdate");
                    checkinInfoObj.set("effectdate", (Object)effectDateNew);
                    checkinInfoObj.set("onbrdtcity", this.getModel().getValue("onbrdtcity"));
                    checkinInfoObj.set("checkintype", this.getModel().getValue("checkintype"));
                    OnbrdBillDomainService.saveOnbrdBillInfo(checkinInfoObj);
                    THREAD_POOL.execute(() -> ((ICollectService)ServiceFactory.getService(ICollectService.class)).sendNoticeCandidate(onbrdId, effectDateNew, effectDateOld), RequestContext.get());
                }
                catch (Exception exception) {
                    txHandle.markRollback();
                    LOGGER.error((Throwable)exception);
                }
            }
        }
    }
}

