/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.checkin;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hom.business.application.utils.HomAppConfigUtil;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.CheckinStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;

public class OnbrdCheckinBillListPlugin
extends HRDataBaseList
implements TabSelectListener {
    private static final Log LOGGER = LogFactory.getLog(OnbrdCheckinBillListPlugin.class);
    private static final String SPACE_VALUE = " ";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey;
        switch (tabKey = tabSelectEvent.getTabKey()) {
            case "all": {
                this.loadCheckinList("hom_allcheckin", "alllist", null, null);
                break;
            }
            case "waitcheckin": {
                this.loadCheckinList("hom_waitcheckin", "waitcheckinlist", CheckinStatusEnum.WAIT_CHECKIN.toString(), null);
                break;
            }
            case "hascheckin": {
                this.loadCheckinList("hom_hascheckin", "hascheckinlist", CheckinStatusEnum.HAS_CHECKIN.toString(), null);
                break;
            }
            case "checkinexception": {
                this.loadCheckinList("hom_exceptioncheckin", "checkinexceptionlist", CheckinStatusEnum.CHECKIN_EXCEPTION.toString(), null);
                break;
            }
            case "breakup": {
                this.loadCheckinList("hom_breakupcheckin", "breakuplist", null, OnbrdStatusEnum.BREAK_UP.toString());
                break;
            }
            case "waitconfirm": {
                this.loadCheckinList("hom_waitconfirm", "waitconfirmflex", CheckinStatusEnum.CHECKIN_WAIT_CONFIRM.toString(), null);
                break;
            }
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.tabInit();
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab(((Control)tab.getItems().get(1)).getKey());
    }

    private void loadCheckinList(String sourceFormId, String tabLabelName, String checkinStatus, String enrollStatus) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(sourceFormId);
        listShowParameter.getOpenStyle().setTargetKey(tabLabelName);
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.setCustomParam("checkinstatus", (Object)checkinStatus);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        if (HRStringUtils.isNotEmpty((String)enrollStatus)) {
            QFilter enrollStatusFilter = new QFilter("enrollstatus", "=", (Object)enrollStatus);
            QFilter checkinStatusFilter = new QFilter("checkinstatus", "!=", (Object)SPACE_VALUE);
            listFilterParameter.getQFilters().add(enrollStatusFilter);
            listFilterParameter.getQFilters().add(checkinStatusFilter);
        } else {
            QFilter checkinStatusFilter;
            if (HRStringUtils.isNotEmpty((String)checkinStatus)) {
                checkinStatusFilter = new QFilter("checkinstatus", "=", (Object)checkinStatus);
                listFilterParameter.getQFilters().add(new QFilter("enrollstatus", "!=", (Object)OnbrdStatusEnum.BREAK_UP.toString()));
                if (CheckinStatusEnum.WAIT_CHECKIN.getValue().equals(enrollStatus)) {
                    checkinStatusFilter.and(new QFilter("enrollstatus", "!=", (Object)OnbrdStatusEnum.HAS_ONBRD.getValue()));
                }
            } else {
                checkinStatusFilter = new QFilter("checkinstatus", "!=", (Object)SPACE_VALUE);
            }
            listFilterParameter.getQFilters().add(checkinStatusFilter);
        }
        listShowParameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)listShowParameter);
        IFormView listView = this.getView().getView(listShowParameter.getPageId());
        if (null != listView) {
            this.getView().sendFormAction(listView);
        }
    }

    private void tabInit() {
        Long userId = RequestContext.get().getCurrUserId();
        Object obj = HomAppConfigUtil.getHomAppParam((String)"checkinconfirm");
        LOGGER.info("OnbrdCheckinBillListPlugin_tabInit:{}", obj);
        boolean isOpen = obj != null && (Boolean)obj != false;
        QFilter qFilter = new QFilter("checkinins.handlers.fbasedataid", "=", (Object)userId);
        QFilter statusFilter = new QFilter("checkinstatus", "=", (Object)CheckinStatusEnum.CHECKIN_WAIT_CONFIRM.getValue());
        QFilter[] filters = new QFilter[]{qFilter, statusFilter};
        int count = IOnbrdBillDomainService.getInstance().getCount(filters);
        LOGGER.info("OnbrdCheckinBillListPlugin_tabInit_count:{}", (Object)count);
        if (!isOpen && count <= 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"waitconfirm"});
        }
    }
}

