/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.cooperation;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hom.business.application.impl.onbrd.OnbrdWorkTableServiceImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdWorkTableService;
import kd.hr.hom.common.enums.ActivityStatusEnum;

public class CooperationBillListPlugin
extends HRDataBaseList
implements TabSelectListener {
    private static final String ACTIVITYINS_TASKSTATUS = "activityins.taskstatus";
    private static final IOnbrdWorkTableService workTableService = new OnbrdWorkTableServiceImpl();

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String key = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if (HRStringUtils.isEmpty((String)key)) {
            this.loadAllCooperationList();
            return;
        }
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab("all");
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey;
        switch (tabKey = tabSelectEvent.getTabKey()) {
            case "all": {
                this.loadAllCooperationList();
                break;
            }
            case "processing": {
                this.loadAllProcessingList();
                break;
            }
            case "overruled": {
                this.loadAllOverruledList();
                break;
            }
            case "done": {
                this.loadAllDoneList();
                break;
            }
            case "breakup": {
                this.loadAllBreakUpList();
                break;
            }
        }
    }

    private void loadAllCooperationList() {
        this.loadCooperationManageList("hom_collaborationalllist", "alllist", "all", null);
    }

    private void loadAllProcessingList() {
        this.loadCooperationManageList("hom_collaborationplist", "processinglist", ActivityStatusEnum.PROCESSING.getValue(), new QFilter(ACTIVITYINS_TASKSTATUS, "=", (Object)ActivityStatusEnum.PROCESSING.getValue()));
    }

    private void loadAllOverruledList() {
        this.loadCooperationManageList("hom_collaborationoverlist", "overruledlist", ActivityStatusEnum.REJECTED.getValue(), new QFilter(ACTIVITYINS_TASKSTATUS, "=", (Object)ActivityStatusEnum.REJECTED.getValue()));
    }

    private void loadAllDoneList() {
        this.loadCooperationManageList("hom_collaborationdonelist", "donelist", ActivityStatusEnum.COMPLETED.getValue(), new QFilter(ACTIVITYINS_TASKSTATUS, "=", (Object)ActivityStatusEnum.COMPLETED.getValue()));
    }

    private void loadAllBreakUpList() {
        this.loadCooperationManageList("hom_collaborationbreakup", "breakuplist", ActivityStatusEnum.TERMINATED.getValue(), new QFilter(ACTIVITYINS_TASKSTATUS, "=", (Object)ActivityStatusEnum.TERMINATED.getValue()));
    }

    private void loadCooperationManageList(String sourceFormId, String tabLabelName, String activeStatus, QFilter qFilter) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(sourceFormId);
        listShowParameter.getOpenStyle().setTargetKey(tabLabelName);
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.setCustomParam("status", (Object)activeStatus);
        String key = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if (!ObjectUtils.isEmpty((Object)this.getView().getParentView()) && !HRStringUtils.isEmpty((String)key)) {
            HRPageCache pageCache = new HRPageCache(this.getView().getParentView().getParentView());
            Map<String, Object> map = this.getStringObjectMap(pageCache);
            listShowParameter.setCustomParam("hrbuids", map.get("hrbuids"));
            listShowParameter.setCustomParam("adminorgids", map.get("adminorgids"));
        }
        String workTableInit = this.getView().getPageCache().get("is_init");
        if (!HRStringUtils.isEmpty((String)key) && workTableInit == null) {
            listShowParameter.setCustomParam("type", (Object)key);
            this.getView().getPageCache().put("is_init", "is_init");
        }
        if (!Objects.isNull(qFilter)) {
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            listFilterParameter.getQFilters().add(qFilter);
            listShowParameter.setListFilterParameter(listFilterParameter);
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
        IFormView listView = this.getView().getView(listShowParameter.getPageId());
        if (null != listView) {
            this.getView().sendFormAction(listView);
        }
    }

    private Map<String, Object> getStringObjectMap(HRPageCache pageCache) {
        return workTableService.getStringObjectMap(pageCache);
    }
}

