/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.invite;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.activity.IActivityCommonInfoService;
import kd.hr.hom.business.domain.service.common.IPreOpenFormCheckService;
import kd.hr.hom.business.domain.service.invite.IOnbrdInviteDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.LoginStatusEnum;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;
import kd.hr.hom.common.enums.SendStatusEnum;
import kd.hr.hom.formplugin.common.InviteHelper;

public class InviteSendBillPlugin
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(InviteSendBillPlugin.class);
    private static final String ONBRDINVITEHEAD = "onbrdinvitehead";
    private static final String SEND_INVITE = "sendinvite";
    private static final String REMIND_LOGIN = "remindlogin";

    public void preOpenForm(PreOpenFormEventArgs e) {
        boolean isEnroll;
        super.preOpenForm(e);
        IPreOpenFormCheckService.getInstance().isHandlerCheck(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        Long pkId = HRJSONUtils.getLongValOfCustomParam((Object)((BillShowParameter)formShowParameter).getPkId());
        LOG.info("InviteSendBillPlugin.preOpenForm pkId:", (Object)pkId);
        DynamicObject dynamicObject = HomCommonRepository.queryDynamicObjectByPk((String)"hom_invitesendbill", (String)"onbrd.id,onbrd.name", (Object)pkId);
        formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"\u5165\u804c\u9080\u7ea6-%s", (String)"InviteSendBillPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), dynamicObject.getString("onbrd.name")));
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("onbrdid"));
        if (onbrdId == null) {
            onbrdId = dynamicObject.getLong("onbrd.id");
        }
        if (isEnroll = IOnbrdBillDomainService.getInstance().isEnrolled(onbrdId)) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Long onbrdId = this.getOnbrdId(this.getView());
        this.showPersonHeadView(onbrdId);
    }

    public void beforeBindData(EventObject evt) {
        Long pkId = IActivityCommonInfoService.getInstance().getId(this.getView());
        BillList list = (BillList)this.getControl("billlistap");
        FilterParameter filterParameter = new FilterParameter();
        QFilter filter = new QFilter("inductioninvite", "=", (Object)pkId);
        filterParameter.setFilter(filter);
        list.setQueryFilterParameter(filterParameter);
        Long onbrdId = this.getOnbrdId(this.getView());
        IOnbrdBillDomainService.getInstance().generateViewForEnrollStatus(onbrdId, this.getView(), new String[]{SEND_INVITE, REMIND_LOGIN});
    }

    private void showPersonHeadView(Long onbrdId) {
        Long pkId = IActivityCommonInfoService.getInstance().getId(this.getView());
        DynamicObject dynamicObject = HomCommonRepository.queryDynamicObjectByPk((String)"hom_invitesendbill", (String)"sendstatus,loginstatus", (Object)pkId);
        if (dynamicObject == null) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(ONBRDINVITEHEAD);
        formShowParameter.setCustomParam("id", (Object)onbrdId);
        formShowParameter.setCustomParam("sendstatus", (Object)dynamicObject.getString("sendstatus"));
        String sendStatus = dynamicObject.getString("sendstatus");
        Long activityId = ActivityNumberEnum.INDUCTIONINVITATION.getId();
        formShowParameter.setCustomParam("activity.id", (Object)activityId);
        formShowParameter.setFormId("hom_onbrdactivityhead");
        formShowParameter.setSendToClient(true);
        SendStatusEnum sendStatusEnum = SendStatusEnum.getEnumByValue((String)sendStatus);
        formShowParameter.setCustomParam("activitystatusdesc", (Object)sendStatusEnum.getDesc());
        formShowParameter.setCustomParam("statusNumber", (Object)sendStatusEnum.getStatusNumber());
        this.getView().showForm(formShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)resultValue) && "sendinvitesingle".equals(actionId)) {
            DynamicObject inviteSendBillObj = this.getModel().getDataEntity();
            InviteHelper.updateInviteDatas(new DynamicObject[]{inviteSendBillObj});
            InviteHelper.sendShortAndEmail(inviteSendBillObj);
            InviteHelper.closeOrRefreshPage(this.getView());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (REMIND_LOGIN.equals(operateKey)) {
            DynamicObject inviteSendBillObj = this.getView().getModel().getDataEntity();
            String sendStatus = inviteSendBillObj.getString("sendstatus");
            if (SendStatusEnum.WAIT_SEND.getValue().equals(sendStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u64cd\u4f5c\u201c\u53d1\u9001\u9080\u7ea6\u201d\u3002", (String)"OnbrdInviteOperateListPlugin_23", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (!HRObjectUtils.isEmpty((Object)afterDoOperationEventArgs.getOperationResult()) && !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        DynamicObject inviteSendBillObj = this.getView().getModel().getDataEntity();
        DynamicObject onbrdObj = inviteSendBillObj.getDynamicObject("onbrd");
        switch (operateKey) {
            case "sendinvite": {
                if (!InviteHelper.sendInviteOne(inviteSendBillObj, this.getView())) {
                    return;
                }
                this.saveData();
                String sendstatus = (String)this.getModel().getValue("sendstatus");
                if (SendStatusEnum.WAIT_SEND.getValue().equals(sendstatus)) {
                    InviteHelper.sendInvite(onbrdObj, inviteSendBillObj, this.getView(), false);
                    break;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u5411\u8be5\u5165\u804c\u5458\u5de5\u53d1\u9001\u8fc7\u5165\u804c\u6b22\u8fce\u4fe1\uff0c\u8bf7\u786e\u8ba4\u518d\u6b21\u53d1\u9001\uff1f", (String)"OnbrdInviteOperateListPlugin_20", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("sendinvitesingle", (IFormPlugin)this));
                break;
            }
            case "remindlogin": {
                if (IOnbrdInviteDomainService.getInstance().isEndOnbrd(inviteSendBillObj)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5f85\u5165\u804c\u4eba\u5458\u5df2\u5165\u804c/\u5df2\u7ec8\u6b62\u5165\u804c\uff0c\u4e0d\u53ef\u53d1\u9001\u5165\u804c\u9080\u7ea6\u3002", (String)"OnbrdInviteOperateListPlugin_11", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.saveData();
                String loginStatus = inviteSendBillObj.getString("loginstatus");
                if (LoginStatusEnum.HAS_LOGIN.getValue().equals(loginStatus)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5f85\u5165\u804c\u4eba\u5458\u5df2\u5b8c\u6210\u5165\u804c\u670d\u52a1\u5e73\u53f0\u767b\u5f55\uff0c\u65e0\u9700\u53d1\u9001\u767b\u5f55\u63d0\u9192\u6d88\u606f\u3002", (String)"OnbrdInviteOperateListPlugin_14", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject onbrdBillByIdDy = HomCommonRepository.queryDynamicObjectByPk((String)"hom_onbrdbilltpl", (String)"", (Object)onbrdObj.getLong("id"));
                Map resultMap = IOnbrdInviteDomainService.getInstance().sendShortInfo(onbrdBillByIdDy, RuleEngineSceneNumberEnum.LOGIN_REMIND_MESSAGE);
                if (Boolean.TRUE.equals(resultMap.get("success"))) {
                    IOnbrdInviteDomainService.getInstance().updateRemindInfo(inviteSendBillObj, this.getView());
                    this.getView().updateView();
                    break;
                }
                this.getView().showErrorNotification(String.valueOf(resultMap.get("message")));
                break;
            }
            case "save": {
                DynamicObject loginschemeObj = (DynamicObject)this.getModel().getValue("loginscheme");
                if (loginschemeObj != null) {
                    long onbrdbillId = onbrdObj.getLong("id");
                    HashMap onbrdLoginConfigIdMap = Maps.newHashMapWithExpectedSize((int)1);
                    onbrdLoginConfigIdMap.put(onbrdbillId, loginschemeObj.getLong("id"));
                    IOnbrdCommonAppService.getInstance().saveOnbrdLoginConfig(Long.valueOf(onbrdbillId), (Map)onbrdLoginConfigIdMap);
                }
                this.getView().updateView();
                break;
            }
        }
    }

    private void saveData() {
        if (!"VIEW".equals(this.getView().getFormShowParameter().getStatus().name())) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()});
            DynamicObject loginschemeObj = (DynamicObject)this.getModel().getValue("loginscheme");
            if (loginschemeObj != null) {
                DynamicObject inviteSendBillObj = this.getModel().getDataEntity();
                DynamicObject onbrdObj = inviteSendBillObj.getDynamicObject("onbrd");
                long onbrdbillId = onbrdObj.getLong("id");
                HashMap onbrdLoginConfigIdMap = Maps.newHashMapWithExpectedSize((int)1);
                onbrdLoginConfigIdMap.put(onbrdbillId, loginschemeObj.getLong("id"));
                String url = IOnbrdCommonAppService.getInstance().saveOnbrdLoginConfig(Long.valueOf(onbrdbillId), (Map)onbrdLoginConfigIdMap);
                if (StringUtils.isNotBlank((CharSequence)url)) {
                    onbrdObj.set("url", (Object)url);
                }
            }
        }
    }

    private Long getOnbrdId(IFormView view) {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)view.getFormShowParameter().getCustomParam("onbrdid"));
        if (onbrdId == null) {
            onbrdId = view.getModel().getDataEntity().getLong("onbrd.id");
        }
        LOG.info("InviteSendBillPlugin.getOnbrdId :", (Object)onbrdId);
        return onbrdId;
    }
}

