/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.invite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;

public class OnbrdInviteConfirmEdit
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(OnbrdInviteConfirmEdit.class);
    private static final String BTN_CONFIRM = "btn_confirm";
    private static final String EXPORT_EXCEL = "exportexcel";
    private static final String FLOWPERSONID = "flowpersonid";
    private static final String WAITSENDID = "waitsendid";
    private static final String ISEXCLUDEHASSEND = "isexcludehassend";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_CONFIRM, EXPORT_EXCEL});
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        IFormView formView = this.getView();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        Label allPersonLabel = (Label)formView.getControl("allperson");
        int allPersonCount = (Integer)formShowParameter.getCustomParam("allperson");
        allPersonLabel.setText(String.valueOf(allPersonCount));
        Label sendPersonLabel = (Label)formView.getControl("sendperson");
        int sendPersonCount = (Integer)formShowParameter.getCustomParam("sendperson");
        sendPersonLabel.setText(String.valueOf(sendPersonCount));
        Label flowPersonLabel = (Label)formView.getControl("flowperson");
        int flowPersonCount = (Integer)formShowParameter.getCustomParam("flowperson");
        flowPersonLabel.setText(String.valueOf(flowPersonCount));
        Label endPersonLabel = (Label)formView.getControl("endperson");
        int endPersonCount = (Integer)formShowParameter.getCustomParam("endperson");
        endPersonLabel.setText(String.valueOf(endPersonCount));
        Label noFitPersonLabel = (Label)formView.getControl("nofitperson");
        int noFitPerson = (Integer)formShowParameter.getCustomParam("nofitperson");
        noFitPersonLabel.setText(String.valueOf(noFitPerson));
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Control) {
            Control control = (Control)evt.getSource();
            switch (control.getKey()) {
                case "btn_confirm": {
                    IOnbrdCommonAppService onbrdCommonAppService = IOnbrdCommonAppService.getInstance();
                    if (!onbrdCommonAppService.checkPermissionAndShowTips("hom_onbrdinvite", "25S0ARLJONHL", this.getView())) {
                        return;
                    }
                    IFormView formView = this.getView();
                    FormShowParameter formShowParameter = formView.getFormShowParameter();
                    HashMap<String, Object> dataMap = new HashMap<String, Object>(6);
                    dataMap.put("sendperson", formShowParameter.getCustomParam("sendperson"));
                    dataMap.put(FLOWPERSONID, formShowParameter.getCustomParam(FLOWPERSONID));
                    dataMap.put(WAITSENDID, formShowParameter.getCustomParam(WAITSENDID));
                    dataMap.put(ISEXCLUDEHASSEND, this.getModel().getValue(ISEXCLUDEHASSEND));
                    formView.returnDataToParent(dataMap);
                    formView.close();
                    break;
                }
                case "exportexcel": {
                    this.exportExcel();
                    break;
                }
            }
        }
    }

    private void exportExcel() {
        String excelName = (String)this.getView().getFormShowParameter().getCustomParam("excelname");
        List exportDataList = (List)this.getView().getFormShowParameter().getCustomParam("exportdatalist");
        List headDataLst = new ArrayList();
        try {
            headDataLst = (List)HRJSONUtils.cast((String)this.getView().getFormShowParameter().getCustomParam("headdatalist").toString(), List.class, (Class[])new Class[]{HRExportHeadObject.class});
        }
        catch (IOException iOException) {
            logger.error((Throwable)iOException);
            this.getView().showErrMessage(iOException.getMessage(), " Fail to cast json ! Reason: ");
        }
        String exportUrl = null;
        try {
            exportUrl = HRExportDataHelper.getExportExcelUrl((String)excelName, (List)exportDataList, headDataLst);
        }
        catch (IOException iOException) {
            logger.error((Throwable)iOException);
            this.getView().showErrMessage(iOException.getMessage(), " Fail to get export Excel url ! Reason: ");
        }
        if (!HRStringUtils.isEmpty((String)exportUrl)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)exportUrl);
        }
    }
}

