/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.application.common.ReentryRuleService;
import kd.hr.hom.business.application.hbpm.IHrmpExternalService;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.hr.hom.business.application.mobile.IMobCommonAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.onbrd.IValidEntryDateService;
import kd.hr.hom.business.application.onbrd.OnbrdAgainRuleUtils;
import kd.hr.hom.business.application.utils.RuleCodeUtils;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.base.IHomConfigDomainService;
import kd.hr.hom.common.enums.AgainCheckResultsEnum;
import kd.hr.hom.common.enums.EmployeeNoSchemeEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.ServiceAgeSchemeEnum;
import kd.hr.hom.common.enums.ViewTypeEnum;
import kd.hr.hom.common.util.UpdateControlUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class AgainOnbrdInfoEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String FS_AGAINCONTISCHEME = "fs_againcontischeme";
    public static final String EMPLOYEENO_CONNECTION_SWITCH = "employeeno_connection_switch";
    private static final Log LOGGER = LogFactory.getLog(AgainOnbrdInfoEdit.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Button startschema = (Button)this.getView().getControl("startschema");
        startschema.addClickListener((ClickListener)this);
        BasedataEdit personFieldEdit = (BasedataEdit)this.getView().getControl("personfield");
        personFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        String viewType = (String)this.getView().getFormShowParameter().getCustomParam("viewtype");
        if (StringUtils.isBlank((CharSequence)viewType)) {
            viewType = ViewTypeEnum.ROUTINE.getCode();
        }
        this.getModel().setValue("viewtype", (Object)viewType);
        if (!ViewTypeEnum.AGAIN.getCode().equals(viewType)) {
            return;
        }
        Long pid = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("personindexid"));
        String pidData = (String)this.getView().getFormShowParameter().getCustomParam("piddata");
        if (pidData != null) {
            DynamicObject dynamicObject = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)pidData);
            if (dynamicObject.get("org") != null) {
                this.getModel().setValue("org", dynamicObject.get("org"));
            }
            if (pid != null && pid != 0L) {
                this.getModel().setValue("name", dynamicObject.get("name"));
                this.getModel().setValue("oemployeeno", dynamicObject.get("oemployeeno"));
                this.getModel().setValue("phone", dynamicObject.get("phone"));
                this.getModel().setValue("gender", dynamicObject.get("gender"));
                this.getModel().setValue("personindexid", dynamicObject.get("personindexid"));
                this.getModel().setValue("personfield", dynamicObject.get("personfield"));
                this.getHrpiInfoOfPersonField(this.getModel().getDataEntity().getDynamicObject("personfield"));
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        LOGGER.info("AgainOnbrdInfoEdit.afterLoadData,status:{}", (Object)this.getView().getFormShowParameter().getStatus());
        this.setBermanfile();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        IFormView view = parentView != null ? parentView : this.getView();
        String changeBErmanfile = (String)view.getFormShowParameter().getCustomParam("change_b_ermanfile");
        LOGGER.info("AgainOnbrdInfoEdit.afterBindData,changeBErmanfile:{}", (Object)changeBErmanfile);
        if ("1".equals(changeBErmanfile)) {
            this.setBermanfile();
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.getModel().beginInit();
        DynamicObject onbrdBill = this.getModel().getDataEntity();
        String viewType = onbrdBill.getString("viewtype");
        this.getView().setVisible(Boolean.FALSE, new String[]{"oemployeeno"});
        if (ViewTypeEnum.AGAIN.getCode().equals(viewType)) {
            IFormView parentView = this.getView().getParentView();
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (OperationStatus.ADDNEW.equals((Object)status) || OperationStatus.EDIT.equals((Object)status)) {
                this.addAndEditTip(onbrdBill, parentView, status);
            }
            String enrollstatus = onbrdBill.getString("enrollstatus");
            if (OnbrdStatusEnum.BREAK_UP.getValue().equals(enrollstatus) || OnbrdStatusEnum.HAS_ONBRD.getValue().equals(enrollstatus)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"startschemaflex"});
            }
            this.putValueInCache(onbrdBill);
            this.getView().setVisible(Boolean.FALSE, new String[]{"name", "employeeno", "oldemployeeno"});
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"personfield", "employeenoscheme", "serviceagescheme"}, (boolean)true);
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"name"}, (boolean)false);
            this.dealNumberSwitch(onbrdBill);
            this.dealScSwitch();
            this.dealAtSwitch();
            this.dealCspSwitch();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"personfield", FS_AGAINCONTISCHEME});
        }
        this.getModel().endInit();
        this.getModel().setDataChanged(false);
    }

    private void dealCspSwitch() {
        String cspSwitch = ((IHomConfigDomainService)ServiceFactory.getService(IHomConfigDomainService.class)).getConfig(this.getView(), "connection_scheme_panel_switch", "connection_scheme_panel_switch");
        if (!"true".equals(cspSwitch)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FS_AGAINCONTISCHEME});
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"employeenoscheme", "oldemployeeno", "serviceagescheme", "automaticinfo"});
    }

    private void dealAtSwitch() {
        String atSwitch = ((IHomConfigDomainService)ServiceFactory.getService(IHomConfigDomainService.class)).getConfig(this.getView(), "automaticinfo_switch", "automaticinfo_switch");
        if ("true".equals(atSwitch)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"automaticinfo"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"automaticinfo"});
        }
    }

    private void dealScSwitch() {
        String scSwitch = ((IHomConfigDomainService)ServiceFactory.getService(IHomConfigDomainService.class)).getConfig(this.getView(), "seniority_connection_switch", "seniority_connection_switch");
        if (!"true".equals(scSwitch)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"serviceagescheme"});
            this.getModel().setValue("serviceagescheme", StringUtils.isBlank((Object)this.getModel().getValue("serviceagescheme")) ? ServiceAgeSchemeEnum.RECALCULATE.getValue() : this.getModel().getValue("serviceagescheme"));
        }
    }

    private void dealNumberSwitch(DynamicObject onbrdBill) {
        String ecSwitch = ((IHomConfigDomainService)ServiceFactory.getService(IHomConfigDomainService.class)).getConfig(this.getView(), EMPLOYEENO_CONNECTION_SWITCH, EMPLOYEENO_CONNECTION_SWITCH);
        if ("true".equals(ecSwitch)) {
            if (HRStringUtils.equals((String)onbrdBill.getString("employeenoscheme"), (String)EmployeeNoSchemeEnum.NEW_EMPLOYEE_NO.getValue())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"oldemployeeno"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"newemployeeno"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"newemployeeno"});
            }
            this.getModel().setValue("newemployeeno", this.getModel().getValue("employeeno"));
            this.getModel().setValue("oldemployeeno", this.getModel().getValue("oemployeeno"));
            this.getView().setVisible(Boolean.FALSE, new String[]{"employeeno"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"employeenoscheme", "oldemployeeno", "newemployeeno"});
            this.getModel().setValue("employeenoscheme", StringUtils.isBlank((Object)this.getModel().getValue("employeenoscheme")) ? EmployeeNoSchemeEnum.NEW_EMPLOYEE_NO.getValue() : this.getModel().getValue("employeenoscheme"));
            this.getView().setVisible(Boolean.TRUE, new String[]{"employeeno", "oemployeeno"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"oemployeeno"});
        }
    }

    private void addAndEditTip(DynamicObject onbrdBill, IFormView parentView, OperationStatus status) {
        if (parentView != null && "hom_persononbrdhandlebody".equals(parentView.getFormShowParameter().getFormId())) {
            parentView.getPageCache().put("againcheckresults", onbrdBill.getString("againcheckresults"));
            Boolean routineSkip = (Boolean)this.getView().getFormShowParameter().getCustomParam("routine_skip");
            if (Boolean.TRUE.equals(routineSkip)) {
                IMobCommonAppService.getInstance().getTipByHRCS(parentView, Long.valueOf(1576924661738921984L), "warnhtmlap");
                parentView.setVisible(Boolean.TRUE, new String[]{"warnflexpanelap"});
                this.routineSkipOpenModal();
            } else {
                IMobCommonAppService.getInstance().getTipByHRCS(parentView, Long.valueOf(1566578302267842560L), "tiphtmlap");
                if (OperationStatus.ADDNEW.equals((Object)status)) {
                    parentView.setVisible(Boolean.TRUE, new String[]{"tipflexpanelap"});
                }
            }
            String tipByHRCS = IMobCommonAppService.getInstance().getTipByHRCS(parentView, Long.valueOf(1593633815979461632L), null);
            Label labelap1 = (Label)parentView.getControl("labelap1");
            labelap1.setText(tipByHRCS);
            String tipByHRCS1 = IMobCommonAppService.getInstance().getTipByHRCS(parentView, Long.valueOf(1645009647679232000L), null);
            Label labelap2 = (Label)parentView.getControl("labelap21");
            labelap2.setText(tipByHRCS1);
            this.getView().sendFormAction(parentView);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        DynamicObject onbrdBill = this.getModel().getDataEntity();
        String viewType = onbrdBill.getString("viewtype");
        if (!ViewTypeEnum.AGAIN.getCode().equals(viewType)) {
            return;
        }
        Object newVal = args.getChangeSet()[0].getNewValue();
        String name = args.getProperty().getName();
        HashMap propertyChangedMap = Maps.newHashMapWithExpectedSize((int)4);
        propertyChangedMap.put("personfield", this::changePersonField);
        propertyChangedMap.put("isprobation", () -> this.changeIsprobation((Boolean)newVal));
        propertyChangedMap.put("employeenoscheme", () -> this.caseWhenEmpScheme(newVal));
        propertyChangedMap.put("newemployeeno", () -> this.changeNewEmployeeNo(onbrdBill, newVal));
        propertyChangedMap.put("effectdate", () -> this.entryDate());
        propertyChangedMap.getOrDefault(name, () -> {}).run();
    }

    private void entryDate() {
        IValidEntryDateService.getInstance().validEntryDateByPropertyChanged(this.getView());
    }

    private void changeNewEmployeeNo(DynamicObject onbrdBill, Object newVal) {
        String empScheme = onbrdBill.getString("employeenoscheme");
        if (!HRStringUtils.equals((String)empScheme, (String)EmployeeNoSchemeEnum.NEW_EMPLOYEE_NO.getValue())) {
            return;
        }
        String oldNumber = onbrdBill.getString("oldemployeeno");
        if (StringUtils.isNotBlank((CharSequence)oldNumber) && HRStringUtils.equals((String)(newVal + ""), (String)oldNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u5de5\u53f7\u4e0d\u5141\u8bb8\u4e0e\u539f\u5de5\u53f7\u76f8\u540c\u3002", (String)"ReservationOnbrdPlugin_7", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("employeeno", (Object)"");
            this.getModel().setValue("newemployeeno", (Object)"");
        } else {
            this.getModel().setValue("employeeno", newVal);
        }
    }

    private void changeIsprobation(Boolean newVal) {
        Boolean isProbation = newVal;
        if (Boolean.TRUE.equals(isProbation)) {
            this.openModal();
        }
    }

    private void changePersonField() {
        IDataModel model = this.getModel();
        Object personField = model.getValue("personfield");
        if (HRObjectUtils.isEmpty((Object)personField)) {
            this.clearSchemeData();
            return;
        }
        if (personField instanceof DynamicObject) {
            this.clearSchemeData();
            this.getHrpiInfoOfPersonField((DynamicObject)personField);
            DynamicObject lastFile = ReentryRuleService.getInstance().getLastFile(this.getModel().getDataEntity());
            if (lastFile != null) {
                String oldNumber = lastFile.getString("number");
                this.getModel().setValue("oldemployeeno", (Object)oldNumber);
                if (EmployeeNoSchemeEnum.OLD_EMPLOYEE_NO.getValue().equals(this.getModel().getValue("employeenoscheme"))) {
                    this.getModel().setValue("oemployeeno", (Object)oldNumber);
                }
            }
            this.setBermanfile();
            this.changeF7Name();
            IValidEntryDateService.getInstance().validEntryDateByPropertyChanged(this.getView());
        }
    }

    private void getHrpiInfoOfPersonField(DynamicObject personField) {
        this.getModel().setValue("name", (Object)personField.getString("person.name"));
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)3);
        paramsMap.put("searchType", new ArrayList(ImmutableList.of((Object)"001", (Object)"003", (Object)"007")));
        paramsMap.put("identifyIdType", "EMPID");
        String personFieldId = personField.getString("id");
        paramsMap.put("identifyId", ImmutableList.of((Object)personFieldId));
        Map resultMaps = IHomToHrpiAppService.getInstance().queryEmployeeInfo((Map)paramsMap);
        if (MapUtils.isEmpty((Map)resultMaps)) {
            return;
        }
        Map resultMap = (Map)resultMaps.get(personFieldId);
        if (MapUtils.isEmpty((Map)resultMap)) {
            return;
        }
        Map<String, Object> hrpiPernontspropMap = this.getObjectToMap(resultMap, "hrpi_pernontsprop");
        Map<String, Object> hrpiPercreMap = this.getObjectToMap(resultMap, "hrpi_percre");
        Map<String, Object> hrpiPercontactMap = this.getObjectToMap(resultMap, "hrpi_percontact");
        this.setEnableValue(hrpiPernontspropMap, "gender_id", "hbss_sex", "gender");
        if (EmployeeNoSchemeEnum.OLD_EMPLOYEE_NO.getValue().equals(this.getModel().getValue("employeenoscheme"))) {
            this.getModel().setValue("employeeno", (Object)resultMap.getOrDefault("empnumber", ""));
        }
        this.getModel().setValue("oemployeeno", (Object)resultMap.getOrDefault("empnumber", ""));
        this.getModel().setValue("certificatetype", (Object)0L);
        this.getModel().setValue("certificatenumber", (Object)"");
        this.setEnableValue(hrpiPercreMap, "credentialstype_id", "hbss_credentialstype", "certificatetype");
        this.getModel().setValue("certificatenumber", hrpiPercreMap.getOrDefault("number", ""));
        this.getModel().setValue("phone", hrpiPercontactMap.getOrDefault("phone", ""));
        this.getModel().setValue("peremail", hrpiPercontactMap.getOrDefault("peremail", ""));
        this.setEnableValue(hrpiPernontspropMap, "nationality_id", "hbss_nationality", "nationality");
        this.getModel().setValue("picturefield", hrpiPernontspropMap.getOrDefault("headsculpture", ""));
    }

    private void setEnableValue(Map<String, Object> map, String key, String entityName, String realKey) {
        Object value = map.getOrDefault(key, 0L);
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)2);
        qFilters.add(new QFilter("id", "=", value));
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        boolean flag = HomCommonRepository.isExists((String)entityName, (QFilter[])qFilters.toArray(new QFilter[0]));
        if (flag) {
            this.getModel().setValue(realKey, value);
        }
    }

    private Map<String, Object> getObjectToMap(Map<String, Object> resultMap, String key) {
        List valueList;
        Map finalResultMap = Maps.newHashMapWithExpectedSize((int)16);
        Object value = resultMap.get(key);
        if (value instanceof ArrayList && CollectionUtils.isNotEmpty((Collection)(valueList = (List)resultMap.get(key)))) {
            finalResultMap = (Map)valueList.get(0);
        }
        return finalResultMap;
    }

    private void clearSchemeData() {
        this.getModel().setValue("oldemployeeno", null);
        this.getModel().setValue("employeenoscheme", null);
        this.getModel().setValue("newemployeeno", null);
        this.getModel().setValue("serviceagescheme", null);
        this.getView().setEnable(Boolean.FALSE, new String[]{"employeenoscheme", "oldemployeeno", "serviceagescheme", "automaticinfo"});
    }

    private Optional<String> changeF7Name() {
        return IOnbrdCommonAppService.getInstance().validateF7Name(this.getView());
    }

    private void caseWhenEmpScheme(Object newVal) {
        if (this.getView().getModel().getValue("personfield") instanceof DynamicObject) {
            DynamicObject lastFile = ReentryRuleService.getInstance().getLastFile(this.getModel().getDataEntity());
            if (lastFile == null) {
                return;
            }
            String oldNumber = lastFile.getString("number");
            this.getModel().setValue("oldemployeeno", (Object)oldNumber);
            this.getModel().setValue("oemployeeno", (Object)oldNumber);
            String newValue = newVal + "";
            if (HRStringUtils.equals((String)newValue, (String)EmployeeNoSchemeEnum.OLD_EMPLOYEE_NO.getValue())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"oldemployeeno"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"newemployeeno"});
                this.getModel().setValue("newemployeeno", (Object)oldNumber);
                this.getModel().setValue("employeeno", (Object)"");
            } else if (HRStringUtils.equals((String)newValue, (String)EmployeeNoSchemeEnum.NEW_EMPLOYEE_NO.getValue())) {
                this.getModel().setValue("newemployeeno", (Object)"");
                this.getView().setVisible(Boolean.TRUE, new String[]{"newemployeeno", "oldemployeeno"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"newemployeeno"});
                String newNumberCache = this.getPageCache().get("newemployeeno");
                if (!HRStringUtils.isEmpty((String)newNumberCache)) {
                    this.getModel().setValue("newemployeeno", (Object)newNumberCache);
                    this.getModel().setValue("employeeno", (Object)newNumberCache);
                } else {
                    String tipByHRCS = IMobCommonAppService.getInstance().getTipByHRCS(null, Long.valueOf(1652273215520792576L), null);
                    this.getView().showTipNotification(tipByHRCS);
                }
            }
        }
    }

    private void openModal() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hom_rechecktips");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void routineSkipOpenModal() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hom_routineskiptip");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void genCode() {
        String newNumberCache = this.getPageCache().get("newemployeeno");
        Boolean ecSwitch = Boolean.valueOf(this.getPageCache().get(EMPLOYEENO_CONNECTION_SWITCH));
        if (HRStringUtils.isEmpty((String)newNumberCache)) {
            DynamicObject data = this.getModel().getDataEntity();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hom_employeeno");
            HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hom_onbrdbillbase");
            DynamicObject dy = serviceHelper.generateEmptyDynamicObject();
            DynamicObject baseDy = baseServiceHelper.generateEmptyDynamicObject();
            baseDy.set("laborreltype", data.get("laborreltype"));
            dy.set("onbrdbill", (Object)baseDy);
            ArrayList numberList = new ArrayList(1);
            RuleCodeUtils.codeRuleHandler((DynamicObject)dy, numberList, (int)1, (int)1);
            if (!numberList.isEmpty()) {
                String newNumber = (String)numberList.get(0);
                if (Boolean.FALSE.equals(ecSwitch)) {
                    this.getModel().setValue("employeeno", (Object)newNumber);
                }
                this.getPageCache().put("newemployeeno", newNumber);
            }
        } else if (Boolean.FALSE.equals(ecSwitch)) {
            this.getModel().setValue("employeeno", (Object)newNumberCache);
        } else if (HRStringUtils.equals((String)this.getModel().getDataEntity().getString("employeenoscheme"), (String)EmployeeNoSchemeEnum.NEW_EMPLOYEE_NO.getValue())) {
            this.getModel().setValue("newemployeeno", (Object)newNumberCache);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        DynamicObject data = this.getModel().getDataEntity();
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("startschema".equals(key)) {
            this.initTipsTool();
            if (!OnbrdAgainRuleUtils.checkParam((IFormView)this.getView(), (DynamicObject)data)) {
                return;
            }
            this.genCode();
            Map inputParams = ReentryRuleService.getInstance().getInputParams(data);
            String enrollStatus = data.getString("enrollstatus");
            if (!HRStringUtils.equals((String)enrollStatus, (String)OnbrdStatusEnum.WAIT_ONBRD.getValue())) {
                String checkResult = OnbrdAgainRuleUtils.reentryLureCheck((Map)inputParams, (IFormView)this.getView(), (DynamicObject)this.getModel().getDataEntity());
                this.getModel().setValue("againcheckresults", (Object)checkResult);
                this.getView().getParentView().getPageCache().put("againcheckresults", checkResult);
                if (AgainCheckResultsEnum.PROHIBIT.getCode().equals(checkResult)) {
                    return;
                }
            }
            OnbrdAgainRuleUtils.reentryCheckHandle((Map)inputParams, (IFormView)this.getView(), (DynamicObject)this.getModel().getDataEntity());
            this.putValueInCache(data);
        }
    }

    private void putValueInCache(DynamicObject dynamicObject) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        pageCache.put("status", status.toString());
        if (status.equals((Object)OperationStatus.VIEW)) {
            pageCache.put("employeenoscheme", dynamicObject.getString("employeenoscheme"));
            pageCache.put("serviceagescheme", dynamicObject.getString("serviceagescheme"));
            pageCache.put("automaticinfo", dynamicObject.getString("automaticinfo"));
        }
        pageCache.put("viewtype", ViewTypeEnum.AGAIN.getCode());
    }

    private void initTipsTool() {
        IFormView parentView = this.getView().getParentView();
        parentView.setVisible(Boolean.FALSE, new String[]{"errorflexpanelap"});
        parentView.setVisible(Boolean.FALSE, new String[]{"rulewarnap"});
        parentView.setVisible(Boolean.FALSE, new String[]{"cerrorflexpanelap"});
        parentView.setVisible(Boolean.FALSE, new String[]{"cwarningflexpanelap"});
        this.getView().sendFormAction(parentView);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        if ("personfield".equals(propertyName)) {
            FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setCustomParam("querylastonbrd", (Object)"querylastonbrd");
        }
    }

    private void setBermanfile() {
        IDataModel model = this.getModel();
        String viewType = model.getDataEntity().getString("viewtype");
        LOGGER.info("AgainOnbrdInfoEdit.setBermanfile,viewType:{}", (Object)viewType);
        if (!ViewTypeEnum.AGAIN.getCode().equals(viewType)) {
            return;
        }
        long personId = model.getDataEntity().getLong("personfield.person.id");
        LOGGER.info("AgainOnbrdInfoEdit.setBermanfile,personId:{},bErmanfile:{}", (Object)personId, model.getValue("b_ermanfile"));
        if (personId != 0L) {
            DynamicObject bErmanfile = IHrmpExternalService.getInstance().getQuitErManFile(Long.valueOf(personId));
            model.setValue("b_ermanfile", (Object)bErmanfile);
            LOGGER.info("AgainOnbrdInfoEdit.setBermanfile,bErmanfile:{}", (Object)bErmanfile);
        }
    }
}

