/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.SynchStatusEnum;
import kd.hr.hom.common.enums.ViewTypeEnum;
import kd.hr.hom.common.util.HOMObjectUtils;

public class OnbrdBillListPlugin
extends HRDataBaseList
implements Serializable {
    private static final Log logger = LogFactory.getLog(OnbrdBillListPlugin.class);
    private static final Map<String, String> listOrderByMap = ImmutableMap.builder().put((Object)OnbrdStatusEnum.WAIT_START.toString(), (Object)"modifytime desc,id asc").put((Object)OnbrdStatusEnum.WAIT_ONBRD.toString(), (Object)"modifytime desc,id asc").put((Object)OnbrdStatusEnum.HAS_ONBRD.toString(), (Object)"modifytime desc,id asc").put((Object)OnbrdStatusEnum.BREAK_UP.toString(), (Object)"breakupdate desc,effectdate desc,starttime desc,id asc").build();
    private static final Set<String> CLOSE_VIEW = ImmutableSet.of((Object)"hom_wbquicksearch");
    private static final long serialVersionUID = 3615633521056644917L;

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        IFormView formView;
        args.setCancel(true);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("name".equals(fieldName) && (formView = this.getView()) instanceof IListView) {
            IListView listView = (IListView)formView;
            String onbrdId = listView.getFocusRowPkId().toString();
            FormShowParameter showParameter = new FormShowParameter();
            DynamicObject onbrdDyObj = IOnbrdBillDomainService.getInstance().findOnbrdBillById("id,name,candidate,viewtype", (Object)Long.valueOf(onbrdId));
            if (HRObjectUtils.isEmpty((Object)onbrdDyObj)) {
                listView.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u5c06\u81ea\u52a8\u5237\u65b0\u5217\u8868\u3002", (String)"OnbrdBillListPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                listView.refresh();
                return;
            }
            String name = onbrdDyObj.getString("name");
            String viewType = onbrdDyObj.getString("viewtype");
            if (ViewTypeEnum.AGAIN.getCode().equals(viewType)) {
                showParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u518d\u5165\u804c\u529e\u7406\u5355-%s", (String)"OnbrdBillListPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]), name));
            } else {
                showParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5165\u804c\u529e\u7406\u5355-%s", (String)"OnbrdBillListPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), name));
            }
            showParameter.setFormId("hom_persononbrdhandlebody");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            IFormView currView = this.getView();
            IFormView parentView = HOMObjectUtils.getCurrAppHomeView((IFormView)currView);
            String appRootPageId = parentView == null ? currView.getFormShowParameter().getRootPageId() : parentView.getPageId();
            String pageId = HOMObjectUtils.getUniquePageId((String)"hom_persononbrdhandlebody", (Object)onbrdId, (String)appRootPageId);
            showParameter.setPageId(pageId);
            showParameter.setCustomParam("onbrdid", (Object)onbrdId);
            showParameter.setCustomParam("candidateid", (Object)onbrdDyObj.getString("candidate.id"));
            currView.showForm(showParameter);
            this.closeView();
        }
    }

    private void closeView() {
        if (this.getView().getParentView() != null) {
            String fromId = this.getView().getParentView().getEntityId();
            if (!CLOSE_VIEW.contains(fromId)) {
                return;
            }
            this.getView().getParentView().invokeOperation("close");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        Object value;
        super.setFilter(setFilterEvent);
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("org_cache", null);
        if (setFilterEvent.getMainOrgQFilter() != null && (value = setFilterEvent.getMainOrgQFilter().getValue()) instanceof List && ((List)value).size() == 1) {
            pageCache.put("org_cache", value.toString());
        }
        String enrollStatus = (String)this.getView().getFormShowParameter().getCustomParam("enrollstatus");
        logger.info("enrollStatus:{}", (Object)enrollStatus);
        if (HRStringUtils.isEmpty((String)enrollStatus)) {
            setFilterEvent.setOrderBy("modifytime desc,id asc");
            return;
        }
        String orderStr = listOrderByMap.get(enrollStatus);
        if (HRStringUtils.isNotEmpty((String)orderStr)) {
            setFilterEvent.setOrderBy(orderStr);
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        this.getView().getPageCache().remove("org_cache");
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.invokeOperation("close");
            this.getView().sendFormAction(parentView);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                IDataEntityType dataEntityType = ((DynamicObject)rows.get(0)).getDataEntityType();
                if (!dataEntityType.getProperties().containsKey((Object)"synchstatus")) {
                    return rows;
                }
                ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(rows.size());
                for (DynamicObject row : rows) {
                    String enrollStatus = row.getString("synchstatus");
                    if (Objects.isNull(enrollStatus) || !HRStringUtils.equals((String)SynchStatusEnum.SYNCH_FAIL.getValue(), (String)enrollStatus)) continue;
                    cellStyles.add(OnbrdBillListPlugin.this.getListUnitStyle("synchstatus", row.getInt("fseq") - 1, "red"));
                }
                BillList billList = (BillList)OnbrdBillListPlugin.this.getView().getControl("billlistap");
                billList.setCellStyle(cellStyles);
                return rows;
            }
        });
    }

    private CellStyle getListUnitStyle(String fieldKey, int rowNum, String foreColor) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey(fieldKey);
        cellStyle.setRow(rowNum);
        cellStyle.setForeColor(foreColor);
        return cellStyle;
    }
}

