/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.constant.HcfCandidateConstants;
import kd.hr.hom.common.enums.PositionTypeEnum;

public class OnbrdBodyPrintInfoPlugin
extends AbstractPrintPlugin {
    private static final Log LOGGER = LogFactory.getLog(OnbrdBodyPrintInfoPlugin.class);
    private static final String HCF_HOMEADDRESS = "hcf_homeaddress";
    private static final String HCF_ADDRESS = "hcf_address";
    private static final String HCF_TELLADDRESS = "hcf_telladdress";
    private static final String HOM_ONBRD = "hom_onbrd";
    private static final String HOM_POSITION = "hom_position";

    public void loadCustomData(CustomDataLoadEvent evt) {
        super.loadCustomData(evt);
        String selProp = "id" + "," + "name" + "," + "candidate" + "," + "apositiontype" + "," + "aposition" + "," + "stdposition" + "," + "ajob";
        if (HRObjectUtils.isEmpty((Object)evt.getDataSource().getPkId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u5165\u804c\u529e\u7406\u5355\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"HomOnbrdDataBaseEdit_6", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        Long pkId = (Long)evt.getDataSource().getPkId();
        DynamicObject onbrdDyObj = IOnbrdBillDomainService.getInstance().findOnbrdBillById(selProp, (Object)pkId);
        Long candidateId = onbrdDyObj.getLong("candidate.id");
        DynamicObjectCollection hcfAddressList = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_canaddress");
        CustomDataSource customDataSource = evt.getDataSource();
        List customDataRows = evt.getCustomDataRows();
        DataRowSet dataRowSet = new DataRowSet();
        if (HCF_ADDRESS.equals(customDataSource.getDsName()) && !CollectionUtils.isEmpty((Collection)hcfAddressList)) {
            for (DynamicObject dynamicObject : hcfAddressList) {
                Long addressTypeId;
                LOGGER.info("===ContactInfoPlugin dynamicObject==={}", (Object)dynamicObject.toString());
                DynamicObject addressType = dynamicObject.getDynamicObject("addresstype");
                if (Objects.isNull(addressType) || (addressTypeId = Long.valueOf(addressType.getLong("id"))).equals(HcfCandidateConstants.ADDRESSTYPE_CN_HUKOUID)) continue;
                if (addressTypeId.equals(HcfCandidateConstants.ADDRESSTYPE_CN_PERSONID)) {
                    dataRowSet.put(HCF_HOMEADDRESS, (Field)new TextField(dynamicObject.getString("addressinfo")));
                    continue;
                }
                if (!addressTypeId.equals(HcfCandidateConstants.ADDRESSTYPE_CN_COMMUID)) continue;
                dataRowSet.put(HCF_TELLADDRESS, (Field)new TextField(dynamicObject.getString("addressinfo")));
            }
        }
        if (HOM_ONBRD.equals(customDataSource.getDsName()) && !HRObjectUtils.isEmpty((Object)onbrdDyObj)) {
            String apositiontype = onbrdDyObj.getString("apositiontype");
            if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue(), (String)apositiontype)) {
                dataRowSet.put(HOM_POSITION, (Field)new TextField(onbrdDyObj.getString("aposition.name")));
            } else if (PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue().equals(apositiontype)) {
                dataRowSet.put(HOM_POSITION, (Field)new TextField(onbrdDyObj.getString("stdposition.name")));
            } else {
                dataRowSet.put(HOM_POSITION, (Field)new TextField(onbrdDyObj.getString("ajob.name")));
            }
        }
        customDataRows.add(dataRowSet);
    }
}

