/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.formplugin.common.PermissionHelper;

public class OnbrdConfirmCountEdit
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(OnbrdConfirmCountEdit.class);
    private static final String BTN_CONFIRM = "btn_confirm";
    private static final String EXPORT_EXCEL = "exportexcel";
    private static final String LABEL_FINAL = "label_final";
    private static final String FLEXPANEL_CANDONEXT = "flexpanel_candonext";
    private static final String FLEXPANEL_NEEDCLOSE = "flexpanel_needclose";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        IFormView formView = this.getView();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        Label fitpersonLabel = (Label)formView.getControl("fitperson");
        Integer fitPersonCount = (Integer)formShowParameter.getCustomParam("fitperson");
        fitpersonLabel.setText(fitPersonCount.toString());
        Label nofitpersonLabel = (Label)formView.getControl("nofitperson");
        nofitpersonLabel.setText(formShowParameter.getCustomParam("nofitperson").toString());
        Label allpersonLabel = (Label)formView.getControl("allperson");
        allpersonLabel.setText(formShowParameter.getCustomParam("allperson").toString());
        if (fitPersonCount == 0) {
            formView.setVisible(Boolean.FALSE, new String[]{LABEL_FINAL, FLEXPANEL_CANDONEXT});
            formView.setVisible(Boolean.TRUE, new String[]{FLEXPANEL_NEEDCLOSE});
        } else {
            formView.setVisible(Boolean.FALSE, new String[]{FLEXPANEL_NEEDCLOSE});
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_CONFIRM});
        this.addClickListeners(new String[]{EXPORT_EXCEL});
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Control) {
            Control control = (Control)evt.getSource();
            switch (control.getKey()) {
                case "btn_confirm": {
                    if (PermissionHelper.getParentViewPerm(this.getView())) {
                        return;
                    }
                    IFormView formView = this.getView();
                    FormShowParameter formShowParameter = formView.getFormShowParameter();
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    dataMap.put("fitIds", this.getView().getFormShowParameter().getCustomParam("fitIds"));
                    dataMap.put("allperson", formShowParameter.getCustomParam("allperson"));
                    formView.returnDataToParent(dataMap);
                    formView.close();
                    break;
                }
                case "exportexcel": {
                    this.exportExcel();
                    break;
                }
            }
        }
    }

    private void exportExcel() {
        String excelName = (String)this.getView().getFormShowParameter().getCustomParam("excelname");
        List exportDataList = (List)this.getView().getFormShowParameter().getCustomParam("exportdatalist");
        List headDataLst = new ArrayList();
        try {
            headDataLst = (List)HRJSONUtils.cast((String)this.getView().getFormShowParameter().getCustomParam("headdatalist").toString(), List.class, (Class[])new Class[]{HRExportHeadObject.class});
        }
        catch (IOException iOException) {
            logger.error((Throwable)iOException);
            this.getView().showErrMessage(iOException.getMessage(), " Fail to cast json ! Reason: ");
        }
        String exportUrl = null;
        try {
            exportUrl = HRExportDataHelper.getExportExcelUrl((String)excelName, (List)exportDataList, headDataLst);
        }
        catch (IOException iOException) {
            logger.error((Throwable)iOException);
            this.getView().showErrMessage(iOException.getMessage(), " Fail to get export Excel url ! Reason: ");
        }
        if (!HRStringUtils.isEmpty((String)exportUrl)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)exportUrl);
        }
    }
}

