/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.tcc.TCCGlobalSession;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParam;
import kd.hr.hbp.common.model.org.staff.StaffUseParam;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.application.impl.onbrd.OnbrdConfirmAppServiceImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.onbrd.IValidEntryDateService;
import kd.hr.hom.business.application.rule.IOnbrdConfirmValidatorService;
import kd.hr.hom.business.application.staff.IStaffUseService;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.business.domain.service.util.OnbrdValidateUtils;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.formplugin.common.PermissionHelper;

public class OnbrdConfirmSingleEdit
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(OnbrdConfirmSingleEdit.class);
    private static final String BTN_CONFIRM = "btn_confirm";
    private static final String LABEL_TIPS = "label_tips";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.initPageData();
    }

    private void initPageData() {
        IDataModel dataModel = this.getView().getModel();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        dataModel.setValue("id", formShowParameter.getCustomParam("id"));
        dataModel.setValue("picturefield", formShowParameter.getCustomParam("picturefield"));
        dataModel.setValue("name", formShowParameter.getCustomParam("name"));
        Object candidate = formShowParameter.getCustomParam("candidate");
        if (candidate instanceof JSONObject) {
            dataModel.setValue("resumeno", ((JSONObject)candidate).get((Object)"number"));
        }
        dataModel.setValue("employeeno", formShowParameter.getCustomParam("employeeno"));
        Object certificateType = formShowParameter.getCustomParam("certificatetype");
        if (certificateType instanceof JSONObject) {
            dataModel.setValue("certificatetype", ((JSONObject)certificateType).get((Object)"id"));
        } else {
            dataModel.setValue("certificatetype", certificateType);
        }
        dataModel.setValue("certificatenumber", formShowParameter.getCustomParam("certificatenumber"));
        String effectDateStr = (String)formShowParameter.getCustomParam("effectdate");
        dataModel.setValue("effectdate", (Object)effectDateStr);
        this.getView().getPageCache().put("effectdate", effectDateStr);
        this.updateCheckMessage();
        try {
            if (HRStringUtils.isNotEmpty((String)effectDateStr)) {
                Date effectDate = HRDateTimeUtils.parseDate((String)effectDateStr);
                this.updateBtnComfirmStatus(effectDate);
            }
        }
        catch (ParseException parseException) {
            LOGGER.error((Throwable)parseException);
            this.getView().showErrMessage(parseException.getMessage(), " Fail to Parse Date ! Reason: ");
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    public void click(EventObject evt) {
        Button button;
        String key;
        super.click(evt);
        Object object = evt.getSource();
        if (object instanceof Button && BTN_CONFIRM.equals(key = (button = (Button)object).getKey()) && this.validateDataWithDB() && this.validateDate()) {
            this.doOnbrdConfirm();
        }
    }

    private boolean validateDate() {
        IStaffUseService staffUseService = IStaffUseService.getInstance();
        Long onbrdId = HOMObjectUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        String properties = "id,effectdate,aadminorg,aposition,stdposition,ajob,validuntil,apositiontype," + staffUseService.getSelectProperties();
        DynamicObject onbrdBillUpdate = IOnbrdBillDomainService.getInstance().findOnbrdBill(properties, new QFilter[]{new QFilter("id", "=", (Object)onbrdId)});
        if (onbrdBillUpdate == null) {
            this.getView().showErrorNotification("Cannot find onbrdBillUpdate!");
            return false;
        }
        DynamicObject onbrdBillFromDB = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hom_onbrdinfo"));
        HRDynamicObjectUtils.copy((DynamicObject)onbrdBillUpdate, (DynamicObject)onbrdBillFromDB);
        Date effectDate = this.getModel().getDataEntity().getDate("effectdate");
        Date validuntil = onbrdBillUpdate.getDate("validuntil");
        if (effectDate != null && validuntil != null && HRDateTimeUtils.dayAfter((Date)effectDate, (Date)validuntil)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f\u9700\u5728\u5165\u804c\u6709\u6548\u671f\uff08%s\uff09\u5185\u3002", (String)"ReservationOnbrdPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]), format.format(validuntil)));
            return false;
        }
        onbrdBillUpdate.set("effectdate", (Object)effectDate);
        Map validEntryDateOfQuitDateMap = IValidEntryDateService.getInstance().validEntryDateOfQuitDate(new DynamicObject[]{onbrdBillUpdate}, false);
        Optional message = validEntryDateOfQuitDateMap.getOrDefault(onbrdBillUpdate.getLong("personfield.id"), Optional.empty());
        if (message.isPresent()) {
            this.getView().showTipNotification((String)message.get());
            return false;
        }
        String validateResult = IOnbrdCommonAppService.getInstance().validateEffectDateWithOrgField(onbrdBillUpdate);
        if (HRStringUtils.isNotEmpty((String)validateResult)) {
            this.getView().showErrorNotification(validateResult);
            return false;
        }
        StaffQueryOutParam staffQueryOutParam = null;
        if (staffUseService.judgeIfChangedWithDimension(onbrdBillFromDB, onbrdBillUpdate, staffUseService.getDimensionSet())) {
            staffQueryOutParam = staffUseService.queryStaffUseInfo(onbrdBillUpdate, "UPDATE");
        }
        if (staffQueryOutParam != null && !staffQueryOutParam.isAllow() && !CollectionUtils.isEmpty((Collection)staffQueryOutParam.getReasonList())) {
            LOGGER.info("staffQueryOutParam:{}", (Object)JSONObject.toJSONString((Object)staffQueryOutParam));
            StringJoiner stringJoiner = new StringJoiner(";");
            staffQueryOutParam.getReasonList().forEach(stringJoiner::add);
            this.getView().showErrorNotification(stringJoiner.toString());
            return false;
        }
        return true;
    }

    private boolean validateDataWithDB() {
        DynamicObject simpleDynamicObject = this.getModel().getDataEntity();
        Long onbrdBillId = simpleDynamicObject.getLong("id");
        String effectDateStr = this.getView().getPageCache().get("effectdate");
        Date effectDateFromCache = null;
        try {
            if (HRStringUtils.isNotEmpty((String)effectDateStr)) {
                effectDateFromCache = HRDateTimeUtils.parseDate((String)effectDateStr);
            }
        }
        catch (ParseException parseException) {
            LOGGER.error((Throwable)parseException);
            this.getView().showErrMessage(parseException.getMessage(), " Fail to Parse Date ! Reason: ");
        }
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdBillId);
        DynamicObject onbrdBill = IOnbrdBillDomainService.getInstance().findOnbrdBill("effectdate", new QFilter[]{qFilter});
        Date effectDateFromDB = onbrdBill.getDate("effectdate");
        boolean flag = true;
        if (effectDateFromDB == null || HRDateTimeUtils.dayAfter((Date)HRDateTimeUtils.truncateDate((Date)effectDateFromDB), (Date)HRDateTimeUtils.truncateDate((Date)effectDateFromCache))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f\u5df2\u88ab\u4fee\u6539\uff0c\u6682\u4e0d\u53ef\u786e\u8ba4\u5165\u804c\u3002", (String)"OnbrdConfirmSingleEdit_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            flag = false;
        } else if (HRDateTimeUtils.dayBefore((Date)HRDateTimeUtils.truncateDate((Date)effectDateFromDB), (Date)HRDateTimeUtils.truncateDate((Date)effectDateFromCache))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u3002", (String)"OnbrdConfirmSingleEdit_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            flag = false;
        }
        if (!flag) {
            this.getModel().setValue("effectdate", (Object)effectDateFromDB);
        }
        return flag;
    }

    private void doOnbrdConfirm() {
        String billFormId;
        if (PermissionHelper.getParentViewPerm(this.getView())) {
            return;
        }
        String operateKey = null;
        IFormView parentView = this.getView().getParentView();
        if (this.getView().getParentView() != null && "hom_onbrdcheckinbody".equals(billFormId = parentView.getFormShowParameter().getFormId())) {
            operateKey = "btn_confirmcheckin";
        }
        if (parentView instanceof IListView && ("hom_waitcheckin".equals(billFormId = ((IListView)parentView).getBillFormId()) || "hom_exceptioncheckin".equals(billFormId) || "hom_waitconfirm".equals(billFormId))) {
            operateKey = "btn_confirmcheckin";
        }
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject simpleDynamicObject = this.getModel().getDataEntity();
        try {
            ImmutableList onbrdBillIds = ImmutableList.of((Object)simpleDynamicObject.getLong("id"));
            IHomDataMutexService homDataMutexService = IHomDataMutexService.getInstance();
            Map batchRequireResult = homDataMutexService.batchRequire((Collection)onbrdBillIds, "hom_onbrdinfo", "doconfirm");
            List failLockIds = batchRequireResult.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(failLockIds)) {
                String errMsg = this.updateOnbrdBill();
                if (HRStringUtils.isEmpty((String)errMsg)) {
                    Map resultMap = new OnbrdConfirmAppServiceImpl().doComfirmWithSimpleInfo(userId, simpleDynamicObject, operateKey);
                    this.getView().returnDataToParent((Object)resultMap);
                    this.getView().close();
                } else {
                    this.getView().showErrorNotification(errMsg);
                }
                homDataMutexService.batchRelease((Collection)onbrdBillIds, "hom_onbrdinfo", "doconfirm");
            } else {
                IOnbrdCommonAppService.getInstance().showMutexMsgWithOnbrdBill(this.getView(), failLockIds, ResManager.loadKDString((String)"\u786e\u8ba4\u5165\u804c", (String)"OnbrdConfirmPlugin_5", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            }
        }
        catch (KDException kdException) {
            LOGGER.error((Throwable)kdException);
            this.getView().showErrMessage(kdException.getMessage(), " Fail to do onbrdConfirm ! ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String updateOnbrdBill() {
        DynamicObject simpleDynamicObject = this.getModel().getDataEntity();
        Long onbrdBillId = simpleDynamicObject.getLong("id");
        IOnbrdBillDomainService onbrdBillDomainService = IOnbrdBillDomainService.getInstance();
        IStaffUseService staffUseService = IStaffUseService.getInstance();
        DynamicObject onbrdBill = onbrdBillDomainService.findOnbrdBillById("effectdate," + staffUseService.getSelectProperties(), (Object)onbrdBillId);
        onbrdBill.set("effectdate", simpleDynamicObject.get("effectdate"));
        try (TXHandle txHandle = TX.required();){
            StaffUseParam staffUseParam = staffUseService.getStaffUseParamsForTCC(new DynamicObject[]{onbrdBill}, "UPDATE");
            if (staffUseParam != null && !CollectionUtils.isEmpty((Collection)staffUseParam.getStaffUseInParamList())) {
                TCCGlobalSession.Try((String)"hom_IHAOSStaffUseService", (String)"hrmp", (String)"haos", (String)"IHAOSStaffUseService", (Param)staffUseParam, null, (DBRoute)DBRoute.of((String)"hrb.hom"));
                LOGGER.info("staffUseParam:{}", (Object)HOMObjectUtils.toJSONString((Object)staffUseParam));
            }
            onbrdBillDomainService.saveOnbrdBillInfo(onbrdBill);
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertyName = propertyChangedArgs.getProperty().getName();
        if ("effectdate".equals(propertyName)) {
            this.updateCheckMessage();
            Date effectDate = this.getModel().getDataEntity().getDate("effectdate");
            this.updateBtnComfirmStatus(effectDate);
        }
    }

    private void updateCheckMessage() {
        IDataModel dataModel = this.getView().getModel();
        Label lblMsgText = (Label)this.getView().getControl(LABEL_TIPS);
        DynamicObject simpleInfo = dataModel.getDataEntity();
        HashSet<Long> onbrdBillIdSet = new HashSet<Long>();
        onbrdBillIdSet.add(simpleInfo.getLong("id"));
        IOnbrdConfirmValidatorService onbrdConfirmValidatorService = IOnbrdConfirmValidatorService.getInstance();
        DynamicObject onbrdBillInfoForCheck = onbrdConfirmValidatorService.getOnbrdBillForCheckValid(onbrdBillIdSet)[0];
        onbrdConfirmValidatorService.takeConfirmPageInfoToTargetObject(simpleInfo, onbrdBillInfoForCheck);
        String tips = onbrdConfirmValidatorService.checkOnbrdBillInfo(onbrdBillInfoForCheck);
        if (HRStringUtils.isEmpty((String)tips)) {
            tips = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u786e\u8ba4\u5165\u804c\u4fe1\u606f\u3002", (String)"OnbrdConfirmSingleEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        }
        lblMsgText.setText(tips);
    }

    private void updateBtnComfirmStatus(Date effectDate) {
        Date currentDate = HRDateTimeUtils.truncateDate((Date)new Date());
        if (Objects.isNull(effectDate) || HRDateTimeUtils.dayAfter((Date)HRDateTimeUtils.truncateDate((Date)effectDate), (Date)currentDate)) {
            if (OnbrdValidateUtils.isSkipEffectDateValidate()) {
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_CONFIRM});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_CONFIRM});
            }
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{BTN_CONFIRM});
        }
    }
}

