/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import java.util.Date;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.QRCode;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.cvp.IHomFaceDetectService;
import kd.hr.hom.business.application.cvp.IHomToCvpAppService;
import kd.hr.hom.business.domain.repository.OnbrdBillRepository;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.entity.ocr.FaceDetectResult;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.ViewTypeEnum;
import kd.hr.hom.common.util.ComboPropValueUtils;
import kd.hr.hom.common.util.FileServiceUtils;
import kd.hr.hom.formplugin.web.activity.AbstractOnbrdHeadPlugin;

public class OnbrdHeadInfoPlugin
extends AbstractOnbrdHeadPlugin {
    private static final Log logger = LogFactory.getLog(OnbrdHeadInfoPlugin.class);
    private static final String PANEL_NEW = "panel_new";
    private static final String PANEL_VIEWA = "panel_viewa";
    private static final String PANEL_VIEWB = "panel_viewb";
    private static final String PROPERTIES_SELECTED = "billno,creator,createtime,name,onbrdtype,org,enrollstatus,gender,laborrelstatus,phone,peremail,validuntil,starttime,effectdate,processstatus,candidate.number,onbrdtype.name,picturefield,nationality,viewtype";
    private static final String NEW_CREATETIME = "new_createtime";
    private static final String HOM_ONBRDDETAILHEAD = "hom_onbrddetailhead";

    public void afterCreateNewData(EventObject eventObject) {
        DynamicObject onbrdBillInfo;
        super.afterCreateNewData(eventObject);
        IFormView formView = this.getView();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("id"));
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdId);
        String viewType = (String)formShowParameter.getCustomParam("viewtype");
        if (ViewTypeEnum.AGAIN.getCode().equals(viewType)) {
            this.setLabelText("viewtypename", ViewTypeEnum.AGAIN.getDesc());
        }
        if (HRObjectUtils.isEmpty((Object)(onbrdBillInfo = IOnbrdBillDomainService.getInstance().findOnbrdBill(PROPERTIES_SELECTED, new QFilter[]{qFilter})))) {
            logger.info("Can not find OnbrdBill By the PkId " + onbrdId);
            formView.setVisible(Boolean.TRUE, new String[]{PANEL_NEW});
            formView.setVisible(Boolean.FALSE, new String[]{PANEL_VIEWA, PANEL_VIEWB});
            this.setFieldValueWithPanelNew();
            return;
        }
        String enrollStatus = onbrdBillInfo.getString("enrollstatus");
        formView.setVisible(Boolean.FALSE, new String[]{PANEL_NEW});
        formView.setVisible(Boolean.TRUE, new String[]{PANEL_VIEWA, PANEL_VIEWB});
        this.setFieldValueWithPanelViewA(onbrdBillInfo);
        this.setFieldValueWithPanelViewB(onbrdBillInfo);
        formView.setEnable(Boolean.FALSE, new String[]{"picturefield"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("modify".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"picturefield"});
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"picturefield")) {
            String relativeUrl = this.getModel().getDataEntity().getString("picturefield");
            if (HRStringUtils.isNotEmpty((String)relativeUrl)) {
                String imageUrl = FileServiceUtils.getImageFullUrl((String)relativeUrl);
                if (IHomToCvpAppService.getInstance().ocrIsEnable().booleanValue()) {
                    FaceDetectResult faceDetectResult = IHomFaceDetectService.getInstance().detectFaceImage(imageUrl);
                    logger.info("===faceDetectResult.errorCode:{}===", (Object)faceDetectResult.getErrorCode());
                    logger.info("===faceDetectResult.description:{}==", (Object)faceDetectResult.getDescription());
                    if (!faceDetectResult.isRightFacePhoto()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u5230\u4eba\u50cf\u5185\u5bb9\uff0c\u8bf7\u4e0a\u4f20\u4eba\u50cf\u56fe\u7247\u3002", (String)"OnbrdInfoEdit_7", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    }
                }
            }
            if (args.getChangeSet().length > 0) {
                Object newValue = args.getChangeSet()[0].getNewValue();
                Object id = this.getView().getFormShowParameter().getCustomParams().get("id");
                DynamicObject dyo = new OnbrdBillRepository().generateDynamicObject(id, "picturefield");
                dyo.set("id", id);
                dyo.set("picturefield", newValue);
                IOnbrdBillDomainService.getInstance().saveOnbrdBillInfo(dyo);
            }
        }
    }

    private void setFieldValueWithPanelNew() {
        this.setLabelText("new_billno", (String)this.getView().getFormShowParameter().getCustomParam("billno"));
        this.setLabelText("new_creator", RequestContext.get().getUserName());
        this.setLabelText(NEW_CREATETIME, HRInteDateTimeUtil.formatDate((String)"hom_onbrdinfo", (String)"createtime", (Date)new Date()));
    }

    private void setFieldValueWithPanelViewA(DynamicObject onbrdBillInfo) {
        this.getModel().setValue("picturefield", (Object)onbrdBillInfo.getString("picturefield"));
        String name = onbrdBillInfo.getString("name");
        if (HRStringUtils.isNotEmpty((String)name) && name.length() > 50) {
            name = name.substring(0, 50) + "...";
        }
        this.setLabelText("view_name", name);
        String billNo = onbrdBillInfo.getString("billno");
        this.setLabelText("view_billno", billNo);
        this.setLabelText("view_org", onbrdBillInfo.getString("org.name"));
        this.setLabelText("view_creator", onbrdBillInfo.getString("creator.name"));
        Date createTime = onbrdBillInfo.getDate("createtime");
        this.setLabelText("view_createtime", createTime != null ? HRInteDateTimeUtil.formatDate((String)"hom_onbrdinfo", (String)"createtime", (Date)createTime) : "");
        QRCode code = (QRCode)this.getView().getControl("barcode");
        code.setUrl(billNo);
        code.setValue(billNo);
        String key = this.setLabelStyle(onbrdBillInfo.getString("enrollstatus"));
        this.setLabelText(key, ComboPropValueUtils.getDropdownListNameByCode((String)"hom_onbrdbilltpl", (String)"enrollstatus", (String)onbrdBillInfo.getString("enrollstatus")));
        String viewType = onbrdBillInfo.getString("viewtype");
        String dropdownListNameByCode = ComboPropValueUtils.getDropdownListNameByCode((String)"hom_onbrdbilltpl", (String)"viewtype", (String)viewType);
        this.setLabelText("viewtype", dropdownListNameByCode);
    }

    private void setFieldValueWithPanelViewB(DynamicObject onbrdBillInfo) {
        Date starttime;
        DynamicObject nationality;
        String name = onbrdBillInfo.getString("name");
        if (HRStringUtils.isNotEmpty((String)name) && name.length() > 50) {
            name = name.substring(0, 50) + "...";
        }
        this.setLabelText("name", name);
        this.setLabelText("candidatenumber", onbrdBillInfo.getString("candidate.number"));
        if (StringUtils.isBlank((CharSequence)onbrdBillInfo.getString("candidate.number"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap211"});
        }
        if (StringUtils.isBlank((CharSequence)onbrdBillInfo.getString("gender.name"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"genderpanelap"});
        }
        this.setLabelText("gender", onbrdBillInfo.getString("gender.name"));
        if (StringUtils.isBlank((CharSequence)onbrdBillInfo.getString("onbrdtype.name"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"onbrdtypename"});
        }
        this.setLabelText("onbrdtypename", onbrdBillInfo.getString("onbrdtype.name"));
        if (StringUtils.isBlank((CharSequence)onbrdBillInfo.getString("phone"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"phonepanelap"});
        }
        this.getModel().setValue("phone", (Object)onbrdBillInfo.getString("phone"));
        this.getModel().setValue("email", (Object)onbrdBillInfo.getString("peremail"));
        if (HRStringUtils.isEmpty((String)onbrdBillInfo.getString("peremail"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"emailpanelap"});
        }
        if (HRObjectUtils.isEmpty((Object)(nationality = onbrdBillInfo.getDynamicObject("nationality")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"nationalitypanelap"});
        } else {
            this.setLabelText("nationality", nationality.getLocaleString("name").getLocaleValue());
        }
        Date validtime = onbrdBillInfo.getDate("validuntil");
        this.setLabelText("validtime", validtime != null ? HRInteDateTimeUtil.formatDate((String)"hom_onbrdinfo", (String)"validuntil", (Date)validtime) : "");
        if (validtime == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap21"});
        }
        this.setLabelText("starttime", (starttime = onbrdBillInfo.getDate("starttime")) != null ? HRInteDateTimeUtil.formatDate((String)"hom_onbrdinfo", (String)"starttime", (Date)starttime) : "");
        if (starttime == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap22"});
        }
        this.setLabelText("processstatus", ComboPropValueUtils.getDropdownListNameByCode((String)"hom_onbrdbilltpl", (String)"processstatus", (String)onbrdBillInfo.getString("processstatus")));
        Date effectdate = onbrdBillInfo.getDate("effectdate");
        this.setLabelText("effectdate", effectdate != null ? HRInteDateTimeUtil.formatDate((String)"hom_onbrdinfo", (String)"effectdate", (Date)effectdate) : "");
        if (effectdate == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap23"});
        }
    }

    private void setLabelText(String key, String value) {
        Label label = (Label)this.getView().getControl(key);
        if (label != null) {
            label.setText(value);
        }
    }

    private String setLabelStyle(String key) {
        if (key.equals(OnbrdStatusEnum.HAS_ONBRD.toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"view_enrollstatus"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"view_break", "view_exception"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"view_has"});
            return "view_has";
        }
        if (key.equals(OnbrdStatusEnum.BREAK_UP.toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"view_has", "view_exception"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"view_enrollstatus"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"view_break"});
            return "view_break";
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"view_break"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"view_has", "view_exception"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"view_enrollstatus"});
        return "view_enrollstatus";
    }
}

