/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParam;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.application.blacklist.IBlackListService;
import kd.hr.hom.business.application.common.ReentryRuleService;
import kd.hr.hom.business.application.cvp.IHomFaceDetectService;
import kd.hr.hom.business.application.cvp.IHomToCvpAppService;
import kd.hr.hom.business.application.hbpm.IHrmpExternalService;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.hpfs.IPersonFileIntegrateService;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.hr.hom.business.application.impl.onbrd.OnbrdCommonAppServiceImpl;
import kd.hr.hom.business.application.impl.page.CertificatePageServiceImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.onbrd.IValidEntryDateService;
import kd.hr.hom.business.application.staff.IStaffUseService;
import kd.hr.hom.business.application.utils.BlackListConfigUtil;
import kd.hr.hom.business.application.utils.RuleCodeUtils;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.base.IHomConfigDomainService;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.business.domain.service.common.IHomConfigService;
import kd.hr.hom.business.domain.service.hbjm.IHbjmDataDomainService;
import kd.hr.hom.business.domain.service.hbpm.IHbpmDataDomainService;
import kd.hr.hom.business.domain.service.impl.hcf.HcfDataDomainService;
import kd.hr.hom.business.domain.service.impl.onbrd.OnbrdInfoInitService;
import kd.hr.hom.business.domain.service.impl.onbrd.OnbrdInfoServiceImpl;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdService;
import kd.hr.hom.business.domain.service.preonbrd.IPreOnBrdService;
import kd.hr.hom.business.domain.service.rulecode.CodeServiceFactory;
import kd.hr.hom.business.domain.service.rulecode.IRuleCodeBusinessCheckService;
import kd.hr.hom.common.constant.BaseDataConstants;
import kd.hr.hom.common.constant.BaseDataIdConstants;
import kd.hr.hom.common.constant.HcfCanCreConstants;
import kd.hr.hom.common.constant.OnbrdPersonFieldConstants;
import kd.hr.hom.common.entity.BlacklistConfigDTO;
import kd.hr.hom.common.entity.IDCardInfo;
import kd.hr.hom.common.entity.ocr.FaceDetectResult;
import kd.hr.hom.common.enums.EmployeeNoSchemeEnum;
import kd.hr.hom.common.enums.HbssSexEnum;
import kd.hr.hom.common.enums.OnbrdBlackListStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.PositionTypeEnum;
import kd.hr.hom.common.enums.ViewTypeEnum;
import kd.hr.hom.common.util.DateUtils;
import kd.hr.hom.common.util.FileServiceUtils;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.common.util.HbpmResultUtils;
import kd.hr.hom.common.util.IDCardUtils;
import kd.hr.hom.common.util.PinyinUtil;
import kd.hr.hom.common.util.UpdateControlUtil;
import kd.hr.hom.formplugin.common.ApBuildUtils;
import kd.hr.hom.formplugin.common.OnBrdHandleHelper;
import kd.hr.hom.formplugin.common.PropertyChange;
import kd.sdk.hr.hom.service.IOnbrdInfoService;

public class OnbrdInfoEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(OnbrdInfoEdit.class);
    private static final String PANEL_BASICINFO = "fs_basicinfo";
    private static final String PANEL_BREAKUPINFO = "fs_breakupinfo";
    private static final String FIELDGROUPPANELAP = "fieldgrouppanelap";
    private static final String FS_ONBOARDBASICINFO = "fs_onboardbasicinfo";
    private static final String FS_PERSONNELMATTERS = "fs_personnelmatters";
    private static final String FS_LEADER1 = "fs_leader1";
    private static final String AJOBSCMORGAP = "ajobscmorgap";
    private static final String FS_CHECKIN_BAK = "fs_checkin_bak";
    private static final String FS_CHECKIN = "fs_checkin";
    private static final String EFFECTDATEBAK = "effectdatebak";
    private static final String ONBRDTCITYBAK = "onbrdtcitybak";
    private static final String JOB = "job";
    private static final String FIRST = "first";
    private Map<String, PropertyChange> propertyChangedMap = ImmutableMap.builder().put((Object)"apositiontype", this::changeWithApositiontype).put((Object)"stdposition", this::changeWithStandAposition).put((Object)"aposition", this::changeWithAposition).put((Object)"ajob", this::changeWithAjob).put((Object)"job", this::changeWithJob).put((Object)"ajobscm", this::changeWithAjobscm).put((Object)"ajobscmorg", this::changeWithAjobscmorg).put((Object)"aadminorg", this::changeWithAadminorg).put((Object)"affaction", this::changeWithAffaction).put((Object)"peremail", this::changeWithEmail).put((Object)"phone", this::changeWithPhone).put((Object)"name", this::changeWithName).put((Object)"employeeno", this::changeWithEmployeeNo).put((Object)"certificatetype", this::changeWithCertificate).put((Object)"certificatenumber", this::changeWithCertificate).put((Object)"picturefield", this::changeWithPicturefield).put((Object)"teacher", this::changeWithTeacher).put((Object)"isprobation", this::changeWithIsprobation).put((Object)"baselocation", this::changeWithBaselocation).put((Object)"laborrelstatus", this::changeWithLaborrelstatus).put((Object)"effectdatebak", this::changeWithEffectDateBak).put((Object)"probationtime", this::calculateTransDate).put((Object)"perprobationtime", this::calculateTransDate).build();
    private static ThreadLocal<String> tipNotification = new ThreadLocal();

    public void beforeBindData(EventObject eventObject) {
        DynamicObject candidate;
        super.beforeBindData(eventObject);
        DynamicObject onbrdBill = this.getModel().getDataEntity();
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        if (HRStringUtils.isEmpty((String)parentPageId)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"persononbrdhead"});
        } else {
            IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
            if (parentView.getFormShowParameter().getFormId() != null && parentView.getFormShowParameter().getFormId().startsWith("wf_")) {
                this.showEntryBaseInfo("hom_onbrddetailhead", "persononbrdhead", onbrdBill.getLong("id"), "");
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"persononbrdhead"});
            }
        }
        this.setDefaultVaule();
        ApBuildUtils.setTextMaxLen(this.getView(), 50, "peremail");
        String enrollStatus = onbrdBill.getString("enrollstatus");
        if (!HRStringUtils.equals((String)OnbrdStatusEnum.BREAK_UP.getValue(), (String)enrollStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_BREAKUPINFO});
        }
        if (HRStringUtils.isEmpty((String)enrollStatus) || OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_BASICINFO});
            this.getView().setVisible(Boolean.FALSE, new String[]{"enterprisein", "managementscopein"});
            HRPageCache pageCache = new HRPageCache(this.getView());
            pageCache.put(OperationStatus.ADDNEW.toString(), (Object)OperationStatus.ADDNEW.toString());
            this.setCandidateNumber();
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"name", "gender", "phone", "candidatenumber"}, (boolean)true);
            this.getView().setEnable(Boolean.FALSE, new String[]{"ajoblevel", "ajobgrade", "joblevelscm", "jobgradescm"});
        } else {
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"name", "candidatenumber", "certificatetype", "gender", "phone", "certificatenumber"}, (boolean)false);
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_BASICINFO});
            this.getView().setVisible(Boolean.TRUE, new String[]{"enterprisein", "managementscopein"});
        }
        if (HRStringUtils.equals((String)OnbrdStatusEnum.WAIT_START.toString(), (String)enrollStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{AJOBSCMORGAP, FS_CHECKIN});
            this.getView().setVisible(Boolean.TRUE, new String[]{FS_CHECKIN_BAK});
            IDataModel iDataModel = this.getModel();
            iDataModel.setValue(EFFECTDATEBAK, iDataModel.getValue("effectdate"));
            iDataModel.setValue(ONBRDTCITYBAK, iDataModel.getValue("onbrdtcity"));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FS_CHECKIN_BAK});
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"effectdate"}, (boolean)true);
        }
        DynamicObject aadminOrg = onbrdBill.getDynamicObject("aadminorg");
        if (HRObjectUtils.isEmpty((Object)aadminOrg)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"stdposition"});
        }
        if (HRObjectUtils.isEmpty((Object)(candidate = onbrdBill.getDynamicObject("candidate")))) {
            String billNo = (String)this.getView().getFormShowParameter().getCustomParam("billno");
            this.getModel().setValue("billno", (Object)billNo);
            return;
        }
        this.getModel().setValue("candidatenumber", (Object)candidate.getString("number"));
        this.getView().setEnable(Boolean.FALSE, new String[]{"candidatenumber", "certificatetype", "certificatenumber"});
        int status = this.getView().getFormShowParameter().getStatus().getValue();
        if (status == OperationStatus.VIEW.getValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"startschemaflex"});
        } else if (status == OperationStatus.EDIT.getValue()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"name", "gender", "phone", "peremail", "employeeno", FIELDGROUPPANELAP, "handler", "validuntil", "isprobation", "teacher", "resumeno", "offernumber", "effectdate"});
        }
    }

    private void setDefaultVaule() {
        this.getModel().beginInit();
        DynamicObject onbrdBill = this.getModel().getDataEntity();
        this.setPagePorp();
        this.getModel().setValue(JOB, this.getModel().getDataEntity().get("ajob"));
        this.getModel().setValue("transdate", (Object)DateUtils.setTransDate((DynamicObject)onbrdBill));
        this.setJobClassLongName();
        OnBrdHandleHelper.setLeader(this.getView());
        IPersonFileIntegrateService.getInstance().getResponsible(this.getView());
        if (HRObjectUtils.isEmpty((Object)this.getModel().getValue("perprobationtime"))) {
            this.getModel().setValue("perprobationtime", (Object)OnbrdPersonFieldConstants.PERPROBATIONTIME_VALUE_FORE);
        }
        this.getModel().endInit();
    }

    private void showEntryBaseInfo(String pageNumber, String targetKey, Long onbrdId, String billNo) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(targetKey);
        formShowParameter.setCustomParam("id", (Object)onbrdId);
        formShowParameter.setCustomParam("billno", (Object)billNo);
        formShowParameter.setCustomParam("viewtype", this.getView().getFormShowParameter().getCustomParam("viewtype"));
        formShowParameter.setFormId(pageNumber);
        formShowParameter.setStatus(OperationStatus.EDIT);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put(pageNumber, formShowParameter.getPageId());
        this.getView().showForm(formShowParameter);
    }

    private void setPagePorp() {
        this.setValueByOnbrdtype();
        this.setIsprobation();
        this.setValueByApositionTye();
        this.setTeacherNum();
    }

    public void afterCreateNewData(EventObject eventObject) {
        OperationStatus pageStatus;
        DynamicObject dependency;
        DynamicObject dependencytype;
        DynamicObject empgroup;
        DynamicObject certificatetype;
        IBaseDataDomainService instance = IBaseDataDomainService.getInstance();
        DynamicObject onbrdtype = instance.getBaseDataInfoById("hbss_onboardtype", BaseDataIdConstants.HBSS_ONBOARDTYPE_1010, "enable");
        if (onbrdtype != null && HRStringUtils.equals((String)"1", (String)onbrdtype.getString("enable"))) {
            this.getModel().setValue("onbrdtype", (Object)onbrdtype);
        }
        if ((certificatetype = instance.getBaseDataInfoById("hbss_credentialstype", BaseDataIdConstants.HBSS_CREDENTIALSTYPE_1010, "enable")) != null && HRStringUtils.equals((String)"1", (String)certificatetype.getString("enable"))) {
            this.getModel().setValue("certificatetype", (Object)certificatetype);
        }
        if ((empgroup = instance.getBaseDataInfoById("hbss_empgroup", BaseDataIdConstants.HBSS_EMPGROUP_1010, "enable")) != null && HRStringUtils.equals((String)"1", (String)empgroup.getString("enable"))) {
            this.getModel().setValue("empgroup", (Object)empgroup);
        }
        if ((dependencytype = instance.getBaseDataInfoById("hbss_depcytype", BaseDataIdConstants.HBSS_DEPCYTYPE_1010, "enable")) != null && HRStringUtils.equals((String)"1", (String)dependencytype.getString("enable"))) {
            this.getModel().setValue("dependencytype", (Object)dependencytype);
        }
        if ((dependency = instance.getBaseDataInfoById("bd_country", BaseDataConstants.BD_COUNTRY_ID_CHINA, "enable")) != null && HRStringUtils.equals((String)"1", (String)dependency.getString("enable"))) {
            this.getModel().setValue("dependency", (Object)dependency);
        }
        if (OperationStatus.ADDNEW.compareTo((Enum)(pageStatus = this.getView().getFormShowParameter().getStatus())) == 0) {
            IFormView parentView = this.getView().getParentView();
            IPageCache pageCache = this.getView().getPageCache();
            String first = pageCache.get(FIRST);
            if (first == null) {
                pageCache.put(FIRST, "true");
            }
            if (parentView != null && "true".equals(pageCache.get(FIRST))) {
                String org;
                String sourceSSCMenu = (String)parentView.getFormShowParameter().getCustomParam("sourceSSCMenu");
                LOGGER.info("###OnmbrdInfoEdit.appId={}", (Object)sourceSSCMenu);
                if ((HRStringUtils.isBlank((CharSequence)sourceSSCMenu) || Boolean.FALSE.toString().equals(sourceSSCMenu)) && (parentView = parentView.getParentView()) != null && (org = parentView.getPageCache().get("org_cache")) != null) {
                    JSONArray parse = JSON.parseArray((String)org);
                    this.getModel().setValue("org", parse.toJavaList(Long.class).get(0));
                }
            }
            pageCache.put(FIRST, "false");
        }
    }

    private void setTeacherNum() {
        DynamicObject teachDyo = this.getModel().getDataEntity().getDynamicObject("teacher");
        if (Objects.isNull(teachDyo)) {
            this.getModel().setValue("teachernumber", (Object)"");
        } else {
            this.getModel().setValue("teachernumber", teachDyo.get("number"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        DynamicObject onbrdBill;
        super.afterDoOperation(afterDoOperationEventArgs);
        String tipMsg = tipNotification.get();
        if (HRStringUtils.isNotEmpty((String)tipMsg)) {
            afterDoOperationEventArgs.getOperationResult().setMessage(tipMsg);
            LOGGER.info("tipNotification.get():{}", (Object)tipMsg);
            tipNotification.remove();
        }
        boolean success = false;
        if (!ObjectUtils.isEmpty((Object)afterDoOperationEventArgs.getOperationResult())) {
            success = afterDoOperationEventArgs.getOperationResult().isSuccess();
        }
        LOGGER.info(afterDoOperationEventArgs.getOperateKey());
        if (success && "save".equals(afterDoOperationEventArgs.getOperateKey())) {
            LOGGER.info("operationResult().getMessage():" + afterDoOperationEventArgs.getOperationResult().getMessage());
            onbrdBill = this.getModel().getDataEntity();
            DynamicObject candidate = onbrdBill.getDynamicObject("candidate");
            if (HRObjectUtils.isEmpty((Object)candidate)) {
                return;
            }
            HRPageCache pageCache = new HRPageCache(this.getView());
            String addNew = (String)pageCache.get(OperationStatus.ADDNEW.toString(), String.class);
            if (OperationStatus.ADDNEW.toString().equals(addNew)) {
                this.saveHcfContactAndBaseInfo(onbrdBill, candidate);
            }
            String enrollStatus = onbrdBill.getString("enrollstatus");
            if (OnbrdStatusEnum.WAIT_START.toString().equals(enrollStatus) || OnbrdStatusEnum.WAIT_ONBRD.toString().equals(enrollStatus)) {
                this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
                this.getView().updateView();
            }
        }
        if (success && "view_candidateinfo".equals(afterDoOperationEventArgs.getOperateKey())) {
            onbrdBill = this.getModel().getDataEntity();
            IOnbrdCommonAppService.getInstance().openOnbrdCandidateInfoPage(this.getView(), onbrdBill);
        }
    }

    private void saveHcfContactAndBaseInfo(DynamicObject onbrdBill, DynamicObject candidate) {
        Long cerType;
        DynamicObject certificateType;
        IHomToHcfAppService homToHcfAppService = IHomToHcfAppService.getInstance();
        DynamicObject candidateConInfo = homToHcfAppService.getSingleRowEntity(Long.valueOf(candidate.getLong("id")), "hcf_cancontactinfo");
        DynamicObject canBaseInfo = homToHcfAppService.getSingleRowEntity(Long.valueOf(candidate.getLong("id")), "hcf_canbaseinfo");
        DynamicObject candidateConInfoNew = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_cancontactinfo"));
        DynamicObject canBaseInfoNew = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_canbaseinfo"));
        if (!HRObjectUtils.isEmpty((Object)canBaseInfo)) {
            HRDynamicObjectUtils.copy((DynamicObject)canBaseInfo, (DynamicObject)canBaseInfoNew);
            canBaseInfoNew.set("id", (Object)0L);
            canBaseInfoNew.set("sourcevid", (Object)0L);
        }
        candidateConInfoNew.set("phone", onbrdBill.get("phone"));
        candidateConInfoNew.set("peremail", onbrdBill.get("peremail"));
        candidateConInfoNew.set("candidate", (Object)candidate);
        candidateConInfoNew.set("boid", HRObjectUtils.isEmpty((Object)candidateConInfo) ? null : Long.valueOf(candidateConInfo.getLong("boid")));
        String name = onbrdBill.getString("name");
        canBaseInfoNew.set("gender", onbrdBill.get("gender"));
        canBaseInfoNew.set("name", onbrdBill.get("name"));
        canBaseInfoNew.set("candidate", (Object)candidate);
        canBaseInfoNew.set("boid", HRObjectUtils.isEmpty((Object)canBaseInfo) ? null : Long.valueOf(canBaseInfo.getLong("boid")));
        String pinyin = "";
        try {
            pinyin = PinyinUtil.converterToSpell((String)name);
            LOGGER.info("name:{} pinyin:{}", (Object)name, (Object)pinyin);
        }
        catch (Exception exp) {
            LOGGER.error((Throwable)exp);
        }
        if (canBaseInfo == null || HRStringUtils.isEmpty((String)canBaseInfo.getString("nameen"))) {
            canBaseInfoNew.set("nameen", (Object)pinyin);
        }
        if (!HRObjectUtils.isEmpty((Object)(certificateType = onbrdBill.getDynamicObject("certificatetype"))) && HcfCanCreConstants.CREDENTIALSTYPE_ID_IDCARD.equals(cerType = Long.valueOf(certificateType.getLong("id")))) {
            String certNum = onbrdBill.getString("certificatenumber");
            Date birthDay = IDCardUtils.getBirthDay((String)certNum);
            canBaseInfoNew.set("birthday", (Object)birthDay);
        }
        canBaseInfoNew.set("nationality", (Object)onbrdBill.getLong("nationality.id"));
        ArrayList candidates = new ArrayList();
        HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>();
        HashMap<String, DynamicObjectCollection> baseMap = new HashMap<String, DynamicObjectCollection>();
        map.put("hcf_cancontactinfo", Arrays.stream(new DynamicObject[]{candidateConInfoNew}).collect(Collectors.toCollection(DynamicObjectCollection::new)));
        baseMap.put("hcf_canbaseinfo", Arrays.stream(new DynamicObject[]{canBaseInfoNew}).collect(Collectors.toCollection(DynamicObjectCollection::new)));
        candidates.add(map);
        candidates.add(baseMap);
        IHomToHcfAppService.getInstance().saveOrUpdateCandidates(candidates);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.showJobInfoPlane();
        LOGGER.info("start to setDataChanged");
        this.getModel().setDataChanged(false);
        this.getView().setEnable(Boolean.FALSE, new String[]{"isprobation"});
        this.showCadreInfo();
        this.getModel().setValue(EFFECTDATEBAK, this.getModel().getValue("effectdate"));
        LOGGER.info("end to setDataChanged");
    }

    private void showCadreInfo() {
        String cadreInfoEnable = ((IHomConfigService)ServiceFactory.getService(IHomConfigService.class)).getConfVal("cadre.info.enable", "false");
        this.getView().setVisible(Boolean.valueOf(cadreInfoEnable), new String[]{"cadreinfo"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        LOGGER.info("onbrdinfo opkey=={}", (Object)opKey);
        if (HRStringUtils.equals((String)"save", (String)opKey)) {
            String validateEffectDateResult;
            Boolean aBoolean;
            String employeeno;
            IDataModel iDataModel = this.getModel();
            String enrollStatus = iDataModel.getDataEntity().getString("enrollstatus");
            if (HRStringUtils.equals((String)OnbrdStatusEnum.WAIT_START.toString(), (String)enrollStatus)) {
                iDataModel.setValue("effectdate", iDataModel.getValue(EFFECTDATEBAK));
                iDataModel.setValue("onbrdtcity", iDataModel.getValue(ONBRDTCITYBAK));
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{FS_CHECKIN_BAK});
            }
            if (iDataModel.getDataEntity().getBoolean("isprobation")) {
                if (OnbrdPersonFieldConstants.PROBATIONTIME_VALUE_ZERO.equals(iDataModel.getDataEntity().get("probationtime"))) {
                    this.getModel().setValue("probationtime", null);
                }
                if (OnbrdPersonFieldConstants.PERPROBATIONTIME_VALUE_FORE.equals(iDataModel.getDataEntity().getInt("perprobationtime"))) {
                    this.getModel().setValue("perprobationtime", (Object)OnbrdPersonFieldConstants.PERPROBATIONTIME_VALUE_ONE);
                }
            }
            this.validateCandidateNumber();
            ILocaleString name = this.getModel().getDataEntity().getLocaleString("name");
            if (name != null && !name.isEmpty() && name.getLocaleValue() != null) {
                name.setLocaleValue(name.getLocaleValue().trim());
                this.getModel().setValue("name", (Object)name);
            }
            if (ViewTypeEnum.AGAIN.getCode().equals(this.getModel().getValue("viewtype"))) {
                DynamicObject dataEntity;
                QFilter qFilter;
                ReentryRuleService reentryRuleService;
                DynamicObject employeeObj;
                String ecSwitch = ((IHomConfigDomainService)ServiceFactory.getService(IHomConfigDomainService.class)).getConfig(this.getView(), "employeeno_connection_switch", "employeeno_connection_switch");
                if ("true".equals(ecSwitch)) {
                    this.getModel().setValue("employeeno", this.getModel().getValue("newemployeeno"));
                    this.getModel().setValue("oemployeeno", this.getModel().getValue("oldemployeeno"));
                }
                if ((employeeObj = (reentryRuleService = ReentryRuleService.getInstance()).getCommonPersonObj("hrpi_employee", "person,mid", qFilter = new QFilter("id", "=", (Object)(dataEntity = this.getModel().getDataEntity()).getLong("personfield.id")), true)) != null) {
                    this.getModel().setValue("mid", (Object)employeeObj.getLong("mid"));
                    long personId = employeeObj.getLong("person.id");
                    DynamicObject personIdObj = reentryRuleService.getCommonPersonObj("hrpi_person", "personindexid", new QFilter("id", "=", (Object)personId), false);
                    if (personIdObj != null) {
                        this.getModel().setValue("personindexid", (Object)personIdObj.getLong("personindexid"));
                    }
                }
            }
            if ((employeeno = this.getModel().getDataEntity().getString("employeeno")) != null) {
                LOGGER.info("employeeno:{}", (Object)employeeno);
                this.getModel().setValue("employeeno", (Object)employeeno.trim());
            }
            String blacklistValidStatus = this.getModel().getDataEntity().getString("passblackliststatus");
            LOGGER.info("OnbrdInfoEdit.beforeDoOperation.passblackliststatus:{}", (Object)blacklistValidStatus);
            if (!HRStringUtils.equals((String)OnbrdBlackListStatusEnum.PASS.getValue(), (String)blacklistValidStatus) && !(aBoolean = this.blackListValid(true, true)).booleanValue()) {
                args.setCancel(true);
                args.setCancelMessage("inblacklist");
                return;
            }
            if (ViewTypeEnum.AGAIN.getCode().equals(this.getModel().getValue("viewtype"))) {
                this.switchSetMustInput();
            }
            HRPluginProxy hrProxyService = HRPlugInProxyFactory.create((Object)new OnbrdInfoServiceImpl(), IOnbrdInfoService.class, (String)"kd.sdk.hr.hom.service.IOnbrdInfoService", null);
            AtomicReference validateMandatoryResult = new AtomicReference(Optional.empty());
            hrProxyService.callReplaceIfPresent(hrProxy -> {
                validateMandatoryResult.set(hrProxy.validateFieldMandatory(this.getView()));
                return null;
            });
            if (validateMandatoryResult.get().isPresent()) {
                args.setCancel(true);
                args.setCancelMessage((String)validateMandatoryResult.get().get());
                return;
            }
            if (!this.validateDataCompliance(args)) {
                args.setCancel(true);
                return;
            }
            IPreOnBrdService service = (IPreOnBrdService)ServiceFactory.getService(IPreOnBrdService.class);
            Table validatePreOnbrdMap = service.validatePreOnbrd(new DynamicObject[]{this.getModel().getDataEntity()});
            if (!validatePreOnbrdMap.isEmpty()) {
                args.setCancel(true);
                Set cells = validatePreOnbrdMap.cellSet();
                for (Table.Cell cell : cells) {
                    args.setCancelMessage(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6709\u5728\u9014\u7684\u9884\u5165\u804c\u7533\u8bf7\uff08\u5355\u636e\u7f16\u53f7\uff1a%s\uff09\uff0c\u4e0d\u53ef\u4e3a\u540c\u4e00\u4eba\u5458\u91cd\u590d\u53d1\u8d77\u3002", (String)"OnbrdInfoEdit_23", (String)"hr-hom-formplugin", (Object[])new Object[0]), ((DynamicObject)cell.getValue()).getString("prebatchonbrd.billno")));
                }
                return;
            }
            ArrayList<Long> adminorgIds = new ArrayList<Long>();
            adminorgIds.add(this.getModel().getDataEntity().getLong("aadminorg.id"));
            Map stringBooleanMap = ((IOnbrdService)ServiceFactory.getService(IOnbrdService.class)).validateVirtuallyOrg(adminorgIds, new Date());
            if (!HRObjectUtils.isEmpty((Object)stringBooleanMap) && stringBooleanMap.getOrDefault(this.getModel().getDataEntity().getString("aadminorg.id"), Boolean.FALSE).booleanValue()) {
                args.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e3a\u865a\u62df\u7ec4\u7ec7\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u7ec4\u7ec7\u3002", (String)"OnbrdInfoEdit_27", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean isNewBill = false;
            DynamicObject candidate = this.getModel().getDataEntity().getDynamicObject("candidate");
            if (HRObjectUtils.isEmpty((Object)candidate)) {
                isNewBill = true;
                boolean candidateDuplicated = this.validateDuplicateWithCandidateNum(args);
                if (candidateDuplicated) {
                    args.setCancel(true);
                    return;
                }
                this.addCandiadteIfNotExist();
                this.synCanCertificate();
            }
            if (HRStringUtils.isNotEmpty((String)(validateEffectDateResult = IOnbrdCommonAppService.getInstance().validateEffectDateWithOrgField(this.getModel().getDataEntity())))) {
                args.setCancel(true);
                args.setCancelMessage(validateEffectDateResult);
                return;
            }
            Optional<String> validateStaffUseResult = this.validateStaffUse(isNewBill);
            if (validateStaffUseResult.isPresent()) {
                args.setCancel(true);
                args.setCancelMessage(validateStaffUseResult.get());
            }
            this.getView().getPageCache().remove("candidatenumber");
        }
    }

    private void switchSetMustInput() {
        String scSwitch;
        String ecSwitch;
        String cspSwitch = ((IHomConfigDomainService)ServiceFactory.getService(IHomConfigDomainService.class)).getConfig(this.getView(), "connection_scheme_panel_switch", "connection_scheme_panel_switch");
        if (!"true".equals(cspSwitch)) {
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"employeenoscheme", "serviceagescheme"}, (boolean)false);
        }
        if (!"true".equals(ecSwitch = ((IHomConfigDomainService)ServiceFactory.getService(IHomConfigDomainService.class)).getConfig("employeeno_connection_switch"))) {
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"employeenoscheme"}, (boolean)false);
        }
        if (!"true".equals(scSwitch = ((IHomConfigDomainService)ServiceFactory.getService(IHomConfigDomainService.class)).getConfig("seniority_connection_switch"))) {
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"serviceagescheme"}, (boolean)false);
        }
    }

    private Optional<String> validateStaffUse(boolean isNewBill) {
        DynamicObject onbrdBill = this.getModel().getDataEntity();
        boolean ifWaitStart = HRStringUtils.equals((String)OnbrdStatusEnum.WAIT_START.getValue(), (String)onbrdBill.getString("enrollstatus"));
        StaffQueryOutParam staffQueryOutParam = null;
        IStaffUseService staffUseService = IStaffUseService.getInstance();
        if (isNewBill || ifWaitStart) {
            staffQueryOutParam = staffUseService.queryStaffUseInfo(onbrdBill, "NEW");
        } else {
            QFilter filter = new QFilter("id", "=", (Object)onbrdBill.getLong("id"));
            DynamicObject onbrdBillFromDB = IOnbrdBillDomainService.getInstance().findOnbrdBill(staffUseService.getSelectProperties(), new QFilter[]{filter});
            if (staffUseService.judgeIfChangedWithDimension(onbrdBillFromDB, onbrdBill, staffUseService.getDimensionSet())) {
                staffQueryOutParam = staffUseService.queryStaffUseInfo(onbrdBill, "UPDATE");
            }
        }
        if (staffQueryOutParam != null && !staffQueryOutParam.isAllow() && !CollectionUtils.isEmpty((Collection)staffQueryOutParam.getReasonList())) {
            LOGGER.info("staffQueryOutParam:{}", (Object)JSON.toJSONString((Object)staffQueryOutParam));
            StringBuilder sbTips = new StringBuilder();
            for (String msg : staffQueryOutParam.getReasonList()) {
                sbTips.append(msg);
            }
            if (isNewBill || ifWaitStart) {
                tipNotification.set(sbTips.toString());
                LOGGER.info("tipNotification.set");
            } else {
                return Optional.of("validateStaffUseResult:" + sbTips);
            }
        }
        return Optional.empty();
    }

    private boolean validateDataCompliance(BeforeDoOperationEventArgs args) {
        Optional<String> numberResult;
        LOGGER.info("onbrdinfo validatedate");
        Optional<String> dateResult = this.validateEffectDate();
        if (dateResult.isPresent()) {
            LOGGER.info("onbrdinfo validatedate false");
            args.setCancelMessage(dateResult.get());
            return false;
        }
        DynamicObject data = this.getModel().getDataEntity();
        if (HRStringUtils.equals((String)data.getString("viewtype"), (String)ViewTypeEnum.AGAIN.getCode()) && HRStringUtils.equals((String)data.getString("employeenoscheme"), (String)EmployeeNoSchemeEnum.NEW_EMPLOYEE_NO.getValue()) && (numberResult = this.validateEmpNumber()).isPresent()) {
            args.setCancelMessage(numberResult.get());
            return false;
        }
        Optional<String> creNumberResult = this.validateCreNumber();
        if (creNumberResult.isPresent()) {
            args.setCancelMessage(creNumberResult.get());
            return false;
        }
        Optional<String> emailResult = this.validateEmail();
        if (emailResult.isPresent()) {
            args.setCancelMessage(emailResult.get());
            return false;
        }
        Optional<String> phoneResult = this.validatePhone();
        if (phoneResult.isPresent()) {
            args.setCancelMessage(phoneResult.get());
            return false;
        }
        Optional<String> employeeNoResult = this.validEmployeeNo();
        if (employeeNoResult.isPresent()) {
            args.setCancelMessage(employeeNoResult.get());
            return false;
        }
        Optional nameResult = IOnbrdCommonAppService.getInstance().validateF7Name(this.getView());
        if (nameResult.isPresent()) {
            args.setCancelMessage((String)nameResult.get());
            return false;
        }
        Optional<String> personIsExistResult = this.validPersonIsExistByHspm("");
        if (personIsExistResult.isPresent()) {
            args.setCancelMessage(personIsExistResult.get());
            return false;
        }
        Optional<String> validNumberRes = this.validNumber(data, this.getView());
        if (validNumberRes.isPresent()) {
            args.setCancelMessage(validNumberRes.get());
            return false;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Map validEntryDateOfQuitDateMap = IValidEntryDateService.getInstance().validEntryDateOfQuitDate(new DynamicObject[]{dataEntity}, false);
        Optional message = validEntryDateOfQuitDateMap.getOrDefault(dataEntity.getLong("personfield.id"), Optional.empty());
        if (message.isPresent()) {
            this.getView().showTipNotification((String)message.get());
            args.setCancelMessage((String)message.get());
            return false;
        }
        return true;
    }

    private Optional<String> validateEffectDate() {
        DynamicObject data = this.getModel().getDataEntity();
        Date effectDate = data.getDate("effectdate");
        Date validuntil = data.getDate("validuntil");
        if (effectDate != null && validuntil != null && HRDateTimeUtils.dayAfter((Date)effectDate, (Date)validuntil)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            return Optional.of(String.format(ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f\u9700\u5728\u5165\u804c\u6709\u6548\u671f\uff08%s\uff09\u5185\u3002", (String)"ReservationOnbrdPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]), format.format(validuntil)));
        }
        return Optional.empty();
    }

    private Optional<String> validateEmpNumber() {
        DynamicObject data = this.getModel().getDataEntity();
        String newEmpNo = data.getString("employeeno");
        String oldEmpNo = data.getString("oemployeeno");
        if (StringUtils.isNotBlank((CharSequence)newEmpNo) && HRStringUtils.equals((String)newEmpNo, (String)oldEmpNo)) {
            this.getModel().setValue("newemployeeno", (Object)"");
            return Optional.of(ResManager.loadKDString((String)"\u65b0\u5de5\u53f7\u4e0d\u5141\u8bb8\u4e0e\u539f\u5de5\u53f7\u76f8\u540c\u3002", (String)"ReservationOnbrdPlugin_7", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    private boolean validateDuplicateWithCandidateNum(BeforeDoOperationEventArgs args) {
        String candidateNumber = this.getModel().getDataEntity().getString("candidatenumber");
        if (new OnbrdCommonAppServiceImpl().validateDuplicateWithCandidateNum(candidateNumber)) {
            String oldCancelMessage = args.getCancelMessage() == null ? "" : args.getCancelMessage() + System.lineSeparator();
            args.setCancelMessage(String.format(ResManager.loadKDString((String)"%s\u5019\u9009\u4eba\u7f16\u53f7\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff1b", (String)"OnbrdInfoEdit_1", (String)"hr-hom-formplugin", (Object[])new Object[0]), oldCancelMessage));
            return true;
        }
        return false;
    }

    private void addCandiadteIfNotExist() {
        DynamicObject onbrdBill = this.getModel().getDataEntity();
        DynamicObject candidate = onbrdBill.getDynamicObject("candidate");
        if (!HRObjectUtils.isEmpty((Object)candidate)) {
            return;
        }
        String candidateNumber = this.getModel().getDataEntity().getString("candidatenumber");
        if (HRStringUtils.isEmpty((String)candidateNumber)) {
            return;
        }
        DynamicObject candidateNew = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_candidate"));
        candidateNew.set("name", (Object)onbrdBill.getString("name"));
        candidateNew.set("number", (Object)candidateNumber);
        DynamicObject candidateFromDB = new HcfDataDomainService().saveCandidate(candidateNew);
        onbrdBill.set("candidate", (Object)candidateFromDB);
    }

    private void synCanCertificate() {
        DynamicObject onbrdBill = this.getModel().getDataEntity();
        Long candidateId = onbrdBill.getLong("candidate.id");
        DynamicObject certificateType = onbrdBill.getDynamicObject("certificatetype");
        if (HRObjectUtils.isEmpty((Object)certificateType)) {
            LOGGER.info("certificateType is empty");
            return;
        }
        long cerType = certificateType.getLong("id");
        String certificateNumber = onbrdBill.getString("certificatenumber");
        DynamicObject certificateDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_cancre"));
        if (HcfCanCreConstants.CREDENTIALSTYPE_ID_IDCARD == cerType) {
            String certNum = onbrdBill.getString("certificatenumber");
            Date birthDay = IDCardUtils.getBirthDay((String)certNum);
            certificateDy.set("birthdate", (Object)birthDay);
        }
        certificateDy.set("id", (Object)ORM.create().genLongId("hcf_cancre"));
        certificateDy.set("candidate", (Object)candidateId);
        certificateDy.set("credentialstype", (Object)certificateType);
        certificateDy.set("number", (Object)certificateNumber);
        certificateDy.set("ismajor", (Object)Boolean.TRUE);
        certificateDy.set("percardname", onbrdBill.get("name"));
        certificateDy.set("gender", onbrdBill.get("gender"));
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.add((Object)certificateDy);
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("hcf_cancre", collection);
        ArrayList<HashMap> list = new ArrayList<HashMap>(1);
        list.add(map);
        Map result = IHomToHcfAppService.getInstance().saveOrUpdateCandidates(list);
        Boolean isSuccess = Boolean.valueOf(result.get("success").toString());
        if (!isSuccess.booleanValue()) {
            LOGGER.error("Fail to synCanCertificate: " + String.valueOf(result.get("message")));
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String name = propertyChangedArgs.getProperty().getName();
        PropertyChange propertyChange = this.propertyChangedMap.get(name);
        if (propertyChange != null) {
            propertyChange.doSomethings(propertyChangedArgs);
        }
        this.showJobInfoPlane();
    }

    private void changeWithAadminorg(PropertyChangedArgs propertyChangedArgs) {
        this.setValueByAadminorg(propertyChangedArgs);
    }

    private void changeWithAjobscmorg(PropertyChangedArgs propertyChangedArgs) {
        this.setValueByAjobscmorg();
    }

    private void changeWithAjobscm(PropertyChangedArgs propertyChangedArgs) {
        this.setValueByAjobscm();
    }

    private void changeWithApositiontype(PropertyChangedArgs propertyChangedArgs) {
        this.setNullWhenApositionTyeChange();
        this.getView().setEnable(Boolean.FALSE, new String[]{"ajoblevel", "ajobgrade", "joblevelscm", "jobgradescm"});
        this.setValueByApositionTye();
        OnBrdHandleHelper.setLeader(this.getView());
    }

    private void changeWithAjob(PropertyChangedArgs propertyChangedArgs) {
        this.setValueByAjob();
    }

    private void changeWithStandAposition(PropertyChangedArgs propertyChangedArgs) {
        this.setValueByStandAposition();
    }

    private void changeWithAposition(PropertyChangedArgs propertyChangedArgs) {
        this.setValueByAposition();
    }

    private void changeWithBaselocation(PropertyChangedArgs propertyChangedArgs) {
        this.setContractLocation();
    }

    private void changeWithLaborrelstatus(PropertyChangedArgs propertyChangedArgs) {
        this.setValueByLaborrelstatus();
    }

    private void setValueByLaborrelstatus() {
        DynamicObject onbrdBill = this.getModel().getDataEntity();
        Long laborrelstatuscls = onbrdBill.getLong("laborrelstatus.labrelstatuscls.id");
        if (BaseDataIdConstants.HBSS_LABRELSTATUSCLS_1010.equals(laborrelstatuscls)) {
            this.getModel().setValue("isprobation", (Object)Boolean.TRUE);
        } else {
            this.getModel().setValue("isprobation", (Object)Boolean.FALSE);
            this.getModel().setValue("probationtime", (Object)OnbrdPersonFieldConstants.PROBATIONTIME_VALUE_ZERO);
            this.getModel().setValue("perprobationtime", (Object)OnbrdPersonFieldConstants.PERPROBATIONTIME_VALUE_FORE);
        }
    }

    private void changeWithIsprobation(PropertyChangedArgs args) {
        this.setIsprobation();
        this.calculateTransDate(args);
    }

    private void changeWithTeacher(PropertyChangedArgs propertyChangedArgs) {
        this.setTeacherNum();
    }

    private void changeWithPicturefield(PropertyChangedArgs propertyChangedArgs) {
        this.changeHeadPhoto();
    }

    private void changeWithAffaction(PropertyChangedArgs propertyChangedArgs) {
        this.setChgDefaultData();
    }

    private void changeWithEmployeeNo(PropertyChangedArgs propertyChangedArgs) {
        DynamicObject dataEntity;
        String number;
        ChangeData[] changeDatas = propertyChangedArgs.getChangeSet();
        if (changeDatas != null && changeDatas.length > 0) {
            for (ChangeData changeData : changeDatas) {
                LOGGER.info("OldValue:{},NewValue:{}", changeData.getOldValue(), changeData.getNewValue());
            }
        }
        if (HRStringUtils.isBlank((CharSequence)(number = (dataEntity = this.getModel().getDataEntity()).getString("employeeno")))) {
            return;
        }
        LOGGER.info("employeeno:{}", (Object)number);
        Optional<String> numRes = this.validEmployeeNo();
        if (numRes.isPresent()) {
            return;
        }
        Optional<String> validPersonIsExist = this.validPersonIsExistByHspm("employeeno");
        if (validPersonIsExist.isPresent()) {
            return;
        }
        Optional<String> validNumberRes = this.validNumber(dataEntity, this.getView());
        if (validNumberRes.isPresent()) {
            return;
        }
    }

    private Optional<String> validNumber(DynamicObject dataEntity, IFormView view) {
        return IOnbrdCommonAppService.getInstance().validNumber(dataEntity, view);
    }

    private void changeWithPhone(PropertyChangedArgs propertyChangedArgs) {
        Optional<String> phoneRes = this.validatePhone();
        if (phoneRes.isPresent()) {
            return;
        }
        Optional<String> validPersonResult = this.validPersonIsExistByHspm("phone");
        if (validPersonResult.isPresent()) {
            return;
        }
        this.blackListValid(false, false);
    }

    private void changeWithName(PropertyChangedArgs propertyChangedArgs) {
        ChangeData[] changeSet = propertyChangedArgs.getChangeSet();
        LocaleDynamicObjectCollection newValueList = (LocaleDynamicObjectCollection)changeSet[0].getNewValue();
        LocaleDynamicObjectCollection oldValueList = (LocaleDynamicObjectCollection)changeSet[0].getOldValue();
        if (HRCollUtil.isEmpty((Collection)newValueList) || HRCollUtil.isNotEmpty((Collection)oldValueList) && ((DynamicObject)newValueList.get(0)).getString("name").equals(((DynamicObject)oldValueList.get(0)).getString("name"))) {
            return;
        }
        this.blackListValid(false, false);
    }

    private void changeWithEmail(PropertyChangedArgs propertyChangedArgs) {
        this.blackListValid(false, false);
        Optional<String> emailRes = this.validateEmail();
        if (!emailRes.isPresent()) {
            this.validPersonIsExistByHspm("peremail");
        }
    }

    private void changeWithCertificate(PropertyChangedArgs propertyChangedArgs) {
        Optional<String> result;
        Optional<String> creNumRes = this.validateCreNumber();
        if (creNumRes.isPresent()) {
            return;
        }
        Boolean validResult = this.blackListValid(false, false);
        if (!validResult.booleanValue()) {
            return;
        }
        this.formerEmployeeValid();
        String credentialsNumber = this.getModel().getDataEntity().getString("certificatenumber");
        if (HRStringUtils.isNotEmpty((String)credentialsNumber) && (result = this.validPersonIsExistByHspm("certificatenumber")).isPresent()) {
            return;
        }
    }

    private void formerEmployeeValid() {
        String viewType = (String)this.getModel().getValue("viewtype");
        if (ViewTypeEnum.ROUTINE.getCode().equals(viewType)) {
            Long credentialsType = this.getModel().getDataEntity().getLong("certificatetype.id");
            String credentialsNumber = this.getModel().getDataEntity().getString("certificatenumber");
            if (credentialsType == 0L || HRStringUtils.isBlank((CharSequence)credentialsNumber)) {
                return;
            }
            Map result = IHomToHrpiAppService.getInstance().isFormerEmployeeByCreNumberAndCreType((List)ImmutableList.of((Object)credentialsNumber), credentialsType);
            if (CollectionUtils.isEmpty((Map)result)) {
                return;
            }
            Map resultMap = (Map)result.get(credentialsNumber);
            if (!CollectionUtils.isEmpty((Map)resultMap)) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u518d\u5165\u804c\u7533\u8bf7", (String)"OnbrdInfoEdit_19", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                showParameter.setFormId("hom_persononbrdhandlebody");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.ADDNEW);
                showParameter.setPageId(this.getView().getPageId() + "hom_persononbrdhandlebody");
                showParameter.setCustomParam("onbrdid", (Object)"0");
                showParameter.setCustomParam("candidateid", (Object)"0");
                showParameter.setCustomParam("viewtype", (Object)ViewTypeEnum.AGAIN.getCode());
                showParameter.setCustomParam("routine_skip", (Object)Boolean.TRUE);
                DynamicObject dynamicObject = new HRBaseServiceHelper("hom_reentrypersonconfirm").generateEmptyDynamicObject();
                dynamicObject.set("personfield", resultMap.get("personfield"));
                showParameter.setCustomParam("personindexid", resultMap.get("personindexid"));
                showParameter.setCustomParam("piddata", (Object)SerializationUtils.serializeToBase64((Object)dynamicObject));
                showParameter.setCustomParam("change_b_ermanfile", (Object)"1");
                this.getModel().setDataChanged(false);
                IFormView parentView = this.getView().getParentView();
                if (parentView != null) {
                    parentView.close();
                    this.getView().sendFormAction(parentView);
                }
                this.getView().showForm(showParameter);
            }
        }
    }

    private void showJobInfoPlane() {
        IDataModel iDataModel = this.getModel();
        if (HRObjectUtils.isEmpty((Object)iDataModel.getValue("ajobscmorg")) && HRObjectUtils.isEmpty((Object)iDataModel.getValue("ajobscm")) && HRObjectUtils.isEmpty((Object)iDataModel.getValue("ajob"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{AJOBSCMORGAP});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{AJOBSCMORGAP});
        }
        String apositionType = this.getModel().getDataEntity().getString("apositiontype");
        if (HRStringUtils.equals((String)"2", (String)apositionType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{AJOBSCMORGAP});
        }
    }

    private Optional<String> validEmployeeNo() {
        return IOnbrdCommonAppService.getInstance().vaildSameFieldByHom("employeeno", this.getView());
    }

    private void setContractLocation() {
        DynamicObject baseLocDyo = this.getModel().getDataEntity().getDynamicObject("baselocation");
        DynamicObject contractLocDyo = this.getModel().getDataEntity().getDynamicObject("contractlocation");
        if (Objects.isNull(baseLocDyo)) {
            return;
        }
        if (baseLocDyo.getBoolean("iscontractworkplace") && Objects.isNull(contractLocDyo)) {
            this.getModel().setValue("contractlocation", (Object)baseLocDyo);
        }
    }

    private void setValueByOnbrdtype() {
        DynamicObject affaction = this.getModel().getDataEntity().getDynamicObject("affaction");
        if (!HRObjectUtils.isEmpty((Object)affaction)) {
            return;
        }
        DynamicObject onbrdType = this.getModel().getDataEntity().getDynamicObject("onbrdtype");
        if (HRObjectUtils.isEmpty((Object)onbrdType)) {
            return;
        }
        OnbrdInfoInitService onbrdInfoInitService = new OnbrdInfoInitService();
        this.getModel().setValue("affaction", (Object)onbrdInfoInitService.getChgactionIdByOnbrdType(onbrdType));
        this.setChgDefaultData();
    }

    private void setValueByAjobLevel() {
        DynamicObject ajoblevel = this.getModel().getDataEntity().getDynamicObject("ajoblevel");
        DynamicObject jobScmOrg = this.getModel().getDataEntity().getDynamicObject("ajobscmorg");
        if (!HOMObjectUtils.isEmpty((Object)ajoblevel) && !HRObjectUtils.isEmpty((Object)jobScmOrg)) {
            Long joblevelscmId = ajoblevel.getLong("joblevelscm.id");
            List<Long> hasPermJobLevelScmIds = this.getHasPermJobLevelScmIds(Collections.singletonList(joblevelscmId), jobScmOrg.getLong("id"));
            this.getModel().setValue("joblevelscm", hasPermJobLevelScmIds.isEmpty() ? null : hasPermJobLevelScmIds.get(0));
        }
    }

    private void setValueByAjobGrade() {
        DynamicObject jobgrade = this.getModel().getDataEntity().getDynamicObject("ajobgrade");
        DynamicObject jobScmOrg = this.getModel().getDataEntity().getDynamicObject("ajobscmorg");
        if (!HOMObjectUtils.isEmpty((Object)jobgrade) && !HRObjectUtils.isEmpty((Object)jobScmOrg)) {
            Long jobgradescmId = jobgrade.getLong("jobgradescm.id");
            List<Long> hasPermJobGradeScmIds = this.getHasPermJobGradeScmIds(Collections.singletonList(jobgradescmId), jobScmOrg.getLong("id"));
            this.getModel().setValue("jobgradescm", hasPermJobGradeScmIds.isEmpty() ? null : hasPermJobGradeScmIds.get(0));
        }
    }

    private void setValueByAjob() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject aJob = dataEntity.getDynamicObject("ajob");
        String apositionType = dataEntity.getString("apositiontype");
        if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_JOB.getValue(), (String)apositionType)) {
            this.getView().setEnable(Boolean.valueOf(!HOMObjectUtils.isEmpty((Object)aJob)), new String[]{"ajoblevel", "ajobgrade", "joblevelscm", "jobgradescm"});
        }
        this.getModel().setValue(JOB, dataEntity.get("ajob"));
        if (HRObjectUtils.isEmpty((Object)dataEntity.get("ajob"))) {
            this.getModel().setValue("ajobscm", null);
            this.getModel().setValue("jobseq", null);
            this.getModel().setValue("jobfamily", null);
            this.getModel().setValue("jobclass", null);
        } else {
            Map jobInfoMap = IBaseDataDomainService.getInstance().getJobLevelGradeRangeInfoByJobId(Long.valueOf(aJob.getLong("id")));
            this.getModel().setValue("ajobscm", jobInfoMap.get("jobscm"));
            this.getModel().setValue("jobseq", jobInfoMap.get("jobseq"));
            this.getModel().setValue("jobfamily", jobInfoMap.get("jobfamily"));
            this.getModel().setValue("jobclass", jobInfoMap.get("jobclass"));
        }
    }

    private List<Long> getHasPermJobLevelScmIds(List<Long> joblevelscmIds, Long orgId) {
        QFilter qFilter = null;
        if (orgId == 0L) {
            return new ArrayList<Long>(0);
        }
        qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"hbjm_joblevelscmhr", (Long)orgId);
        Map map = IHbjmDataDomainService.getInstance().hasPermJobLevelScmIds(new HashSet<Long>(joblevelscmIds), qFilter, "hom", "hom_onbrdinfo", "joblevelscm");
        if (map.getOrDefault("flag", Boolean.FALSE).booleanValue()) {
            return (List)map.get("list");
        }
        return new ArrayList<Long>(0);
    }

    private List<Long> getHasPermJobGradeScmIds(List<Long> jobgradescmIds, Long orgId) {
        QFilter qFilter = null;
        if (orgId == 0L) {
            return new ArrayList<Long>(0);
        }
        qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"hbjm_jobgradescmhr", (Long)orgId);
        Map map = IHbjmDataDomainService.getInstance().hasPermJobGradeScmIds(new HashSet<Long>(jobgradescmIds), qFilter, "hom", "hom_onbrdinfo", "jobgradescm");
        if (map.getOrDefault("flag", Boolean.FALSE).booleanValue()) {
            return (List)map.get("list");
        }
        return new ArrayList<Long>(0);
    }

    private void setValueByAjobscm() {
        String apositionType = this.getModel().getDataEntity().getString("apositiontype");
        if (HRStringUtils.equals((String)"2", (String)apositionType)) {
            return;
        }
        DynamicObject dyo = this.getModel().getDataEntity();
        if (HRObjectUtils.isEmpty((Object)dyo.getDynamicObject("ajobscm"))) {
            this.getModel().setValue("ajob", (Object)"");
            this.getView().setEnable(Boolean.FALSE, new String[]{"ajob"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"ajob"});
        }
    }

    private void setValueByAjobscmorg() {
        String apositionType = this.getModel().getDataEntity().getString("apositiontype");
        if (HRStringUtils.equals((String)"2", (String)apositionType)) {
            return;
        }
        DynamicObject dyo = this.getModel().getDataEntity();
        if (HRObjectUtils.isEmpty((Object)dyo.getDynamicObject("ajobscmorg"))) {
            this.getModel().setValue("ajobscm", (Object)"");
            this.getModel().setValue("ajob", (Object)"");
            this.getView().setEnable(Boolean.FALSE, new String[]{"ajobscm", "ajob"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"ajobscm"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"ajob"});
        }
    }

    private void setValueByAposition() {
        DynamicObject onbrdBill = this.getModel().getDataEntity();
        DynamicObject aposition = onbrdBill.getDynamicObject("aposition");
        String apositionType = this.getModel().getDataEntity().getString("apositiontype");
        if (ObjectUtils.isEmpty((Object)aposition)) {
            this.getModel().setValue("role", null);
            String leaderType = this.getModel().getDataEntity().getString("leadertype");
            if (HRStringUtils.equals((String)"0", (String)leaderType)) {
                this.getModel().setValue("leader", null);
            }
            if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue(), (String)apositionType)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"ajoblevel", "ajobgrade", "joblevelscm", "jobgradescm"});
            }
            return;
        }
        if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue(), (String)apositionType)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"ajoblevel", "ajobgrade", "joblevelscm", "jobgradescm"});
        }
        if (HRObjectUtils.isEmpty((Object)this.getModel().getValue("aadminorg"))) {
            this.getModel().setValue("aadminorg", aposition.get("adminorg"));
        }
        Long aposionId = aposition.getLong("id");
        ImmutableList aposionIds = ImmutableList.of((Object)aposionId);
        Map resultMap = IHbpmDataDomainService.getInstance().getHrBuScmJob((List)aposionIds);
        this.getView().setVisible(Boolean.valueOf(!HRObjectUtils.isEmpty((Object)resultMap)), new String[]{AJOBSCMORGAP});
        OnBrdHandleHelper.setLeader(this.getView());
        DynamicObject roleDy = aposition.getDynamicObject("workrole");
        this.getModel().setValue("role", (Object)roleDy);
    }

    private void setValueByStandAposition() {
        DynamicObject onbrdBill = this.getModel().getDataEntity();
        DynamicObject aposition = onbrdBill.getDynamicObject("stdposition");
        String apositionType = this.getModel().getDataEntity().getString("apositiontype");
        if (ObjectUtils.isEmpty((Object)aposition)) {
            if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue(), (String)apositionType)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"ajoblevel", "ajobgrade", "joblevelscm", "jobgradescm"});
            }
            return;
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"ajoblevel", "ajobgrade", "joblevelscm", "jobgradescm"});
        Long stdPositionId = onbrdBill.getLong("stdposition.id");
        ImmutableList aposionIds = ImmutableList.of((Object)stdPositionId);
        Map resultMap = IHbpmDataDomainService.getInstance().getStandardBuScmJob((List)aposionIds);
        this.getView().setVisible(Boolean.valueOf(!HRObjectUtils.isEmpty((Object)resultMap)), new String[]{AJOBSCMORGAP});
    }

    private void setIsprobation() {
        boolean isprobation = this.getModel().getDataEntity().getBoolean("isprobation");
        if (isprobation) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"probationtime"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"perprobationtime"});
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"probationtime", "perprobationtime"}, (boolean)true);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"probationtime"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"perprobationtime"});
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"probationtime", "perprobationtime"}, (boolean)false);
        }
    }

    private void setValueByApositionTye() {
        String apositionType = this.getModel().getDataEntity().getString("apositiontype");
        UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"ajob"}, (boolean)false);
        this.getView().setEnable(Boolean.FALSE, new String[]{"ajob"});
        this.getView().setVisible(Boolean.TRUE, new String[]{JOB});
        this.getView().setVisible(Boolean.FALSE, new String[]{"ajob"});
        Tips leaderTips = UpdateControlUtil.getTextTips((String)ResManager.loadKDString((String)"\u4efb\u804c\u5230\u4e3b\u8d1f\u8d23\u5c97\uff0c\u5219\u4f18\u5148\u53d6\u4e0a\u7ea7\u5c97\u4f4d\u7684\u4eba\uff0c\u5982\u679c\u4e0a\u7ea7\u5c97\u4f4d\u65e0\u4eba\uff0c\u5219\u53d6\u4e0a\u7ea7\u90e8\u95e8\u4e3b\u8d1f\u8d23\u4eba\uff1b\u4efb\u804c\u5230\u975e\u4e3b\u8d1f\u8d23\u5c97\uff0c\u5219\u4f18\u5148\u53d6\u4e0a\u7ea7\u5c97\u4f4d\u7684\u4eba\uff0c\u5982\u679c\u4e0a\u7ea7\u5c97\u4f4d\u65e0\u4eba\uff0c\u5219\u53d6\u5165\u804c\u90e8\u95e8\u4e3b\u8d1f\u8d23\u4eba\uff1b\u4efb\u804c\u5230\u804c\u4f4d\u3001\u6807\u51c6\u5c97\u4f4d\uff0c\u5219\u53d6\u5165\u804c\u90e8\u95e8\u4e3b\u8d1f\u8d23\u4eba\u3002", (String)"OnbrdInfoEdit_28", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_JOB.getValue(), (String)apositionType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"aposition", "stdposition"});
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"aposition", "stdposition"}, (boolean)false);
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"ajob"}, (boolean)true);
            this.getView().setEnable(Boolean.TRUE, new String[]{"ajob"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"ajob"});
            this.getView().setVisible(Boolean.FALSE, new String[]{JOB});
            if (HOMObjectUtils.isEmpty((Object)this.getModel().getDataEntity().getDynamicObject("ajob"))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"ajoblevel", "ajobgrade", "joblevelscm", "jobgradescm"});
            }
            IPersonFileIntegrateService.getInstance().getResponsible(this.getView());
        } else if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue(), (String)apositionType)) {
            LOGGER.info("===APOSITION true STDPOSITION false===");
            this.getView().setVisible(Boolean.TRUE, new String[]{"aposition"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"stdposition"});
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"aposition"}, (boolean)true);
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"stdposition"}, (boolean)false);
            this.getView().setEnable(Boolean.TRUE, new String[]{"aadminorg"});
        } else {
            LOGGER.info("===STDPOSITION true APOSITION false===");
            this.getView().setVisible(Boolean.FALSE, new String[]{"aposition"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"stdposition"});
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"aposition"}, (boolean)false);
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"stdposition"}, (boolean)true);
            this.getView().setEnable(Boolean.TRUE, new String[]{"aadminorg"});
            IPersonFileIntegrateService.getInstance().getResponsible(this.getView());
        }
        UpdateControlUtil.setFieldTips((IFormView)this.getView(), (String)"leader", (Tips)leaderTips);
        if (HRObjectUtils.isEmpty((Object)this.getModel().getValue("stdposition")) && HRObjectUtils.isEmpty((Object)this.getModel().getValue("aposition"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{AJOBSCMORGAP});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{FS_ONBOARDBASICINFO, FS_PERSONNELMATTERS, FS_LEADER1});
    }

    private void setNullWhenApositionTyeChange() {
        this.getModel().setValue("aposition", null);
        this.getModel().setValue("stdposition", null);
        this.getModel().setValue("ajob", null);
        this.getModel().setValue(JOB, null);
        this.getModel().setValue("ajoblevel", null);
        this.getModel().setValue("ajobgrade", null);
        this.getModel().setValue("leader", null);
        this.getModel().setValue("ajobscmorg", null);
        this.getModel().setValue("ajobscm", null);
        this.getModel().setValue("jobseq", null);
        this.getModel().setValue("jobfamily", null);
        this.getModel().setValue("jobclass", null);
        this.getModel().setValue("jobclasslongname", null);
        this.getModel().setValue("joblevelscm", null);
        this.getModel().setValue("jobgradescm", null);
    }

    private void setValueByAadminorg(PropertyChangedArgs propertyChangedArgs) {
        DynamicObject baseDyo;
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        boolean retFlag = HRObjectUtils.isEmpty((Object)changeData.getNewValue()) || !HRObjectUtils.isEmpty((Object)changeData.getNewValue()) && !HRObjectUtils.isEmpty((Object)changeData.getOldValue()) && !HRObjectUtils.equals((Object)changeData.getNewValue(), (Object)changeData.getOldValue());
        String apositionType = this.getModel().getDataEntity().getString("apositiontype");
        if (retFlag && HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue(), (String)apositionType)) {
            this.getModel().setValue("aposition", null);
        } else if (retFlag) {
            if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue(), (String)apositionType)) {
                this.getModel().setValue("stdposition", null);
            }
            OnBrdHandleHelper.setLeader(this.getView());
        }
        this.getView().getModel().setValue("responsible", (Object)"");
        DynamicObject aadminOrg = this.getModel().getDataEntity().getDynamicObject("aadminorg");
        if (HRObjectUtils.isEmpty((Object)aadminOrg)) {
            this.getModel().setValue("affiliateadminorg", null);
            this.getModel().setValue("hrbu", null);
            this.getModel().setValue("acompany", null);
            this.getView().getModel().setValue("responsible", (Object)"");
            if (HRStringUtils.equals((String)apositionType, (String)"0")) {
                this.getView().getModel().setValue("leader", null);
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"stdposition"});
            return;
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"stdposition"});
        this.getModel().setValue("affiliateadminorg", (Object)aadminOrg);
        DynamicObject onbrdBill = this.getModel().getDataEntity();
        DynamicObject[] onbrdBillInfos = new DynamicObject[]{onbrdBill};
        OnbrdInfoInitService onbrdInfoInitService = new OnbrdInfoInitService();
        Map hrBuOrgMap = onbrdInfoInitService.getHRBuOrgMap(onbrdBillInfos);
        Long onbrdBillId = onbrdBill.getLong("id");
        this.getModel().setValue("hrbu", hrBuOrgMap.get(onbrdBillId));
        Long adminOrgId = aadminOrg.getLong("id");
        Map orgCompanyMap = IBaseDataDomainService.getInstance().getCompanyMapWithAdminorgByRPC((List)ImmutableList.of((Object)adminOrgId));
        this.getModel().setValue("acompany", (Object)orgCompanyMap.getOrDefault(adminOrgId, 0L));
        DynamicObject baselocDyo = aadminOrg.getDynamicObject("workplace");
        if (!Objects.isNull(baselocDyo) && Objects.isNull(this.getModel().getValue("baselocation")) && !Objects.isNull(baseDyo = IBaseDataDomainService.getInstance().getBaseDataInfoByNumber("hbss_workplace", baselocDyo.getString("number"), "ispermanworkplace")) && baseDyo.getBoolean("ispermanworkplace")) {
            this.getModel().setValue("baselocation", (Object)baselocDyo);
        }
        IPersonFileIntegrateService.getInstance().getResponsible(this.getView());
    }

    private Optional<String> validateCreNumber() {
        Optional certNumInfo;
        DynamicObject dynamicObjectPage = this.getView().getModel().getDataEntity();
        DynamicObject credentialsType = dynamicObjectPage.getDynamicObject("certificatetype");
        String credentialsNumber = dynamicObjectPage.getString("certificatenumber");
        if (HRStringUtils.isEmpty((String)credentialsNumber) || credentialsType == null) {
            return Optional.empty();
        }
        boolean isPass = new CertificatePageServiceImpl().validateCreNumber(credentialsType, credentialsNumber);
        if (!isPass) {
            String msg = ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7\u7801\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"OnbrdInfoEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return Optional.of(msg);
        }
        long creType = credentialsType.getLong("id");
        DynamicObject gender = dynamicObjectPage.getDynamicObject("gender");
        if (HcfCanCreConstants.CREDENTIALSTYPE_ID_IDCARD == creType && Objects.isNull(gender)) {
            this.setValueByIdCardNumber(credentialsNumber);
        }
        if ((certNumInfo = IOnbrdBillDomainService.getInstance().validateCertNum(Long.valueOf(dynamicObjectPage.getLong("id")), credentialsType.getString("id"), credentialsNumber)).isPresent()) {
            this.getView().showTipNotification((String)certNumInfo.get());
            return certNumInfo;
        }
        return Optional.empty();
    }

    private Optional<String> validPersonIsExistByHspm(String keyName) {
        DynamicObject onbrdBillInfo = this.getView().getModel().getDataEntity();
        ImmutableList fieldNames = HRStringUtils.isEmpty((String)keyName) ? ImmutableList.of((Object)"employeeno", (Object)"phone", (Object)"certificatenumber", (Object)"peremail") : ImmutableList.of((Object)keyName);
        Map checkResultMap = IHomToHrpiAppService.getInstance().checkAndTipByPersonFields((List)ImmutableList.of((Object)onbrdBillInfo), (List)fieldNames);
        String validPersonResult = (String)checkResultMap.get(onbrdBillInfo.getLong("id"));
        if (HRStringUtils.isNotEmpty((String)validPersonResult)) {
            String tmpStr = ResManager.loadKDString((String)"\u60a8\u586b\u5199\u7684", (String)"OnbrdInfoEdit_11", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            String msg = tmpStr + validPersonResult + ResManager.loadKDString((String)"\u4e0e\u5728\u804c\u4eba\u5458\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OnbrdInfoEdit_12", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            if (HRStringUtils.equals((String)ResManager.loadKDString((String)"\u4eba\u5458\u63a5\u53e3\u672a\u8fd4\u56de\u67e5\u8be2\u7ed3\u679c\u3002", (String)"OnbrdInfoEdit_13", (String)"hr-hom-formplugin", (Object[])new Object[0]), (String)validPersonResult)) {
                msg = validPersonResult;
            }
            this.getView().showTipNotification(msg);
            return Optional.of(msg);
        }
        return Optional.empty();
    }

    private Optional<String> validateEmail() {
        DynamicObject dynamicObjectPage = this.getView().getModel().getDataEntity();
        String email = dynamicObjectPage.getString("peremail");
        Optional optEmail = IOnbrdCommonAppService.getInstance().validateEmail(email);
        if (optEmail.isPresent() && HRStringUtils.isNotEmpty((String)((String)optEmail.get()))) {
            this.getView().showErrorNotification((String)optEmail.get());
            return optEmail;
        }
        return IOnbrdCommonAppService.getInstance().vaildSameFieldByHom("peremail", this.getView());
    }

    private Optional<String> validatePhone() {
        DynamicObject dynamicObjectPage = this.getView().getModel().getDataEntity();
        String phone = dynamicObjectPage.getString("phone");
        if (HRStringUtils.isEmpty((String)phone)) {
            return Optional.empty();
        }
        Optional phoneResult = IOnbrdCommonAppService.getInstance().validatePhone(phone);
        if (phoneResult.isPresent()) {
            this.getView().showErrorNotification((String)phoneResult.get());
            return phoneResult;
        }
        return IOnbrdCommonAppService.getInstance().vaildSameFieldByHom("phone", this.getView());
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit certificateTypeEdit = (BasedataEdit)this.getView().getControl("certificatetype");
        certificateTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit alaborreltypeEdit = (BasedataEdit)this.getView().getControl("laborreltype");
        alaborreltypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit alaborrelstatusEdit = (BasedataEdit)this.getView().getControl("laborrelstatus");
        alaborrelstatusEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit postypeEdit = (BasedataEdit)this.getView().getControl("postype");
        postypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit posstatusEdit = (BasedataEdit)this.getView().getControl("posstatus");
        posstatusEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit affactionEdit = (BasedataEdit)this.getView().getControl("affaction");
        affactionEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit empgroupEdit = (BasedataEdit)this.getView().getControl("empgroup");
        empgroupEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        DynamicObject onbrdBill = this.getModel().getDataEntity();
        QFilter filter = null;
        switch (propertyName) {
            case "affaction": {
                filter = this.getQFilterChgevent();
                break;
            }
            case "empgroup": {
                filter = this.getQFilterWithEmpgroup();
                break;
            }
        }
        if (!HRObjectUtils.isEmpty(filter)) {
            beforeF7SelectEvent.getCustomQFilters().add(filter);
        }
    }

    private QFilter getQFilterWithStdposition() {
        Long aadminOrgId = this.getModel().getDataEntity().getLong("aadminorg.id");
        Map stdpositionMap = IBaseDataDomainService.getInstance().queryStdPositionByOrg((List)ImmutableList.of((Object)aadminOrgId));
        List standardPositions = (List)stdpositionMap.get(aadminOrgId);
        if (standardPositions == null || standardPositions.isEmpty()) {
            return new QFilter("id", "=", null);
        }
        List ids = standardPositions.stream().map(dyInfo -> dyInfo.getLong("id")).collect(Collectors.toList());
        return new QFilter("id", "in", ids);
    }

    private QFilter getQFilterWithAjob(DynamicObject ajobscm) {
        if (HRObjectUtils.isEmpty((Object)ajobscm)) {
            return null;
        }
        return new QFilter("jobscm", "=", (Object)ajobscm.getLong("id"));
    }

    private Tuple<List<DynamicObject>, List<DynamicObject>> getLevelGradeRangesByJobId(Long jobId) {
        Map jobInfoMap = new HashMap();
        if (jobId != 0L) {
            jobInfoMap = IBaseDataDomainService.getInstance().getJobLevelGradeRangeInfoByJobId(jobId);
        }
        List jobGrades = new ArrayList();
        List jobleves = new ArrayList();
        if (jobInfoMap != null && !jobInfoMap.isEmpty()) {
            jobGrades = (List)jobInfoMap.get("jobgradeRanges");
            jobleves = (List)jobInfoMap.get("joblevelRanges");
        }
        return Tuple.create(jobleves, jobGrades);
    }

    private QFilter getQFilterWithJoblevelScm() {
        long joblevelscmId = (Long)this.getJobLevelGradeScmId().item1;
        return joblevelscmId == 0L ? null : new QFilter("id", "=", (Object)joblevelscmId);
    }

    private QFilter getQFilterWithJobgradeScm() {
        long jobgradescmId = (Long)this.getJobLevelGradeScmId().item2;
        return jobgradescmId == 0L ? null : new QFilter("id", "=", (Object)jobgradescmId);
    }

    private Tuple<Long, Long> getJobLevelGradeScmId() {
        long joblevelscmId = 0L;
        long jobgradescmId = 0L;
        DynamicObject onbrdBillPage = this.getModel().getDataEntity();
        String apositionType = onbrdBillPage.getString("apositiontype");
        if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue(), (String)apositionType)) {
            Long stdPositionId = onbrdBillPage.getLong("stdposition.id");
            Map resultMap = IHbpmDataDomainService.getInstance().getStandardBuScmJob((List)ImmutableList.of((Object)stdPositionId));
            if (!HRObjectUtils.isEmpty((Object)resultMap)) {
                joblevelscmId = HOMObjectUtils.getLongValOfCustomParam(resultMap.get("joblevelscm.id"));
                jobgradescmId = HOMObjectUtils.getLongValOfCustomParam(resultMap.get("jobgradescm.id"));
            }
        } else if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue(), (String)apositionType)) {
            Long apositionId = onbrdBillPage.getLong("aposition.id");
            Map resultMap = IHbpmDataDomainService.getInstance().getHrBuScmJob((List)ImmutableList.of((Object)apositionId));
            if (!HRObjectUtils.isEmpty((Object)resultMap)) {
                joblevelscmId = HOMObjectUtils.getLongValOfCustomParam(resultMap.get("highjoblevel.joblevelscm"));
                jobgradescmId = HOMObjectUtils.getLongValOfCustomParam(resultMap.get("highjobgrade.jobgradescm"));
            }
        }
        if (joblevelscmId == 0L || jobgradescmId == 0L) {
            long jobId = onbrdBillPage.getLong("ajob.id");
            Map jobInfoMap = new HashMap();
            if (jobId != 0L) {
                jobInfoMap = IBaseDataDomainService.getInstance().getJobLevelGradeRangeInfoByJobId(Long.valueOf(jobId));
            }
            if (jobInfoMap != null) {
                joblevelscmId = joblevelscmId == 0L ? HOMObjectUtils.getLongValOfCustomParam(jobInfoMap.get("joblevelScmid")) : joblevelscmId;
                jobgradescmId = jobgradescmId == 0L ? HOMObjectUtils.getLongValOfCustomParam(jobInfoMap.get("jobgradeScmid")) : jobgradescmId;
            }
        }
        return Tuple.create((Object)joblevelscmId, (Object)jobgradescmId);
    }

    private QFilter getQFilterWithAjoblevel() {
        Map JobInfoMap;
        DynamicObject onbrdBillPage = this.getModel().getDataEntity();
        Long jobId = onbrdBillPage.getLong("ajob.id");
        QFilter qFilter = null;
        QFilter idFilter = null;
        long joblevelscmId = this.getModel().getDataEntity().getLong("joblevelscm.id");
        if (joblevelscmId != 0L) {
            qFilter = new QFilter("joblevelscm", "=", (Object)joblevelscmId);
        }
        String apositionType = onbrdBillPage.getString("apositiontype");
        Map positionLevelGradeMap = null;
        if (HRStringUtils.equals((String)"1", (String)apositionType)) {
            Long apositionId = this.getModel().getDataEntity().getLong("aposition.id");
            JobInfoMap = IHbpmDataDomainService.getInstance().queryJobLevelAndJobGradeByPositionIds((List)ImmutableList.of((Object)apositionId));
            if (!ObjectUtils.isEmpty((Object)JobInfoMap)) {
                positionLevelGradeMap = (Map)JobInfoMap.get(apositionId);
            }
        } else if (HRStringUtils.equals((String)"0", (String)apositionType)) {
            Long stdPositionId = this.getModel().getDataEntity().getLong("stdposition.id");
            JobInfoMap = IHbpmDataDomainService.getInstance().queryJobLevelAndJobGradeByStdPositionIds((List)ImmutableList.of((Object)stdPositionId));
            if (!ObjectUtils.isEmpty((Object)JobInfoMap)) {
                positionLevelGradeMap = (Map)JobInfoMap.get(stdPositionId);
            }
        }
        List jobleves = null;
        if (positionLevelGradeMap != null) {
            jobleves = HbpmResultUtils.getJobLevel(positionLevelGradeMap);
        }
        if (CollectionUtils.isEmpty(jobleves)) {
            Tuple<List<DynamicObject>, List<DynamicObject>> jobleveGradeTuple = this.getLevelGradeRangesByJobId(jobId);
            jobleves = (List)jobleveGradeTuple.item1;
        }
        if (jobleves != null && !jobleves.isEmpty()) {
            List jobleveIdList = jobleves.stream().map(jobLevel -> jobLevel.getLong("id")).collect(Collectors.toList());
            idFilter = new QFilter("id", "in", jobleveIdList);
        }
        if (idFilter != null) {
            qFilter = qFilter == null ? idFilter : idFilter.and(qFilter);
        }
        LOGGER.info("qFilter:{}", (Object)(qFilter == null ? "null" : qFilter.toString()));
        return qFilter;
    }

    private QFilter getQFilterWithAjobgrade() {
        Map JobInfoMap;
        DynamicObject onbrdBillPage = this.getModel().getDataEntity();
        Long jobId = onbrdBillPage.getLong("ajob.id");
        QFilter qFilter = null;
        long jobgradeScmId = this.getModel().getDataEntity().getLong("jobgradescm.id");
        if (jobgradeScmId != 0L) {
            qFilter = new QFilter("jobgradescm", "=", (Object)jobgradeScmId);
        }
        QFilter idFilter = null;
        String apositionType = this.getModel().getDataEntity().getString("apositiontype");
        Map positionLevelGradeMap = null;
        if (HRStringUtils.equals((String)"1", (String)apositionType)) {
            Long apositionId = this.getModel().getDataEntity().getLong("aposition.id");
            JobInfoMap = IHbpmDataDomainService.getInstance().queryJobLevelAndJobGradeByPositionIds((List)ImmutableList.of((Object)apositionId));
            if (!ObjectUtils.isEmpty((Object)JobInfoMap)) {
                positionLevelGradeMap = (Map)JobInfoMap.get(apositionId);
            }
        } else if (HRStringUtils.equals((String)"0", (String)apositionType)) {
            Long stdPositionId = this.getModel().getDataEntity().getLong("stdposition.id");
            JobInfoMap = IHbpmDataDomainService.getInstance().queryJobLevelAndJobGradeByStdPositionIds((List)ImmutableList.of((Object)stdPositionId));
            if (!ObjectUtils.isEmpty((Object)JobInfoMap)) {
                positionLevelGradeMap = (Map)JobInfoMap.get(stdPositionId);
            }
        }
        List jobGrades = null;
        if (positionLevelGradeMap != null) {
            jobGrades = HbpmResultUtils.getJobGrade(positionLevelGradeMap);
        }
        if (CollectionUtils.isEmpty(jobGrades)) {
            jobGrades = (List)this.getLevelGradeRangesByJobId((Long)jobId).item2;
        }
        if (jobGrades != null && !jobGrades.isEmpty()) {
            List jobGradeIdList = jobGrades.stream().map(jobGrade -> jobGrade.getLong("id")).collect(Collectors.toList());
            idFilter = new QFilter("id", "in", jobGradeIdList);
        }
        if (idFilter != null) {
            qFilter = qFilter == null ? idFilter : idFilter.and(qFilter);
        }
        LOGGER.info("qFilter:{}", (Object)(qFilter == null ? "null" : qFilter.toString()));
        return qFilter;
    }

    private QFilter getQFilterWithEmpgroup() {
        DynamicObject bussinessfield = IBaseDataDomainService.getInstance().getBaseDataInfoById("hbss_bussinessfield", BaseDataIdConstants.HBSS_BUSSINESSFIELD_103010, "id");
        if (bussinessfield == null) {
            return null;
        }
        return new QFilter("bussinessfield", "=", (Object)bussinessfield.getLong("id"));
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        super.beforeClosed(beforeClosedEvent);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (HRStringUtils.equalsIgnoreCase((String)status.name(), (String)"EDIT")) {
            Long onbrdBillId = this.getModel().getDataEntity().getLong("id");
            IOnbrdCommonAppService.getInstance().releaseLockWithOnbrdBill(onbrdBillId, "hom_onbrdinfo");
        }
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.recycleNumber();
        }
    }

    private void recycleNumber() {
        String candidateNumber = this.getView().getPageCache().get("candidatenumber");
        if (HRStringUtils.isEmpty((String)candidateNumber)) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hom_candidatenumber");
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        RuleCodeUtils.recycleNumber((DynamicObject)dynamicObject, (String)candidateNumber);
    }

    private void changeHeadPhoto() {
        String relativeUrl = this.getModel().getDataEntity().getString("picturefield");
        if (HRStringUtils.isEmpty((String)relativeUrl)) {
            return;
        }
        String imageUrl = FileServiceUtils.getImageFullUrl((String)relativeUrl);
        if (!IHomToCvpAppService.getInstance().ocrIsEnable().booleanValue()) {
            return;
        }
        FaceDetectResult faceDetectResult = IHomFaceDetectService.getInstance().detectFaceImage(imageUrl);
        LOGGER.info("===faceDetectResult.errorCode:{}===", (Object)faceDetectResult.getErrorCode());
        LOGGER.info("===faceDetectResult.description:{}==", (Object)faceDetectResult.getDescription());
        if (!faceDetectResult.isRightFacePhoto()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u5230\u4eba\u50cf\u5185\u5bb9\uff0c\u8bf7\u4e0a\u4f20\u4eba\u50cf\u56fe\u7247\u3002", (String)"OnbrdInfoEdit_7", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
    }

    private QFilter getQFilterChgevent() {
        return new QFilter("enable", "in", (Object)"1");
    }

    private void setChgDefaultData() {
        DynamicObject chgDyo = this.getModel().getDataEntity().getDynamicObject("affaction");
        if (Objects.isNull(chgDyo)) {
            this.setValue(null);
            return;
        }
        Long pkId = chgDyo.getLong("id");
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(pkId);
        Tuple chgRuleInfo = IPersonFileIntegrateService.getInstance().getChgRuleInfo(ids);
        Map infoMap = (Map)chgRuleInfo.item1;
        if (infoMap == null || infoMap.isEmpty()) {
            LOGGER.info("setChgDefaultData_null");
            this.setValue(null);
            return;
        }
        Map ruleMap = (Map)infoMap.get(pkId);
        this.setValue(ruleMap);
        String viewType = (String)this.getModel().getValue("viewtype");
        if (ViewTypeEnum.AGAIN.getCode().equals(viewType) && this.getModel().getValue("laborrelstatus") == null) {
            this.getModel().setValue("laborrelstatus", (Object)BaseDataIdConstants.HBSS_LABORRELSTATUS_1020);
            this.setValueByLaborrelstatus();
        }
    }

    private void setValue(Map<String, List<Long>> ruleMap) {
        Arrays.stream(BaseDataConstants.RULEDATA_NAME).forEach(str -> {
            if (ruleMap == null) {
                this.getModel().setValue(str, null);
                return;
            }
            this.getModel().setValue(str, null);
            if (ruleMap.get(str) != null && ((List)ruleMap.get(str)).size() == 1) {
                this.getModel().setValue(str, ((List)ruleMap.get(str)).get(0));
            }
        });
    }

    private void setCandidateNumber() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"candidatenumber"});
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hom_candidatenumber");
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        ArrayList numberList = new ArrayList(1);
        RuleCodeUtils.codeRuleHandler((DynamicObject)dynamicObject, numberList, (int)1, (int)1);
        if (!CollectionUtils.isEmpty(numberList)) {
            this.getView().getModel().setValue("candidatenumber", numberList.get(0));
            this.getView().getPageCache().put("candidatenumber", (String)numberList.get(0));
        }
    }

    private void validateCandidateNumber() {
        HRPageCache pageCache = new HRPageCache(this.getView());
        String status = (String)pageCache.get(OperationStatus.ADDNEW.toString(), String.class);
        if (!OperationStatus.ADDNEW.toString().equals(status)) {
            return;
        }
        IRuleCodeBusinessCheckService service = CodeServiceFactory.getService((String)"hom_candidatenumber");
        ArrayList<String> list = new ArrayList<String>(1);
        list.add((String)this.getModel().getValue("candidatenumber"));
        List number = service.checkNumber(list);
        if (CollectionUtils.isEmpty((Collection)number)) {
            this.setCandidateNumber();
        }
    }

    private void setValueByIdCardNumber(String idCardNumber) {
        IDCardInfo idCardInfo = IDCardUtils.parse((String)idCardNumber);
        if (Objects.nonNull(idCardInfo)) {
            HbssSexEnum hbssSex = idCardInfo.getGender() ? HbssSexEnum.MALE : HbssSexEnum.FEMALE;
            this.getModel().setValue("gender", (Object)hbssSex.getId());
            this.getView().updateView("gender");
        }
    }

    private void calculateTransDate(PropertyChangedArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.getModel().setValue("transdate", (Object)DateUtils.setTransDate((DynamicObject)dataEntity));
    }

    private void changeWithEffectDateBak(PropertyChangedArgs args) {
        IDataModel dataModel = this.getModel();
        dataModel.setValue("effectdate", dataModel.getValue(EFFECTDATEBAK));
        this.calculateTransDate(args);
    }

    private void setJobClassLongName() {
        DynamicObject job = (DynamicObject)this.getModel().getValue(JOB);
        if (!HRObjectUtils.isEmpty((Object)job)) {
            long jobBoId = job.getLong("boid");
            Map jobClassLongNameMap = IHrmpExternalService.getInstance().getJobClassLongNameByJobAndBsed((List)Lists.newArrayList((Object[])new Long[]{jobBoId}), job.getDate("bsed"));
            this.getModel().setValue("jobclasslongname", jobClassLongNameMap.get(jobBoId));
        }
    }

    private void changeWithJob(PropertyChangedArgs propertyChangedArgs) {
        this.setJobClassLongName();
    }

    private Boolean blackListValid(boolean ignorePagePache, boolean isButton) {
        Map invokeResult;
        Map invokeResult2;
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        BlacklistConfigDTO config = BlackListConfigUtil.getBlackListConfig((Long)orgId);
        if (Boolean.FALSE.equals(config.getEnableBlacklistValid())) {
            return true;
        }
        BlacklistConfigDTO.ValidFieldDTO eConfigDto = config.getErrorValidFieldDto();
        Map<String, Object> checkedFieldMap = this.buildValidFieldDto(eConfigDto);
        IBlackListService blackListService = IBlackListService.getInstance();
        if (!HRMapUtils.isEmpty(checkedFieldMap) && !HRMapUtils.isEmpty((Map)(invokeResult2 = blackListService.queryBlackListSingle(checkedFieldMap)))) {
            if (isButton) {
                this.showBlacklistValidConfirmForButton(invokeResult2, "1");
            } else {
                this.showBlacklistValidConfirm(invokeResult2, "1");
            }
            return Boolean.FALSE;
        }
        BlacklistConfigDTO.ValidFieldDTO wConfigDto = config.getWarnValidFieldDto();
        checkedFieldMap = this.buildValidFieldDto(wConfigDto);
        if (!HRMapUtils.isEmpty(checkedFieldMap) && !HRMapUtils.isEmpty((Map)(invokeResult = blackListService.queryBlackListSingle(checkedFieldMap)))) {
            String blackListId = String.valueOf(invokeResult.get("id"));
            if (ignorePagePache || this.hasNotValidBlackList(blackListId)) {
                if (isButton) {
                    this.showBlacklistValidConfirmForButton(invokeResult, "2");
                } else {
                    this.showBlacklistValidConfirm(invokeResult, "2");
                }
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean hasNotValidBlackList(String blackListId) {
        String hasIgnore = this.getPageCache().get(blackListId);
        if (HRStringUtils.isBlank((CharSequence)hasIgnore)) {
            return true;
        }
        this.getModel().setValue("ignorereason", (Object)hasIgnore);
        this.getModel().setValue("passblackliststatus", (Object)OnbrdBlackListStatusEnum.PASS.getValue());
        return false;
    }

    private Map<String, Object> buildValidFieldDto(BlacklistConfigDTO.ValidFieldDTO configDto) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        HashMap<String, Object> checkedFieldMap = new HashMap<String, Object>(8);
        String name = dataEntity.getString("name");
        Long certificateType = dataEntity.getLong("certificatetype.id");
        String certificateNumber = dataEntity.getString("certificatenumber");
        String phone = dataEntity.getString("phone");
        String email = dataEntity.getString("peremail");
        if (Boolean.TRUE.equals(configDto.getName())) {
            if (!HRStringUtils.isBlank((CharSequence)dataEntity.getString("name"))) {
                checkedFieldMap.put("name", name);
            } else {
                return Collections.emptyMap();
            }
        }
        if (Boolean.TRUE.equals(configDto.getCertificate())) {
            if (!HRStringUtils.isBlank((CharSequence)certificateNumber) && !HRObjectUtils.isEmpty((Object)certificateType)) {
                checkedFieldMap.put("cardtype", certificateType);
                checkedFieldMap.put("cardnumber", certificateNumber);
            } else {
                return Collections.emptyMap();
            }
        }
        if (Boolean.TRUE.equals(configDto.getPhone())) {
            if (!HRStringUtils.isBlank((CharSequence)phone)) {
                checkedFieldMap.put("phone", phone);
            } else {
                return Collections.emptyMap();
            }
        }
        if (Boolean.TRUE.equals(configDto.getEmail())) {
            if (!HRStringUtils.isBlank((CharSequence)email)) {
                checkedFieldMap.put("email", email);
            } else {
                return Collections.emptyMap();
            }
        }
        return checkedFieldMap;
    }

    private void showBlacklistValidConfirm(Map<String, Object> blackListInfo, String validLevel) {
        if (!HRStringUtils.isBlank((CharSequence)this.getView().getPageCache().get("hasOpenValidBlackForm"))) {
            return;
        }
        FormShowParameter formShowParameter = this.setValidFormShowParameter(blackListInfo, validLevel);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hom_blacklistvalidconfirm"));
        this.getView().showForm(formShowParameter);
        this.getView().getPageCache().put("hasOpenValidBlackForm", "true");
    }

    private void showBlacklistValidConfirmForButton(Map<String, Object> blackListInfo, String validLevel) {
        this.getView().getPageCache().remove("hasOpenValidBlackForm");
        FormShowParameter formShowParameter = this.setValidFormShowParameter(blackListInfo, validLevel);
        formShowParameter.setCloseCallBack(new CloseCallBack("kd.hr.hom.formplugin.web.personmange.OnbrdBodyHandleInfoPlugin", "hom_blacklistvalidconfirm"));
        this.getView().getParentView().showForm(formShowParameter);
    }

    private FormShowParameter setValidFormShowParameter(Map<String, Object> blackListInfo, String validLevel) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hom_blacklistvalidconfirm");
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCustomParam("blackListInfo", blackListInfo);
        formShowParameter.setCustomParam("validLevel", (Object)validLevel);
        return formShowParameter;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        if ("hom_blacklistvalidconfirm".equals(actionId)) {
            this.getView().getPageCache().remove("hasOpenValidBlackForm");
            Map returnDataMap = (Map)returnData;
            String btnKey = (String)returnDataMap.get("btnKey");
            String blackListId = (String)returnDataMap.get("blackListId");
            String ignoreReason = (String)returnDataMap.get("ignorereason");
            if ("btnok".equals(btnKey)) {
                this.getView().getPageCache().put(blackListId, ignoreReason);
                this.getModel().setValue("ignorereason", (Object)ignoreReason);
                this.getModel().setValue("passblackliststatus", (Object)OnbrdBlackListStatusEnum.PASS.getValue());
                this.formerEmployeeValid();
                return;
            }
            if ("btnno".equals(btnKey) || "btncancel".equals(btnKey)) {
                this.getModel().setValue("ignorereason", null);
                this.getModel().setValue("passblackliststatus", (Object)OnbrdBlackListStatusEnum.NO_PASS.getValue());
            }
        }
    }
}

