/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import java.util.Date;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.cvp.IHomFaceDetectService;
import kd.hr.hom.business.application.cvp.IHomToCvpAppService;
import kd.hr.hom.business.domain.repository.OnbrdBillRepository;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.entity.ocr.FaceDetectResult;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.util.ComboPropValueUtils;
import kd.hr.hom.common.util.FileServiceUtils;
import kd.hr.hom.formplugin.web.activity.AbstractOnbrdHeadPlugin;
import kd.hr.hom.formplugin.web.personmange.OnbrdHeadInfoPlugin;

public class OnbrdInfoHeadInfoPlugin
extends AbstractOnbrdHeadPlugin {
    private static final Log logger = LogFactory.getLog(OnbrdHeadInfoPlugin.class);
    private static final String PANEL_VIEWB = "panel_viewb";
    private static final String PROPERTIES_SELECTED = "billno,creator,createtime,name,onbrdtype,org,enrollstatus,gender,laborrelstatus,phone,peremail,validuntil,starttime,effectdate,processstatus,candidate.number,onbrdtype.name,picturefield,aposition,stdposition,apositiontype,acompany.name,aadminorg.name,nationality,ajob.name,viewtype";

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        IFormView formView = this.getView();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("id"));
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdId);
        DynamicObject onbrdBillInfo = IOnbrdBillDomainService.getInstance().findOnbrdBill(PROPERTIES_SELECTED, new QFilter[]{qFilter});
        if (HRObjectUtils.isEmpty((Object)onbrdBillInfo)) {
            logger.info("Can not find OnbrdBill By the PkId " + onbrdId);
            this.setFieldValueWithPanelNew();
            return;
        }
        formView.setVisible(Boolean.TRUE, new String[]{PANEL_VIEWB});
        this.setFieldValueWithPanelViewB(onbrdBillInfo);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"picturefield")) {
            String relativeUrl = this.getModel().getDataEntity().getString("picturefield");
            if (HRStringUtils.isNotEmpty((String)relativeUrl)) {
                String imageUrl = FileServiceUtils.getImageFullUrl((String)relativeUrl);
                if (IHomToCvpAppService.getInstance().ocrIsEnable().booleanValue()) {
                    FaceDetectResult faceDetectResult = IHomFaceDetectService.getInstance().detectFaceImage(imageUrl);
                    logger.info("===faceDetectResult.errorCode:{}===", (Object)faceDetectResult.getErrorCode());
                    logger.info("===faceDetectResult.description:{}==", (Object)faceDetectResult.getDescription());
                    if (!faceDetectResult.isRightFacePhoto()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u5230\u4eba\u50cf\u5185\u5bb9\uff0c\u8bf7\u4e0a\u4f20\u4eba\u50cf\u56fe\u7247\u3002", (String)"OnbrdInfoEdit_7", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    }
                }
            }
            if (e.getChangeSet().length > 0) {
                Object newValue = e.getChangeSet()[0].getNewValue();
                Object id = this.getView().getFormShowParameter().getCustomParams().get("id");
                DynamicObject dyo = new OnbrdBillRepository().generateDynamicObject(id, "picturefield");
                dyo.set("id", id);
                dyo.set("picturefield", newValue);
                IOnbrdBillDomainService.getInstance().saveOnbrdBillInfo(dyo);
            }
        }
    }

    private void setFieldValueWithPanelNew() {
        this.setLabelText("new_billno", (String)this.getView().getFormShowParameter().getCustomParam("billno"));
        this.setLabelText("new_creator", RequestContext.get().getUserName());
        this.setLabelText("new_createtime", HRDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
    }

    private void setFieldValueWithPanelViewB(DynamicObject onbrdBillInfo) {
        boolean lockFlag;
        Date starttime;
        Date validtime;
        DynamicObject nationality;
        this.getModel().setValue("picturefield", (Object)onbrdBillInfo.getString("picturefield"));
        String name = onbrdBillInfo.getString("name");
        if (HRStringUtils.isNotEmpty((String)name) && name.length() > 50) {
            name = name.substring(0, 50) + "...";
        }
        this.setLabelText("name", name);
        this.setLabelText("candidatenumber", onbrdBillInfo.getString("candidate.number"));
        if (StringUtils.isBlank((CharSequence)onbrdBillInfo.getString("candidate.number"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2112"});
        }
        if (StringUtils.isBlank((CharSequence)onbrdBillInfo.getString("gender.name"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"sexpanelap"});
        }
        this.setLabelText("sex", onbrdBillInfo.getString("gender.name"));
        if (StringUtils.isBlank((CharSequence)onbrdBillInfo.getString("onbrdtype.name"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"onbrdtypename"});
        }
        this.setLabelText("onbrdtypename", onbrdBillInfo.getString("onbrdtype.name"));
        if (StringUtils.isBlank((CharSequence)onbrdBillInfo.getString("phone"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"phonepanelap"});
        }
        this.getModel().setValue("phone", (Object)onbrdBillInfo.getString("phone"));
        this.getModel().setValue("email", (Object)onbrdBillInfo.getString("peremail"));
        if (HRStringUtils.isEmpty((String)onbrdBillInfo.getString("peremail"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"emailpanelap"});
        }
        if (HRObjectUtils.isEmpty((Object)(nationality = onbrdBillInfo.getDynamicObject("nationality")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"nationalitypanelap"});
        } else {
            this.setLabelText("nationality", nationality.getLocaleString("name").getLocaleValue());
        }
        this.setLabelText("aadminorgname", onbrdBillInfo.getString("acompany.name"));
        if (StringUtils.isBlank((CharSequence)onbrdBillInfo.getString("acompany.name"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap231"});
        }
        this.setLabelText("acompanyname", onbrdBillInfo.getString("aadminorg.name"));
        if (StringUtils.isBlank((CharSequence)onbrdBillInfo.getString("aadminorg.name"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap232"});
        }
        this.setLabelText("validtime", (validtime = onbrdBillInfo.getDate("validuntil")) != null ? HRInteDateTimeUtil.formatDate((String)"hom_onbrdinfo", (String)"validuntil", (Date)validtime) : "");
        if (validtime == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap21"});
        }
        this.setLabelText("starttime", (starttime = onbrdBillInfo.getDate("starttime")) != null ? HRInteDateTimeUtil.formatDate((String)"hom_onbrdinfo", (String)"starttime", (Date)starttime) : "");
        if (starttime == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap22"});
        }
        this.setLabelText("processstatus", ComboPropValueUtils.getDropdownListNameByCode((String)"hom_onbrdbilltpl", (String)"processstatus", (String)onbrdBillInfo.getString("processstatus")));
        this.setLabelStyle(onbrdBillInfo.getString("enrollstatus"));
        String status = onbrdBillInfo.getString("enrollstatus");
        boolean bl = lockFlag = HRStringUtils.equals((String)status, (String)OnbrdStatusEnum.HAS_ONBRD.toString()) || HRStringUtils.equals((String)status, (String)OnbrdStatusEnum.BREAK_UP.toString());
        if (lockFlag) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"picturefield"});
        }
        this.setNameByPositionType(onbrdBillInfo, "labelap1911");
        this.setValueByPositionType(onbrdBillInfo, "aposition");
        String viewType = onbrdBillInfo.getString("viewtype");
        String dropdownListNameByCode = ComboPropValueUtils.getDropdownListNameByCode((String)"hom_onbrdbilltpl", (String)"viewtype", (String)viewType);
        this.setLabelText("viewtype", dropdownListNameByCode);
    }

    private void setLabelText(String key, String value) {
        Label label = (Label)this.getView().getControl(key);
        if (label != null) {
            label.setText(value);
        }
    }

    private String setLabelStyle(String key) {
        if (key.equals(OnbrdStatusEnum.HAS_ONBRD.toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"view_enrollstatus"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"view_break", "view_exception", "view_waitstart"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"view_has"});
            return "view_has";
        }
        if (key.equals(OnbrdStatusEnum.BREAK_UP.toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"view_has", "view_exception"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"view_enrollstatus", "view_waitstart"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"view_break"});
            return "view_break";
        }
        if (key.equals(OnbrdStatusEnum.WAIT_START.toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"view_break", "view_has", "view_enrollstatus", "view_exception"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"view_waitstart"});
            return "view_waitstart";
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"view_break"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"view_has", "view_exception", "view_waitstart"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"view_enrollstatus"});
        return "view_enrollstatus";
    }
}

