/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.common.entity.ListNode;
import kd.hr.hom.common.enums.ViewTypeEnum;

public class ReentryPersonnelConfirmEdit
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(ReentryPersonnelConfirmEdit.class);
    private static final String NODE_ID = "nodeId";
    private static final String LIST_NODE = "listNode";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"btnprev", "btnnext", "btnok", "btntrue"});
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        String data = (String)this.getView().getFormShowParameter().getCustomParam("data");
        if (StringUtils.isBlank((CharSequence)data)) {
            LOGGER.info("ReentryPersonnelConfirmEdit is empty");
            return;
        }
        List resultList = (List)JSONObject.parseObject((String)data, List.class);
        LOGGER.info("ReentryPersonnelConfirmEdit resultList {}", (Object)resultList);
        if (resultList == null || resultList.isEmpty()) {
            LOGGER.info("ReentryPersonnelConfirmEdit is empty");
            return;
        }
        int size = resultList.size();
        Map result = (Map)resultList.get(0);
        if (size == 1) {
            IPageCache pageCache = this.getView().getPageCache();
            Long pid = HRJSONUtils.getLongValOfCustomParam(result.get("personindexid"));
            pageCache.put(NODE_ID, String.valueOf(pid));
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnprev", "btnnext", "btnok", "btncancel", "mulittippanelap"});
            this.setValue(result);
        } else {
            List pidResultList;
            IPageCache pageCache = this.getView().getPageCache();
            Long nodeId = HRJSONUtils.getLongValOfCustomParam((Object)pageCache.get(NODE_ID));
            if (nodeId != null && !CollectionUtils.isEmpty(pidResultList = resultList.stream().filter(result1 -> nodeId.equals(HRJSONUtils.getLongValOfCustomParam(result1.get("personindexid")))).collect(Collectors.toList()))) {
                result = (Map)pidResultList.get(0);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"btntrue", "btnfalse", "singletippanelap"});
            this.setValue(result);
            Long pid = HRJSONUtils.getLongValOfCustomParam(result.get("personindexid"));
            List pids = resultList.stream().map(tmp -> HRJSONUtils.getLongValOfCustomParam(tmp.get("personindexid"))).collect(Collectors.toList());
            List listNodes = ListNode.getListNodes(pids);
            pageCache.put(LIST_NODE, JSONObject.toJSONString((Object)listNodes));
            pageCache.put(NODE_ID, String.valueOf(pid));
            Long nextId = ListNode.getNextId((List)listNodes, (Long)pid);
            Long prevId = ListNode.getPrevId((List)listNodes, (Long)pid);
            if (nextId == 0L) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"btnnext"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"btnnext"});
            }
            if (prevId == 0L) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"btnprev"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"btnprev"});
            }
        }
    }

    private void setValue(Map<String, Object> result) {
        LOGGER.info("ReentryPersonnelConfirmEdit result=== {}", result);
        IDataModel dataEntity = this.getView().getModel();
        dataEntity.setValue("personindexid", result.get("personindexid"));
        dataEntity.setValue("name", result.getOrDefault("name", " "));
        dataEntity.setValue("oemployeeno", result.getOrDefault("number", " "));
        Map hrpiPercontact = result.get("hrpi_percontact") == null ? Collections.EMPTY_MAP : (Map)result.get("hrpi_percontact");
        dataEntity.setValue("phone", (Object)hrpiPercontact.getOrDefault("phone", " "));
        Map hrpiEmpentrel = result.get("hrpi_empentrel") == null ? new HashMap() : (Map)result.get("hrpi_empentrel");
        dataEntity.setValue("personfield", hrpiEmpentrel.get("employee_id"));
        Map hrpiPernontsprop = result.get("hrpi_pernontsprop") == null ? new HashMap() : (Map)result.get("hrpi_pernontsprop");
        dataEntity.setValue("gender", hrpiPernontsprop.get("gender_id"));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put("btnprev", this::prev);
        params.put("btnnext", this::next);
        params.put("btnok", this::isThisPerson);
        params.put("btntrue", this::isTrue);
        params.getOrDefault(key, () -> {}).run();
    }

    private void isTrue() {
        this.skipAgainPage();
    }

    public void skipAgainPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u518d\u5165\u804c\u7533\u8bf7", (String)"OnbrdInfoEdit_19", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("hom_persononbrdhandlebody");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPageId(this.getView().getPageId() + "hom_persononbrdhandlebody");
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("onbrdid", (Object)"0");
        showParameter.setCustomParam("candidateid", (Object)"0");
        showParameter.setCustomParam("viewtype", (Object)ViewTypeEnum.AGAIN.getCode());
        showParameter.setCustomParam("routine_skip", (Object)Boolean.TRUE);
        IPageCache pageCache = this.getView().getPageCache();
        Long nodeId = HRJSONUtils.getLongValOfCustomParam((Object)pageCache.get(NODE_ID));
        showParameter.setCustomParam("personindexid", (Object)nodeId);
        showParameter.setCustomParam("piddata", (Object)SerializationUtils.serializeToBase64((Object)this.getModel().getDataEntity()));
        this.getView().showForm(showParameter);
    }

    private void isThisPerson() {
        this.skipAgainPage();
    }

    private void next() {
        Long nodeId;
        IPageCache pageCache = this.getView().getPageCache();
        List listNodes = JSONObject.parseArray((String)pageCache.get(LIST_NODE), ListNode.class);
        Long nextId = ListNode.getNextId((List)listNodes, (Long)(nodeId = Long.valueOf(pageCache.get(NODE_ID))));
        if (nextId != 0L) {
            pageCache.put(NODE_ID, String.valueOf(nextId));
        }
        this.getView().updateView();
    }

    private void prev() {
        Long nodeId;
        IPageCache pageCache = this.getView().getPageCache();
        List listNodes = JSONObject.parseArray((String)pageCache.get(LIST_NODE), ListNode.class);
        Long prevId = ListNode.getPrevId((List)listNodes, (Long)(nodeId = Long.valueOf(pageCache.get(NODE_ID))));
        if (prevId != 0L) {
            pageCache.put(NODE_ID, String.valueOf(prevId));
        }
        this.getView().updateView();
    }
}

