/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.imports;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.imp.MultiEntityRowData;
import kd.hr.hbp.formplugin.web.multimport.HRMultipleEntitiesImportPlugin;
import kd.hr.hom.business.application.impl.rule.HcfBankValidator;
import kd.hr.hom.business.application.impl.rule.HcfContactValidator;
import kd.hr.hom.business.application.impl.rule.HcfEduExpValidator;
import kd.hr.hom.business.application.impl.rule.HcfFamilyValidator;
import kd.hr.hom.business.application.impl.rule.HcfLgabilityValidator;
import kd.hr.hom.business.application.impl.rule.HcfMultiRowCommonValidator;
import kd.hr.hom.business.application.impl.rule.OnbrdImportInitServiceImpl;
import kd.hr.hom.business.application.impl.rule.OnbrdMultiImportValidator;
import kd.hr.hom.business.application.rule.IMultiImportValidatorService;
import kd.hr.hom.business.application.rule.IOnbrdImportCacheService;
import kd.hr.hom.business.domain.service.impl.hcf.HcfDataDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.constant.MultiEntityImportConstants;
import kd.sdk.hr.hom.service.IOnbrdInfoService;

public class OnbrdMultiEntitiesImportPlugin
extends HRMultipleEntitiesImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(OnbrdMultiEntitiesImportPlugin.class);
    private static final Map<String, IMultiImportValidatorService> IMPORT_VALIDATOR_MAP = ImmutableMap.builder().put((Object)"hom_personwaitstart", (Object)new OnbrdMultiImportValidator()).put((Object)"hcf_caneduexp", (Object)new HcfEduExpValidator()).put((Object)"hcf_cancontact_ext", (Object)new HcfContactValidator()).put((Object)"hcf_canfamily_ext", (Object)new HcfFamilyValidator()).put((Object)"hcf_canbankcard", (Object)new HcfBankValidator()).put((Object)"hcf_canlgability", (Object)new HcfLgabilityValidator()).put((Object)"hcf_canprework", (Object)new HcfMultiRowCommonValidator()).put((Object)"hcf_rsmpatinv", (Object)new HcfMultiRowCommonValidator()).build();

    public void wrapOriginalJson(List<ImportBillData> rowdatas, Map<String, ImportLogger> importLoggerMap, String optionCode) {
        LOGGER.info("start wrapOriginalJson:{}", (Object)rowdatas.size());
        try {
            super.wrapOriginalJson(rowdatas, importLoggerMap, optionCode);
            new OnbrdImportInitServiceImpl().wrapOriginalJson(rowdatas, importLoggerMap, optionCode);
        }
        catch (Throwable throwable) {
            LOGGER.error(throwable);
            String errorMsg = RequestContext.getOrCreate().getTraceId() + ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnbrdMultiEntitiesImportPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            for (ImportBillData rowData : rowdatas) {
                JSONObject data = rowData.getData().getJSONObject("data");
                String entityName = (String)data.keySet().iterator().next();
                importLoggerMap.get(entityName).log(Integer.valueOf(rowData.getStartIndex()), errorMsg);
            }
        }
        LOGGER.info("end wrapOriginalJson:{}", (Object)rowdatas.size());
    }

    public List<MultiEntityRowData> getValidateErrDataList() {
        List errDataList = super.getValidateErrDataList();
        if (CollectionUtils.isEmpty((Collection)errDataList)) {
            return errDataList;
        }
        LOGGER.info("errDataList.size():" + errDataList.size());
        List validErrDataDeleteList = errDataList.stream().filter(rowData -> HRStringUtils.equals((String)rowData.getOptionCode(), (String)"new")).collect(Collectors.toList());
        Map<String, List<MultiEntityRowData>> validErrDataDeleteListMap = validErrDataDeleteList.stream().collect(Collectors.groupingBy(MultiEntityRowData::getMainEntity));
        for (Map.Entry<String, List<MultiEntityRowData>> entry : validErrDataDeleteListMap.entrySet()) {
            Map passedRowdatasMap = IOnbrdImportCacheService.getInstance().getWrapPassedRelationInfos();
            Set<Long> candidateIdSet = entry.getValue().stream().filter(errData -> errData.getOpEntity().getDynamicObject("candidate") != null).filter(errData -> {
                String sheetName = errData.getMainEntity();
                int rowNum = errData.getRownum();
                String candidateNum = errData.getOpEntity().getString("candidate.number");
                Integer passedRowdataIndex = (Integer)passedRowdatasMap.get(candidateNum);
                return !HRStringUtils.equals((String)"hom_personwaitstart", (String)sheetName) || passedRowdataIndex == null || passedRowdataIndex == rowNum;
            }).map(errData -> {
                DynamicObject candidate = errData.getOpEntity().getDynamicObject("candidate");
                return candidate == null ? 0L : candidate.getLong("id");
            }).collect(Collectors.toSet());
            LOGGER.info("getValidateErrDataList, candidateIdSet.size():" + candidateIdSet.size());
            this.deleteAllByCandidateIds("new", entry.getKey(), candidateIdSet);
        }
        return errDataList;
    }

    public void customOpName(Map<String, String> opNameMap) {
        super.customOpName(opNameMap);
        String opSave = "his_save";
        opNameMap.put("hcf_caneduexp", opSave);
        opNameMap.put("hcf_cancontact_ext", opSave);
        opNameMap.put("hcf_canfamily_ext", opSave);
        opNameMap.put("hcf_canlgability", opSave);
        opNameMap.put("hcf_canprework", opSave);
    }

    public void extendProcessRowData(Map<String, ImportLogger> importLoggerMap, String optionCode, List<MultiEntityRowData> rowDataList) {
        LOGGER.info("start extendProcessRowData," + rowDataList.size());
        super.extendProcessRowData(importLoggerMap, optionCode, rowDataList);
        Map<String, List<MultiEntityRowData>> sheetMap = rowDataList.stream().collect(Collectors.groupingBy(MultiEntityRowData::getMainEntity));
        for (Map.Entry<String, List<MultiEntityRowData>> entry : sheetMap.entrySet()) {
            UnmodifiableIterator errorRows = importLoggerMap.get(entry.getKey()).getLogCache().keySet();
            entry.setValue(entry.getValue().stream().filter(rowData -> !errorRows.contains(rowData.getRownum())).collect(Collectors.toList()));
        }
        HashSet deleteCandidateNums = Sets.newHashSetWithExpectedSize((int)rowDataList.size());
        ArrayList<Tuple> sheetTupleList = new ArrayList<Tuple>(sheetMap.size());
        sheetTupleList.add(Tuple.create((Object)"hom_onbrdpersoninfo", sheetMap.get("hom_onbrdpersoninfo")));
        sheetTupleList.add(Tuple.create((Object)"hom_personwaitstart", sheetMap.get("hom_personwaitstart")));
        for (String sheetEntityName : MultiEntityImportConstants.ENTITY_SHEET_SEQUENCE) {
            sheetTupleList.add(Tuple.create((Object)sheetEntityName, sheetMap.get(sheetEntityName)));
        }
        IOnbrdImportCacheService importCacheService = IOnbrdImportCacheService.getInstance();
        for (Tuple sheetTuple : sheetTupleList) {
            String entityName = (String)sheetTuple.item1;
            List sheetRowDataList = (List)sheetTuple.item2;
            if (CollectionUtils.isEmpty((Collection)sheetRowDataList)) continue;
            LOGGER.info("entityName:" + entityName + ", deleteCandidateNums:" + JSONObject.toJSONString((Object)deleteCandidateNums));
            ImportLogger importLogger = importLoggerMap.get(entityName);
            sheetRowDataList.stream().forEach(rowData -> {
                String candidateNumber = rowData.getOpEntity().getString("candidate.number");
                if (deleteCandidateNums.contains(candidateNumber)) {
                    importLogger.log(rowData.getRownum(), ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5019\u9009\u4eba\u3002", (String)"OnbrdMultiEntitiesImportPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                }
            });
            CopyOnWriteArraySet errorRowsBeforeValid = Sets.newCopyOnWriteArraySet(importLogger.getLogCache().keySet());
            LOGGER.info(entityName + " before validate:" + sheetRowDataList.size() + ",errorRowsBeforeValid:" + JSONObject.toJSONString((Object)errorRowsBeforeValid));
            this.validate(entityName, optionCode, sheetRowDataList, importLogger);
            importCacheService.putRelationInfosToCache(sheetRowDataList, entityName);
            CopyOnWriteArraySet errorRows = Sets.newCopyOnWriteArraySet(importLogger.getLogCache().keySet());
            deleteCandidateNums.addAll(sheetRowDataList.stream().filter(rowData -> errorRows.contains(rowData.getRownum())).map(rowData -> rowData.getOpEntity().getString("candidate.number")).collect(Collectors.toSet()));
            LOGGER.info(entityName + " end validate:" + sheetRowDataList.size() + ", errorRows:" + JSONObject.toJSONString((Object)errorRows));
            errorRows.removeAll(errorRowsBeforeValid);
            Set<Long> candidateIdSet = rowDataList.stream().filter(rowData -> errorRows.contains(rowData.getRownum())).map(rowData -> rowData.getOpEntity().getLong("candidate.id")).collect(Collectors.toSet());
            this.showErrorMsgForPreSheet(optionCode, entityName, candidateIdSet);
        }
        LOGGER.info("end extendProcessRowData," + rowDataList.size());
    }

    private void validate(String entityName, String optionCode, List<MultiEntityRowData> sheetRowDataList, ImportLogger importLogger) {
        try {
            IMultiImportValidatorService importValidator = IMPORT_VALIDATOR_MAP.get(entityName);
            if (importValidator != null) {
                importValidator.validate(optionCode, sheetRowDataList, importLogger);
            }
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IOnbrdInfoService.class, (String)"kd.sdk.hr.hom.service.IOnbrdInfoService", null);
            hrPluginProxy.callReplace(hrPlugin -> {
                hrPlugin.validateMultiOnbrd(entityName, optionCode, sheetRowDataList, importLogger);
                return null;
            });
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            String errorMsg = RequestContext.getOrCreate().getTraceId() + ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnbrdMultiEntitiesImportPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            for (MultiEntityRowData rowData : sheetRowDataList) {
                importLogger.log(rowData.getRownum(), errorMsg);
            }
        }
    }

    public List<MultiEntityRowData> getOpErrDataList() {
        List opErrDataList = super.getOpErrDataList();
        if (CollectionUtils.isEmpty((Collection)opErrDataList)) {
            return opErrDataList;
        }
        LOGGER.info("opErrDataList.size():" + opErrDataList.size());
        List opErrDataDeleteList = opErrDataList.stream().filter(rowData -> HRStringUtils.equals((String)rowData.getOptionCode(), (String)"new")).collect(Collectors.toList());
        Map<String, List<MultiEntityRowData>> opErrDataDeleteListMap = opErrDataDeleteList.stream().collect(Collectors.groupingBy(MultiEntityRowData::getMainEntity));
        for (Map.Entry<String, List<MultiEntityRowData>> entry : opErrDataDeleteListMap.entrySet()) {
            Set<Long> candidateIdSet = entry.getValue().stream().filter(errData -> errData.getOpEntity().getDynamicObject("candidate") != null).map(errData -> {
                DynamicObject candidate = errData.getOpEntity().getDynamicObject("candidate");
                return candidate == null ? 0L : candidate.getLong("id");
            }).collect(Collectors.toSet());
            LOGGER.info("getOpErrDataList, candidateIdSet.size():" + candidateIdSet.size());
            this.deleteAllByCandidateIds("new", entry.getKey(), candidateIdSet);
        }
        return opErrDataList;
    }

    private void deleteAllByCandidateIds(String optionCode, String sheetName, Set<Long> candidateIds) {
        LOGGER.info("optionCode:" + optionCode);
        if (CollectionUtils.isEmpty(candidateIds)) {
            return;
        }
        LOGGER.info("candidateIds.size()\uff1a" + candidateIds.size() + "," + JSONObject.toJSON(candidateIds));
        List candidateIdSetCurrent = IOnbrdImportCacheService.getInstance().getCurrentNewCandidateIds();
        if (CollectionUtils.isEmpty((Collection)candidateIdSetCurrent)) {
            return;
        }
        Set candidateIdDeletes = candidateIds.stream().filter(candidateIdSetCurrent::contains).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(candidateIdDeletes)) {
            return;
        }
        LOGGER.info("candidateIdDeletes.size()\uff1a" + candidateIdDeletes.size() + "," + JSONObject.toJSON(candidateIdDeletes));
        HcfDataDomainService hcfDataDomainService = new HcfDataDomainService();
        ArrayList candidateIdList = new ArrayList(candidateIdDeletes);
        for (String entityName : MultiEntityImportConstants.CANDIDATE_ATTACH_ENTITY) {
            hcfDataDomainService.deleteHcfAttachedData(entityName, candidateIdList);
        }
        hcfDataDomainService.deleteByIds(candidateIdDeletes, "hcf_candidate");
        int deleteNumOnbrd = IOnbrdBillDomainService.getInstance().deleteByCandidateIds(candidateIdDeletes);
        this.showErrorMsgForPreSheet(optionCode, sheetName, candidateIds);
        LOGGER.info("End deleteAllByCandidateIds {}, deleteNumOnbrd:{}", (Object)candidateIdDeletes.size(), (Object)deleteNumOnbrd);
    }

    private void showErrorMsgForPreSheet(String optionCode, String sheetName, Collection<Long> candidateIds) {
        String sheetEntityName;
        LOGGER.info("optionCode:" + optionCode + ",sheetName:" + sheetName);
        if (!HRStringUtils.equals((String)optionCode, (String)"new") || HRStringUtils.equals((String)sheetName, (String)"hom_personwaitstart") || HRStringUtils.equals((String)sheetName, (String)"hom_onbrdpersoninfo")) {
            return;
        }
        LOGGER.info("Start showErrorMsgForPreSheet " + candidateIds.size());
        if (CollectionUtils.isEmpty(candidateIds)) {
            return;
        }
        LOGGER.info("candidateIds.size()\uff1a" + candidateIds.size() + "," + JSONObject.toJSON(candidateIds));
        String subfix = ResManager.loadKDString((String)"\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"OnbrdMultiEntitiesImportPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        String errorMsg = HcfMultiRowCommonValidator.getEntityName((String)sheetName) + subfix;
        Map onbrdRelationInfoMap = IOnbrdImportCacheService.getInstance().getRelationInfosFromCache("hom_personwaitstart");
        this.setErrorImportMsgBatch("hom_personwaitstart", errorMsg, onbrdRelationInfoMap, candidateIds);
        UnmodifiableIterator unmodifiableIterator = MultiEntityImportConstants.ENTITY_SHEET_SEQUENCE.iterator();
        while (unmodifiableIterator.hasNext() && !HRStringUtils.equals((String)(sheetEntityName = (String)unmodifiableIterator.next()), (String)sheetName)) {
            Map relationInfoMap = IOnbrdImportCacheService.getInstance().getRelationInfosFromCache(sheetEntityName);
            this.setErrorImportMsgBatch(sheetEntityName, errorMsg, relationInfoMap, candidateIds);
        }
        LOGGER.info("End showErrorMsgForPreSheet");
    }

    private void setErrorImportMsgBatch(String sheetName, String errorMsg, Map<Integer, Long> relationInfoMap, Collection<Long> candidateIds) {
        LOGGER.info("sheetName:" + sheetName + ", relationInfoMap:" + JSONObject.toJSONString(relationInfoMap));
        for (Map.Entry<Integer, Long> entry : relationInfoMap.entrySet()) {
            if (!candidateIds.contains(entry.getValue())) continue;
            this.setErrorImportMsg(sheetName, entry.getKey(), errorMsg);
        }
    }
}

