/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.formplugin.common.ApBuildUtils;
import kd.hr.hom.formplugin.web.base.HcfDataBaseEdit;
import kd.hr.hom.formplugin.web.personmange.personinfo.CanFamilyShowPlugin;
import kd.sdk.hr.hom.business.personinfo.IBankCardService;

public class BankCardShowPlugin
extends HcfDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(CanFamilyShowPlugin.class);
    private static final String BTN_EDIT = "btn_edit";
    private static final String BTN_DEL = "btn_del";
    private static final String BTN_VIEW = "btn_view";
    private static final String EDITANDDELETEAP = "editanddeleteap";
    private static final String VIEWAP = "viewap";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map customParamsmap = showParameter.getCustomParams();
        ApBuildUtils.setLabelData(this.getView(), "bankdeposit", (String)customParamsmap.get("bankdeposit"));
        this.getView().getModel().setValue("account", customParamsmap.get("account"));
        HRPluginProxy hrPluginProxySdk = HRPlugInProxyFactory.create(null, IBankCardService.class, (String)"kd.sdk.hr.hom.business.personinfo.IBankCardService", null);
        hrPluginProxySdk.callReplace(hrPlugin -> {
            hrPlugin.setViewModel(this.getView().getModel(), customParamsmap);
            return null;
        });
        ApBuildUtils.setLabelData(this.getView(), "name", (String)customParamsmap.get("name"));
        this.isEnrolled(customParamsmap.get("onbrdid"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRObjectUtils.isEmpty((Object)args.getOperationResult()) || !args.getOperationResult().isSuccess()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        if (BTN_EDIT.equals(operate.getOperateKey())) {
            String appId = this.getView().getFormShowParameter().getAppId();
            if (IOnbrdCommonAppService.getInstance().checkPermission("hom_bankcard_show", "4715a0df000000ac", appId) || IOnbrdCommonAppService.getInstance().checkPermission("hom_bankcard_view", "4715a0df000000ac", appId)) {
                this.editBankPage(OperationStatus.EDIT);
            } else {
                this.editBankPage(OperationStatus.VIEW);
            }
        }
        if (BTN_DEL.equals(operate.getOperateKey())) {
            this.delBankPage(this.getView().getFormShowParameter().getCustomParam("id").toString());
        }
        if (BTN_VIEW.equals(operate.getOperateKey())) {
            this.editBankPage(OperationStatus.VIEW);
        }
    }

    private void isEnrolled(Object onbrd) {
        if (onbrd instanceof Long) {
            boolean isEnroll = IOnbrdBillDomainService.getInstance().isEnrolled((Long)onbrd);
            if (isEnroll) {
                this.getView().setVisible(Boolean.FALSE, new String[]{EDITANDDELETEAP});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{VIEWAP});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        if (HRStringUtils.equals((String)actionId, (String)BTN_DEL) && MessageBoxResult.Yes == resultValue) {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String conBankId = pageCache.get("canBankId");
            try {
                Map result = IHomToHcfAppService.getInstance().deleteByIdNoHis(Long.valueOf(conBankId), "hcf_canbankcard");
                Boolean success = (Boolean)result.get("success");
                if (success.booleanValue()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"CanFamilyEdit_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    this.getView().getParentView().updateView();
                    this.getView().sendFormAction(this.getView().getParentView());
                } else {
                    this.getView().showErrorNotification((String)result.get("message"));
                }
            }
            finally {
                IOnbrdCommonAppService.getInstance().releaseLockByHCF(Long.valueOf(conBankId), "hcf_canbankcard", "delete");
            }
        }
    }

    private void delBankPage(String id) {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        if (!this.checkDataIsExistById(Long.valueOf(id), candidateId)) {
            String errMsg = ResManager.loadKDString((String)"\u8be5\u6761\u94f6\u884c\u5361\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"Bankcard_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errMsg);
            return;
        }
        if (!this.getRequireLock("delete")) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5f53\u524d\u8bb0\u5f55\uff1f", (String)"CanFamilyEdit_1", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_DEL, (IFormPlugin)this));
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put("canBankId", id);
    }

    private boolean checkDataIsExistById(Long id, Long candidateId) {
        DynamicObjectCollection coll = IHomToHcfAppService.getInstance().getHisMultiRowEntityById(id, candidateId, "hcf_canbankcard");
        return !CollectionUtils.isEmpty((Collection)coll);
    }

    private void editBankPage(OperationStatus operationStatus) {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        if (!this.checkDataIsExistById(id, candidateId)) {
            String errMsg = ResManager.loadKDString((String)"\u8be5\u6761\u94f6\u884c\u5361\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"Bankcard_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errMsg);
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(operationStatus);
        if (HRStringUtils.equals((String)OperationStatus.EDIT.name(), (String)operationStatus.name()) && !this.getRequireLock("modify")) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        formShowParameter.setCustomParam("onbrdid", (Object)onbrdBillId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hom_bankcard_edit");
        formShowParameter.setCustomParam("candidateid", (Object)candidateId);
        formShowParameter.setCustomParam("id", (Object)id);
        formShowParameter.setCustomParam("hom_bankcard_show", (Object)"hom_bankcard_show");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u94f6\u884c\u5361\u4fe1\u606f", (String)"Bankcard_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private boolean getRequireLock(String opKey) {
        Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        return IOnbrdCommonAppService.getInstance().tryRequireLockByHCF(this.getView(), id, "hcf_canbankcard", opKey);
    }
}

