/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.page.OnbrdNullPageServiceImpl;
import kd.hr.hom.business.application.impl.page.PanelApAdatper;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.formplugin.web.base.HcfDataBaseEdit;
import kd.sdk.hr.hom.business.personinfo.IBankCardService;

public class BankCardViewPlugin
extends HcfDataBaseEdit {
    private static final String BTN_ADD = "btn_add";
    private static final String FLEXPANELAP1 = "flexpanelap1";
    private static final String KEY_ONBRDNULLPAGE = "onbrdnullpage";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        this.isEnrollStatus(onbrdBillId, this.getView());
        this.refreshBankCardData();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRObjectUtils.isEmpty((Object)args.getOperationResult()) || !args.getOperationResult().isSuccess()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        if (BTN_ADD.equals(operate.getOperateKey())) {
            this.addBankCardView();
        }
    }

    private void addBankCardView() {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hom_bankcard_edit"));
        formShowParameter.setFormId("hom_bankcard_edit");
        formShowParameter.setCustomParam("candidateid", (Object)candidateId);
        formShowParameter.setCustomParam("onbrdid", this.getView().getFormShowParameter().getCustomParam("id"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u94f6\u884c\u5361\u4fe1\u606f", (String)"Bankcard_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private void refreshBankCardData() {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        DynamicObjectCollection bankInfos = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_canbankcard");
        if (CollectionUtils.isEmpty((Collection)bankInfos)) {
            new OnbrdNullPageServiceImpl().loadOnbrdNullPage(this.getView());
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ONBRDNULLPAGE});
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAP1});
        this.showUpBankCardView(bankInfos, candidateId);
    }

    private void showUpBankCardView(DynamicObjectCollection bankCollection, Long candidateId) {
        List bankInfos = bankCollection.stream().sorted(Comparator.comparing(dyo -> dyo.getDate("createtime"), Comparator.reverseOrder())).collect(Collectors.toList());
        FlexPanelAp allBankPanel = this.generateBankPanel(FLEXPANELAP1);
        for (int i = 0; i < bankInfos.size(); ++i) {
            DynamicObject bankInfo = (DynamicObject)bankInfos.get(i);
            PanelApAdatper bankInfoAdapter = new PanelApAdatper("allBankPanel" + i){

                public void setStyle() {
                    this.panelAp.setWidth(new LocaleString("340"));
                    this.panelAp.setHeight(new LocaleString("140px"));
                    this.panelAp.setGrow(0);
                    this.panelAp.setShrink(0);
                }
            };
            Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey("allBankPanel" + i);
            formShowParameter.setStatus(OperationStatus.VIEW);
            formShowParameter.setFormId("hom_bankcard_show");
            formShowParameter.setCustomParams(this.getBankParams(bankInfo));
            formShowParameter.setCustomParam("index", (Object)(i + 1 + ""));
            formShowParameter.setCustomParam("candidateid", (Object)candidateId);
            formShowParameter.setCustomParam("onbrdid", (Object)onbrdId);
            formShowParameter.setCustomParam("id", bankInfo.get("id"));
            this.getView().showForm(formShowParameter);
            allBankPanel.getItems().add(bankInfoAdapter.getPanelAp());
        }
        this.getView().updateControlMetadata(allBankPanel.getKey(), allBankPanel.createControl());
    }

    private Map<String, Object> getBankParams(DynamicObject bankInfo) {
        HashMap customParamsmap = Maps.newHashMapWithExpectedSize((int)6);
        String name = bankInfo.getString("name");
        customParamsmap.put("name", name);
        String accout = bankInfo.getString("account");
        customParamsmap.put("account", accout);
        DynamicObject bankdeposit = bankInfo.getDynamicObject("bankdeposit");
        customParamsmap.put("bankdeposit", HRObjectUtils.isEmpty((Object)bankdeposit) ? "" : bankdeposit.getString("name"));
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IBankCardService.class, (String)"kd.sdk.hr.hom.business.personinfo.IBankCardService", null);
        hrPluginProxy.callReplace(p -> {
            p.setCustomParamsMap(customParamsmap, bankInfo);
            return null;
        });
        return customParamsmap;
    }

    private FlexPanelAp generateBankPanel(String panelKey) {
        PanelApAdatper mainPanelApt = new PanelApAdatper(panelKey){

            public void setStyle() {
                this.panelAp.setGrow(0);
                this.panelAp.setShrink(1);
                this.panelAp.setAlignSelf("stretch");
            }
        };
        return mainPanelApt.getPanelAp();
    }

    private boolean isEnrollStatus(Long onbrdId, IFormView view) {
        boolean isEnroll = IOnbrdBillDomainService.getInstance().isEnrolled(onbrdId);
        if (isEnroll) {
            view.setVisible(Boolean.FALSE, new String[]{BTN_ADD});
            return true;
        }
        return false;
    }
}

