/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.extension.PersonInfoExService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.common.util.PutValueToModelUtils;
import kd.hr.hom.formplugin.web.base.HomDataBaseEdit;
import kd.sdk.hr.hom.business.personinfo.ICanFamilyService;

public class CanFamilyEditPlugin
extends HomDataBaseEdit {
    private static final Log logger = LogFactory.getLog(CanFamilyEditPlugin.class);
    private String CANFAMILY_PROPERTIES = "name,familymembship,mobilephone,contactaddr,country,workunit";
    private static final String BTN_SAVE = "btnsave";
    private static final String KEY_NAME = "name";
    private static final String KEY_FAMILYMEMBSHIP = "familymembship";
    private static final String KEY_MOBILEPHONE = "mobilephone";
    private static final String KEY_CONTACTADDR = "contactaddr";
    private static final String KEY_COUNTRY = "country";
    private static final String KEY_WORKUNIT = "workunit";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String status = formShowParameter.getStatus().name();
        if (HRStringUtils.equals((String)status, (String)"VIEW")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SAVE});
        }
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("candidateid"));
        this.getView().getModel().setValue("candidate", (Object)candidateId);
        Long maidId = (Long)formShowParameter.getCustomParam("id");
        if (!HRObjectUtils.isEmpty((Object)maidId)) {
            Set exFields = PersonInfoExService.getExFields((IFormView)this.getView());
            if (!CollectionUtils.isEmpty((Collection)exFields)) {
                this.CANFAMILY_PROPERTIES = this.CANFAMILY_PROPERTIES + "," + String.join((CharSequence)",", exFields);
            }
            HashMap<String, String> entityFields = new HashMap<String, String>(2);
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, kd.hr.hom.business.application.extension.ICanFamilyService.class, (String)"kd.hr.hom.business.application.extension.ICanFamilyService", null);
            hrPluginProxy.callReplace(kd.hr.hom.business.application.extension.ICanFamilyService::getCanFamilyExtProperties).forEach(properties -> {
                if (HRStringUtils.isNotEmpty((String)properties)) {
                    this.CANFAMILY_PROPERTIES = properties;
                }
            });
            HRPluginProxy hrPluginProxySdk = HRPlugInProxyFactory.create(null, ICanFamilyService.class, (String)"kd.sdk.hr.hom.business.personinfo.ICanFamilyService", null);
            hrPluginProxySdk.callReplace(ICanFamilyService::getCanFamilyExtProperties).forEach(properties -> {
                if (HRStringUtils.isNotEmpty((String)properties)) {
                    this.CANFAMILY_PROPERTIES = properties;
                }
            });
            entityFields.put("hcf_canfamily", this.CANFAMILY_PROPERTIES);
            Map map = IHomToHcfAppService.getInstance().getCandidate(candidateId, entityFields, Long.valueOf(0L));
            DynamicObjectCollection canFamilyCollection = (DynamicObjectCollection)map.get("hcf_canfamily");
            for (DynamicObject obj : canFamilyCollection) {
                if (obj.getLong("id") != maidId.longValue()) continue;
                PutValueToModelUtils.putValueToModel((IFormView)this.getView(), (DynamicObject)obj, (String[])this.CANFAMILY_PROPERTIES.split(","));
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String isAlreadyClose = this.getPageCache().get("isalreadyclose");
        if (this.getModel().getDataChanged() && HRStringUtils.isEmpty((String)isAlreadyClose)) {
            e.setCancel(true);
            this.clickCancelChanged("cancel");
        } else {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (HRStringUtils.equalsIgnoreCase((String)status.name(), (String)"VIEW")) {
                return;
            }
            Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
            IOnbrdCommonAppService.getInstance().releaseLockByHCF(id, "hcf_canfamily", "modify");
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_SAVE});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.checkDataValidate(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        boolean success = afterDoOperationEventArgs.getOperationResult().isSuccess();
        if (success && "save".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.updateOrSaveCanFamilyInfo();
            this.updateCanFamilyView();
        }
    }

    public void checkDataValidate(BeforeDoOperationEventArgs args) {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        if (IOnbrdCommonAppService.getInstance().isEnrolledWithTip(this.getView(), onbrdId)) {
            args.setCancel(true);
            return;
        }
        DynamicObject dyo = this.getModel().getDataEntity();
        String name = dyo.getString(KEY_NAME);
        DynamicObject relation = dyo.getDynamicObject(KEY_FAMILYMEMBSHIP);
        String mobilephone = dyo.getString(KEY_MOBILEPHONE);
        String errMsg = "";
        if (this.validateSameFamily(name, relation, mobilephone)) {
            errMsg = ResManager.loadKDString((String)"\u8be5\u5bb6\u5ead\u6210\u5458\u6570\u636e\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"CanFamilyEdit_3", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
            args.setCancel(true);
        }
    }

    private boolean validateSameFamily(String name, DynamicObject relation, String mobilephone) {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        QFilter filter = new QFilter(KEY_NAME, "=", (Object)name).and(KEY_FAMILYMEMBSHIP, "=", relation.get("id")).and(KEY_MOBILEPHONE, "=", (Object)mobilephone).and("id", "!=", this.getView().getFormShowParameter().getCustomParams().get("id"));
        DynamicObjectCollection entity = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_canfamily", new QFilter[]{filter});
        return !CollectionUtils.isEmpty((Collection)entity);
    }

    private void updateCanFamilyView() {
        this.getPageCache().put("isalreadyclose", "1");
        if (HRStringUtils.equals((String)"hom_canfamily_show", (String)((String)this.getView().getFormShowParameter().getCustomParam("hom_canfamily_show")))) {
            this.getView().getParentView().getParentView().updateView();
            this.getView().sendFormAction(this.getView().getParentView().getParentView());
            this.getView().close();
        } else {
            this.getView().getParentView().updateView();
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    private void updateOrSaveCanFamilyInfo() {
        DynamicObjectCollection coll;
        DynamicObject familyDyo = null;
        Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        if (!HRObjectUtils.isEmpty((Object)id) && !CollectionUtils.isEmpty((Collection)(coll = IHomToHcfAppService.getInstance().getHisMultiRowEntityById(id, candidateId, "hcf_canfamily")))) {
            familyDyo = (DynamicObject)coll.get(0);
        }
        DynamicObject personBaseDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_canfamily"));
        if (familyDyo == null) {
            personBaseDy.set("boid", null);
        } else {
            personBaseDy.set("boid", (Object)familyDyo.getLong("boid"));
        }
        personBaseDy.set("candidate", this.getView().getModel().getValue("candidate"));
        personBaseDy.set(KEY_NAME, this.getView().getModel().getValue(KEY_NAME));
        personBaseDy.set(KEY_MOBILEPHONE, this.getView().getModel().getValue(KEY_MOBILEPHONE));
        personBaseDy.set(KEY_CONTACTADDR, this.getView().getModel().getValue(KEY_CONTACTADDR));
        personBaseDy.set(KEY_COUNTRY, this.getView().getModel().getValue(KEY_COUNTRY));
        personBaseDy.set(KEY_FAMILYMEMBSHIP, this.getView().getModel().getValue(KEY_FAMILYMEMBSHIP));
        personBaseDy.set(KEY_WORKUNIT, this.getView().getModel().getValue(KEY_WORKUNIT));
        PersonInfoExService.setExFieldValue((IFormView)this.getView(), (DynamicObject)personBaseDy);
        HRPluginProxy hrPluginProxySdk = HRPlugInProxyFactory.create(null, ICanFamilyService.class, (String)"kd.sdk.hr.hom.business.personinfo.ICanFamilyService", null);
        hrPluginProxySdk.callReplace(hrPlugin -> {
            hrPlugin.setDataModel(personBaseDy, this.getView().getModel());
            return null;
        });
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.add((Object)personBaseDy);
        HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>(2);
        map.put("hcf_canfamily", collection);
        ArrayList<HashMap<String, DynamicObjectCollection>> list = new ArrayList<HashMap<String, DynamicObjectCollection>>(1);
        list.add(map);
        IHomToHcfAppService.getInstance().saveOrUpdateCandidates(list);
    }
}

