/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.extension.PersonInfoExService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.common.util.PutValueToModelUtils;
import kd.hr.hom.formplugin.web.base.HomDataBaseEdit;
import kd.sdk.hr.hom.business.personinfo.IBasePeronInfoService;
import kd.sdk.hr.hom.business.personinfo.ICancontactService;

public class CancontactEditPlugin
extends HomDataBaseEdit {
    private String CANCONTACT_PROPERTIES = "emrgname,emrgrelation,emrgphone,country";
    private static final String BTN_SAVE = "btnsave";
    private static final String KEY_EMRGNAME = "emrgname";
    private static final String KEY_EMRGRELATION = "emrgrelation";
    private static final String KEY_EMRGPHONE = "emrgphone";
    private static final String KEY_COUNTRY = "country";
    private static final Log logger = LogFactory.getLog(CancontactEditPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_SAVE});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.checkDataValidate(args);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String isAlreadyClose = this.getPageCache().get("isalreadyclose");
        if (this.getModel().getDataChanged() && HRStringUtils.isEmpty((String)isAlreadyClose)) {
            e.setCancel(true);
            this.clickCancelChanged("cancel");
        } else {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (HRStringUtils.equalsIgnoreCase((String)status.name(), (String)"VIEW")) {
                return;
            }
            Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
            IOnbrdCommonAppService.getInstance().releaseLockByHCF(id, "hcf_cancontact", "modify");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        boolean success = afterDoOperationEventArgs.getOperationResult().isSuccess();
        if (success && "save".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.updateOrSaveCanCantactInfo();
            this.updateContactView();
        }
    }

    public void checkDataValidate(BeforeDoOperationEventArgs args) {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        if (IOnbrdCommonAppService.getInstance().isEnrolledWithTip(this.getView(), onbrdId)) {
            args.setCancel(true);
            return;
        }
        DynamicObject dyo = this.getModel().getDataEntity();
        String emrgname = dyo.getString(KEY_EMRGNAME);
        DynamicObject relation = dyo.getDynamicObject(KEY_EMRGRELATION);
        String emrgphone = dyo.getString(KEY_EMRGPHONE);
        String errMsg = "";
        if (this.validateSameContact(emrgname, relation, emrgphone)) {
            errMsg = ResManager.loadKDString((String)"\u8be5\u7d27\u6025\u8054\u7cfb\u4eba\u6570\u636e\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"CanContactEdit_3", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
            args.setCancel(true);
        }
    }

    private boolean validateSameContact(String emrgname, DynamicObject relation, String emrgphone) {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        QFilter filter = new QFilter(KEY_EMRGNAME, "=", (Object)emrgname).and(KEY_EMRGRELATION, "=", relation.get("id")).and(KEY_EMRGPHONE, "=", (Object)emrgphone).and("id", "!=", this.getView().getFormShowParameter().getCustomParams().get("id"));
        DynamicObjectCollection entity = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_cancontact", new QFilter[]{filter});
        return !CollectionUtils.isEmpty((Collection)entity);
    }

    private void updateContactView() {
        this.getPageCache().put("isalreadyclose", "1");
        if (HRStringUtils.equals((String)"hom_emergencycontact_show", (String)((String)this.getView().getFormShowParameter().getCustomParam("hom_emergencycontact_show")))) {
            this.getView().getParentView().getParentView().updateView();
            this.getView().sendFormAction(this.getView().getParentView().getParentView());
            this.getView().close();
        } else {
            this.getView().getParentView().updateView();
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    private void updateOrSaveCanCantactInfo() {
        DynamicObjectCollection coll;
        DynamicObject contactDyo = null;
        Long id = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        if (!HRObjectUtils.isEmpty((Object)id) && !CollectionUtils.isEmpty((Collection)(coll = IHomToHcfAppService.getInstance().getHisMultiRowEntityById(id, candidateId, "hcf_cancontact")))) {
            contactDyo = (DynamicObject)coll.get(0);
        }
        DynamicObject personBaseDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_cancontact"));
        if (contactDyo == null) {
            personBaseDy.set("boid", null);
        } else {
            personBaseDy.set("boid", (Object)contactDyo.getLong("boid"));
        }
        personBaseDy.set("candidate", this.getView().getModel().getValue("candidate"));
        personBaseDy.set(KEY_EMRGNAME, this.getView().getModel().getValue(KEY_EMRGNAME));
        personBaseDy.set(KEY_EMRGRELATION, this.getView().getModel().getValue(KEY_EMRGRELATION));
        personBaseDy.set(KEY_EMRGPHONE, this.getView().getModel().getValue(KEY_EMRGPHONE));
        personBaseDy.set(KEY_COUNTRY, this.getView().getModel().getValue(KEY_COUNTRY));
        PersonInfoExService.setExFieldValue((IFormView)this.getView(), (DynamicObject)personBaseDy);
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, ICancontactService.class, (String)"kd.sdk.hr.hom.business.personinfo.ICancontactService", null);
        hrPluginProxy.callReplace(p -> {
            p.setDataModel(personBaseDy, this.getView().getModel());
            return null;
        });
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.add((Object)personBaseDy);
        HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>(2);
        map.put("hcf_cancontact", collection);
        ArrayList<HashMap<String, DynamicObjectCollection>> list = new ArrayList<HashMap<String, DynamicObjectCollection>>(1);
        list.add(map);
        IHomToHcfAppService.getInstance().saveOrUpdateCandidates(list);
    }

    public void afterCreateNewData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String status = formShowParameter.getStatus().name();
        if (HRStringUtils.equals((String)status, (String)"VIEW")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SAVE});
        }
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("candidateid"));
        this.getView().getModel().setValue("candidate", (Object)candidateId);
        Long maidId = (Long)formShowParameter.getCustomParam("id");
        if (!HRObjectUtils.isEmpty((Object)maidId)) {
            Set exFields = PersonInfoExService.getExFields((IFormView)this.getView());
            if (!CollectionUtils.isEmpty((Collection)exFields)) {
                this.CANCONTACT_PROPERTIES = this.CANCONTACT_PROPERTIES + "," + String.join((CharSequence)",", exFields);
            }
            HashMap<String, String> entityFields = new HashMap<String, String>(2);
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, ICancontactService.class, (String)"kd.sdk.hr.hom.business.personinfo.ICancontactService", null);
            hrPluginProxy.callReplace(IBasePeronInfoService::getExtProperties).forEach(fieldStr -> {
                this.CANCONTACT_PROPERTIES = fieldStr;
            });
            entityFields.put("hcf_cancontact", this.CANCONTACT_PROPERTIES);
            Map map = IHomToHcfAppService.getInstance().getCandidate(candidateId, entityFields, Long.valueOf(0L));
            DynamicObjectCollection contactCollection = (DynamicObjectCollection)map.get("hcf_cancontact");
            for (DynamicObject obj : contactCollection) {
                if (obj.getLong("id") != maidId.longValue()) continue;
                PutValueToModelUtils.putValueToModel((IFormView)this.getView(), (DynamicObject)obj, (String[])this.CANCONTACT_PROPERTIES.split(","));
                break;
            }
        }
    }
}

