/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.page.OnbrdNullPageServiceImpl;
import kd.hr.hom.business.application.impl.page.PanelApAdatper;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.formplugin.web.base.HcfDataBaseEdit;
import kd.sdk.hr.hom.business.personinfo.ICancontactService;

public class CancontactViewPlugin
extends HcfDataBaseEdit {
    private static final String BTN_ADD = "btn_add";
    private static final String KEY_FLEXPANELAP1 = "flexpanelap1";
    private static final String KEY_ONBRDNULLPAGE = "onbrdnullpage";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        this.generateViewForEnrollStatus(onbrdBillId, this.getView(), BTN_ADD);
        this.refreshEntryEntity();
    }

    private void refreshEntryEntity() {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        DynamicObjectCollection contactInfos = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_cancontact");
        if (CollectionUtils.isEmpty((Collection)contactInfos)) {
            new OnbrdNullPageServiceImpl().loadOnbrdNullPage(this.getView());
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEXPANELAP1});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ONBRDNULLPAGE});
        this.showUpCanContactView(contactInfos, candidateId);
    }

    private void showUpCanContactView(DynamicObjectCollection contactCollection, Long candidateId) {
        List contactInfos = contactCollection.stream().sorted(Comparator.comparing(dyo -> dyo.getDate("createtime"), Comparator.naturalOrder())).collect(Collectors.toList());
        FlexPanelAp allConContactPanel = this.generateCanContactPanel(KEY_FLEXPANELAP1);
        for (int i = 0; i < contactInfos.size(); ++i) {
            DynamicObject contactInfo = (DynamicObject)contactInfos.get(i);
            PanelApAdatper contactPanelStyleAdapter = new PanelApAdatper("contactPanel" + i){

                public void setStyle() {
                    this.panelAp.setWidth(new LocaleString("340px"));
                    this.panelAp.setHeight(new LocaleString("120px"));
                    this.panelAp.setGrow(0);
                    this.panelAp.setShrink(0);
                }
            };
            Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey("contactPanel" + i);
            formShowParameter.setStatus(OperationStatus.VIEW);
            formShowParameter.setFormId("hom_emergencycontact_show");
            formShowParameter.setCustomParams(this.getParamsMapForShowContact(contactInfo));
            formShowParameter.setCustomParam("index", (Object)(i + 1 + ""));
            formShowParameter.setCustomParam("candidateid", (Object)candidateId);
            formShowParameter.setCustomParam("onbrdid", (Object)onbrdId);
            formShowParameter.setCustomParam("id", contactInfo.get("id"));
            this.getView().showForm(formShowParameter);
            allConContactPanel.getItems().add(contactPanelStyleAdapter.getPanelAp());
        }
        this.getView().updateControlMetadata(allConContactPanel.getKey(), allConContactPanel.createControl());
    }

    private Map<String, Object> getParamsMapForShowContact(DynamicObject contactInfo) {
        HashMap customParamsmap = Maps.newHashMapWithExpectedSize((int)4);
        String emrgname = contactInfo.getString("emrgname");
        customParamsmap.put("emrgname", emrgname);
        String emrgphone = contactInfo.getString("emrgphone");
        customParamsmap.put("emrgphone", emrgphone);
        DynamicObject country = contactInfo.getDynamicObject("country");
        customParamsmap.put("country", HRObjectUtils.isEmpty((Object)country) ? "" : country.getString("name"));
        DynamicObject emrgrelation = contactInfo.getDynamicObject("emrgrelation");
        customParamsmap.put("emrgrelation", HRObjectUtils.isEmpty((Object)emrgrelation) ? "" : emrgrelation.getString("name"));
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, ICancontactService.class, (String)"kd.sdk.hr.hom.business.personinfo.ICancontactService", null);
        hrPluginProxy.callReplace(p -> {
            p.setCustomParamsMap(customParamsmap, contactInfo);
            return null;
        });
        return customParamsmap;
    }

    private FlexPanelAp generateCanContactPanel(String panelKey) {
        PanelApAdatper mainPanelApt = new PanelApAdatper(panelKey){

            public void setStyle() {
                this.panelAp.setGrow(0);
                this.panelAp.setShrink(1);
                this.panelAp.setAlignSelf("stretch");
            }
        };
        return mainPanelApt.getPanelAp();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRObjectUtils.isEmpty((Object)args.getOperationResult()) || !args.getOperationResult().isSuccess()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        if (BTN_ADD.equals(operate.getOperateKey())) {
            this.addCanContactView();
        }
    }

    private boolean generateViewForEnrollStatus(Long onbrdId, IFormView view, String ... btnStrs) {
        boolean isEnroll = IOnbrdBillDomainService.getInstance().isEnrolled(onbrdId);
        if (isEnroll) {
            view.setVisible(Boolean.FALSE, btnStrs);
            return true;
        }
        return false;
    }

    private void addCanContactView() {
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hom_emergencycontact_edit");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hom_emergencycontact_edit"));
        formShowParameter.setCustomParam("candidateid", (Object)candidateId);
        formShowParameter.setCustomParam("onbrdid", this.getView().getFormShowParameter().getCustomParam("id"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7d27\u6025\u8054\u7cfb\u4eba", (String)"CanContactEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }
}

