/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.hr.hom.business.application.impl.extension.ContactInfoServiceImpl;
import kd.hr.hom.business.application.impl.extension.ContactInfoServiceSdkImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.common.constant.BaseDataConstants;
import kd.hr.hom.common.constant.BaseDataIdConstants;
import kd.hr.hom.common.constant.HcfCandidateConstants;
import kd.hr.hom.formplugin.common.ApBuildUtils;
import kd.sdk.hr.hom.business.personinfo.IContactInfoService;

public class ContactInfoPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(ContactInfoPlugin.class);

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.initData();
        this.initHukou();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.checkDataValid(args);
    }

    private void checkDataValid(BeforeDoOperationEventArgs args) {
        LOGGER.info("===ContactInfoPlugin checkDataValid===");
        String phone = (String)this.getModel().getValue("phone");
        String email = (String)this.getModel().getValue("peremail");
        Optional phoneResult = IOnbrdCommonAppService.getInstance().validatePhone(phone);
        if (phoneResult.isPresent()) {
            args.setCancelMessage((String)phoneResult.get());
            args.setCancel(true);
            return;
        }
        Optional emailResult = IOnbrdCommonAppService.getInstance().validateEmail(email);
        if (emailResult.isPresent()) {
            args.setCancelMessage((String)emailResult.get());
            args.setCancel(true);
            return;
        }
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        DynamicObject onbrdBillInfo = HomCommonRepository.queryDynamicObjectByPk((String)"hom_onbrdbillbase", (String)"certificatenumber,certificatetype,peremail,phone,name,viewtype,employeeno,candidatenumber", (Object)onbrdBillId);
        if (!HRObjectUtils.isEmpty((Object)onbrdBillInfo)) {
            String candidateNumStr = IOnbrdCommonAppService.getInstance().validPhoneAndNum(onbrdBillInfo, "phone", phone);
            if (!HRStringUtils.isEmpty((String)candidateNumStr)) {
                String msg = String.format(ResManager.loadKDString((String)"\u201c\u8054\u7cfb\u7535\u8bdd\u201d\u4e0e\u5df2\u6709\u5019\u9009\u4eba\uff08\u5019\u9009\u4eba\u7f16\u53f7\u4e3a%s\uff09\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OnbrdInfoEdit_16", (String)"hr-hom-formplugin", (Object[])new Object[0]), candidateNumStr);
                args.setCancelMessage(msg);
                args.setCancel(true);
                return;
            }
            String candidateEamilStr = IOnbrdCommonAppService.getInstance().validPhoneAndNum(onbrdBillInfo, "peremail", email);
            if (!HRStringUtils.isEmpty((String)candidateEamilStr)) {
                String msg = String.format(ResManager.loadKDString((String)"\u201c\u90ae\u7bb1\u201d\u4e0e\u5df2\u6709\u5019\u9009\u4eba\uff08\u5019\u9009\u4eba\u7f16\u53f7\u4e3a%s\uff09\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OnbrdInfoEdit_17", (String)"hr-hom-formplugin", (Object[])new Object[0]), candidateEamilStr);
                args.setCancelMessage(msg);
                args.setCancel(true);
                return;
            }
        }
        DynamicObject dy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hom_onbrdbillbase"));
        if (!HRObjectUtils.isEmpty((Object)onbrdBillInfo)) {
            HRDynamicObjectUtils.copy((DynamicObject)onbrdBillInfo, (DynamicObject)dy);
        }
        dy.set("phone", (Object)phone);
        dy.set("peremail", (Object)email);
        Optional phoneRes = IHomToHrpiAppService.getInstance().validOnePersonWithTip(dy, "phone");
        if (phoneRes.isPresent()) {
            args.setCancelMessage((String)phoneRes.get());
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (HRStringUtils.equals((String)operateKey, (String)"save") && operationResult.isSuccess()) {
            Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
            Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
            IHomToHcfAppService homToHcfService = IHomToHcfAppService.getInstance();
            if (!this.saveContactInfo(candidateId, homToHcfService)) {
                return;
            }
            this.hcfSyncHom(onbrdId);
            this.saveAddressInfo(candidateId, homToHcfService);
            this.refreshHeadPage("hom_onbrddetailhead", "persononbrdhead", onbrdId, "");
        }
    }

    private void refreshHeadPage(String pageNumber, String targetKey, Long onbrdId, String billNo) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(targetKey);
        formShowParameter.setCustomParam("id", (Object)onbrdId);
        formShowParameter.setCustomParam("billno", (Object)billNo);
        formShowParameter.setFormId(pageNumber);
        formShowParameter.setStatus(OperationStatus.VIEW);
        this.getView().getParentView().showForm(formShowParameter);
    }

    private void saveAddressInfo(Long candidateId, IHomToHcfAppService homToHcfService) {
        DynamicObject hukouDynamicObject = null;
        DynamicObject liveDynamicObject = null;
        DynamicObject commDynamicObject = null;
        DynamicObjectCollection hcfAddressList = homToHcfService.getHisMultiRowEntity(candidateId, "hcf_canaddress");
        if (!CollectionUtils.isEmpty((Collection)hcfAddressList)) {
            HashSet<Long> boids = new HashSet<Long>(hcfAddressList.size());
            for (DynamicObject hcfAddressObj : hcfAddressList) {
                DynamicObject addressTypeObj = hcfAddressObj.getDynamicObject("addresstype");
                if (Objects.isNull(addressTypeObj)) continue;
                boids.add(hcfAddressObj.getLong("id"));
            }
            IHcfDataDomainService.getInstance().deleteByIds(boids, "hcf_canaddress");
        }
        hukouDynamicObject = this.dealDynamicObject(candidateId, hukouDynamicObject, HcfCandidateConstants.ADDRESSTYPE_CN_HUKOUID, "regresidencecountry", "regresidenceaddressdetail");
        liveDynamicObject = this.dealDynamicObject(candidateId, liveDynamicObject, HcfCandidateConstants.ADDRESSTYPE_CN_PERSONID, "livecountry", "liveaddressdetail");
        commDynamicObject = this.dealDynamicObject(candidateId, commDynamicObject, HcfCandidateConstants.ADDRESSTYPE_CN_COMMUID, "commucountry", "commuaddress");
        DynamicObjectCollection addressCollection = new DynamicObjectCollection();
        if (hukouDynamicObject.get("countrycode") != null || !HRStringUtils.isEmpty((String)hukouDynamicObject.getString("addressinfo"))) {
            addressCollection.add((Object)hukouDynamicObject);
        }
        if (liveDynamicObject.get("countrycode") != null || !HRStringUtils.isEmpty((String)liveDynamicObject.getString("addressinfo"))) {
            addressCollection.add((Object)liveDynamicObject);
        }
        if (commDynamicObject.get("countrycode") != null || !HRStringUtils.isEmpty((String)commDynamicObject.getString("addressinfo"))) {
            addressCollection.add((Object)commDynamicObject);
        }
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)new ContactInfoServiceImpl(), kd.hr.hom.business.application.extension.IContactInfoService.class, (String)"kd.hr.hom.business.application.extension.IContactInfoService", null);
        hrPluginProxy.callAfter(p -> {
            p.setValueBeforeSaveAddress(this.getView(), addressCollection);
            return null;
        });
        HRPluginProxy hrPluginProxySdk = HRPlugInProxyFactory.create((Object)new ContactInfoServiceSdkImpl(), IContactInfoService.class, (String)"kd.sdk.hr.hom.business.personinfo.IContactInfoService", null);
        hrPluginProxySdk.callAfter(p -> {
            p.setValueBeforeSaveAddress(this.getView(), addressCollection);
            return null;
        });
        HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>();
        map.put("hcf_canaddress", addressCollection);
        ArrayList<HashMap<String, DynamicObjectCollection>> list = new ArrayList<HashMap<String, DynamicObjectCollection>>();
        list.add(map);
        homToHcfService.saveOrUpdateCandidates(list);
    }

    private void initHukou() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("hom_personbasicinfo") != null) {
            Long candidateId = HRJSONUtils.getLongValOfCustomParam(customParams.get("candidateid"));
            IHomToHcfAppService homToHcfService = IHomToHcfAppService.getInstance();
            Long nationNum = this.getNationNum(candidateId, homToHcfService);
            this.getView().setVisible(Boolean.TRUE, new String[]{"regresidencecountry"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"regresidenceaddressdetail"});
            if (nationNum != 0L) {
                if (BaseDataIdConstants.HBSS_NATIONALITY_1010.equals(nationNum)) {
                    if (this.getView().getModel().getValue("regresidencecountry") == null) {
                        this.getView().getModel().setValue("regresidencecountry", (Object)IBaseDataDomainService.getInstance().getBaseDataInfoById("bd_country", BaseDataConstants.BD_COUNTRY_ID_CHINA, "number"));
                        DynamicObject hukouDynamicObject = null;
                        hukouDynamicObject = this.dealDynamicObject(candidateId, hukouDynamicObject, HcfCandidateConstants.ADDRESSTYPE_CN_HUKOUID, "regresidencecountry", "regresidenceaddressdetail");
                        DynamicObjectCollection addressCollection = new DynamicObjectCollection();
                        if (hukouDynamicObject.get("countrycode") != null || !HRStringUtils.isEmpty((String)hukouDynamicObject.getString("addressinfo"))) {
                            addressCollection.add((Object)hukouDynamicObject);
                        }
                        HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>();
                        map.put("hcf_canaddress", addressCollection);
                        ArrayList<HashMap<String, DynamicObjectCollection>> list = new ArrayList<HashMap<String, DynamicObjectCollection>>();
                        list.add(map);
                        homToHcfService.saveOrUpdateCandidates(list);
                    }
                } else {
                    this.setHukouDisVisible();
                    Long boid = null;
                    DynamicObjectCollection hcfAddressList = homToHcfService.getHisMultiRowEntity(candidateId, "hcf_canaddress");
                    if (!CollectionUtils.isEmpty((Collection)hcfAddressList)) {
                        for (DynamicObject hcfAddressObj : hcfAddressList) {
                            Long addressTypeId;
                            DynamicObject addressTypeObj = hcfAddressObj.getDynamicObject("addresstype");
                            if (Objects.isNull(addressTypeObj) || !HRObjectUtils.equals((Object)HcfCandidateConstants.ADDRESSTYPE_CN_HUKOUID, (Object)(addressTypeId = Long.valueOf(addressTypeObj.getLong("id"))))) continue;
                            boid = hcfAddressObj.getLong("id");
                            break;
                        }
                        homToHcfService.deleteById(boid, "hcf_canaddress");
                    }
                }
            }
        }
    }

    private Long getNationNum(Long candidateId, IHomToHcfAppService homToHcfService) {
        DynamicObject perInfo = homToHcfService.getSingleRowEntity(candidateId, "hcf_canbaseinfo");
        if (perInfo != null) {
            DynamicObject nationDy = perInfo.getDynamicObject("nationality");
            return nationDy != null ? nationDy.getLong("id") : 0L;
        }
        return 0L;
    }

    private void setHukouDisVisible() {
        this.getView().getModel().setValue("regresidencecountry", null);
        this.getView().getModel().setValue("regresidenceaddressdetail", (Object)"");
        this.getView().setVisible(Boolean.FALSE, new String[]{"regresidencecountry"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"regresidenceaddressdetail"});
    }

    private DynamicObject dealDynamicObject(Long candidateId, DynamicObject dynamicObject, Long addressTypeId, String country, String addressDetail) {
        DynamicObject dyNew = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_canaddress"));
        if (Objects.isNull(dynamicObject)) {
            dyNew.set("boid", null);
        } else {
            dyNew.set("boid", (Object)dynamicObject.getLong("boid"));
        }
        dyNew.set("candidate", (Object)candidateId);
        dyNew.set("addresstype", (Object)this.getAddressTypeById(addressTypeId));
        dyNew.set("countrycode", this.getModel().getValue(country));
        dyNew.set("addressinfo", this.getModel().getValue(addressDetail));
        return dyNew;
    }

    private DynamicObject getAddressTypeById(Long addressTypeId) {
        return IHcfDataDomainService.getInstance().getAddressTypeById(addressTypeId);
    }

    private void hcfSyncHom(Long onbrdId) {
        LOGGER.info("===hcfSyncHom:{}===");
        if (onbrdId != null && onbrdId > 0L) {
            LOGGER.info("===hcfSyncHom:{}===", (Object)onbrdId.toString());
            HashMap<String, Object> param = new HashMap<String, Object>(4);
            param.put("phone", this.getModel().getValue("phone"));
            param.put("peremail", this.getModel().getValue("peremail"));
            IHcfDataDomainService.getInstance().saveHcfToHom(onbrdId, param);
        }
    }

    private boolean saveContactInfo(Long candidateId, IHomToHcfAppService homToHcfService) {
        DynamicObject hcfContactObj = homToHcfService.getSingleRowEntity(candidateId, "hcf_cancontactinfo");
        DynamicObject hcfContactObjNew = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_cancontactinfo"));
        hcfContactObjNew.set("candidate", (Object)candidateId);
        hcfContactObjNew.set("boid", HRObjectUtils.isEmpty((Object)hcfContactObj) ? null : Long.valueOf(hcfContactObj.getLong("boid")));
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)new ContactInfoServiceImpl(), kd.hr.hom.business.application.extension.IContactInfoService.class, (String)"kd.hr.hom.business.application.extension.IContactInfoService", null);
        hrPluginProxy.callAfter(p -> {
            p.setValueBeforeSave(this.getView(), hcfContactObjNew);
            return null;
        });
        HRPluginProxy hrPluginProxySdk = HRPlugInProxyFactory.create((Object)new ContactInfoServiceSdkImpl(), IContactInfoService.class, (String)"kd.sdk.hr.hom.business.personinfo.IContactInfoService", null);
        hrPluginProxySdk.callAfter(p -> {
            p.setValueBeforeSave(this.getView(), hcfContactObjNew);
            return null;
        });
        HashMap<Long, DynamicObject> entities = new HashMap<Long, DynamicObject>(2);
        entities.put(candidateId, hcfContactObjNew);
        Map result = homToHcfService.saveHisSingleRowEntity(entities, "hcf_cancontactinfo");
        if (!((Boolean)result.get("success")).booleanValue()) {
            this.getView().getParentView().showErrorNotification(result.get("message").toString());
            LOGGER.error("Person Base Info Save Fail, ", (Object)result.get("message").toString());
            return false;
        }
        return true;
    }

    private void initData() {
        LOGGER.info("===ContactInfoPlugin initData===");
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        ApBuildUtils.setTextMaxLen(this.getView(), 50, "peremail");
        IHomToHcfAppService homToHcfService = IHomToHcfAppService.getInstance();
        DynamicObject hcfContact = homToHcfService.getSingleRowEntity(candidateId, "hcf_cancontactinfo");
        LOGGER.info("===ContactInfoPlugin hcfContact begin===");
        Long nationNum = this.getNationNum(candidateId, homToHcfService);
        this.getView().setVisible(Boolean.TRUE, new String[]{"regresidencecountry"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"regresidenceaddressdetail"});
        if (nationNum != 0L && !BaseDataIdConstants.HBSS_NATIONALITY_1010.equals(nationNum)) {
            this.setHukouDisVisible();
        }
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)new ContactInfoServiceImpl(), kd.hr.hom.business.application.extension.IContactInfoService.class, (String)"kd.hr.hom.business.application.extension.IContactInfoService", null);
        HRPluginProxy hrPluginProxySdk = HRPlugInProxyFactory.create((Object)new ContactInfoServiceSdkImpl(), IContactInfoService.class, (String)"kd.sdk.hr.hom.business.personinfo.IContactInfoService", null);
        hrPluginProxy.callAfter(p -> {
            p.initViewForExt(this.getView(), hcfContact);
            return null;
        });
        hrPluginProxySdk.callAfter(p -> {
            p.initViewForExt(this.getView(), hcfContact);
            return null;
        });
        DynamicObjectCollection hcfAddressList = homToHcfService.getHisMultiRowEntity(candidateId, "hcf_canaddress");
        hrPluginProxy.callAfter(p -> {
            p.initViewWithAddress(this.getView(), hcfAddressList);
            return null;
        });
    }
}

