/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hom.common.enums.CheckinStatusEnum;
import kd.hr.hom.common.enums.PreEnrollStatusEnum;

public class QFilterSetPlugin
extends HRDataBaseList {
    private static final Map<String, String> CHECKIN_STATUS = new ImmutableMap.Builder().put((Object)"3", (Object)CheckinStatusEnum.WAIT_CHECKIN.getValue()).put((Object)"4", (Object)CheckinStatusEnum.WAIT_CHECKIN.getValue()).put((Object)"5", (Object)CheckinStatusEnum.CHECKIN_EXCEPTION.getValue()).put((Object)"6", (Object)CheckinStatusEnum.CHECKIN_EXCEPTION.getValue()).build();
    private static final Map<String, String> PRE_ENROLL_STATUS_LIST = new ImmutableMap.Builder().put((Object)"2", (Object)PreEnrollStatusEnum.WAIT_RESERVATION.getValue()).build();
    private static final Set<String> WAIT_TYPE = new ImmutableSet.Builder().add((Object)"1").add((Object)"2").add((Object)"3").add((Object)"4").build();
    private static final String TODAY = "13";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        String key = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if (key == null) {
            return;
        }
        if (WAIT_TYPE.contains(key)) {
            this.setWaitOnbrd(commonFilterColumns);
        } else if ("9".equals(key)) {
            this.setCalendarFilter(commonFilterColumns);
        }
    }

    private void setWaitOnbrd(List<FilterColumn> commonFilterColumns) {
        commonFilterColumns.forEach(this::setFieldValue);
    }

    private void setCalendarFilter(List<FilterColumn> commonFilterColumns) {
        commonFilterColumns.forEach(this::setCalendar);
    }

    private void setCalendar(FilterColumn filterColumn) {
        String fieldName = filterColumn.getFieldName();
        if (HRStringUtils.equals((String)"org.name", (String)fieldName)) {
            filterColumn.setDefaultValue(null);
        }
        this.setOrgAndOrg("aadminorg.name", "org.name", filterColumn, fieldName);
        if (HRStringUtils.equals((String)"effectdate", (String)fieldName)) {
            String date = (String)this.getView().getFormShowParameter().getCustomParam("effectdate");
            ArrayList<String> dates = new ArrayList<String>();
            dates.add(date);
            dates.add(date);
            filterColumn.setDefaultValues(dates.toArray(new Object[0]));
        }
    }

    private void setFieldValue(FilterColumn filterColumn) {
        String key;
        String fieldName = filterColumn.getFieldName();
        if (HRStringUtils.equals((String)"checkinstatus", (String)fieldName)) {
            key = (String)this.getView().getFormShowParameter().getCustomParam("type");
            filterColumn.setDefaultValue(CHECKIN_STATUS.get(key));
        }
        if (HRStringUtils.equals((String)"preenrollstatus", (String)fieldName)) {
            key = (String)this.getView().getFormShowParameter().getCustomParam("type");
            filterColumn.setDefaultValue((String)PRE_ENROLL_STATUS_LIST.getOrDefault(key, null));
        }
        this.setOrgAndOrg("aadminorg.name", "org.name", filterColumn, fieldName);
        if (HRStringUtils.equals((String)"effectdate", (String)fieldName) && "4".equals(key = (String)this.getView().getFormShowParameter().getCustomParam("type"))) {
            filterColumn.setDefaultValue(TODAY);
        }
    }

    private void setOrgAndOrg(String orgName, String hrbuName, FilterColumn filterColumn, String fieldName) {
        List orgIds;
        String[] ids;
        if (HRStringUtils.equals((String)orgName, (String)fieldName) && (ids = this.getStrings(orgIds = (List)this.getView().getFormShowParameter().getCustomParam("adminorgids"))) != null) {
            filterColumn.setDefaultValues(Arrays.stream(ids).toArray());
        }
        if (HRStringUtils.equals((String)hrbuName, (String)fieldName)) {
            List hrbuIds = (List)this.getView().getFormShowParameter().getCustomParam("hrbuids");
            ids = this.getStrings(hrbuIds);
            if (ids != null) {
                filterColumn.setDefaultValues(Arrays.stream(ids).toArray());
            } else {
                filterColumn.setDefaultValue(null);
            }
        }
    }

    private String[] getStrings(List<Long> ids) {
        if (ids == null) {
            return null;
        }
        String[] strs = new String[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            strs[i] = String.valueOf(ids.get(i));
        }
        return strs;
    }
}

