/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange.personinfo;

import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.page.OnbrdNullPageServiceImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.base.IUploadConfigDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.AttachmentTypeEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.sdk.hr.hom.business.personinfo.IRsmpatinvService;

public class RsmpatinvViewPlugin
extends HRDynamicFormBasePlugin {
    private static final String BTN_ADD = "btn_add";
    private static final String OPCOLUMNAP_EDIT = "opcolumnapedit";
    private static final String OPCOLUMNAP_VIEW = "opcolumnapview";
    private static final String OPKEY_ADD = "donothing_add";
    private static final String OPKEY_EDIT = "donothing_edit";
    private static final String OPKEY_DELETE = "donothing_delete";
    private static final String OPKEY_VIEW = "donothing_view";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final Log logger = LogFactory.getLog(RsmpatinvViewPlugin.class);

    public void afterCreateNewData(EventObject eventObject) {
        this.refreshEntryEntity();
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        IOnbrdBillDomainService.getInstance().generateViewForEnrollStatus(onbrdId, this.getView(), new String[]{BTN_ADD});
    }

    private void refreshEntryEntity() {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        DynamicObjectCollection rsmpatinvInfos = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_rsmpatinv");
        if (CollectionUtils.isEmpty((Collection)rsmpatinvInfos)) {
            new OnbrdNullPageServiceImpl().loadOnbrdNullPage(this.getView());
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"onbrdnullpage"});
        Boolean isEnrolled = this.isEnrolled(onbrdId);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        entryGrid.setColumnProperty(OPCOLUMNAP_VIEW, "visible", (Object)isEnrolled);
        entryGrid.setColumnProperty(OPCOLUMNAP_EDIT, "visible", (Object)(isEnrolled == false ? 1 : 0));
        IDataModel dataModel = this.getModel();
        if (!(dataModel instanceof AbstractFormDataModel)) {
            return;
        }
        List<DynamicObject> rsmpatinvsList = rsmpatinvInfos.stream().sorted(Comparator.comparing(dyo -> dyo.getDate("createtime"), Comparator.reverseOrder())).collect(Collectors.toList());
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.deleteEntryData(KEY_ENTRYENTITY);
        model.beginInit();
        TableValueSetter vs = this.getTableValue(rsmpatinvsList);
        model.batchCreateNewEntryRow(KEY_ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(KEY_ENTRYENTITY);
    }

    private Boolean isEnrolled(Long onbrdId) {
        DynamicObject onbrdBillInfo = IOnbrdBillDomainService.getInstance().findOnbrdBillById("enrollstatus", (Object)onbrdId);
        if (!HRObjectUtils.isEmpty((Object)onbrdBillInfo)) {
            String enrollStatus = onbrdBillInfo.getString("enrollstatus");
            if (HRStringUtils.equals((String)OnbrdStatusEnum.HAS_ONBRD.toString(), (String)enrollStatus) || HRStringUtils.equals((String)OnbrdStatusEnum.BREAK_UP.toString(), (String)enrollStatus)) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private TableValueSetter getTableValue(List<DynamicObject> rsmpatinvsList) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int indexRow = 0;
        for (DynamicObject rsmpatinvInfo : rsmpatinvsList) {
            Long id = rsmpatinvInfo.getLong("id");
            vs.set("id", (Object)id, indexRow);
            ILocaleString patentName = rsmpatinvInfo.getLocaleString("patentname");
            vs.set("patentname", (Object)(ObjectUtils.isEmpty((Object)patentName) ? "" : patentName), indexRow);
            DynamicObject patentCategory = rsmpatinvInfo.getDynamicObject("patentcategoryid");
            vs.set("patentcategoryid", HRObjectUtils.isEmpty((Object)patentCategory) ? "" : Long.valueOf(patentCategory.getLong("id")), indexRow);
            ILocaleString inventor = rsmpatinvInfo.getLocaleString("inventor");
            vs.set("inventor", (Object)(ObjectUtils.isEmpty((Object)inventor) ? "" : inventor), indexRow);
            Date applicationDate = rsmpatinvInfo.getDate("applicationdate");
            vs.set("applicationdate", HRObjectUtils.isEmpty((Object)applicationDate) ? "" : applicationDate, indexRow);
            Date ptstartDate = rsmpatinvInfo.getDate("ptstartdate");
            Date ptendingDate = rsmpatinvInfo.getDate("ptendingdate");
            vs.set("ptstartdate", HRObjectUtils.isEmpty((Object)ptstartDate) ? "" : ptstartDate, indexRow);
            vs.set("ptendingdate", HRObjectUtils.isEmpty((Object)ptendingDate) ? "" : ptendingDate, indexRow);
            DynamicObject country = rsmpatinvInfo.getDynamicObject("countryid");
            vs.set("countryid", HRObjectUtils.isEmpty((Object)country) ? "" : Long.valueOf(country.getLong("id")), indexRow);
            DynamicObject patentStatus = rsmpatinvInfo.getDynamicObject("patentstatusid");
            vs.set("patentstatusid", HRObjectUtils.isEmpty((Object)patentStatus) ? "" : Long.valueOf(patentStatus.getLong("id")), indexRow);
            String patentUrl = rsmpatinvInfo.getString("patenturl");
            vs.set("patenturl", (Object)(HRObjectUtils.isEmpty((Object)patentUrl) ? "" : patentUrl), indexRow);
            String patentDesc = rsmpatinvInfo.getString("patentdesc");
            vs.set("patentdesc", (Object)(ObjectUtils.isEmpty((Object)patentDesc) ? "" : patentDesc), indexRow);
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IRsmpatinvService.class, (String)"kd.sdk.hr.hom.business.personinfo.IRsmpatinvService", null);
            int finalIndexRow = indexRow++;
            hrPluginProxy.callReplace(p -> {
                p.setTableValue(vs, finalIndexRow, rsmpatinvInfo);
                return null;
            });
        }
        return vs;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Long candidateId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("candidateid"));
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        DynamicObject rsmpatinvInfo = this.getModel().getEntryRowEntity(KEY_ENTRYENTITY, entryCurrentRowIndex);
        FormOperate operation = (FormOperate)args.getSource();
        String opKey = operation.getOperateKey();
        if (opKey.equals(OPKEY_ADD) || opKey.equals(OPKEY_EDIT) || opKey.equals(OPKEY_DELETE)) {
            Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id").toString());
            if (IOnbrdCommonAppService.getInstance().isEnrolledWithTip(this.getView(), onbrdId)) {
                args.setCancel(true);
                return;
            }
        }
        switch (opKey) {
            case "donothing_add": {
                this.addRsmpatinv(candidateId);
                break;
            }
            case "donothing_edit": {
                String appId = this.getView().getFormShowParameter().getAppId();
                if (IOnbrdCommonAppService.getInstance().checkPermission("hom_rsmpatinv_view", "4715a0df000000ac", appId)) {
                    this.editRsmpatinv(candidateId, rsmpatinvInfo);
                    break;
                }
                this.viewRsmpatinv(candidateId, rsmpatinvInfo);
                break;
            }
            case "donothing_delete": {
                this.deleteRsmpatinv(rsmpatinvInfo);
                break;
            }
            case "donothing_view": {
                this.viewRsmpatinv(candidateId, rsmpatinvInfo);
                break;
            }
        }
    }

    private void addRsmpatinv(Long candidateId) {
        this.showNewPage(candidateId);
    }

    private void editRsmpatinv(Long candidateId, DynamicObject rsmpatinvInfo) {
        if (!IOnbrdCommonAppService.getInstance().tryRequireLockByHCF(this.getView(), Long.valueOf(rsmpatinvInfo.getLong("id")), "hcf_rsmpatinv", "modify")) {
            this.viewRsmpatinv(candidateId, rsmpatinvInfo);
            return;
        }
        this.showEditPage(candidateId, rsmpatinvInfo, OperationStatus.EDIT);
    }

    private void viewRsmpatinv(Long candidateId, DynamicObject rsmpatinvInfo) {
        this.showEditPage(candidateId, rsmpatinvInfo, OperationStatus.VIEW);
    }

    private void deleteRsmpatinv(DynamicObject rsmpatinvInfo) {
        if (!IOnbrdCommonAppService.getInstance().tryRequireLockByHCF(this.getView(), Long.valueOf(rsmpatinvInfo.getLong("id")), "hcf_rsmpatinv", "delete")) {
            return;
        }
        String rsmpatinvInfoId = rsmpatinvInfo.getString("id");
        try {
            IHomToHcfAppService.getInstance().getById(Long.valueOf(rsmpatinvInfoId), "hcf_rsmpatinv");
        }
        catch (KDException e) {
            String errMsg = ResManager.loadKDString((String)"\u8be5\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"RsmpatinvViewPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5f53\u524d\u8bb0\u5f55\uff1f", (String)"PreWorkExpViewPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(OPKEY_DELETE, (IFormPlugin)this));
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put("rsmpId", rsmpatinvInfo.getString("id"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        if (HRStringUtils.equals((String)actionId, (String)OPKEY_DELETE) && MessageBoxResult.Yes == resultValue) {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String rsmpId = pageCache.get("rsmpId");
            try {
                Map result = IHomToHcfAppService.getInstance().deleteByIdNoHis(Long.valueOf(rsmpId), "hcf_rsmpatinv");
                Boolean success = (Boolean)result.get("success");
                if (success.booleanValue()) {
                    List attachmentList = IHomToHcfAppService.getInstance().queryAttach(Long.valueOf(rsmpId), IUploadConfigDomainService.getInstance().getAttachmentType(Long.valueOf(AttachmentTypeEnum.RSMPATINV.getId())));
                    if (!CollectionUtils.isEmpty((Collection)attachmentList)) {
                        this.delAllAttachment(rsmpId, attachmentList);
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"RsmpatinvViewPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    this.getView().invokeOperation("refresh");
                } else {
                    this.getView().showErrorNotification((String)result.get("message"));
                }
            }
            finally {
                IOnbrdCommonAppService.getInstance().releaseLockByHCF(Long.valueOf(rsmpId), "hcf_rsmpatinv", "delete");
            }
        }
    }

    private void showNewPage(Long candidateId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hom_rsmpatinv_edit");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hom_rsmpatinv_edit"));
        formShowParameter.setCustomParam("candidateid", (Object)candidateId);
        formShowParameter.setCustomParam("onbrdid", this.getView().getFormShowParameter().getCustomParam("id"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u4e13\u5229\u53d1\u660e", (String)"RsmpatinvViewPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private void showEditPage(Long candidateId, DynamicObject rsmpatinvInfo, OperationStatus status) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(status);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hom_rsmpatinv_edit");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hom_rsmpatinv_edit"));
        formShowParameter.setCustomParam("id", rsmpatinvInfo.get("id"));
        formShowParameter.setCustomParam("candidateid", (Object)candidateId);
        formShowParameter.setCustomParam("onbrdid", this.getView().getFormShowParameter().getCustomParam("id"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u4e13\u5229\u53d1\u660e", (String)"RsmpatinvViewPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        this.getView().showForm(formShowParameter);
    }

    private void delAllAttachment(String rsmpatinvInfoId, List<DynamicObject> attachmentList) {
        for (DynamicObject dyo : attachmentList) {
            AttachmentServiceHelper.remove((String)dyo.getString("fbilltype"), (Object)rsmpatinvInfoId, (Object)dyo.get("fnumber"));
        }
    }
}

