/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.preonbrd;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.DefaultValueCalculator;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.FieldDefValue;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridSetRowDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hom.business.application.utils.RuleCodeUtils;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.business.domain.service.handler.HPFSTemplatePropertyHandler;
import kd.hr.hom.business.domain.service.preonbrd.IPreOnBrdService;
import kd.hr.hom.common.constant.AffactionConstants;
import kd.hr.hom.common.constant.BaseDataIdConstants;
import kd.hr.hom.common.enums.PreOnBrdOperateTypeEnum;
import kd.hr.hom.common.util.DateUtils;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.common.util.PreOnBrdCommonUtil;
import kd.hr.hom.common.util.UpdateControlUtil;
import kd.hr.hom.formplugin.common.PreOnBrdHelper;
import kd.hr.hom.formplugin.common.PropertyChange;
import kd.sdk.hr.hpfs.utils.RepositoryUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class PreOnBrdBillEdit
extends HRCoreBaseBillEdit
implements EntryGridSetRowDataListener {
    private static final Log LOGGER = LogFactory.getLog(PreOnBrdBillEdit.class);
    public static final String JOBLEVEL_RANGES = "joblevelRanges";
    public static final String JOBGRADE_RANGES = "jobgradeRanges";
    public static final String JOBLEVEL_SCMID = "joblevelScmid";
    public static final String JOBGRADE_SCMID = "jobgradeScmid";
    private final Map<String, PropertyChange> propertyChangedMap = ImmutableMap.builder().put((Object)"isprobation", this::changeWithIsprobation).put((Object)"ajob", this::changeWithJob).put((Object)"jobgradescm", this::changeWithJobgradeScm).put((Object)"joblevelscm", this::changeWithJoblevelScm).put((Object)"aadminorg", this::changeWithAdminOrg).put((Object)"plaborrelstatus", this::changeWithLaborrelstatus).put((Object)"effectdate", this::changeWithEffectDate).put((Object)"probationtime", this::changeWithProbationTime).put((Object)"perprobationtime", this::changeWithPerProbationTime).put((Object)"name", this::changeWithName).build();

    private void changeWithJoblevelScm(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex);
        DynamicObject ajoblevel = dynamicObject.getDynamicObject("joblevel");
        DynamicObject joblevelScm = dynamicObject.getDynamicObject("joblevelscm");
        if (HOMObjectUtils.isNotEmpty((Object)ajoblevel)) {
            long currentscmId;
            long lastscmId = ajoblevel.getLong("joblevelscm.id");
            long l = currentscmId = HOMObjectUtils.isEmpty((Object)joblevelScm) ? 0L : joblevelScm.getLong("id");
            if (lastscmId != currentscmId) {
                this.getModel().setValue("joblevel", null);
            }
        }
    }

    private void changeWithJobgradeScm(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex);
        DynamicObject ajobgrade = dynamicObject.getDynamicObject("jobgrade");
        DynamicObject jobgradeScm = dynamicObject.getDynamicObject("jobgradescm");
        if (HOMObjectUtils.isNotEmpty((Object)ajobgrade)) {
            long currentscmId;
            long lastscmId = ajobgrade.getLong("jobgradescm.id");
            long l = currentscmId = HOMObjectUtils.isEmpty((Object)jobgradeScm) ? 0L : jobgradeScm.getLong("id");
            if (lastscmId != currentscmId) {
                this.getModel().setValue("jobgrade", null);
            }
        }
    }

    private void changeWithName(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        LocaleDynamicObjectCollection newValueColl = (LocaleDynamicObjectCollection)changeData.getNewValue();
        for (DynamicObject newValue : newValueColl) {
            newValue.set("name", (Object)newValue.getString("name").trim());
        }
    }

    private void changeWithPerProbationTime(PropertyChangedArgs propertyChangedArgs) {
        this.setTransdDateByChangeField(propertyChangedArgs);
    }

    private void changeWithProbationTime(PropertyChangedArgs propertyChangedArgs) {
        this.setTransdDateByChangeField(propertyChangedArgs);
    }

    private void changeWithEffectDate(PropertyChangedArgs propertyChangedArgs) {
        this.setTransdDateByChangeField(propertyChangedArgs);
    }

    private void setTransdDateByChangeField(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex);
        this.getModel().setValue("transdate", (Object)DateUtils.setTransDate((DynamicObject)dynamicObject), rowIndex);
        this.getView().updateView("transdate", rowIndex);
    }

    private void changeWithLaborrelstatus(PropertyChangedArgs propertyChangedArgs) {
        this.setValueByLaborrelstatus(propertyChangedArgs);
    }

    private void setValueByLaborrelstatus(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex);
        this.setProbationView(rowIndex, dynamicObject);
    }

    private void setProbationView(int rowIndex, DynamicObject dynamicObject) {
        Long laborrelstatuscls = dynamicObject.getLong("plaborrelstatus.labrelstatuscls.id");
        if (BaseDataIdConstants.HBSS_LABRELSTATUSCLS_1010.equals(laborrelstatuscls)) {
            this.getModel().setValue("probationtime", (Object)6, rowIndex);
            this.getModel().setValue("perprobationtime", (Object)1, rowIndex);
            this.getModel().setValue("isprobation", (Object)Boolean.TRUE, rowIndex);
            this.getModel().setValue("transdate", (Object)DateUtils.setTransDate((DynamicObject)dynamicObject), rowIndex);
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"probationtime", "perprobationtime"}, (boolean)true);
        } else {
            this.getModel().setValue("probationtime", null, rowIndex);
            this.getModel().setValue("perprobationtime", null, rowIndex);
            this.getModel().setValue("isprobation", (Object)Boolean.FALSE, rowIndex);
            this.getModel().setValue("transdate", null, rowIndex);
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"probationtime", "perprobationtime"}, (boolean)false);
        }
    }

    private void changeWithAdminOrg(PropertyChangedArgs propertyChangedArgs) {
        this.setValueByAdminOrg(propertyChangedArgs);
    }

    private void setValueByAdminOrg(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex);
        DynamicObject adminOrg = (DynamicObject)changeData.getNewValue();
        if (ObjectUtils.isEmpty((Object)adminOrg)) {
            return;
        }
        Long adminOrgId = adminOrg.getLong("id");
        Map orgCompanyMap = IBaseDataDomainService.getInstance().getCompanyMapWithAdminorgByRPC(Collections.singletonList(adminOrgId));
        this.getModel().setItemValueByID((IDataEntityProperty)dynamicObject.getDataEntityType().getProperties().get((Object)"acompany"), dynamicObject, (Object)orgCompanyMap.getOrDefault(adminOrgId, 0L));
    }

    private void changeWithJob(PropertyChangedArgs propertyChangedArgs) {
        this.setValueByJob(propertyChangedArgs);
    }

    private void setValueByJob(PropertyChangedArgs propertyChangedArgs) {
        this.getModel().setValue("joblevelscm", null);
        this.getModel().setValue("jobgradescm", null);
        this.getModel().setValue("joblevel", null);
        this.getModel().setValue("jobgrade", null);
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObject entryEntityDy = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex);
        DynamicObject aJobDy = (DynamicObject)changeData.getNewValue();
        if (ObjectUtils.isEmpty((Object)aJobDy)) {
            return;
        }
        Long aJobId = aJobDy.getLong("id");
        this.setJobFieldIsLocked(rowIndex, aJobDy);
        Map jobRelationInfoMap = IBaseDataDomainService.getInstance().getJobLevelGradeRangeInfoByJobIds(Collections.singletonList(aJobId));
        Map jobRelationInfo = (Map)jobRelationInfoMap.get(aJobId);
        Object joblevelscm = jobRelationInfo.get(JOBLEVEL_SCMID);
        Object jobgradescm = jobRelationInfo.get(JOBGRADE_SCMID);
        this.getModel().setItemValueByID((IDataEntityProperty)entryEntityDy.getDataEntityType().getProperties().get((Object)"joblevelscm"), entryEntityDy, joblevelscm);
        this.getModel().setItemValueByID((IDataEntityProperty)entryEntityDy.getDataEntityType().getProperties().get((Object)"jobgradescm"), entryEntityDy, jobgradescm);
        List jobLevelInfos = (List)jobRelationInfo.get(JOBLEVEL_RANGES);
        List jobGradeInfos = (List)jobRelationInfo.get(JOBGRADE_RANGES);
        if (joblevelscm != null && CollectionUtils.isNotEmpty((Collection)jobLevelInfos) && jobLevelInfos.size() == 1) {
            this.getModel().setItemValueByID((IDataEntityProperty)entryEntityDy.getDataEntityType().getProperties().get((Object)"joblevel"), entryEntityDy, ((DynamicObject)jobLevelInfos.get(0)).get("id"));
        }
        if (jobgradescm != null && CollectionUtils.isNotEmpty((Collection)jobGradeInfos) && jobGradeInfos.size() == 1) {
            this.getModel().setItemValueByID((IDataEntityProperty)entryEntityDy.getDataEntityType().getProperties().get((Object)"jobgrade"), entryEntityDy, ((DynamicObject)jobGradeInfos.get(0)).get("id"));
        }
    }

    private void changeWithIsprobation(PropertyChangedArgs propertyChangedArgs) {
        this.setIsprobation(propertyChangedArgs);
        this.getView().updateView();
    }

    private void setIsprobation(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObject entryEntityDy = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex);
        boolean isprobation = entryEntityDy.getBoolean("isprobation");
        if (isprobation) {
            this.getModel().setValue("probationtime", (Object)6, rowIndex);
            this.getModel().setValue("perprobationtime", (Object)1, rowIndex);
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"probationtime", "perprobationtime"}, (boolean)true);
        } else {
            this.getModel().setValue("probationtime", null, rowIndex);
            this.getModel().setValue("perprobationtime", null, rowIndex);
            UpdateControlUtil.setMustInput((IFormView)this.getView(), (String[])new String[]{"probationtime", "perprobationtime"}, (boolean)false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                this.beforeSaveAndSubmitValidate(args, PreOnBrdOperateTypeEnum.SAVE);
                break;
            }
            case "submit": {
                if (!this.submitStatusValidate(args, this.getModel().getDataEntity())) {
                    return;
                }
                this.beforeSaveAndSubmitValidate(args, PreOnBrdOperateTypeEnum.SUBMIT);
                break;
            }
            case "unsubmit": {
                Object pkValue = this.getModel().getDataEntity().getPkValue();
                DynamicObject batchRegBill = IPreOnBrdService.getInstance().queryOne("billstatus", ((Long)pkValue).longValue());
                IPreOnBrdService.getInstance().beforeValidateUnSubmit((AbstractFormPlugin)this, args, batchRegBill.getString("billstatus"));
                break;
            }
        }
    }

    private boolean submitStatusValidate(BeforeDoOperationEventArgs args, DynamicObject batchRegBill) {
        String billStatus = batchRegBill.getString("billstatus");
        if ("A".equals(billStatus) || "G".equals(billStatus)) {
            return true;
        }
        String msg = ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"PreOnBrdBillEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        this.getView().showErrorNotification(msg);
        args.setCancel(true);
        return false;
    }

    private void beforeSaveAndSubmitValidate(BeforeDoOperationEventArgs args, PreOnBrdOperateTypeEnum operateTypeEnum) {
        ArrayList entryData = Lists.newArrayList((Iterable)this.getModel().getEntryEntity("entryentity"));
        if (HRCollUtil.isEmpty((Collection)entryData)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5165\u804c\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53d1\u8d77\u9884\u5165\u804c\u7533\u8bf7\u65f6\u81f3\u5c11\u5b58\u5728\u4e00\u884c\u5b8c\u6574\u7684\u4fe1\u606f\u3002", (String)"PreOnBrdBillEdit_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!this.validateDataCompliance(args)) {
            args.setCancel(true);
        }
    }

    private boolean validateDataCompliance(BeforeDoOperationEventArgs args) {
        DynamicObject preOnBrd = this.getModel().getDataEntity();
        DynamicObjectCollection preOnBrdDytColl = preOnBrd.getDynamicObjectCollection("entryentity");
        List<DynamicObject> onBrdList = PreOnBrdHelper.buildOnbrdInfo(preOnBrdDytColl, preOnBrd);
        Optional<String> mustInputValidateResult = PreOnBrdHelper.mustInputValidate(onBrdList);
        if (mustInputValidateResult.isPresent() && !mustInputValidateResult.get().isEmpty()) {
            args.setCancelMessage(mustInputValidateResult.get());
            this.getView().showTipNotification(args.getCancelMessage());
            return false;
        }
        Optional<String> formatValidateResult = PreOnBrdHelper.formatValidate(onBrdList);
        if (formatValidateResult.isPresent() && !formatValidateResult.get().isEmpty()) {
            args.setCancelMessage(formatValidateResult.get());
            this.getView().showTipNotification(args.getCancelMessage());
            return false;
        }
        Optional<String> fieldUniqueValidateResult = PreOnBrdHelper.fieldUniqueValidate(onBrdList);
        if (fieldUniqueValidateResult.isPresent() && !fieldUniqueValidateResult.get().isEmpty()) {
            args.setCancelMessage(fieldUniqueValidateResult.get());
            this.getView().showTipNotification(args.getCancelMessage());
            return false;
        }
        Optional<String> preUniqueValidateResult = PreOnBrdHelper.preUniqueValidate((List<DynamicObject>)preOnBrdDytColl, preOnBrd);
        if (preUniqueValidateResult.isPresent()) {
            args.setCancelMessage(preUniqueValidateResult.get());
            this.getView().showTipNotification(args.getCancelMessage());
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "unsubmit": 
            case "save": 
            case "submit": {
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        IPageCache pageCache = this.getView().getPageCache();
        for (RowDataEntity rowDataEntity : rowDataEntities) {
            List<String> generateBillList = PreOnBrdHelper.generateBillNo(1);
            LOGGER.info("PreOnBrdBillEdit.afterAddRow.generateBillList={}", generateBillList);
            DynamicObject dataEntity = rowDataEntity.getDataEntity();
            if (generateBillList.size() == 1) {
                String generateBillNo = generateBillList.get(0);
                dataEntity.set("pbillno", (Object)generateBillNo);
                pageCache.put("candidatenumber" + generateBillNo, generateBillNo);
            }
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hom_preonbrdbasebill");
            IDataEntityProperty prop = (IDataEntityProperty)((EntityType)type.getAllEntities().get("entryentity")).getProperties().get((Object)"paffaction");
            FieldDefValue defValue2 = ((IFieldHandle)prop).getDefValue2();
            DefaultValueCalculator calculator = new DefaultValueCalculator(this.getModel(), this.getModel().getDataEntity(), 0);
            Object defaultAffaction = calculator.getValue2(this.getModel(), this.getModel().getDataEntity(), prop, defValue2);
            boolean businessValue = HPFSTemplatePropertyHandler.isNewChgAction((String)"hom_onbrd_hpfs_new");
            DynamicObject affaction = RepositoryUtils.queryDynamicObject((String)"hpfs_chgaction", (String)"id, numebr, isnewchgaction", (QFilter[])new QFilter[]{new QFilter("id", "=", defaultAffaction)});
            if (!HRObjectUtils.isEmpty((Object)affaction) && businessValue == affaction.getBoolean("isnewchgaction")) continue;
            if (businessValue) {
                this.getModel().setItemValueByID((IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)"paffaction"), dataEntity, (Object)AffactionConstants.HOM_AFFACTION_NEW);
                continue;
            }
            this.getModel().setItemValueByID((IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)"paffaction"), dataEntity, (Object)AffactionConstants.HOM_AFFACTION);
        }
        this.getView().updateView();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        PropertyChange propertyChange = this.propertyChangedMap.get(name);
        if (propertyChange != null) {
            propertyChange.doSomethings(e);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            DynamicObject jobDy = dynamicObject.getDynamicObject("ajob");
            this.setJobFieldIsLocked(i, jobDy);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setAuditStatusLabelWithColorful(this.getModel().getDataEntity().getString("billstatus"));
    }

    private void setAuditStatusLabelWithColorful(String labelValue) {
        LabelAp statusLabel = PreOnBrdCommonUtil.setAuditStatusLabelWithColorful((String)"lblbillstatus", (String)labelValue);
        this.getView().updateControlMetadata(statusLabel.getKey(), statusLabel.createControl());
    }

    private void setJobFieldIsLocked(int rowIndex, DynamicObject jobDy) {
        if (ObjectUtils.isNotEmpty((Object)jobDy)) {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"joblevel", "jobgrade", "joblevelscm", "jobgradescm"});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"joblevel", "jobgrade", "joblevelscm", "jobgradescm"});
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection removeCol = new DynamicObjectCollection();
        if (selectRows != null && selectRows.length > 0) {
            for (int selectRow : selectRows) {
                DynamicObject entryEntity = (DynamicObject)entity.get(selectRow);
                removeCol.add((Object)entryEntity);
            }
        }
        if (OperationStatus.ADDNEW.equals((Object)status) || OperationStatus.EDIT.equals((Object)status)) {
            this.recycleNumber(removeCol);
        }
    }

    private void recycleNumber(DynamicObjectCollection entryEntity) {
        for (DynamicObject entity : entryEntity) {
            String candidateNumber = this.getView().getPageCache().get("candidatenumber" + entity.getString("pbillno"));
            if (HOMObjectUtils.isEmpty((Object)candidateNumber)) continue;
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hom_candidatenumber");
            DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
            RuleCodeUtils.recycleNumber((DynamicObject)dynamicObject, (String)candidateNumber);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (status == OperationStatus.ADDNEW) {
            this.setAddCaption(formShowParameter, ResManager.loadKDString((String)"\u65b0\u589e\u9884\u5165\u804c\u7533\u8bf7", (String)"PreOnBrdBillEdit_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
    }

    private void setAddCaption(FormShowParameter formShowParameter, String caption) {
        formShowParameter.setCaption(caption);
    }
}

