/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.preonbrd;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.common.constant.BaseDataIdConstants;
import kd.hr.hom.common.util.DateUtils;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.formplugin.common.PreOnBrdHelper;
import kd.hr.hom.formplugin.web.preonbrd.validator.PreOnBrdValidateHandler;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hrmp.hies.entry.common.dto.FieldHeaderWriterFormat;
import kd.hrmp.hies.entry.common.enu.EntryValidatorEnum;
import kd.hrmp.hies.entry.common.plugin.impt.AfterBackFillDataEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterInitContextArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterValidateEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeBackFillDataEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeCreateHeaderColumnEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeInitValidatorEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeTemplateValidateEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeValidateEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImportPlugin;
import kd.hrmp.hies.entry.core.validate.AbstractEntryValidateHandler;
import kd.sdk.hr.hom.business.onbrd.IPreOnbrdService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class PreOnBrdImportPlugin
implements HREntryImportPlugin {
    private static final Log logger = LogFactory.getLog(PreOnBrdImportPlugin.class);
    private static final List<String> PRE_IMPORT_TPL_NOT_CONTAIN_FIELD = Arrays.asList("pbillno", "phone", "acompany", "onbrd", "peremail", "nationality", "transdate");
    public static final String ENTRYENTITY_ID = "entryentity_id";
    public static final String LABRELSTATUSCLS_ID_FIELD = "labrelstatuscls.id";
    public static final List<Integer> LABRELSTATUSCLS_ID = Arrays.asList(1010, 1020, 1030);
    public static final String LABORRELTYPECLS_ID_FIELD = "laborreltypecls.id";
    public static final List<Integer> LABORRELTYPECLS_ID = Arrays.asList(1010, 1020, 1030, 1040, 1050);
    public static final String ISPERMANWORKPLACE = "ispermanworkplace";
    public static final String ISCONTRACTWORKPLACE = "iscontractworkplace";

    public void beforeQueryRefBd(BeforeQueryRefBdEventArgs args) {
        super.beforeQueryRefBd(args);
        String fieldId = args.getFieldId();
        QFilter[] filters = args.getFilters();
        switch (fieldId) {
            case "paffaction": {
                List chgeventKeys = IBaseDataDomainService.getInstance().getChgActionIdsByHomMetadata();
                if (CollectionUtils.isNotEmpty((Collection)chgeventKeys)) {
                    QFilter paffactionFilter = new QFilter("id", "in", (Object)chgeventKeys);
                    PreOnBrdImportPlugin.addFilter(filters, paffactionFilter);
                    break;
                }
                logger.info("getHpfsChgactionInfo_null");
                break;
            }
            case "plaborreltype": {
                QFilter plaborreltypeFilter = new QFilter(LABORRELTYPECLS_ID_FIELD, "in", LABORRELTYPECLS_ID);
                PreOnBrdImportPlugin.addFilter(filters, plaborreltypeFilter);
                break;
            }
            case "plaborrelstatus": {
                QFilter plaborrelStatusFilter = new QFilter(LABRELSTATUSCLS_ID_FIELD, "in", LABRELSTATUSCLS_ID);
                PreOnBrdImportPlugin.addFilter(filters, plaborrelStatusFilter);
                break;
            }
            case "baselocation": {
                QFilter baseLocationFilter = new QFilter(ISPERMANWORKPLACE, "=", (Object)"1");
                PreOnBrdImportPlugin.addFilter(filters, baseLocationFilter);
                break;
            }
            case "contractlocation": {
                QFilter placeGroupFilter = new QFilter(ISCONTRACTWORKPLACE, "=", (Object)"1");
                PreOnBrdImportPlugin.addFilter(filters, placeGroupFilter);
                break;
            }
            case "empgroup": {
                DynamicObject bussinessfield = IBaseDataDomainService.getInstance().getBaseDataInfoById("hbss_bussinessfield", BaseDataIdConstants.HBSS_BUSSINESSFIELD_103010, "id");
                if (bussinessfield == null) break;
                QFilter empGroupFilter = new QFilter("bussinessfield", "=", (Object)bussinessfield.getLong("id"));
                PreOnBrdImportPlugin.addFilter(filters, empGroupFilter);
                break;
            }
            case "joblevel": {
                QFilter levelFilter = new QFilter("entryboid", "=", (Object)"id", true);
                PreOnBrdImportPlugin.addFilter(filters, levelFilter);
                break;
            }
            case "jobgrade": {
                QFilter gradeFilter = new QFilter("entryboid", "=", (Object)"id", true);
                PreOnBrdImportPlugin.addFilter(filters, gradeFilter);
                break;
            }
        }
        args.setFilters(filters);
    }

    private static void addFilter(QFilter[] filters, QFilter filter) {
        for (int i = 0; i < filters.length; ++i) {
            if (i != filters.length - 1) continue;
            filters[i].and(filter);
        }
    }

    public void beforeTemplateValidate(BeforeTemplateValidateEventArgs args) {
        super.beforeTemplateValidate(args);
        LinkedList<String> ignoreValidateField = new LinkedList<String>();
        ignoreValidateField.add("pbillno");
        ignoreValidateField.add("phone");
        ignoreValidateField.add("locationcode");
        ignoreValidateField.add("phonecode");
        ignoreValidateField.add("transdate");
        args.setIgnoreValidateField(ignoreValidateField);
    }

    public void afterInitContext(AfterInitContextArgs args) {
        super.afterInitContext(args);
        LinkedList<String> ignoreValidateField = new LinkedList<String>();
        ignoreValidateField.add("pbillno");
        ignoreValidateField.add("phone");
        ignoreValidateField.add("locationcode");
        ignoreValidateField.add("phonecode");
        ignoreValidateField.add("transdate");
        args.setIgnoreValidateField(ignoreValidateField);
        super.afterInitContext(args);
        ArrayList<String> list = new ArrayList<String>();
        list.add("certificatetype");
        list.add("certificatenumber");
        args.setUniqueFields(list);
    }

    public void beforeValidate(BeforeValidateEventArgs args) {
        super.beforeValidate(args);
        args.getBillDatas().forEach(data -> {
            JSONObject importObj = data.getData();
            if (importObj != null) {
                try {
                    JSONObject entryEntityJsonObject = importObj.getJSONObject("entryentity");
                    String locationCode = entryEntityJsonObject.getString("locationcode");
                    if (HRStringUtils.isNotEmpty((String)locationCode) && !locationCode.startsWith("+")) {
                        locationCode = "+" + locationCode;
                    }
                    String phoneCode = entryEntityJsonObject.getString("phonecode");
                    entryEntityJsonObject.put("phone", (Object)(locationCode + "-" + phoneCode));
                }
                catch (Exception e) {
                    logger.error("PreOnBrdImportPlugin:", (Object)e.getMessage());
                }
            }
        });
    }

    public void afterValidate(AfterValidateEventArgs args) {
        super.afterValidate(args);
        args.getBillDatas().forEach(data -> {
            JSONObject importObj = data.getData();
            if (importObj != null) {
                try {
                    JSONObject entryEntityJsonObject = importObj.getJSONObject("entryentity");
                    String locationCode = entryEntityJsonObject.getString("locationcode");
                    if (HRStringUtils.isNotEmpty((String)locationCode) && !locationCode.startsWith("+")) {
                        locationCode = "+" + locationCode;
                    }
                    String phoneCode = entryEntityJsonObject.getString("phonecode");
                    entryEntityJsonObject.put("phone", (Object)(locationCode + "-" + phoneCode));
                    entryEntityJsonObject.put("transdate", (Object)DateUtils.setTransDate((JSONObject)entryEntityJsonObject));
                }
                catch (Exception e) {
                    logger.error("PreOnBrdImportPlugin:", (Object)e.getMessage());
                }
            }
        });
    }

    public void afterQueryRefBd(AfterQueryRefBdEventArgs args) {
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IPreOnbrdService.class, (String)"kd.sdk.hr.hom.business.onbrd.IPreOnbrdService", null);
        hrPluginProxy.callReplace(hrPlugin -> {
            hrPlugin.validateData(args);
            return null;
        });
    }

    public void beforeBackFillData(BeforeBackFillDataEventArgs args) {
        super.beforeBackFillData(args);
        try {
            List rowData = args.getRowData();
            List<String> numbers = PreOnBrdHelper.generateBillNo(rowData.size());
            AtomicInteger index = new AtomicInteger();
            ArrayList<String> fillpbillnos = new ArrayList<String>();
            for (ImportBillData rowDatum : rowData) {
                JSONObject entity = rowDatum.getData().getJSONObject("entryentity");
                String pbillno = entity.getString("pbillno");
                String generateBillNo = numbers.get(index.getAndIncrement());
                if (!HRStringUtils.isEmpty((String)pbillno) || generateBillNo == null) continue;
                entity.put("pbillno", (Object)generateBillNo);
                fillpbillnos.add(generateBillNo);
                args.getFormView().getPageCache().put("candidatenumber" + generateBillNo, generateBillNo);
                args.getFormView().getPageCache().saveChanges();
            }
            args.getCustomParams().put("fillpbillnos", fillpbillnos);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public void afterBackFillData(AfterBackFillDataEventArgs args) {
        try {
            IDataModel model = args.getFormView().getModel();
            DynamicObjectCollection entryEntity = args.getDataModel().getEntryEntity("entryentity");
            List fillpbillnos = (List)args.getCustomParams().get("fillpbillnos");
            List<DynamicObject> fillEntryEntities = entryEntity.stream().filter(e -> fillpbillnos.contains(e.getString("pbillno"))).collect(Collectors.toList());
            HashSet orgIds = Sets.newHashSetWithExpectedSize((int)fillEntryEntities.size());
            HashSet jobIds = Sets.newHashSetWithExpectedSize((int)fillEntryEntities.size());
            for (DynamicObject entryDy : fillEntryEntities) {
                long jobId;
                long orgId = entryDy.getLong("aadminorg.id");
                if (orgId != 0L) {
                    orgIds.add(orgId);
                }
                if ((jobId = entryDy.getLong("ajob.id")) == 0L) continue;
                jobIds.add(jobId);
            }
            Map orgCompanyMap = IBaseDataDomainService.getInstance().getCompanyMapWithAdminorgByRPC((List)Lists.newArrayList((Iterable)orgIds));
            Map jobRelationInfoMap = IBaseDataDomainService.getInstance().getJobLevelGradeRangeInfoByJobIds((List)Lists.newArrayList((Iterable)jobIds));
            fillEntryEntities.forEach(e -> {
                DynamicObject ajob;
                DynamicObject adminOrgDy = e.getDynamicObject("aadminorg");
                if (HOMObjectUtils.isNotEmpty((Object)adminOrgDy)) {
                    Long adminOrgId = adminOrgDy.getLong("id");
                    model.setItemValueByID((IDataEntityProperty)e.getDataEntityType().getProperties().get((Object)"acompany"), e, (Object)orgCompanyMap.getOrDefault(adminOrgId, 0L));
                }
                if (ObjectUtils.isNotEmpty((Object)(ajob = e.getDynamicObject("ajob")))) {
                    Long aJobId = ajob.getLong("id");
                    Map jobRelationInfo = (Map)jobRelationInfoMap.get(aJobId);
                    if (ObjectUtils.isEmpty((Object)jobRelationInfo)) {
                        return;
                    }
                    Object joblevelscm = jobRelationInfo.get("joblevelScmid");
                    Object jobgradescm = jobRelationInfo.get("jobgradeScmid");
                    if (ObjectUtils.isEmpty((Object)e.get("joblevelscm"))) {
                        model.setItemValueByID((IDataEntityProperty)e.getDataEntityType().getProperties().get((Object)"joblevelscm"), e, joblevelscm);
                    }
                    if (ObjectUtils.isEmpty((Object)e.get("jobgradescm"))) {
                        model.setItemValueByID((IDataEntityProperty)e.getDataEntityType().getProperties().get((Object)"jobgradescm"), e, jobgradescm);
                    }
                    List jobLevelInfos = (List)jobRelationInfo.get("joblevelRanges");
                    List jobGradeInfos = (List)jobRelationInfo.get("jobgradeRanges");
                    if (ObjectUtils.isEmpty((Object)e.get("joblevel")) && joblevelscm != null && CollectionUtils.isNotEmpty((Collection)jobLevelInfos) && jobLevelInfos.size() == 1) {
                        model.setItemValueByID((IDataEntityProperty)e.getDataEntityType().getProperties().get((Object)"joblevel"), e, ((DynamicObject)jobLevelInfos.get(0)).get("id"));
                    }
                    if (ObjectUtils.isEmpty((Object)e.get("jobgrade")) && joblevelscm != null && CollectionUtils.isNotEmpty((Collection)jobLevelInfos) && jobLevelInfos.size() == 1) {
                        model.setItemValueByID((IDataEntityProperty)e.getDataEntityType().getProperties().get((Object)"jobgrade"), e, ((DynamicObject)jobGradeInfos.get(0)).get("id"));
                    }
                }
            });
            args.getFormView().updateView("entryentity");
        }
        catch (Exception e2) {
            logger.error(e2.getMessage());
        }
    }

    public void beforeCreateHeaderColumn(BeforeCreateHeaderColumnEventArgs args) {
        super.beforeCreateHeaderColumn(args);
        List headerWriterFormats = args.getHeaderWriterFormats();
        this.handlePreOnbrdColumn(headerWriterFormats);
        Map<KeyValue, Integer> linkedHashMap = PreOnBrdImportPlugin.getLinkedHasMap(headerWriterFormats);
        this.resetAllFieldSeq(headerWriterFormats, linkedHashMap);
    }

    private void handlePreOnbrdColumn(List<KeyValue> headerWriterFormats) {
        ArrayList<String> removeHeadColumn = new ArrayList<String>();
        removeHeadColumn.add("phone");
        removeHeadColumn.add("onbrd");
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IPreOnbrdService.class, (String)"kd.sdk.hr.hom.business.onbrd.IPreOnbrdService", null);
        hrPluginProxy.callReplace(hrPlugin -> {
            hrPlugin.preOnbrdTemplateVisibleColumn(removeHeadColumn);
            return null;
        });
        headerWriterFormats.removeIf(keyValue -> ENTRYENTITY_ID.equals(keyValue.key));
        headerWriterFormats.forEach(headerWriterFormat -> {
            KeyValue keyValue = headerWriterFormat;
            Integer n = keyValue.seq;
            Integer n2 = keyValue.seq = Integer.valueOf(keyValue.seq - 1);
        });
    }

    private void resetAllFieldSeq(List<KeyValue> headerWriterFormats, Map<KeyValue, Integer> linkedHashMap) {
        for (KeyValue headerWriterFormat : headerWriterFormats) {
            List fieldKeyValueList = (List)((KeyValue)headerWriterFormat.value).value;
            for (KeyValue value : fieldKeyValueList) {
                value.seq = linkedHashMap.get(value);
            }
            fieldKeyValueList = fieldKeyValueList.stream().sorted(Comparator.comparing(e -> e.seq)).collect(Collectors.toList());
            headerWriterFormat.seq = ((KeyValue)fieldKeyValueList.get((int)0)).seq;
        }
    }

    private static Map<KeyValue, Integer> getLinkedHasMap(List<KeyValue> headerWriterFormats) {
        LinkedHashMap<KeyValue, Integer> linkedHashMap = new LinkedHashMap<KeyValue, Integer>();
        Integer seq = 0;
        for (KeyValue headerWriterFormat : headerWriterFormats) {
            List fieldKeyValueList = (List)((KeyValue)headerWriterFormat.value).value;
            fieldKeyValueList.removeIf(keyValue -> PRE_IMPORT_TPL_NOT_CONTAIN_FIELD.contains(keyValue.key));
            PreOnBrdImportPlugin.addPhoneKeyValue(headerWriterFormat, fieldKeyValueList);
            fieldKeyValueList = fieldKeyValueList.stream().sorted(Comparator.comparing(e -> e.seq)).collect(Collectors.toList());
            for (KeyValue keyValue2 : fieldKeyValueList) {
                linkedHashMap.put(keyValue2, seq);
                Integer n = seq;
                Integer n2 = seq = Integer.valueOf(seq + 1);
            }
        }
        return linkedHashMap;
    }

    private static void addPhoneKeyValue(KeyValue headerWriterFormat, List<KeyValue> fieldKeyValueList) {
        if ("baseinfogroupap".equals(headerWriterFormat.key)) {
            FieldHeaderWriterFormat locationCodeHeaderWriterFormat = new FieldHeaderWriterFormat();
            locationCodeHeaderWriterFormat.setColWidth(0);
            locationCodeHeaderWriterFormat.setMustInput(true);
            KeyValue locationCode = new KeyValue("locationcode", (Object)ResManager.loadKDString((String)"*\u533a\u4f4d\u7801", (String)"PreOnBrdImportPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), (Object[])new FieldHeaderWriterFormat[]{locationCodeHeaderWriterFormat}, Integer.valueOf(fieldKeyValueList.size() + 1));
            fieldKeyValueList.add(locationCode);
            FieldHeaderWriterFormat phoneCodeHeaderWriterFormat = new FieldHeaderWriterFormat();
            phoneCodeHeaderWriterFormat.setColWidth(0);
            phoneCodeHeaderWriterFormat.setMustInput(true);
            KeyValue phoneCode = new KeyValue("phonecode", (Object)ResManager.loadKDString((String)"*\u8054\u7cfb\u7535\u8bdd", (String)"PreOnBrdImportPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]), (Object[])new FieldHeaderWriterFormat[]{phoneCodeHeaderWriterFormat}, Integer.valueOf(fieldKeyValueList.size() + 1));
            fieldKeyValueList.add(phoneCode);
            FieldHeaderWriterFormat mailHeaderWriterFormat = new FieldHeaderWriterFormat();
            mailHeaderWriterFormat.setColWidth(0);
            mailHeaderWriterFormat.setMustInput(false);
            KeyValue perEmail = new KeyValue("peremail", (Object)ResManager.loadKDString((String)"\u90ae\u7bb1", (String)"PreOnBrdImportPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]), (Object[])new FieldHeaderWriterFormat[]{mailHeaderWriterFormat}, Integer.valueOf(fieldKeyValueList.size() + 1));
            fieldKeyValueList.add(perEmail);
            FieldHeaderWriterFormat nationalityHeaderWriterFormat = new FieldHeaderWriterFormat();
            nationalityHeaderWriterFormat.setColWidth(0);
            nationalityHeaderWriterFormat.setMustInput(false);
            KeyValue nationality = new KeyValue("nationality", (Object)ResManager.loadKDString((String)"\u56fd\u7c4d", (String)"PreOnBrdImportPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]), (Object[])new FieldHeaderWriterFormat[]{nationalityHeaderWriterFormat}, Integer.valueOf(fieldKeyValueList.size() + 1));
            fieldKeyValueList.add(nationality);
        }
    }

    public void beforeInitValidator(BeforeInitValidatorEventArgs args) {
        super.beforeInitValidator(args);
        IDataModel model = args.getFormView().getModel();
        String billno = model.getDataEntity().getString("billno");
        args.setValidator(EntryValidatorEnum.CUSTOM_VALIDATOR, (AbstractEntryValidateHandler)new PreOnBrdValidateHandler(billno));
    }
}

