/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.preonbrd;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import org.apache.commons.collections.CollectionUtils;

public class PreOnBrdListProvider
extends ListDataProvider {
    private static final Log LOGGER = LogFactory.getLog(PreOnBrdListProvider.class);
    public static final String EMPLOYEES = "employees";
    public static final String HADEMPLOYEES = "hademployees";

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        if (rows.isEmpty()) {
            return rows;
        }
        this.addPreOnBrdBillDynamicProperty(rows);
        return rows;
    }

    private void addPreOnBrdBillDynamicProperty(DynamicObjectCollection rows) {
        DynamicSimpleProperty employees = new DynamicSimpleProperty(EMPLOYEES, Integer.class, (Object)0);
        DynamicSimpleProperty hademployees = new DynamicSimpleProperty(HADEMPLOYEES, Integer.class, (Object)0);
        rows.getDynamicObjectType().addProperty((DynamicProperty)employees);
        rows.getDynamicObjectType().addProperty((DynamicProperty)hademployees);
        List preOnBrdBillIds = rows.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
        DynamicObject[] preOnBrdDynamicObjects = HomCommonRepository.queryDynamicObjects((String)"hom_preonbrdentry", (String)"", (QFilter[])new QFilter[]{new QFilter("prebatchonbrd", "in", preOnBrdBillIds)});
        for (DynamicObject row : rows) {
            List preOnBrdDyColl = Arrays.stream(preOnBrdDynamicObjects).filter(p -> p.getLong("prebatchonbrd.id") == row.getLong("id")).collect(Collectors.toList());
            if (!HRCollUtil.isNotEmpty(preOnBrdDyColl) || !CollectionUtils.isNotEmpty(preOnBrdDyColl)) continue;
            long onBrdStatusCount = preOnBrdDyColl.stream().filter(p -> {
                DynamicObject onBrdDy = p.getDynamicObject("onbrd");
                return !Objects.isNull(onBrdDy) && onBrdDy.get("enrollstatus").equals("3");
            }).count();
            row.set(EMPLOYEES, (Object)preOnBrdDyColl.size());
            row.set(HADEMPLOYEES, (Object)onBrdStatusCount);
        }
    }
}

