/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.reservation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hom.business.domain.service.impl.reservation.ReservationService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.OnbrdStatusEnum;

public class ReservationWaitConfirmPlugin
extends HRDataBaseList {
    private static final String RESERVATION_CONFIRM = "reservation_confirm";
    private static final String RESERVATION_CANCEL = "reservation_cancel";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)RESERVATION_CONFIRM, (String)operateKey)) {
            List<Long> idList = this.getIds();
            if (IOnbrdBillDomainService.getInstance().isEnrolled(idList.toArray(new Object[0]))) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ec8\u6b62\u5165\u804c\u6216\u5df2\u5165\u804c\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ReservationOnbrdPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
                return;
            }
            ReservationService.reservationConfirm(idList);
            this.getView().invokeOperation("refresh");
        }
        if (HRStringUtils.equals((String)RESERVATION_CANCEL, (String)operateKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u53d6\u6d88\u9884\u7ea6\u5c06\u6e05\u7a7a\u9884\u7ea6\u5165\u804c\u65e5\u671f\u548c\u5165\u804c\u5730\u70b9\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u53d6\u6d88\u9884\u7ea6\u3002", (String)"ReservationWaitConfirmPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String actionId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && HRStringUtils.equals((String)RESERVATION_CANCEL, (String)actionId)) {
            List<Long> idList = this.getIds();
            ReservationService.reservationCancel(idList);
            this.getView().invokeOperation("refresh");
        }
    }

    private List<Long> getIds() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection rows = listView.getSelectedRows();
        return Arrays.stream(rows.getPrimaryKeyValues()).map(pkKey -> Long.valueOf(pkKey.toString())).collect(Collectors.toList());
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        setFilterEvent.setMainOrgQFilter(null);
        List customQFilters = setFilterEvent.getCustomQFilters();
        ArrayList<String> status = new ArrayList<String>(2);
        status.add(OnbrdStatusEnum.HAS_ONBRD.toString());
        status.add(OnbrdStatusEnum.BREAK_UP.toString());
        QFilter numberFilter = new QFilter("enrollstatus", "not in", status);
        customQFilters.add(numberFilter);
    }
}

