/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.task;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.utils.ScheduleTaskUtil;

public class MultiPageListConfigUpgradeTask
extends AbstractTask {
    private static final String TASK_NUMBER = "hom_multi_page_list_config_upgrade_SKDJ_S";
    private static final Log LOGGER = LogFactory.getLog(MultiPageListConfigUpgradeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("###HomMultiPageListConfigUpgradeTask config begin");
        DataSet dataSet = this.getMultipagelistConfig();
        if (dataSet.isEmpty()) {
            LOGGER.info("###HomMultiPageListConfigUpgradeTask dataSet is empty.");
            this.doUpgrade();
        }
        ScheduleTaskUtil.disEnableTask((String)TASK_NUMBER);
        LOGGER.info("###HomMultiPageListConfigUpgradeTask config end");
    }

    private DataSet getMultipagelistConfig() {
        DBRoute dbRoute = new DBRoute("hrb.hom");
        String sql = "select fid, fbusinesskey ,fbusinessvalue  from t_hom_config where fbusinesskey = 'hcf_multipagelist'";
        return HRDBUtil.queryDataSet((String)"HomMultiPageListConfigUpgradeTask", (DBRoute)dbRoute, (String)sql, null);
    }

    private void doUpgrade() {
        try (BufferedReader bd = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/upgrade/hom_multi_page_listconfig_upgrade.sql")));){
            String line;
            DBRoute dbRoute = new DBRoute("hrb.hom");
            while ((line = bd.readLine()) != null) {
                if (HRStringUtils.isEmpty((String)line)) continue;
                HRDBUtil.execute((DBRoute)dbRoute, (String)line, null);
            }
        }
        catch (IOException io) {
            LOGGER.error("###HomMultiPageListConfigUpgradeServiceupgrade config, doUpgrade exception:", (Throwable)io);
        }
    }
}

