/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.task;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hom.business.application.utils.ScheduleTaskUtil;
import kd.hr.hom.business.domain.repository.OnbrdBillRepository;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;

public class OnbrdBillOfferIdUpgradeTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(OnbrdBillOfferIdUpgradeTask.class);
    private static final String OFFER_INVALID_STATUS = "1010050";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("OnbrdBillOfferIdUpgradeTask start");
        DynamicObject[] onbrdBills = this.getOnbrdBills();
        if (onbrdBills != null && onbrdBills.length > 0) {
            LOGGER.info("getOnbrdBills result:{}", (Object)onbrdBills.length);
            List<Long> candidateIds = Arrays.stream(onbrdBills).map(dy -> dy.getLong("candidate.id")).collect(Collectors.toList());
            Map<Long, Long> candidateOfferMap = this.getOffersByCandidateId(candidateIds);
            ArrayList updateOnbrdBills = new ArrayList(onbrdBills.length);
            if (candidateOfferMap.size() > 0) {
                LOGGER.info("getOffers result:{}", (Object)candidateOfferMap.size());
                Arrays.stream(onbrdBills).forEach(dy -> {
                    Long offerId = (Long)candidateOfferMap.get(dy.getLong("candidate.id"));
                    if (offerId != null && offerId != 0L) {
                        dy.set("offerid", (Object)offerId);
                        updateOnbrdBills.add(dy);
                    }
                });
            }
            if (updateOnbrdBills.size() > 0) {
                OnbrdBillRepository.saveOnbrdBillInfos((DynamicObject[])onbrdBills);
            }
        }
        ScheduleTaskUtil.disEnableTask((String)"hom_offerid_upgrade_SKDP_S");
    }

    private DynamicObject[] getOnbrdBills() {
        QFilter offerIdFilter = new QFilter("offerid", "=", (Object)0L);
        QFilter offerNumberFilter = new QFilter("offernumber", "!=", (Object)" ");
        return OnbrdBillRepository.findOnbrdBills((String)"candidate,offerid", (QFilter[])new QFilter[]{offerIdFilter, offerNumberFilter});
    }

    private Map<Long, Long> getOffersByCandidateId(List<Long> candidateIds) {
        QFilter idFilter = new QFilter("id", "in", candidateIds).and(new QFilter("datasource", "=", (Object)"0"));
        DynamicObject[] candidates = HomCommonRepository.queryDynamicObjects((String)"hcf_candidate", (String)"appfileid", (QFilter[])new QFilter[]{idFilter});
        if (candidates == null || candidates.length < 1) {
            return new HashMap<Long, Long>();
        }
        int size = candidateIds.size();
        HashMap candidateAppFileIdMap = Maps.newHashMapWithExpectedSize((int)size);
        ArrayList<Long> appFileIds = new ArrayList<Long>(size);
        for (DynamicObject candidate : candidates) {
            long appFileId = candidate.getLong("appfileid");
            if (appFileId == 0L) continue;
            candidateAppFileIdMap.put(appFileId, candidate.getLong("id"));
            appFileIds.add(appFileId);
        }
        if (appFileIds.size() < 1) {
            return new HashMap<Long, Long>();
        }
        DynamicObject[] offers = HomCommonRepository.queryDynamicObjects((String)"tso_somk_offerbase", (String)"appfile,status,isdelete", (QFilter[])new QFilter[]{new QFilter("appfile", "in", appFileIds)});
        if (offers == null || offers.length < 1) {
            return new HashMap<Long, Long>();
        }
        LOGGER.info("get offers size:{}", (Object)offers.length);
        HashMap candidateOfferIdMap = Maps.newHashMapWithExpectedSize((int)size);
        for (DynamicObject offer : offers) {
            Long candidateId;
            if (OFFER_INVALID_STATUS.equals(offer.getString("status.id")) || offer.getBoolean("isdelete") || (candidateId = (Long)candidateAppFileIdMap.get(offer.getLong("appfile.id"))) == null || candidateId == 0L) continue;
            candidateOfferIdMap.put(candidateId, offer.getLong("id"));
        }
        return candidateOfferIdMap;
    }
}

