/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hom.business.application.onbrd.IOnbrdConfirmAppService;
import kd.hr.hom.business.application.utils.ScheduleTaskUtil;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.SynchStatusEnum;

public class OnbrdBillVidUpgradeTask
extends AbstractTask {
    public static final String TASK_NUMBER = "hom_onbrdbill_vid_upgrade_task_SKDP_S";
    private static final Log LOGGER = LogFactory.getLog(OnbrdBillVidUpgradeTask.class);
    private static final ThreadPool THREADPOOL = ThreadPools.newFixedThreadPool((String)"OnbrdBillVidUpgradeTask", (int)10);
    private static final int BATCH_DATA_NUM = 1000;
    private static final String SUCCESS = "success";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("###Start Updating Datasource of OnbrdBillVidUpgradeTask ");
        QFilter qFilter = new QFilter("enrollstatus", "=", (Object)OnbrdStatusEnum.HAS_ONBRD.getValue());
        qFilter.and("synchstatus", "=", (Object)SynchStatusEnum.SYNCH_SUCCESS.getValue());
        String selectFields = "id,billno,effectdate,acompany,aadminorg,stdposition,aposition,ajob";
        DynamicObject[] onbrdBillList = IOnbrdBillDomainService.getInstance().findOnbrdBills(selectFields, qFilter.toArray());
        int dataSize = onbrdBillList.length;
        LOGGER.info("###OnbrdBillVidUpgradeTask upgrade data size is:{}", (Object)dataSize);
        boolean taskSuccess = true;
        if (dataSize > 0) {
            int countDownSize = this.computeCountDownSize(dataSize);
            CountDownLatch countDownLatch = new CountDownLatch(countDownSize);
            IHRAppCache ihrAppCache = HRAppCache.get((String)((Object)((Object)this)).getClass().getSimpleName());
            TXHandle tx = TX.required();
            try {
                ArrayList<Object> batchDataList = new ArrayList<DynamicObject>(1000);
                for (int i = 0; i < dataSize; ++i) {
                    batchDataList.add(onbrdBillList[i]);
                    if (batchDataList.size() == 1000) {
                        THREADPOOL.execute((Runnable)new Worker(batchDataList, countDownLatch, ihrAppCache));
                        batchDataList = new ArrayList(1000);
                        continue;
                    }
                    if (batchDataList.size() >= 1000 || i != dataSize - 1) continue;
                    THREADPOOL.execute((Runnable)new Worker(batchDataList, countDownLatch, ihrAppCache));
                }
                countDownLatch.await();
                if (Boolean.FALSE.equals(ihrAppCache.get(SUCCESS, Boolean.class))) {
                    throw new KDBizException("###OnbrdBillVidUpgradeTask upgrade data fail!");
                }
                LOGGER.info("###OnbrdBillVidUpgradeTask complate changeBoidToVid method");
                IOnbrdBillDomainService.getInstance().saveOnbrdBillInfos(onbrdBillList);
                LOGGER.info("###OnbrdBillVidUpgradeTask complate update");
            }
            catch (Exception e) {
                LOGGER.error("###OnbrdBillVidUpgradeTask exception:", (Throwable)e);
                tx.markRollback();
                taskSuccess = false;
            }
            finally {
                tx.close();
                ihrAppCache.remove(SUCCESS);
            }
        }
        if (taskSuccess) {
            ScheduleTaskUtil.disEnableTask((String)TASK_NUMBER);
        }
    }

    private int computeCountDownSize(Integer dataSize) {
        if (dataSize == 0) {
            return 0;
        }
        int i = dataSize / 1000;
        if (i == 0 || dataSize % 1000 != 0) {
            return i + 1;
        }
        return i;
    }

    static class Worker
    implements Runnable {
        List<DynamicObject> datas;
        CountDownLatch countDownLatch;
        IHRAppCache ihrAppCache;

        public Worker(List<DynamicObject> datas, CountDownLatch countDownLatch, IHRAppCache ihrAppCache) {
            this.datas = datas;
            this.countDownLatch = countDownLatch;
            this.ihrAppCache = ihrAppCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                IOnbrdConfirmAppService onbrdConfirmAppService = IOnbrdConfirmAppService.getInstance();
                for (DynamicObject item : this.datas) {
                    onbrdConfirmAppService.changeBoidToVid(item);
                }
            }
            catch (Exception e) {
                LOGGER.error("###QuitApplyVidUpgradeServiceImpl.Worker error:", (Throwable)e);
                this.ihrAppCache.put(OnbrdBillVidUpgradeTask.SUCCESS, (Object)Boolean.FALSE);
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

