/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.task;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hom.business.domain.repository.OnbrdBillRepository;

public class OnbrdDarkPositionBsedUpgradeTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(OnbrdDarkPositionBsedUpgradeTask.class);
    private static final String PARAM_DARKPOSID = "darkposid";
    private static final String PARAM_BSED = "bsed";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long startTime = System.currentTimeMillis();
        LOG.info("\u6570\u636e\u5347\u7ea7\u4efb\u52a1 \u5f00\u59cb\u6267\u884c:");
        this.executeUpgrade(map);
        this.disableTask();
        LOG.info("\u6570\u636e\u5347\u7ea7\u4efb\u52a1: \u6267\u884c\u5b8c\uff0c\u5171\u8017\u65f6 {} \u6beb\u79d2", (Object)(System.currentTimeMillis() - startTime));
    }

    private void executeUpgrade(Map<String, Object> map) {
        List darkPositionIdToBsedMapList;
        QFilter apositiontypeQf = new QFilter("apositiontype", "in", (Object)new String[]{"0", "2"});
        QFilter enrollstatusQf = new QFilter("enrollstatus", "=", (Object)"3");
        DynamicObject[] onbrdBills = OnbrdBillRepository.findOnbrdBills((String)"id,apositiontype,effectdate,darkposition,enrollstatus", (QFilter[])new QFilter[]{apositiontypeQf, enrollstatusQf});
        if (onbrdBills.length > 0 && !CollectionUtils.isEmpty(darkPositionIdToBsedMapList = Arrays.asList(onbrdBills).stream().filter(dynamicObject -> dynamicObject.get("darkposition") != null).map(onbrdBill -> {
            HashMap darkPositionIdToBsedMap = Maps.newHashMap();
            darkPositionIdToBsedMap.put(PARAM_DARKPOSID, onbrdBill.getLong("darkposition.id"));
            darkPositionIdToBsedMap.put(PARAM_BSED, onbrdBill.getDate("effectdate"));
            return darkPositionIdToBsedMap;
        }).collect(Collectors.toList()))) {
            Map map2 = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IDarkPostionService", (String)"darkPosFromEmployedDataUpgrade", (Object[])new Object[]{darkPositionIdToBsedMapList});
        }
    }

    private void disableTask() {
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob("3TW4EGVMEFHP");
        scheduleManager.disableSchedule("3TW4HYRMC=UP");
    }
}

