/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.task;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.utils.ScheduleTaskUtil;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.common.IHomConfigService;

public class SmsWhiteListUpgradeTask
extends AbstractTask {
    private static final String TASK_NUMBER = "hom_sms_white_list_upgrade_task_SKDP_S";
    private static final Log LOGGER = LogFactory.getLog(SmsWhiteListUpgradeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("###start execute SmsWhiteListUpgradeTask");
        this.insertPreData();
        IHomConfigService homConfigService = (IHomConfigService)ServiceFactory.getService(IHomConfigService.class);
        String smsWhitelistEnable = homConfigService.getConfVal("sms_whitelist_enable", "0");
        String smsWhitelistStr = homConfigService.getConfVal("sms_whitelist_str", "");
        boolean taskSuccess = true;
        try {
            if ("1".equals(smsWhitelistEnable)) {
                this.updateHpfsDevParamConfig("sms_whitelist_enable", Boolean.TRUE.toString());
            } else {
                this.updateHpfsDevParamConfig("sms_whitelist_enable", Boolean.FALSE.toString());
            }
            this.updateHpfsDevParamConfig("sms_whitelist_str", smsWhitelistStr);
            this.deleteHomConfig();
        }
        catch (Exception e) {
            taskSuccess = false;
            LOGGER.error("###SmsWhiteListUpgradeTask exception:", (Throwable)e);
        }
        if (taskSuccess) {
            ScheduleTaskUtil.disEnableTask((String)TASK_NUMBER);
        }
    }

    private boolean updateHpfsDevParamConfig(String key, String value) {
        LOGGER.info("###SmsWhiteListUpgradeServiceImpl.updateHpfsDevParamConfigValue, key:{},value:{}", (Object)key, (Object)value);
        if (HRStringUtils.isBlank((CharSequence)key)) {
            return true;
        }
        Object[] params = new Object[]{value, key};
        String sql = "update t_hpfs_devconfig set fbusinessvalue=? where fbusinesskey =?";
        return DB.execute((DBRoute)DBRoute.of((String)"hr"), (String)sql, (Object[])params);
    }

    private boolean deleteHomConfig() {
        LOGGER.info("###SmsWhiteListUpgradeServiceImpl.deleteHomConfig");
        Object[] params = new Object[]{"sms_whitelist_enable", "sms_whitelist_str"};
        String sql = "delete from t_hom_config where fbusinesskey in (?,?)";
        return DB.execute((DBRoute)DBRoute.of((String)"hrb.hom"), (String)sql, (Object[])params);
    }

    private void insertPreData() {
        try (InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/upgrade/hpfs_devconfig_init_data.sql");
             InputStreamReader isr = new InputStreamReader(inputStream);
             BufferedReader bd = new BufferedReader(isr);){
            String line;
            DBRoute dbRoute = new DBRoute("hr");
            while ((line = bd.readLine()) != null) {
                if (HRStringUtils.isEmpty((String)line)) continue;
                HRDBUtil.execute((DBRoute)dbRoute, (String)line, null);
            }
        }
        catch (Exception e) {
            LOGGER.error("SmsWhiteListUpgradeServiceImpl exec hpfs_devconfig_init_data.sql exception:", (Throwable)e);
        }
    }
}

