/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.worktable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.container.GridContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.constant.SchemeType;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.pluginnew.GridContainerPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.impl.onbrd.OnbrdWorkTableServiceImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdWorkTableService;

public class HomGridPlugin
extends GridContainerPlugin
implements BeforeF7SelectListener,
SearchEnterListener {
    private static final Log LOGGER = LogFactory.getLog(HomGridPlugin.class);
    private static final IOnbrdWorkTableService workTableService = new OnbrdWorkTableServiceImpl();
    private static final String AADMINORG = "aadminorg";
    private static final String SEARCH_AP = "searchap";

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        FormShowParameter billShowParameter = (FormShowParameter)evt.getSource();
        billShowParameter.setCustomParam("checkRightAppId", (Object)"hom");
        evt.getFormShowParameter().setCustomParam("customHREntityNumber", (Object)"hom_onbrdinfo");
        evt.getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)AADMINORG);
        evt.getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit adminOrg = (BasedataEdit)this.getView().getControl(AADMINORG);
        adminOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Search search = (Search)this.getControl(SEARCH_AP);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (AADMINORG.equals(name)) {
            long userId = RequestContext.get().getCurrUserId();
            Object result = HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgsF7", (Object[])new Object[]{userId, "1WXB5G9/BL46", "hom_onbrdinfo", "47150e89000000ac", AADMINORG});
            if (HRObjectUtils.isEmpty((Object)result)) {
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", new ArrayList()));
                return;
            }
            AuthorizedOrgResult orgResult = (AuthorizedOrgResult)result;
            if (orgResult == null) {
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", new ArrayList()));
                return;
            }
            if (!orgResult.isHasAllOrgPerm()) {
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", (Object)orgResult.getHasPermOrgs()));
            }
        }
    }

    public void search(SearchEnterEvent event) {
        String str = event.getText();
        if (HRStringUtils.isEmpty((String)str)) {
            return;
        }
        List nameList = event.getFieldNames();
        QFilter qFilter = workTableService.getAllSearchFilter(nameList, str, false, false);
        DynamicObject[] dynamicObjects = workTableService.getDynamicObjects(qFilter);
        this.searchHandle(dynamicObjects, nameList, str);
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String name = event.getProperty().getName();
        if (AADMINORG.equals(name)) {
            this.changeProperty(event, "adminorgids");
            this.refreshGridContainer();
        }
    }

    public void refreshGridContainer() {
        super.refreshGridContainer();
        this.resetGridContainer();
    }

    private void changeProperty(PropertyChangedArgs event, String changedArg) {
        ChangeData[] changeData = event.getChangeSet();
        HRPageCache pageCache = new HRPageCache(this.getView());
        DynamicObjectCollection newHRBUObjects = (DynamicObjectCollection)changeData[0].getNewValue();
        if (CollectionUtils.isEmpty((Collection)newHRBUObjects)) {
            pageCache.remove(changedArg);
        } else {
            ArrayList ids = new ArrayList();
            newHRBUObjects.stream().forEach(dynamicObject -> ids.add(dynamicObject.getLong("fbasedataid.id")));
            pageCache.put(changedArg, ids);
            LOGGER.info("HomGridPlugin_changeProperty_ids:{}", (Object)((Object)ids).toString());
        }
    }

    private void searchHandle(DynamicObject[] dynamicObjects, List<String> nameList, String text) {
        FormShowParameter showParameter = new FormShowParameter();
        if (HRArrayUtils.isEmpty((Object[])dynamicObjects) || dynamicObjects.length > 1) {
            showParameter.setFormId("hom_wbquicksearch");
            showParameter.getOpenStyle().setShowType(ShowType.NonModal);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("searchlist", nameList);
            showParameter.setCustomParam("searchtext", (Object)text);
            String name = ResManager.loadKDString((String)"\u5f85\u5165\u804c\u4eba\u5458\u901f\u67e5", (String)"HomGridPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            showParameter.setCaption(name);
            this.getView().showForm(showParameter);
        } else {
            DynamicObject dynamicObject = dynamicObjects[0];
            Long onbrdId = dynamicObject.getLong("id");
            showParameter.setFormId("hom_persononbrdhandlebody");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            String name = ResManager.loadKDString((String)"\u5165\u804c\u5355-", (String)"HomGridPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            showParameter.setCaption(name + dynamicObject.getString("name"));
            showParameter.setCustomParam("onbrdid", (Object)onbrdId);
            this.getView().showForm(showParameter);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.resetGridContainer();
    }

    private void resetGridContainer() {
        Map allCardConfigMap;
        String appId;
        IOnbrdCommonAppService onbrdCommonAppService = IOnbrdCommonAppService.getInstance();
        if (!onbrdCommonAppService.checkPermission("hom_apphome", "47150e89000000ac", appId = this.getView().getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
        }
        if (CollectionUtils.isEmpty((Map)(allCardConfigMap = this.getAllCardConfigMap()))) {
            LOGGER.info("allCardConfigMap isEmpty");
            return;
        }
        HashMap newCardConfigMap = new HashMap();
        Map<String, Tuple<String, String>> cardPermItemMap = this.getCardPermItemMap();
        for (Map.Entry entry : allCardConfigMap.entrySet()) {
            Object cardPermItemTuple;
            JSONObject jsonObject = JSON.parseObject((String)((String)entry.getValue()));
            String entityNumber = jsonObject.getString("cardformnum");
            if (HRStringUtils.isEmpty((String)entityNumber)) {
                entityNumber = jsonObject.getString("cardType");
            }
            if ((cardPermItemTuple = cardPermItemMap.get(entityNumber)) != null) {
                if (!onbrdCommonAppService.checkPermission((String)((Tuple)cardPermItemTuple).item1, (String)((Tuple)cardPermItemTuple).item2, appId)) continue;
                newCardConfigMap.put(entry.getKey(), entityNumber);
                continue;
            }
            if (!onbrdCommonAppService.checkPermission(entityNumber, "47150e89000000ac", appId)) continue;
            newCardConfigMap.put(entry.getKey(), entityNumber);
        }
        DynamicObject schemeObj = this.getCurUserSuitableScheme(RequestContext.getOrCreate().getCurrUserId());
        if (schemeObj == null) {
            LOGGER.info("schemeObj == null");
            return;
        }
        String layout = schemeObj.getString("layout");
        List layoutCards = JSON.parseArray((String)layout, String.class);
        HashMap<String, String> newlayoutCardMap = new HashMap<String, String>();
        for (String layoutCard : layoutCards) {
            JSONObject layoutCardObject = JSON.parseObject((String)layoutCard);
            String cardId = layoutCardObject.getString("i");
            if (cardId == null || !HRStringUtils.isNotEmpty((String)((String)newCardConfigMap.get(cardId)))) continue;
            newlayoutCardMap.put(cardId, layoutCard);
        }
        String layouts = newlayoutCardMap.values().toString();
        GridContainer gridContainer = (GridContainer)this.getView().getControl("gridcontainerap");
        gridContainer.setLayout(layouts);
    }

    private Map<String, Tuple<String, String>> getCardPermItemMap() {
        HashMap<String, Tuple<String, String>> cardPermItemMap = new HashMap<String, Tuple<String, String>>();
        cardPermItemMap.put("hom_wbwaitin", Tuple.create((Object)"hom_apphome", (Object)"3G8MCKS3W+33"));
        cardPermItemMap.put("hom_wbwarning", Tuple.create((Object)"hom_apphome", (Object)"3G8MDKP41W9Y"));
        cardPermItemMap.put("hom_wbcalendar", Tuple.create((Object)"hom_apphome", (Object)"3G8MEHKOPU0E"));
        return cardPermItemMap;
    }

    private DynamicObject getCurUserSuitableScheme(Long userId) {
        String selFields = "id,layout,schemetype,ismultiorg";
        boolean isMainPage = CardUtils.isMainPage((IFormView)this.getView());
        this.getPageCache().put("IS_MainPage_Type", Boolean.toString(isMainPage));
        String strSchemeId = this.getPageCache().get("pgCache_currentScheme");
        if (StringUtils.isNotEmpty((String)strSchemeId) && CardUtils.isHaveSchemeRecord((String)strSchemeId)) {
            return BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(strSchemeId), (String)"portal_scheme", (String)selFields);
        }
        String bizAppId = CardUtils.getAppIdFromView((IFormView)this.getView());
        String entityId = this.getView().getEntityId();
        String pageType = CardUtils.getPageType((IFormView)this.getView());
        Long defaultSchemeId = CardUtils.getDefaultSchemeId((String)pageType, (String)bizAppId, (String)entityId, (IFormView)this.getView());
        if (defaultSchemeId != null) {
            return BusinessDataServiceHelper.loadSingle((Object)defaultSchemeId, (String)"portal_scheme", (String)selFields);
        }
        String modeType = CardUtils.convertModeType();
        List<QFilter> modeTypeFilter = Collections.singletonList(new QFilter("ismultiorg", "=", (Object)modeType));
        DynamicObject schemeObj = CardUtils.loadScheme((SchemeType)SchemeType.UserScheme, (Long)userId, (String)selFields, modeTypeFilter, (boolean)isMainPage, (IFormView)this.getView());
        if (schemeObj != null) {
            return schemeObj;
        }
        Long schemeId = CardUtils.getGroupSchemeId((Long)userId, (IFormView)this.getView());
        if (schemeId != null) {
            return BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"portal_scheme", (String)selFields);
        }
        schemeObj = CardUtils.loadScheme((SchemeType)SchemeType.SysDefScheme, (Long)userId, (String)selFields, modeTypeFilter, (boolean)isMainPage, (IFormView)this.getView());
        if (schemeObj == null && "2".equals(modeType)) {
            List<QFilter> ccsFilter = Collections.singletonList(new QFilter("ismultiorg", "=", (Object)"1"));
            schemeObj = CardUtils.loadScheme((SchemeType)SchemeType.SysDefScheme, (Long)userId, (String)selFields, ccsFilter, (boolean)isMainPage, (IFormView)this.getView());
        }
        return schemeObj;
    }
}

